/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AppHome.TaskChartCardPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class MergeBackRankPlugin
extends TaskChartCardPlugin {
    protected static final String HISTOGRAMCHARTAP = "histogramchartap";
    public static final List<String> ALL_DIM_INFO = Arrays.asList("model", "scenario", "year", "period");
    private static int TopNum = 10;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshData();
    }

    @Override
    protected boolean hasEntity() {
        return ALL_DIM_INFO.contains("entity");
    }

    @Override
    public void refreshData() {
        if (this.validateDim(ALL_DIM_INFO) && this.validateCslScheme()) {
            this.refreshInfo(null);
        } else {
            this.cleanChart();
        }
    }

    @Override
    public void refreshInfo(String statusCategory) {
        LinkedHashMap dataMap = (LinkedHashMap)TaskCardHelper.queryMergeBackData(this.getFixedItem(), TopNum);
        this.refreshChart(null, null, dataMap);
    }

    @Override
    public void cleanChart() {
        HistogramChart chart = (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
        chart.clearData();
        chart.refresh();
    }

    @Override
    public void refreshChart(Object statusEnum, String serieName, LinkedHashMap<String, Integer> dataMap) {
        HistogramChart chart = (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
        if (null == dataMap || dataMap.size() == 0) {
            this.cleanChart();
            return;
        }
        chart.clearData();
        ArrayList<String> categorys = new ArrayList<String>(dataMap.size());
        ArrayList<Integer> data = new ArrayList<Integer>(dataMap.size());
        for (Map.Entry<String, Integer> e : dataMap.entrySet()) {
            categorys.add(e.getKey());
            data.add(e.getValue());
        }
        for (int i = 0; i < TopNum - dataMap.size(); ++i) {
            categorys.add("");
            data.add(null);
        }
        chart.setShowTooltip(true);
        chart.addTooltip("axisPointer", (Object)new HashMap<String, Object>(1){
            {
                this.put("type", "shadow");
            }
        });
        chart.addTooltip("trigger", (Object)"axis");
        chart.setMargin(Position.bottom, "20");
        chart.setMargin(Position.left, "20");
        chart.setMargin(Position.right, "20");
        chart.setMargin(Position.top, "40");
        final int showTextNum = 10;
        Axis xAxis = chart.createXAxis("", categorys);
        xAxis.setPropValue("axisTick", (Object)new HashMap<String, Object>(1){
            {
                this.put("alignWithLabel", true);
            }
        });
        xAxis.setPropValue("axisLabel", (Object)new HashMap<String, Object>(4){
            {
                super(x0);
                this.put("interval", 0);
                this.put("hideOverlap", false);
                this.put("formatter", String.format("function(value) { return value.length > %s ? (value.slice(0, %s) + '...') : value;}", showTextNum, showTextNum));
            }
        });
        chart.addFuncPath((List)Lists.newArrayList((Object[])new Object[]{"xAxis", 0, "axisLabel", "formatter"}));
        chart.createYAxis(ResManager.loadKDString((String)"\uff08\u6b21)", (String)"MergeBackRankPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        serieName = ResManager.loadKDString((String)"\u6253\u56de\u6b21\u6570", (String)"MergeBackRankPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        BarSeries barSeries = chart.createSeries(serieName);
        barSeries.setData((Number[])data.toArray(new Integer[0]));
        chart.refresh();
    }

    @Override
    protected FixedItem getFixedItem() {
        String entityRootId = this.getPageCache().get("entity");
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)(StringUtils.isNotEmpty((String)entityRootId) ? Long.parseLong(entityRootId) : 0L));
        SimpleItem entityItem = null != entityNode && IDNumberTreeNode.NotFoundTreeNode != entityNode ? SimpleItem.newOne((Object)entityNode.getId(), (String)entityNode.getNumber()) : SimpleItem.newOne((Object)0L, (String)"");
        return this.getFixedItem(entityItem);
    }

    private boolean validateCslScheme() {
        DynamicObject userSelect = UserSelectUtil.getUserSelectDynamicObject(UserSelectUtil.buildOtherSelectFileds(Collections.emptyList()), ModelUtil.queryApp(this.getView()));
        if (userSelect == null || !String.valueOf(this.getModelId()).equals(userSelect.getString("model"))) {
            this.getPageCache().put("entity", "0");
            return false;
        }
        Long entityRootId = null;
        Long entityId = userSelect.getLong("entity");
        if (LongUtil.isvalidLong((Object)entityId)) {
            String cslschemeProp = (String)MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)entityId).getProperty("cslscheme");
            String cslschemeNumber = StringUtils.isNotEmpty((String)cslschemeProp) ? cslschemeProp : CslSchemeEnum.Default.getNumber();
            IDNumberTreeNode entityRoot = MemberReader.findEntityMemberByNum((String)this.getCtrl("model").getString("number"), (String)"Entity").getChildren().stream().filter(e -> Objects.equals(cslschemeNumber, e.getProperty("cslscheme"))).findFirst().orElseGet(() -> null);
            entityRootId = null != entityRoot && IDNumberTreeNode.NotFoundTreeNode != entityRoot ? entityRoot.getId() : null;
        }
        this.getPageCache().put("entity", null != entityRootId ? String.valueOf(entityRootId) : "0");
        return LongUtil.isvalidLong(entityRootId);
    }
}

