/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.bcm.business.taskmanage.enums.MergeStatusEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.formplugin.AppHome.TaskChartCardPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;

public class MergeStatusCountPlugin
extends TaskChartCardPlugin {
    private static final String PROCESS = "process";
    public static final List<String> ALL_DIM_INFO = Arrays.asList("model", "scenario", "year", "period", "entity");

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshData();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private String getProcess() {
        return (String)this.getModel().getValue(PROCESS);
    }

    @Override
    public void refreshData() {
        if (this.validateDim(ALL_DIM_INFO)) {
            this.cleanMcStatusCountCache();
            this.refreshInfo(this.getStatusCategory());
        } else {
            this.cleanMcStatusCountCache();
            this.setTitle(this.getStatusCategory());
            this.cleanChart();
        }
    }

    @Override
    public void refreshInfo(String statusCategory) {
        this.setTitle(statusCategory);
        MergeStatusEnum statusEnum = MergeStatusEnum.getEnumByCode((String)statusCategory);
        this.refreshChart(statusEnum, this.getAllDimInfo(ALL_DIM_INFO), this.getMergeStatusData(statusEnum));
    }

    @Override
    public String getStatusColor(Object statusEnum, String statusName) {
        return ((MergeStatusEnum)statusEnum).getStatusColor(statusName);
    }

    private LinkedHashMap<String, Integer> getMergeStatusData(MergeStatusEnum statusEnum) {
        Map<String, LinkedHashMap<String, Integer>> cacheMap = this.getMcStatusCountCache();
        if (cacheMap.containsKey(statusEnum.getCode())) {
            return cacheMap.get(statusEnum.getCode());
        }
        TaskCardHelper.countMergeStatus(statusEnum, this.getFixedItem(), this.getProcess(), null, cacheMap);
        LinkedHashMap<String, Integer> resultMap = cacheMap.get(statusEnum.getCode());
        this.updateMcStatusCountCache(cacheMap);
        return resultMap;
    }

    private Map<String, LinkedHashMap<String, Integer>> getMcStatusCountCache() {
        String seria = this.getPageCache().get("KEY_MCSTATUS_COUNT");
        if (StringUtils.isNotEmpty((CharSequence)seria)) {
            Map map = (Map)JacksonUtils.fromJson((String)seria, (TypeReference)new TypeReference<Map<String, LinkedHashMap<String, Integer>>>(){});
            return map;
        }
        return new HashMap<String, LinkedHashMap<String, Integer>>(8);
    }

    private void updateMcStatusCountCache(Map<String, LinkedHashMap<String, Integer>> map) {
        this.getPageCache().put("KEY_MCSTATUS_COUNT", JacksonUtils.toJson(map));
    }

    private void cleanMcStatusCountCache() {
        this.getPageCache().remove("KEY_MCSTATUS_COUNT");
    }
}

