/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.field.ComboEdit;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.AppHome.MergeMonitorPlugin;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskChartCardPlugin
extends AbstractBaseListPlugin {
    protected static final String TITLE = "taskstatusname";
    protected static final String PIECHARTAP = "piechartap";
    protected static final String STATUSCATEGORY = "statuscategory";
    protected static final String COUNTINFOPANELAP = "countinfopanelap";
    protected static final String KEY_MCSTATUS_COUNT = "KEY_MCSTATUS_COUNT";
    protected boolean isShowTip = false;
    protected static final List<String> CardFormIdsNoEntity = Arrays.asList("bcm_card_taskprogress", "bcm_card_taskprogresslist", "bcm_card_mergebackrank", "bcm_card_mergestatuscount", "bcm_card_mergemonitor");

    @Override
    public String getBizAppId() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return StringUtils.isNotEmpty((String)appId) ? appId : "cm";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshDimByUserSelect();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "statuscategory": {
                this.refreshInfo((String)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "refreshtime": {
                this.refreshDimByUserSelect();
            }
            case "scenario": 
            case "year": 
            case "period": 
            case "entity": {
                this.refreshData();
                break;
            }
        }
    }

    protected void refreshDimByUserSelect() {
        this.refreshBillByUserSelect(MergeMonitorPlugin._DIM_KEYS, true);
        if (this.hasEntity() && null != this.getValue("model")) {
            this.refreshBillByUserSelect(MergeMonitorPlugin._NO_LEAF_KEYS, false);
        }
    }

    protected DynamicObject getCtrl(String ctl) {
        return (DynamicObject)this.getModel().getValue(ctl);
    }

    protected Long getCtrlId(String ctl) {
        DynamicObject obj = this.getCtrl(ctl);
        return obj != null ? Long.valueOf(obj.getLong("id")) : null;
    }

    protected String getAllDimInfo(List<String> dimKeys) {
        ArrayList<String> names = new ArrayList<String>(dimKeys.size());
        for (String dimKey : dimKeys) {
            DynamicObject dyn = this.getCtrl(dimKey);
            if (null == dyn) continue;
            names.add(dyn.getString("name"));
        }
        return String.join((CharSequence)" ", names);
    }

    protected String setTitle(String statusCategory) {
        ComboEdit comboEdit;
        List comboItems;
        ValueMapItem item;
        String title = StringUtils.isEmpty((String)statusCategory) ? this.getTitleDefalut() : (null != (item = (comboItems = ((ComboProp)(comboEdit = (ComboEdit)this.getControl(STATUSCATEGORY)).getProperty()).getComboItems()).stream().filter(e -> Objects.equals(statusCategory, e.getValue())).findFirst().orElseGet(() -> null)) ? item.getName().toString() : (CollectionUtils.isNotEmpty((Collection)comboItems) ? ((ValueMapItem)comboItems.get(0)).getName().toString() : this.getTitleDefalut()));
        ((kd.bos.form.control.Label)this.getControl(TITLE)).setText(title);
        return title;
    }

    protected void refreshData() {
    }

    protected void refreshInfo(String statusCategory) {
    }

    protected String getTitleDefalut() {
        return "";
    }

    protected String getStatusColor(Object statusEnum, String statusName) {
        return null;
    }

    protected int getItemMaxNum() {
        return 6;
    }

    protected boolean hasEntity() {
        return true;
    }

    protected boolean validateDim(List<String> dimKeys) {
        boolean flag = true;
        Long modelId = this.getModelId();
        for (String dimKey : dimKeys) {
            if (null != this.getCtrl(dimKey)) continue;
            flag = false;
            IFormView parentView = null != this.getView().getParentView() ? this.getView().getParentView() : this.getView();
            List<Pair<String, String>> list = TaskCardHelper.getCardPageId(parentView.getPageCache(), CardFormIdsNoEntity);
            Pair cardPageId = list.stream().filter(e -> StringUtils.isNotEmpty((String)((String)e.p2)) && null != parentView.getView((String)e.p2)).findFirst().orElseGet(() -> null);
            if (this.isShowTip || null == cardPageId || !Objects.equals(cardPageId.p2, this.getView().getPageId())) break;
            this.isShowTip = true;
            if (TaskCardHelper.existCard(this.getView(), "bcm_card_taskcontextf7")) break;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6dfb\u52a0\u4efb\u52a1\u4e0a\u4e0b\u6587\u5361\u7247\u3002", (String)"TaskProgressPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TaskCardHelper.getDimTitle(modelId, dimKey)));
            break;
        }
        return flag;
    }

    protected void refreshChart(Object statusEnum, String serieName, LinkedHashMap<String, Integer> dataMap) {
        PieChart pieChart = (PieChart)this.getControl(PIECHARTAP);
        if (null == dataMap || dataMap.size() == 0) {
            this.cleanChart();
            return;
        }
        pieChart.clearData();
        int total = dataMap.values().stream().mapToInt(e -> e).sum();
        pieChart.setShowTitle(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        pieChart.setTitlePropValue("text", (Object)ResManager.loadKDString((String)"\u603b\u8ba1", (String)"TaskChartCardPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        pieChart.setTitlePropValue("subtext", (Object)total);
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        pieChart.setLegendVertical(true);
        pieChart.setLegendAlign(XAlign.left, YAlign.center);
        pieChart.setLegendPropValue("left", (Object)300);
        pieChart.setLegendPropValue("itemGap", (Object)25);
        pieChart.setLegendPropValue("itemHeight", (Object)8);
        pieChart.setLegendPropValue("itemWidth", (Object)8);
        PieSeries pieSeries = pieChart.createPieSeries(serieName);
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        ItemValue[] itemValues = new ItemValue[dataMap.size()];
        int i = 0;
        for (Map.Entry<String, Integer> e2 : dataMap.entrySet()) {
            String color = this.getStatusColor(statusEnum, e2.getKey());
            itemValues[i] = new ItemValue(e2.getKey(), (Number)e2.getValue(), color);
            LabelAp itemColor = new LabelAp();
            String itemColorKey = "item_color" + i;
            itemColor.setKey(itemColorKey);
            itemColor.setBackColor(color);
            this.getView().updateControlMetadata(itemColorKey, itemColor.createControl());
            BigDecimal rate = 0 != total ? new BigDecimal(e2.getValue()).multiply(new BigDecimal(100)).divide(new BigDecimal(total), 0, RoundingMode.HALF_UP) : BigDecimal.ZERO;
            ((kd.bos.form.control.Label)this.getControl("item_name" + i)).setText(e2.getKey());
            ((kd.bos.form.control.Label)this.getControl("item_rate" + i)).setText("| &nbsp;" + rate + "%");
            ((kd.bos.form.control.Label)this.getControl("item_num" + i)).setText("| &nbsp;" + e2.getValue());
            ++i;
        }
        pieSeries.setData(itemValues);
        pieChart.refresh();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{COUNTINFOPANELAP});
        for (int j = 0; j < this.getItemMaxNum(); ++j) {
            this.getView().setVisible(Boolean.valueOf(j < i), new String[]{"countitem" + j});
        }
    }

    protected String getStatusCategory() {
        return (String)this.getModel().getValue(STATUSCATEGORY);
    }

    protected void cleanChart() {
        PieChart pieChart = (PieChart)this.getControl(PIECHARTAP);
        pieChart.clearData();
        pieChart.refresh();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{COUNTINFOPANELAP});
    }

    protected FixedItem getFixedItem() {
        DynamicObject entityDy = this.getCtrl("entity");
        SimpleItem entityItem = null != entityDy ? SimpleItem.newOne((Object)entityDy.getLong("id"), (String)entityDy.getString("number")) : null;
        return this.getFixedItem(entityItem);
    }

    protected FixedItem getFixedItem(SimpleItem entityItem) {
        DynamicObject modelDy = this.getCtrl("model");
        DynamicObject scenarioDy = this.getCtrl("scenario");
        DynamicObject yearDy = this.getCtrl("year");
        DynamicObject periodDy = this.getCtrl("period");
        SimpleItem modelItem = null != modelDy ? SimpleItem.newOne((Object)modelDy.getLong("id"), (String)modelDy.getString("number")) : null;
        SimpleItem scenarioItem = null != scenarioDy ? SimpleItem.newOne((Object)scenarioDy.getLong("id"), (String)scenarioDy.getString("number")) : null;
        SimpleItem yearItem = null != yearDy ? SimpleItem.newOne((Object)yearDy.getLong("id"), (String)yearDy.getString("number")) : null;
        SimpleItem periodDyItem = null != periodDy ? SimpleItem.newOne((Object)periodDy.getLong("id"), (String)periodDy.getString("number")) : null;
        FixedItem ctx = FixedItem.newOne((SimpleItem)modelItem, (SimpleItem)scenarioItem, (SimpleItem)yearItem, (SimpleItem)periodDyItem, (SimpleItem)entityItem);
        return ctx;
    }
}

