/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.AppHome.MergeBackRankPlugin;
import kd.fi.bcm.formplugin.AppHome.MergeMonitorPlugin;
import kd.fi.bcm.formplugin.AppHome.MergeStatusCountPlugin;
import kd.fi.bcm.formplugin.AppHome.TaskProgressPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCardHelper;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class TaskContextF7Plugin
extends AbstractBaseListPlugin {
    private static final List<String> _DIM_KEYS = MergeMonitorPlugin._DIM_KEYS;
    private static final List<String> _NO_LEAF_KEYS = MergeMonitorPlugin._NO_LEAF_KEYS;
    private static final List<String> ALL_KEYS = Arrays.asList("scenario", "year", "period", "entity");

    @Override
    public void initialize() {
        HashMap map = new HashMap();
        this.asMapF7toType(_DIM_KEYS, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(_NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        super.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(_DIM_KEYS, true);
        if (null != this.getValue("model")) {
            this.refreshBillByUserSelect(_NO_LEAF_KEYS, false);
        }
        this.setF7DimName();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.propertyChangedByDim(e);
        if ("model".equals(e.getProperty().getName())) {
            this.setF7DimName();
        }
        TaskCardHelper.refreshRelaCard(this.getView(), "bcm_card_mergemonitor", Collections.singletonList(Pair.onePair((Object)e.getProperty().getName(), (Object)e.getChangeSet()[0].getNewValue())));
        TaskCardHelper.refreshRelaCardByChangeDim(e, this.getView(), "bcm_card_mergestatuscount", MergeStatusCountPlugin.ALL_DIM_INFO);
        TaskCardHelper.refreshRelaCardByChangeDim(e, this.getView(), "bcm_card_taskprogress", TaskProgressPlugin.ALL_DIM_INFO);
        TaskCardHelper.refreshRelaCardByChangeDim(e, this.getView(), "bcm_card_taskprogresslist", TaskProgressPlugin.ALL_DIM_INFO);
        TaskCardHelper.refreshRelaCardByChangeDim(e, this.getView(), "bcm_card_mergebackrank", MergeBackRankPlugin.ALL_DIM_INFO);
    }

    private void propertyChangedByDim(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() != null && !(e.getChangeSet()[0].getNewValue() instanceof DynamicObject)) {
            return;
        }
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getLong("id") == oldValue.getLong("id")) {
            return;
        }
        Long modelId = this.getCtrlId("model");
        Long sceneId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        String modelNumber = this.getCtrlNumber("model");
        String yearNumber = this.getCtrlNumber("year");
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        if ("model".equals(propName)) {
            this.propertyChangedModelUse(new ArrayList<String>(ALL_KEYS));
        } else if (!"entity".equals(propName) && _DIM_KEYS.contains(propName)) {
            DynamicObject entityOld;
            Boolean isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false);
            if (Boolean.FALSE.equals(isSureReturn)) {
                return;
            }
            if (modelId == null || sceneId == null || yearId == null || periodId == null) {
                this.getModel().setValue("entity", null);
                return;
            }
            if ("scenario".equals(propName)) {
                IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId);
                this.getView().setVisible(Boolean.valueOf(Boolean.TRUE.equals(sceneNode.getProperty("isversioned"))), new String[]{"versioned", "cancelversioned", "scenename"});
            }
            if ((entityOld = this.getCtrl("entity")) == null) {
                this.getModel().setValue("entity", null);
                return;
            }
            dynColl.add((Object)entityOld);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId.longValue(), sceneId.longValue(), yearNumber, periodId.longValue());
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)filterOrgStructParam, (List)dynColl);
            if (CollectionUtils.isEmpty((Collection)dynColl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u8303\u56f4\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u539f\u6709\u8bb0\u5fc6\u529f\u80fd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u9009\u62e9\u7ec4\u7ec7\u6210\u5458\u3002", (String)"MergeControlListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("entity", null);
                return;
            }
            DynamicObjectCollection noMerge = OrgServiceHelper.getNoMergeOrgList((DynamicObjectCollection)dynColl, (Long)this.getModelId(), (Long)sceneId, (Long)yearId, (Long)periodId);
            if (CollectionUtils.isNotEmpty((Collection)noMerge)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d,\u5728\u6b64\u671f\u95f4\u4e0d\u53c2\u4e0e\u5408\u5e76\u3002", (String)"MergeControlListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)noMerge.get(0)).getString("name")));
                if (!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") || !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM030") && !ConfigServiceHelper.getNonLeafOfCM030((Long)this.getModelId())) {
                    this.getModel().setValue("entity", null);
                    return;
                }
            }
        }
        this.saveUserSelect();
    }

    private DynamicObject getCtrl(String ctl) {
        return (DynamicObject)this.getModel().getValue(ctl);
    }

    private Long getCtrlId(String ctl) {
        DynamicObject obj = this.getCtrl(ctl);
        return obj != null ? Long.valueOf(obj.getLong("id")) : null;
    }

    private String getCtrlNumber(String ctl) {
        DynamicObject obj = this.getCtrl(ctl);
        return obj != null ? obj.getString("number") : null;
    }

    private void saveUserSelect() {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String sceneId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        String entityId = UserSelectUtil.getF7SelectId(this.getView(), "entity");
        if (StringUtils.isBlank((CharSequence)modelId) || StringUtils.isBlank((CharSequence)sceneId) || StringUtils.isBlank((CharSequence)yearId) || StringUtils.isBlank((CharSequence)periodId) || StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        UserSelectModel userModel = new UserSelectModel();
        userModel.setApplication(ModelUtil.queryApp((IFormView)this.getView()));
        userModel.setModel(modelId);
        userModel.setScene(sceneId);
        userModel.setPeriod(periodId);
        userModel.setYear(yearId);
        userModel.setOrg(entityId);
        userModel.setModifier(RequestContext.getOrCreate().getUserId());
        UserSelectUtil.savetUserSelect(userModel);
    }

    private void setF7DimName() {
        Long modelId = this.getModelId();
        for (String dimKey : ALL_KEYS) {
            ((BasedataEditSingleMemberF7)this.getControl(dimKey)).setCaption(new LocaleString(TaskCardHelper.getDimTitle(modelId, dimKey)));
        }
    }

    @Override
    protected Map<String, Object> getF7CustomData(String f7Key) {
        if ("entity".equals(f7Key)) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            DynamicObject yearDy = this.getCtrl("year");
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
            DynamicObject scenarioDy = this.getCtrl("scenario");
            if (yearDy != null) {
                customData.put("yearNum", yearDy.getString("number"));
                customData.put("yearId", yearDy.getLong("id"));
            }
            if (periodId != null) {
                customData.put("periodId", periodId);
            }
            if (scenarioDy != null) {
                customData.put("scenarioId", scenarioDy.getLong("id"));
            }
            customData.put("isContainShare", true);
            customData.put("disableRateCls", true);
            customData.put("org_fuzzySearch_flag", 1);
            return customData;
        }
        return null;
    }
}

