/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskPermHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskTmplStatus;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AppHome.TaskChartCardPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskCommonHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOpenMenuHelper;
import kd.fi.bcm.formplugin.taskmanage.helper.TaskOperateHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskProgressPlugin
extends TaskChartCardPlugin {
    private static final String BASEINFO = "baseinfo";
    private static final String ENDTIME = "endtime";
    private static final String BILLLISTAP = "billlistap";
    public static final List<String> ALL_DIM_INFO = Arrays.asList("model", "scenario", "year", "period");
    private boolean hasAddListener = false;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BASEINFO);
        this.createListDataProviderListener();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.validateDim(ALL_DIM_INFO)) {
            this.initTaskRecordList();
            this.refreshInfo(this.getStatusCategory());
        } else {
            this.cleanInfo();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    public void click(EventObject evt) {
        String eKey;
        super.click(evt);
        switch (eKey = ((Control)evt.getSource()).getKey()) {
            case "baseinfo": {
                this.baseinfo();
                break;
            }
        }
    }

    @Override
    public void refreshData() {
        if (this.validateDim(ALL_DIM_INFO)) {
            this.initTaskRecordList();
        } else {
            this.initTaskRecordList();
            this.cleanInfo();
        }
    }

    @Override
    public void refreshInfo(String statusCategory) {
        this.setTitle(statusCategory);
        this.refreshChart(null, this.getAllDimInfo(ALL_DIM_INFO), this.getTaskStatusData(statusCategory));
        TaskRecordModel recordModel = this.refreshTaskRecordInfo(statusCategory);
        this.refreshBillList(statusCategory, recordModel);
    }

    private LinkedHashMap<String, Integer> getTaskStatusData(String statusCategory) {
        if (StringUtils.isEmpty((CharSequence)statusCategory)) {
            return null;
        }
        Map map = UserTaskHelper.getTaskRecordStatusCount((Long)Long.valueOf(statusCategory));
        LinkedHashMap<String, Integer> resultMap = new LinkedHashMap<String, Integer>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            String name = TaskStatusEnum.getEnumByCode((String)((String)entry.getKey())).getName();
            resultMap.put(name, (Integer)entry.getValue());
        }
        return resultMap;
    }

    @Override
    public String getTitleDefalut() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6", (String)"TaskProgressPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getStatusColor(Object statusEnum, String statusName) {
        return TaskStatusEnum.getStatusColor((String)statusName);
    }

    @Override
    protected int getItemMaxNum() {
        return 4;
    }

    @Override
    protected boolean hasEntity() {
        return ALL_DIM_INFO.contains("entity");
    }

    private void cleanInfo() {
        this.setTitle(this.getStatusCategory());
        this.cleanChart();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BASEINFO, ENDTIME});
        this.refreshBillList(null, null);
    }

    private void initTaskRecordList() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("statuscategory");
        Long modelId = this.getModelId();
        Long scenarioId = this.getCtrlId("scenario");
        Long yearId = this.getCtrlId("year");
        Long periodId = this.getCtrlId("period");
        if (!(LongUtil.isvalidLong((Object)modelId) && LongUtil.isvalidLong((Object)scenarioId) && LongUtil.isvalidLong((Object)yearId) && LongUtil.isvalidLong((Object)periodId))) {
            comboEdit.setComboItems(Collections.emptyList());
            this.setValue("statuscategory", null);
            return;
        }
        HashMap<String, Long> dimMap = new HashMap<String, Long>(3);
        dimMap.put(SysDimensionEnum.Scenario.getNumber(), scenarioId);
        dimMap.put(SysDimensionEnum.Year.getNumber(), yearId);
        dimMap.put(SysDimensionEnum.Period.getNumber(), periodId);
        List recordModelList = UserTaskHelper.loadTaskRecordByDataSet((Long)modelId, dimMap);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(recordModelList.size());
        for (TaskRecordModel e : recordModelList) {
            items.add(new ComboItem(new LocaleString(e.getTaskTemplateModel().getName()), String.valueOf(e.getId())));
        }
        comboEdit.setComboItems(items);
        String selectValue = null;
        if (CollectionUtils.isNotEmpty((Collection)recordModelList)) {
            selectValue = String.valueOf(((TaskRecordModel)recordModelList.get(0)).getId());
        }
        this.setValue("statuscategory", selectValue);
    }

    private void baseinfo() {
        Long taskRecordId = Long.valueOf(this.getStatusCategory());
        TaskRecordModel recordModel = UserTaskHelper.loadTaskRecord((Long)taskRecordId);
        if (TaskReocrdStatusEnum.SUSPEND == recordModel.getTaskRecordStatus()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6682\u6302", (String)"TaskProgressPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TaskOpenMenuHelper.openUserTaskList(this.getView(), this.getModelId(), taskRecordId);
    }

    private TaskRecordModel refreshTaskRecordInfo(String statusCategory) {
        int is;
        if (StringUtils.isEmpty((CharSequence)statusCategory)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BASEINFO, ENDTIME});
            return null;
        }
        Long taskRecordId = Long.valueOf(statusCategory);
        TaskRecordModel recordModel = UserTaskHelper.loadTaskRecord((Long)taskRecordId);
        if (null != recordModel.getEndTime()) {
            Label endTime = (Label)this.getControl(ENDTIME);
            long remainTime = recordModel.getEndTime().getTime() - System.currentTimeMillis();
            if (remainTime > 0L) {
                BigDecimal t = new BigDecimal(remainTime).divide(new BigDecimal(86400000), 1, RoundingMode.HALF_UP);
                endTime.setText(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5269\u4f59\u65f6\u95f4\uff1a%s\u5929\u3002", (String)"TaskProgressPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), t));
            } else {
                endTime.setText(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f", (String)"TaskProgressPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        boolean permflag = (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), this.getBizAppId(), "bcm_usertasklist", "47150e89000000ac")) == 0 && !MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()));
        this.getView().setVisible(Boolean.valueOf(!permflag), new String[]{BASEINFO});
        this.getView().setVisible(Boolean.valueOf(null != recordModel.getEndTime()), new String[]{ENDTIME});
        ((Label)this.getControl("taskstatusname")).setText(recordModel.getTaskTemplateModel().getName());
        return recordModel;
    }

    private void refreshBillList(String statusCategory, TaskRecordModel recordModel) {
        if (!Objects.equals("bcm_card_taskprogresslist", this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        if (!this.hasAddListener) {
            this.createListDataProviderListener();
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        FilterParameter fp = new FilterParameter();
        if (StringUtils.isEmpty((CharSequence)statusCategory) || null == recordModel) {
            fp.getQFilters().add(new QFilter("1", "=", (Object)2));
        } else {
            fp.getQFilters().add(new QFilter("taskrecord", "=", (Object)Long.valueOf(statusCategory)));
            fp.getQFilters().add(TaskPermHelper.getDisMemberPerm((Long)recordModel.getTaskTemplateId()));
        }
        billList.clearSelection();
        billList.setQueryFilterParameter(fp);
        this.setColumnDimName(recordModel);
        billList.refresh();
    }

    private void createListDataProviderListener() {
        if (null == this.getControl(BILLLISTAP)) {
            return;
        }
        this.hasAddListener = true;
        ((BillList)this.getControl(BILLLISTAP)).addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ListDataProvider(){
            private static final String REPORTCOMPLETE = "reportcomplete";
            private static final String REPORTCOMMIT = "reportcommit";
            private List showProps = Lists.newArrayList((Object[])new DynamicSimpleProperty[]{new DynamicSimpleProperty("reportcomplete", String.class, (Object)"-"), new DynamicSimpleProperty("reportcommit", String.class, (Object)"-")});

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                this.showProps.forEach(e -> rows.getDynamicObjectType().getProperties().add(e));
                TaskRecordModel taskRecord = UserTaskHelper.loadTaskRecord((Long)UserTaskModel.dynToModel((Long)((DynamicObject)rows.get(0)).getLong("id")).getTaskrecord());
                Map<Long, Long> usertaskAndOrgIds = rows.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> TaskOperateHelper.getEntityMemberId(e)));
                Map reportProgressMap = TaskRecordServiceHelper.getUserTaskReportProgress((TaskRecordModel)taskRecord, usertaskAndOrgIds, null, null);
                for (DynamicObject row : rows) {
                    TaskTmplStatus reportPregress = (TaskTmplStatus)reportProgressMap.get(row.getLong("id"));
                    if (null == reportPregress || reportPregress.getTotal() <= 0) continue;
                    row.set(REPORTCOMPLETE, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)reportPregress.getEcCount().getComplete(), (Object)reportPregress.getTotal())));
                    row.set(REPORTCOMMIT, (Object)TaskCommonHelper.convertProgress((Pair<Integer, Integer>)Pair.onePair((Object)reportPregress.getEcCount().getCommit(), (Object)reportPregress.getTotal())));
                }
                return rows;
            }
        }));
    }

    private void setColumnDimName(TaskRecordModel recordModel) {
        String disDimension = null != recordModel ? recordModel.getTaskTemplateModel().getDisdimensionentity() : SysDimensionEnum.Entity.getMemberTreemodel();
        SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByMemberTreemodel((String)disDimension);
        TaskCommonHelper.setColumnDimNumAndName(this.getView(), this.getModelId(), new String[]{"membernumber", "membername"}, (null != dimEnum ? dimEnum : SysDimensionEnum.Entity).getSign());
    }
}

