/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.util.UpgradeStatusUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DownFileUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.invest.InvRelationReportPlugin;
import kd.fi.bcm.formplugin.licence.BcmLicenceControl;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.perm.UnionPermCommon;
import kd.fi.bcm.formplugin.report.ReportListPlugin;
import kd.fi.bcm.formplugin.template.model.ISupportPageCacheProxy;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

@SDKMark
public interface BCMBaseFunction {
    public static final WatchLogger watchlogger = BcmLogFactory.getWatchLogInstance((boolean)true, BCMBaseFunction.class);
    public static final Set<String> EXCLUDE_VIEW_SET = Sets.newHashSet((Object[])new String[]{"bcm_createautoadjustparam", "bcm_continueentryparam", "bcm_shareholdingcalc", "bcm_copyinvestparam", "bcm_dispatchparam", "bcm_periodsetting", "bcm_dispatchmergeconfig", "bcm_dispatchperiod", "bcm_dispatchmergeflow", "bcm_showprogress"});

    public AbstractFormPlugin getPlugin();

    default public void bcmPreOpen(PreOpenFormEventArgs e) {
        UserSelectModel userSelect;
        Long modelId;
        FormShowParameter fs = (FormShowParameter)e.getSource();
        fs.setHasRight(true);
        String formId = fs.getFormId();
        String appId = e.getFormShowParameter().getAppId();
        String msg = BcmLicenceControl.checkByVersion(fs);
        if (StringUtils.isNotEmpty((String)msg)) {
            e.setCancel(true);
            e.setCancelMessage(msg);
            BcmLicenceControl.setCustomLicWindowMsg(e, msg);
            return;
        }
        if (!UpgradeStatusUtil.isInWhiteList((FormShowParameter)fs) && (modelId = LongUtil.toLong((Object)(userSelect = UserSelectServiceHelper.getUserSelect((String)RequestContext.get().getUserId(), (String)UserSelectServiceHelper.getDefaultFileds((String)formId), (ApplicationTypeEnum)ApplicationTypeEnum.getEnumByNumber((String)appId))).getModel())) != 0L && !UpgradeStatusUtil.isModelUpgraded((long)modelId).booleanValue()) {
            QFilter qf = new QFilter("id", "=", (Object)modelId);
            DynamicObject modelobj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"name", (QFilter[])qf.toArray());
            String modelName = modelobj.getString("name");
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u5347\u7ea7\uff0c\u201c%s\u201d\u4f53\u7cfb\u9700\u5148\u5347\u7ea7\u624d\u80fd\u4f7f\u7528\u3002", (String)"BCMBaseFunction_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName));
            BcmLicenceControl.setCustomLicWindowMsg(e, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u5347\u7ea7\uff0c\u201c%s\u201d\u4f53\u7cfb\u9700\u5148\u5347\u7ea7\u624d\u80fd\u4f7f\u7528\u3002", (String)"BCMBaseFunction_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelName));
            return;
        }
        LicenseCheckResult re = null;
        re = BcmLicenceControl.check(appId, formId);
        if (re != null && !re.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(re.getMsg());
            BcmLicenceControl.setStandardPlatformLicWindowMsg(e, re);
        }
    }

    default public PermissionService getPermService(Long modelId) {
        return PermissionServiceImpl.getInstance((Long)modelId);
    }

    default public IFormView getParentView() {
        try {
            return this.getPlugin().getView().getParentView();
        }
        catch (KDException e) {
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    default public long getModelId() {
        Object model = ThreadCache.get((Object)"getModelId");
        if (model != null) {
            return (Long)model;
        }
        long modelid = this.loadModelId();
        if (modelid != 0L) {
            ThreadCache.put((Object)"getModelId", (Object)modelid);
        }
        return modelid;
    }

    default public Long loadModelId() {
        Object model;
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model") && (model = this.getPlugin().getView().getModel().getValue("model")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        String modelId = this.getPlugin().getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("KEY_MODEL_ID") == null ? "" : this.getFormCustomParam("KEY_MODEL_ID").toString();
        }
        if (StringUtils.isEmpty((String)modelId) || "null".equals(modelId)) {
            this.getPlugin().getPageCache().put("KEY_MODEL_ID", "0");
            this.getPlugin().getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)0);
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    default public boolean isCMModel() {
        long modelId = this.getModelId();
        if (Objects.isNull(modelId) || modelId == 0L) {
            return false;
        }
        return (Boolean)ThreadCache.get((Object)("isCMModel_" + modelId), () -> {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            if (dy == null) {
                return false;
            }
            if (ApplicationTypeEnum.CM.getOIndex().equals(dy.getString("reporttype"))) {
                return true;
            }
            return false;
        });
    }

    default public boolean isExistDimension(String modelNum, String dimNum) {
        return MemberReader.isExistDimension((String)modelNum, (String)dimNum);
    }

    default public boolean isExistAuditTrailDimension() {
        return this.isExistAuditTrailDimension(this.getModelId());
    }

    default public boolean isExistChangeTypeDimension() {
        return this.isExistChangeTypeDimension(this.getModelId());
    }

    default public boolean isExistAuditTrailDimension(long modelId) {
        return this.isExistDimension(MemberReader.findModelNumberById((Object)modelId), PresetConstant.AUDITTRIAL_DIM);
    }

    default public boolean isExistChangeTypeDimension(long modelId) {
        return this.isExistDimension(MemberReader.findModelNumberById((Object)modelId), PresetConstant.CHANGETYPE_DIM);
    }

    default public long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    default public <T> T deSerializedBytes(String serial) {
        return (T)(serial == null ? null : ObjectSerialUtil.deSerializedBytes((String)serial));
    }

    default public String toByteSerialized(Object t) {
        return ObjectSerialUtil.toByteSerialized((Object)t);
    }

    default public <T> T getFormCustomParam(String key) {
        return (T)this.getPlugin().getView().getFormShowParameter().getCustomParam(key);
    }

    default public void asMapF7toType(List<String> dimKeys, SingleF7TypeEnum type, Map<String, SingleF7TypeEnum> map) {
        dimKeys.forEach(k -> map.put((String)k, type));
    }

    default public void initSingleMemberF7(Map<String, SingleF7TypeEnum> map) {
        this.getPlugin().getView().addCustomControls(map.keySet().toArray(new String[0]));
        this.getPlugin().getPageCache().put("dimKeyMap2Type", this.toByteSerialized(map));
    }

    default public SingleMemberF7Util.ISingleMemberF7Handle getSingleMemberF7Handle(final List<String> dimKeys) {
        SingleMemberF7Util.ISingleMemberF7Handle handle = new SingleMemberF7Util.ISingleMemberF7Handle(){

            @Override
            public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
                DynamicObject yearDy;
                Object ifFifterDataSource;
                FormShowParameter formShowParameter = arg0.getFormShowParameter();
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"BCMBaseFunction_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                long modelId = BCMBaseFunction.this.getModelId();
                if (0L == modelId) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BCMBaseFunction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                BasedataEditSingleMemberF7 source = (BasedataEditSingleMemberF7)((Object)arg0.getSource());
                final String f7Name = source.getFieldKey();
                BCMBaseFunction.this.setSingleF7Filter(source);
                OrgUtils.resetBasedataFuzzySearchQFilter2Org(arg0, modelId);
                Map<String, Object> customData = source.getCustomData();
                if (customData != null && "true".equals(ifFifterDataSource = customData.get("ifFifterDataSource"))) {
                    QFilter qf = new QFilter("datasource", "=", (Object)"3");
                    qf.and("isleaf", "=", (Object)"1");
                    qf.and("model", "=", (Object)BCMBaseFunction.this.getModelId());
                    ArrayList<QFilter> qflist = new ArrayList<QFilter>();
                    qflist.add(qf);
                    source.setQFilters(qflist);
                }
                List sourceqFilters = source.getQFilters();
                if (source.getCustomData() != null) {
                    formShowParameter.getCustomParams().putAll(source.getCustomData());
                    Object isContainShare = formShowParameter.getCustomParam("isContainShare");
                    if (isContainShare != null && !((Boolean)isContainShare).booleanValue()) {
                        sourceqFilters.add(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
                    }
                }
                if (BCMBaseFunction.this.getPeriodLogo().equals(f7Name) && dimKeys.contains("scenario")) {
                    DynamicObject scenarioDy = (DynamicObject)source.getModel().getValue("scenario");
                    if (scenarioDy == null) {
                        scenarioDy = (DynamicObject)BCMBaseFunction.this.getValue("scenario");
                    }
                    DimensionServiceHelper.checkSPConfig((boolean)true, (DynamicObject)scenarioDy, (long)BCMBaseFunction.this.getModelId(), (IDataModel)BCMBaseFunction.this.getPlugin().getView().getModel(), (String)BCMBaseFunction.this.getPeriodLogo());
                    DimensionServiceHelper.buildPeriodFilter((long)BCMBaseFunction.this.getModelId(), (long)scenarioDy.getLong("id"), (FormShowParameter)formShowParameter);
                    if (Objects.isNull(arg0.getProperty()) || Objects.isNull(arg0.getProperty().getParent()) || !Objects.equals(arg0.getProperty().getParent().getName(), "bcm_taskcatalogedit")) {
                        DimensionServiceHelper.hazySearch((long)BCMBaseFunction.this.getModelId(), (long)scenarioDy.getLong("id"), (BasedataEdit)source);
                    }
                }
                if (!EXCLUDE_VIEW_SET.contains(source.getView().getFormShowParameter().getFormId()) && source.getModel().getDataEntityType().getProperties().containsKey((Object)"year") && BCMBaseFunction.this.getPeriodLogo().equals(f7Name) && dimKeys.contains("year") && (yearDy = (DynamicObject)source.getModel().getValue("year")) == null && BCMBaseFunction.this.getValue("year") == null && !"bcm_doc_uploads".equals(source.getView().getFormShowParameter().getFormId()) && !"bcm_doc_manage".equals(source.getView().getFormShowParameter().getFormId())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d22\u5e74\u3002", (String)"RptAdjustQueryEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                String keyField = arg0.getProperty().toString();
                if (keyField != null) {
                    ListFilterParameter listFilterParameter;
                    QFilter filter3;
                    QFilter filter2;
                    QFilter filter1;
                    ArrayList<QFilter> qFilters;
                    ListShowParameter showParameter;
                    ListFilterParameter listFilterParameter2;
                    if (formShowParameter instanceof ListShowParameter && (listFilterParameter2 = (showParameter = (ListShowParameter)formShowParameter).getListFilterParameter()) != null) {
                        String periodFilter;
                        List paramFilters = listFilterParameter2.getQFilters();
                        paramFilters.clear();
                        paramFilters.addAll(source.getQFilters());
                        if ("currency".equals(keyField) && "bcm_reportlistmultiexport".equals(source.getView().getFormShowParameter().getFormId())) {
                            paramFilters.add(new QFilter("number", "!=", (Object)"DC"));
                        }
                        if ("period".equals(keyField) && StringUtils.isNotEmpty((String)(periodFilter = (String)showParameter.getCustomParam("periodFilter")))) {
                            QFilter pFilter = (QFilter)ObjectSerialUtil.deSerializedBytes((String)periodFilter);
                            paramFilters.add(pFilter);
                        }
                    }
                    if (MessageDigest.isEqual("year".getBytes(), keyField.getBytes())) {
                        if (formShowParameter instanceof ListShowParameter) {
                            showParameter = (ListShowParameter)formShowParameter;
                            qFilters = new ArrayList<QFilter>();
                            filter1 = new QFilter("number", "<>", (Object)"CurrentYear");
                            filter2 = new QFilter("number", "<>", (Object)"LastYear");
                            filter3 = new QFilter("model", "=", (Object)BCMBaseFunction.this.getModelId());
                            QFilter isleaf = new QFilter("isleaf", "=", (Object)"1");
                            qFilters.add(filter1);
                            qFilters.add(filter2);
                            qFilters.add(filter3);
                            qFilters.add(isleaf);
                            listFilterParameter = showParameter.getListFilterParameter();
                            if (listFilterParameter != null) {
                                listFilterParameter.getQFilters().addAll(qFilters);
                            }
                            showParameter.setListFilterParameter(listFilterParameter == null ? new ListFilterParameter(qFilters, (String)null) : listFilterParameter);
                        }
                    } else if (MessageDigest.isEqual(BCMBaseFunction.this.getPeriodLogo().getBytes(), keyField.getBytes())) {
                        if (formShowParameter instanceof ListShowParameter) {
                            showParameter = (ListShowParameter)formShowParameter;
                            qFilters = new ArrayList();
                            filter1 = new QFilter("number", "<>", (Object)"CurrentPeriod");
                            filter2 = new QFilter("number", "<>", (Object)"LastPeriod");
                            filter3 = new QFilter("model", "=", (Object)BCMBaseFunction.this.getModelId());
                            boolean isFromReportList = BCMBaseFunction.this.getPlugin() instanceof ReportListPlugin;
                            if (!isFromReportList) {
                                QFilter isleaf = new QFilter("isleaf", "=", (Object)"1");
                                qFilters.add(isleaf);
                            }
                            qFilters.add(filter1);
                            qFilters.add(filter2);
                            qFilters.add(filter3);
                            listFilterParameter = showParameter.getListFilterParameter();
                            if (listFilterParameter != null) {
                                listFilterParameter.getQFilters().addAll(qFilters);
                            }
                            showParameter.setListFilterParameter(listFilterParameter == null ? new ListFilterParameter(qFilters, (String)null) : listFilterParameter);
                        }
                    } else if (MessageDigest.isEqual("version".getBytes(), keyField.getBytes()) && formShowParameter instanceof ListShowParameter) {
                        showParameter = (ListShowParameter)formShowParameter;
                        qFilters = new ArrayList();
                        QFilter actualqcf = new QFilter("number", "!=", (Object)"ACTUAL").and("number", "!=", (Object)"Version");
                        QFilter filter32 = new QFilter("model", "=", (Object)BCMBaseFunction.this.getModelId());
                        qFilters.add(actualqcf);
                        qFilters.add(filter32);
                        ListFilterParameter listFilterParameter3 = showParameter.getListFilterParameter();
                        if (listFilterParameter3 != null) {
                            listFilterParameter3.getQFilters().addAll(qFilters);
                        }
                        showParameter.setListFilterParameter(listFilterParameter3 == null ? new ListFilterParameter(qFilters, (String)null) : listFilterParameter3);
                    }
                    if (customData != null && customData.get("from") != null && "DimDesignerControlPlugin".equalsIgnoreCase(customData.get("from").toString()) && MessageDigest.isEqual("entity".getBytes(), keyField.getBytes())) {
                        String[] strings;
                        String value;
                        if (source.getSearchFilter() != null && source.getSearchFilter().getValue() != null && (value = source.getSearchFilter().getValue().toString()).contains("#") && value.contains("_") && (strings = value.split("#")).length > 1) {
                            String searchParam1 = strings[0];
                            String searchParam2 = strings[1];
                            String[] s = searchParam2.split("_");
                            if (s.length > 1) {
                                String fatherNumber = s[0];
                                String childNumber = s[1];
                                if (StringUtils.isNotEmpty((String)childNumber)) {
                                    String finalValue = searchParam1 + "#" + childNumber;
                                    source.getSearchFilter().__setValue((Object)finalValue);
                                    ListShowParameter showParameter2 = (ListShowParameter)formShowParameter;
                                    ArrayList<QFilter> qFilters2 = new ArrayList<QFilter>();
                                    QFilter filter = new QFilter("parent.number", "like", (Object)fatherNumber);
                                    qFilters2.add(filter);
                                    ListFilterParameter listFilterParameter4 = showParameter2.getListFilterParameter();
                                    if (listFilterParameter4 != null) {
                                        listFilterParameter4.getQFilters().addAll(qFilters2);
                                    }
                                    showParameter2.setListFilterParameter(listFilterParameter4 == null ? new ListFilterParameter(qFilters2, (String)null) : listFilterParameter4);
                                }
                            }
                        }
                        source.addAfterF7SelectListener(new AfterF7SelectListener(){

                            public void afterF7Select(AfterF7SelectEvent evt) {
                                if (evt.getInputValue() != null) {
                                    DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)evt.getInputValue(), (String)"bcm_entitymembertree");
                                    DynamicObject parent = org.getDynamicObject("parent");
                                    if (parent != null) {
                                        String code = parent.getString("number") + "_" + org.getString("number");
                                        org.set("number", (Object)code);
                                    }
                                    ThreadCache.put((Object)"from_entity_refresh", (Object)true);
                                    BCMBaseFunction.this.getView().getModel().setValue(f7Name, (Object)org);
                                }
                            }
                        });
                    }
                }
                if (formShowParameter.getShowParameter() instanceof ListShowParameter && source.getCustomData() != null && source.getCustomData().get("filter") != null) {
                    ((ListShowParameter)formShowParameter.getShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "in", source.getCustomData().get("filter")));
                }
            }
        };
        return handle;
    }

    default public String getPeriodLogo() {
        return "period";
    }

    default public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        QFilter numberFilter;
        boolean isTrue = true;
        boolean isFalse = false;
        QFilter modelFilter = new QFilter("model", "=", (Object)bdEdit.getModelId());
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,dseq,memberform", (QFilter[])new QFilter[]{modelFilter, numberFilter = new QFilter("number", "=", (Object)QueryDimensionServiceHelper.getDimNumberEgnoreCase((String)bdEdit.getDimNumber(), (long)bdEdit.getModelId()))});
        if (dimObj != null) {
            bdEdit.setDimId(dimObj.getLong("id"));
            bdEdit.setF7Value(dimObj.getInt("dseq"));
            bdEdit.setEntity(dimObj.getString("memberform"));
            QFilter permissonFilter = SingleMemberF7Util.getPermissionFilter(dimObj.getString("memberform"), dimObj.getLong("id"), bdEdit.getModelId());
            Map<String, Object> customData = bdEdit.getCustomData();
            if (customData != null) {
                Boolean queryexchangerate = (Boolean)customData.get("queryExchangeRateEntity");
                if (queryexchangerate != null && queryexchangerate.booleanValue()) {
                    modelFilter.and("isexchangerate", "=", (Object)"1");
                } else {
                    ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)modelFilter, (String)dimObj.getString("memberform"));
                }
            } else {
                ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)modelFilter, (String)dimObj.getString("memberform"));
            }
            if (permissonFilter != null) {
                modelFilter.and(permissonFilter);
            }
            modelFilter.and(QFilter.of((String)"dimension = ?", (Object[])new Object[]{bdEdit.getDimId()}));
        }
        switch (bdEdit.getType()) {
            case LEAF: {
                modelFilter.and(new QFilter("isleaf", "=", (Object)isTrue));
                break;
            }
            case NOLEAF: {
                modelFilter.and(new QFilter("isleaf", "=", (Object)isFalse));
                break;
            }
            case ROOT: {
                modelFilter.and(new QFilter("level", "!=", (Object)1));
                break;
            }
        }
        ArrayList qfilters = Lists.newArrayListWithCapacity((int)1);
        qfilters.add(modelFilter);
        bdEdit.setQFilters(qfilters);
    }

    default public void bcmInit() {
        DynamicPage dp;
        Page page;
        if (this instanceof DynamicPage && (page = (dp = (DynamicPage)((Object)this)).getPage(this.getPlugin().getView())) != null) {
            if (page.isChangeable()) {
                this.getPlugin().getView().getModel().getDataEntity();
            }
            ((DynamicPage)((Object)this)).getPage(this.getPlugin().getView()).bindCtrlMapping(this.getPlugin().getView());
        }
    }

    default public void bcmProChange(PropertyChangedArgs e) {
        if (this instanceof DynamicPage) {
            Element ele;
            Page page;
            String propertyName = e.getProperty().getName();
            DynamicPage dp = (DynamicPage)((Object)this);
            if (dp.needCache() && (page = dp.getPage(this.getPlugin().getView())) != null && (ele = page.findElementBySign(propertyName)) != null) {
                ele.setValue(this.getPlugin().getPageCache(), e.getChangeSet()[0].getNewValue());
                dp.setPage(this.getPlugin().getView(), page);
            }
        }
        BcmBasePluginUtil.propertyChanged(this.getPlugin(), e);
    }

    default public Object getValue(String sign) {
        DynamicPage dp;
        if (this instanceof DynamicPage && (dp = (DynamicPage)((Object)this)).needCache()) {
            Page page = dp.getPage(this.getPlugin().getView());
            if (null == page) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f", (String)"BCMBaseFunction_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return null;
            }
            Element ele = page.findElementBySign(sign);
            if (ele != null) {
                Object ori = this.getPlugin().getView().getModel().getValue(sign);
                if (ori instanceof DynamicObjectCollection) {
                    List relist = (List)ele.getValue(this.getPlugin().getPageCache());
                    if (relist == null) {
                        return this.getPlugin().getView().getModel().getValue(sign);
                    }
                    DynamicObjectCollection result = (DynamicObjectCollection)ori;
                    result.clear();
                    for (DynamicObject oo : relist) {
                        DynamicObject addnew = result.addNew();
                        addnew.set("fbasedataid", (Object)oo);
                    }
                    return result;
                }
                return ele.getValue(this.getPlugin().getPageCache());
            }
        }
        return this.getPlugin().getView().getModel().getValue(sign);
    }

    default public void setValue(String sign, Object value) {
        this.setValue(sign, value, true);
    }

    default public void setValue(String sign, Object value, boolean cachePage) {
        Page page;
        Element ele;
        DynamicPage dp;
        this.getPlugin().getView().getModel().setValue(sign, value);
        if (this instanceof DynamicPage && (dp = (DynamicPage)((Object)this)).needCache() && (ele = (page = dp.getPage(this.getPlugin().getView())).findElementBySign(sign)) != null) {
            ele.setValue(this.getPlugin().getPageCache(), this.getPlugin().getView().getModel().getValue(sign));
            if (cachePage) {
                dp.setPage(this.getPlugin().getView(), page);
            }
        }
    }

    default public void getBcmEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            try {
                MainEntityType copy = (MainEntityType)e.getOriginalEntityType().clone();
                e.setNewEntityType(copy);
                Page page = ((DynamicPage)((Object)this)).getPage(this.getPlugin().getView());
                if (page != null) {
                    page.cacheMainProp(this.getPlugin().getPageCache(), copy.getProperties());
                }
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    default public void getBcmControl(OnGetControlArgs e) {
        Element ele;
        DynamicPage dp;
        Page page;
        if (this instanceof DynamicPage && (page = (dp = (DynamicPage)((Object)this)).getPage(this.getPlugin().getView())) != null && (ele = page.findElementBySign(e.getKey())) != null) {
            e.setControl(ele.getControl(this.getPlugin().getView()));
        }
    }

    default public boolean checkControlKeyPrefix(IFormView view, String controlKey) {
        return TemplateUtil.isCtrl(view, controlKey);
    }

    @Deprecated
    default public boolean isEPM() {
        return false;
    }

    default public boolean isFIDM() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FIDM.appnum, appId);
    }

    default public boolean isFAR() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FAR.appnum, appId);
    }

    default public boolean isRPT() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.RPT == sign;
    }

    default public boolean isCM() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.CM == sign;
    }

    default public boolean isDI() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.DI == sign;
    }

    default public boolean isAEF() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.AEF == sign;
    }

    default public boolean isTrueFlagInCache(String key) {
        String str = this.getPlugin().getPageCache().get(key);
        return StringUtils.isEmpty((String)str) ? false : Boolean.parseBoolean(str);
    }

    default public long getEntityBaseMemberId(Object id) {
        return TreeStructureServiceHelper.getEntityBaseMemberId((long)Long.parseLong(id.toString()));
    }

    default public Map<Long, Long> getEntityBaseMemberIds(Collection<Long> ids) {
        return TreeStructureServiceHelper.getEntityBaseMemberIds(ids);
    }

    default public Map<String, Long> getEntityBaseMemberNumbers(Collection<Long> ids) {
        return TreeStructureServiceHelper.getEntityBaseMemberNumbers(ids);
    }

    default public Map<Long, String> getEntityBaseMemberid2Numbers(Collection<Long> ids) {
        return TreeStructureServiceHelper.getEntityBaseMemberid2Numbers(ids);
    }

    default public ApplicationTypeEnum getApplicationType() {
        return ModelUtil.queryApp(this.getPlugin().getView());
    }

    default public void delOrgMenberPerm(DynamicObjectCollection doc, Object modelid) {
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(Long.valueOf(modelid.toString()))) {
            this.getPlugin().getPageCache().put("isroot", "true");
            return;
        }
        this.getPlugin().getPageCache().put("isroot", "false");
        long dimensionId = this.queryDimensionId(modelid, PresetConstant.ENTITY_DIM);
        PermissionService permService = PermissionServiceImpl.getInstance((Long)Long.valueOf(modelid.toString()));
        PermPackageList perms = permService.getDimPermSet(Long.valueOf(dimensionId));
        this.getPlugin().getPageCache().put(PermCacheKey.ORG_PERM_CACHE_KEY, SerializationUtils.toJsonString((Object)perms));
        Map relationMap = MemberPermHelper.BuildPCRelation((DynamicObjectCollection)doc);
        Iterator permIt = doc.iterator();
        while (permIt.hasNext()) {
            DynamicObject dd = (DynamicObject)permIt.next();
            boolean flag = MemberPermHelper.memberCanShow((Object)dd.getLong("id"), (PermPackageList)perms, (Map)relationMap);
            if (flag) continue;
            permIt.remove();
        }
    }

    default public long queryDimensionId(Object modelid, String dimNum) {
        QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
        filter.and("number", "=", (Object)dimNum);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)LongUtil.toLong((Object)modelid), (String)dimNum);
        return dimensionId == null ? 0L : dimensionId;
    }

    default public DynamicObjectCollection getOrgDynamicObjectCollection(Object modelid) {
        return this.getCustomOrgDynamicObjectCollection(modelid, null);
    }

    default public DynamicObjectCollection getCustomOrgDynamicObjectCollection(Object modelid, QFBuilder builder) {
        String modelId = modelid == null ? "" : "" + modelid;
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)modelId);
        param.setBuilder(builder);
        param.setNeedSchemeFilter(this.isCM() || this.isRPT() || this.isDI());
        param.setNeedSchemeModelFilter(this.isCMModel() || this.isRPT() || this.isDI());
        DynamicObject dataEntity = this.getPlugin().getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        this.buildQueryParam(param, properties, "cslscheme", "number");
        this.buildQueryParam(param, properties, "year", "number");
        this.buildQueryParam(param, properties, "period", "id");
        this.buildQueryParam(param, properties, "scenario", "id");
        if (param.getCslScheme() == null) {
            Set cslSet = CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme((String)String.valueOf(this.getModelId()), (boolean)false);
            param.setCslSchemeSet(cslSet);
        }
        DynamicObjectCollection doc = CslSchemeServiceHelper.getOrgDynamicObjectCollection((CslSchemeServiceHelper.QueryOrgParam)param);
        return doc;
    }

    default public void buildQueryParam(CslSchemeServiceHelper.QueryOrgParam param, DataEntityPropertyCollection properties, String field, String propertyField) {
        DynamicObject dyn = null;
        if (properties.containsKey((Object)field)) {
            dyn = (DynamicObject)this.getPlugin().getView().getModel().getValue(field);
        } else {
            String value = (String)this.getPlugin().getView().getFormShowParameter().getCustomParam(field);
            if (StringUtils.isNotEmpty((String)value)) {
                String[] vs = value.split("&");
                dyn = BusinessDataServiceHelper.loadSingleFromCache((String)vs[0], (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)vs[1]))});
            }
        }
        if (dyn == null) {
            return;
        }
        if (dyn != null) {
            if ("cslscheme".equals(field)) {
                param.setCslScheme(Pair.of((Object)dyn.getLong("id"), (Object)dyn.getString("number")));
            } else {
                param.set(field, (Object)dyn.getString(propertyField));
            }
        }
    }

    default public void putCache2ParentView(String key, String v) {
        IFormView view = this.getPlugin().getView();
        if (view.getParentView() != null) {
            view = view.getParentView();
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
            List plugins = pluginProxy.getPlugIns();
            IPageCache pageCache = null;
            for (IFormPlugin p : plugins) {
                if (!ISupportPageCacheProxy.class.isAssignableFrom(p.getClass())) continue;
                pageCache = ((ISupportPageCacheProxy)ISupportPageCacheProxy.class.cast(p)).getPageCache();
                pageCache.put(key, v);
                ((ISupportPageCacheProxy)ISupportPageCacheProxy.class.cast(p)).pushCache();
                break;
            }
            if (pageCache == null) {
                pageCache = (IPageCache)view.getService(IPageCache.class);
                pageCache.put(key, v);
            }
        }
    }

    default public void checkItemAuthForHide(String ... buttons) {
        Map<String, Integer> btnPerms = this.getButtonsPerm(buttons);
        IFormView view = this.getPlugin().getView();
        btnPerms.forEach((btnStr, perm) -> view.setVisible(Boolean.valueOf(perm != 0), new String[]{btnStr}));
    }

    default public Map<String, Integer> getButtonsPerm(String ... buttons) {
        return this.getButtonsPermByPage(this.getPlugin().getView().getEntityId(), buttons);
    }

    default public Map<String, Integer> getButtonsPermByPage(String entity, String ... buttons) {
        HashMap btnPerms = Maps.newHashMapWithExpectedSize((int)16);
        if (buttons != null) {
            boolean hasModel = this.getModelId() != 0L;
            IFormView view = this.getPlugin().getView();
            Map permitem = BcmPermSingleModel.getInstance().getPermitem();
            Map map = (Map)permitem.get(entity);
            if (map != null && map.size() >= 1) {
                for (String button : buttons) {
                    String[] perm;
                    if (map.get(button) == null || (perm = ((String)map.get(button)).split("@")).length < 2) continue;
                    int permIndex = hasModel ? BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getAppId()).getId(), perm[0], perm[1]) : 0;
                    btnPerms.put(button, permIndex);
                }
            }
        }
        return btnPerms;
    }

    default public void savetUserSelectWhenOtherChange(String key, UserSelectModel userSelectModel) {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        if (modelId == null) {
            return;
        }
        ApplicationTypeEnum application = kd.fi.bcm.business.dimension.util.ModelUtil.queryApp((IFormView)this.getView());
        userSelectModel.setModel(modelId);
        userSelectModel.setOnlyModel(false);
        userSelectModel.setApplication(application);
        userSelectModel.setModifier(RequestContext.get().getUserId());
        if ("scenario".equals(key)) {
            userSelectModel.setScene(UserSelectUtil.getF7SelectId(this.getView(), "scenario"));
        }
        if ("year".equals(key)) {
            userSelectModel.setYear(UserSelectUtil.getF7SelectId(this.getView(), "year"));
        }
        if ("period".equals(key)) {
            userSelectModel.setPeriod(UserSelectUtil.getF7SelectId(this.getView(), "period"));
        }
        if ("currency".equals(key)) {
            userSelectModel.setCurrency(UserSelectUtil.getF7SelectId(this.getView(), "currency"));
        }
        if ("entity".equals(key)) {
            userSelectModel.setOrg(UserSelectUtil.getF7SelectId(this.getView(), "entity"));
        }
        if ("version".equals(key)) {
            userSelectModel.setVersion(UserSelectUtil.getF7SelectId(this.getView(), "version"));
        }
        if ("cslscheme".equals(key)) {
            userSelectModel.setCslScheme(UserSelectUtil.getF7SelectId(this.getView(), "cslscheme"));
        }
        if ("templatecatalog".equals(key)) {
            userSelectModel.setConfig(MapInitHelper.ofMap((Object)"templatecatalog", (Object)UserSelectUtil.getF7SelectId(this.getView(), "templatecatalog")));
        }
        UserSelectUtil.savetUserSelect(userSelectModel);
    }

    default public IFormView getView() {
        return this.getPlugin().getView();
    }

    default public boolean isModelManager(long modelId) {
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(modelId)) {
            this.getPlugin().getPageCache().put("isroot", "true");
            return true;
        }
        this.getPlugin().getPageCache().put("isroot", "false");
        return false;
    }

    default public boolean checkOrgMemberIsNoPerm(String memId) {
        if (Boolean.parseBoolean(this.getPlugin().getPageCache().get("isroot"))) {
            return false;
        }
        long modelId = this.getModelId();
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        return permService.hasNoPerm(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), LongUtil.toLong((Object)memId));
    }

    default public boolean checkOrgMemberIsReadAndWrite(String memId) {
        if (Boolean.parseBoolean(this.getPlugin().getPageCache().get("isroot"))) {
            return true;
        }
        long modelId = this.getModelId();
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        return permService.hasWritePerm(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), LongUtil.toLong((Object)memId));
    }

    default public boolean checkOrgMemberIsOnlyRead(String memId) {
        if (Boolean.parseBoolean(this.getPlugin().getPageCache().get("isroot"))) {
            return false;
        }
        long modelId = this.getModelId();
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        return permService.hasReadPerm(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), LongUtil.toLong((Object)memId));
    }

    default public PermPackageList getPermMapFromCache() {
        String permMapSerial = this.getPlugin().getPageCache().get(PermCacheKey.ORG_PERM_CACHE_KEY);
        if (StringUtil.isEmptyString((String)permMapSerial)) {
            return new PermPackageList(this.getModelId());
        }
        return (PermPackageList)SerializationUtils.fromJsonString((String)permMapSerial, PermPackageList.class);
    }

    default public void hideATAndCT(IFormView formView, String entity, boolean visible) {
        String entityId = formView.getEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                if (!entity.equals(baseEntityId)) continue;
                formView.setVisible(Boolean.valueOf(visible), new String[]{property.getName()});
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection items = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty item : items) {
                if (item instanceof BasedataProp) {
                    if (!entity.equals(((BasedataProp)item).getBaseEntityId())) continue;
                    formView.setVisible(Boolean.valueOf(visible), new String[]{item.getName()});
                    continue;
                }
                if (!(item instanceof TextProp)) continue;
                String name = "";
                if (entity.equals("bcm_audittrialmembertree")) {
                    name = DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase();
                } else if (entity.equals("bcm_changetypemembertree")) {
                    name = DimTypesEnum.CHANGETYPE.getNumber().toLowerCase();
                }
                if (!StringUtils.isNotEmpty((String)name) || !item.getName().endsWith(name)) continue;
                formView.setVisible(Boolean.valueOf(visible), new String[]{item.getName()});
            }
        }
    }

    default public boolean checkOperationPermission(String metadataName, String permItem) {
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()));
        if (admin) {
            return true;
        }
        String appId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
        int have = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), appId, metadataName, permItem);
        return have != 0;
    }

    default public void doCheckUnionPerm(String[] perm) {
        DynamicObjectCollection permClassEntities;
        long modelId = this.getModelId();
        long userId = this.getUserId();
        String bizAppId = this.getView().getFormShowParameter().getAppId();
        if (bizAppId == null) {
            bizAppId = ApplicationTypeEnum.CM.appnum;
        }
        if (CollectionUtils.isEmpty((Collection)(permClassEntities = UnionPermCommon.getPermClassId("bcm_entitymembertree", modelId, this.unionPermEntityIdsToAll(), bizAppId)))) {
            return;
        }
        for (DynamicObject entity : permClassEntities) {
            DynamicObject[] userAllPermission;
            Long permClassId = entity.getLong("permclass.id");
            ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp(this.getView());
            Long unionPermId = UnionPermCommon.getUnionPermId(perm, applicationTypeEnum);
            if (unionPermId == null || (userAllPermission = UnionPermCommon.getUserAllPermission(permClassId, modelId, userId)).length == 0) continue;
            for (DynamicObject authInfo : userAllPermission) {
                DynamicObjectCollection entryEntity = authInfo.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    boolean check = (Boolean)dynamicObject.get("ischeck");
                    Long unionPermIdInConfig = (Long)dynamicObject.get("unionpermid");
                    if (check || !unionPermIdInConfig.equals(unionPermId)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u7ec4\u7ec7\u64cd\u4f5c\u7684\u8054\u5408\u6743\u9650\u3002", (String)"BCMBaseFunction_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    default public Set<Long> unionPermEntityIds() {
        return Collections.emptySet();
    }

    default public Set<Long> unionPermEntityIdsToAll() {
        Set<Long> ids = this.unionPermEntityIds();
        if (ids.size() == 0) {
            return Collections.emptySet();
        }
        long modelId = this.getModelId();
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        String sql = String.format("select  a.fid from t_bcm_structofent a ,t_bcm_structofent b where a.fnumber = b.fnumber and a.fmodelid = b.fmodelid and b.fid in (%s) and a.fmodelid = %s", ids.stream().map(id -> String.valueOf(id)).collect(Collectors.joining(",")), modelId);
        try (DataSet dataSet = DB.queryDataSet((String)"t_bcm_structofent", (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            for (Row next : dataSet) {
                Long id2 = next.getLong("fid");
                idSet.add(id2);
            }
        }
        return idSet;
    }

    default public void buildMultiF7ShowName(StringBuilder sb, String name, String number, int rangeVal) {
        RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)rangeVal);
        StringBuilder rangeName = new StringBuilder();
        if (rangeEnum != RangeEnum.VALUE_10) {
            rangeName.append(ResManager.loadKDString((String)"\u7684", (String)"BCMBaseFunction_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(rangeEnum.getName());
        }
        sb.append(name).append((CharSequence)rangeName).append(",");
    }

    default public boolean checkIsExistExtDimension(long modelId, boolean isShowTip) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        boolean exist = QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])qf.toArray());
        if (!exist && isShowTip) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u62d3\u5c55\u7ef4\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5230\u7ef4\u5ea6\u754c\u9762\u65b0\u589e\u62d3\u5c55\u7ef4\u540e\u91cd\u8bd5\u3002", (String)"BCMBaseFunction_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return exist;
    }

    default public List<IDNumberTreeNode> getOrgNodes(long modelId, Predicate<IDNumberTreeNode> filterCondition, Map<String, List<Long>> need2RemoveNodes) {
        return this.getOrgNodes(modelId, filterCondition, need2RemoveNodes, false);
    }

    default public List<IDNumberTreeNode> getOrgNodes(long modelId, Predicate<IDNumberTreeNode> filterCondition, Map<String, List<Long>> need2RemoveNodes, boolean isShowRate) {
        CslSchemeServiceHelper.QueryOrgParam param = this.buildQueryOrgParam(modelId, null);
        if (filterCondition != null) {
            param.setFilterCondition(filterCondition);
        }
        param.setShowExchangeRate(isShowRate);
        param.setIncludeExchangeRateMembers(isShowRate);
        Map orgNodesFromCache = CslSchemeServiceHelper.getOrgNodesFromCache((CslSchemeServiceHelper.QueryOrgParam)param);
        if (StringUtils.isNotEmpty((String)param.getYearNum()) && StringUtils.isNotEmpty((String)param.getPeriodId())) {
            List filterVersionNodeIds = EntityVersioningUtil.filterVersionOrgTreeNodes((Map)orgNodesFromCache, (long)modelId, (Long)LongUtil.toLong((Object)param.getSceneId()), (String)param.getYearNum(), (long)LongUtil.toLong((Object)param.getPeriodId()));
            need2RemoveNodes.put("filterVersionNodeIds", filterVersionNodeIds);
        }
        return this.removeNoPermAndNoMergeNodes(modelId, orgNodesFromCache, need2RemoveNodes);
    }

    default public boolean isIgnoreOrgPermFilter() {
        return false;
    }

    default public CslSchemeServiceHelper.QueryOrgParam buildQueryOrgParam(long modelId, QFBuilder builder) {
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)modelId);
        param.setBuilder(builder);
        param.setNeedSchemeFilter(this.isCM() || this.isRPT() || this.isDI());
        param.setNeedSchemeModelFilter(this.isCMModel() || this.isRPT() || this.isDI());
        DynamicObject dataEntity = this.getPlugin().getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        boolean filterYear = InvRelationReportPlugin.class != this.getPlugin().getClass();
        this.buildQueryParam(param, properties, "cslscheme", "number");
        if (filterYear) {
            this.buildQueryParam(param, properties, "year", "number");
            this.buildQueryParam(param, properties, "period", "id");
            this.buildQueryParam(param, properties, "scenario", "id");
        }
        if (param.getCslScheme() == null) {
            Set cslSet = CslSchemeServiceHelper.getCurrUserHavePermCslSchemeIdNotRateScheme((String)String.valueOf(this.getModelId()), (boolean)false);
            param.setCslSchemeSet(cslSet);
        }
        return param;
    }

    default public List<IDNumberTreeNode> removeNoPermAndNoMergeNodes(long modelId, Map<Long, IDNumberTreeNode> orgNodesFromCache, Map<String, List<Long>> need2RemoveNodes) {
        IPageCache pageCache = this.getPlugin().getPageCache();
        IDataModel model = this.getView().getModel();
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        pageCache.put("isroot", String.valueOf(modelIds.contains(modelId)));
        long dimensionId = this.queryDimensionId(modelId, PresetConstant.ENTITY_DIM);
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        PermPackageList perms = permService.getDimPermSet(Long.valueOf(dimensionId));
        this.getPlugin().getPageCache().put(PermCacheKey.ORG_PERM_CACHE_KEY, SerializationUtils.toJsonString((Object)perms));
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        Long yearId = null;
        Long scenarioId = null;
        Long periodId = null;
        if (properties.containsKey((Object)"year")) {
            yearId = OrgUtils.getF7Id(model, "year");
        }
        if (properties.containsKey((Object)"scenario")) {
            scenarioId = OrgUtils.getF7Id(model, "scenario");
        }
        if (properties.containsKey((Object)"period")) {
            periodId = OrgUtils.getF7Id(model, "period");
        }
        ArrayList noMergeNodeIds = Lists.newArrayListWithExpectedSize((int)orgNodesFromCache.size());
        ArrayList noPermNodeIds = Lists.newArrayListWithExpectedSize((int)orgNodesFromCache.size());
        HashMap relationMap = Maps.newHashMapWithExpectedSize((int)orgNodesFromCache.size());
        Table isMergeMap = MergeControlHelper.getAllStructInfoForTable((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
        orgNodesFromCache.forEach((id, node) -> {
            Long orgId = node.getId();
            IDNumberTreeNode parent = node.getParent();
            if (parent != null) {
                String orgNumber = node.getNumber();
                String parentNumber = parent.getNumber();
                relationMap.computeIfAbsent(parent.getId(), k -> new ArrayList()).add(orgId);
                if (Boolean.FALSE.equals(isMergeMap.get((Object)parentNumber, (Object)orgNumber))) {
                    noMergeNodeIds.add(orgId);
                }
            }
        });
        if (!this.isIgnoreOrgPermFilter()) {
            orgNodesFromCache.forEach((id, node) -> {
                if (!MemberPermHelper.memberCanShow((Object)node.getId(), (PermPackageList)perms, (Map)relationMap)) {
                    noPermNodeIds.add(node.getId());
                }
            });
        }
        boolean showNoMergeOrg = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM030");
        boolean showNoMergeOrgOfNonLeaf = ConfigServiceHelper.getNonLeafOfCM030((Long)modelId);
        HashSet noMergeChilds = new HashSet(10);
        if (!showNoMergeOrg && CollectionUtils.isNotEmpty((Collection)noMergeNodeIds)) {
            noMergeNodeIds.removeIf(id -> {
                IDNumberTreeNode node = (IDNumberTreeNode)orgNodesFromCache.get(id);
                if (node.isLeaf()) {
                    return false;
                }
                if (!showNoMergeOrgOfNonLeaf) {
                    noMergeChilds.add(node.getId());
                    OrgServiceHelper.addAllChildrens((IDNumberTreeNode)node, (Set)noMergeChilds);
                }
                return this.hasMergeNodes(noMergeNodeIds, node.getChildren());
            });
        }
        if (noMergeChilds.size() > 0) {
            noMergeNodeIds.addAll(noMergeChilds);
        }
        HashSet orgIds = new HashSet();
        if (!modelIds.contains(modelId)) {
            orgIds.addAll(noPermNodeIds);
            need2RemoveNodes.put("noPermNodeIds", noPermNodeIds);
        }
        if (!showNoMergeOrg) {
            orgIds.addAll(noMergeNodeIds);
        }
        ArrayList<IDNumberTreeNode> orgNodes = new ArrayList<IDNumberTreeNode>();
        orgNodesFromCache.forEach((id, node) -> {
            if (orgIds.contains(id)) {
                return;
            }
            orgNodes.add((IDNumberTreeNode)node);
        });
        need2RemoveNodes.put("noMergeNodeIds", noMergeNodeIds);
        return orgNodes;
    }

    default public boolean hasMergeNodes(List<Long> noMergeNodeIds, List<IDNumberTreeNode> nodes) {
        return nodes.stream().anyMatch(node -> {
            boolean hasMergeNode = node.isLeaf() ? !noMergeNodeIds.contains(node.getId()) : this.hasMergeNodes(noMergeNodeIds, node.getChildren());
            return hasMergeNode;
        });
    }

    default public Predicate<IDNumberTreeNode> dealBuilder(QFBuilder builder) {
        return node -> true;
    }

    @SDKMark(description="")
    default public void doCheckPermission(String entityNum, String permItemId, Long modelId, String curAppId) {
        int is;
        List publishApps;
        PermissionControlType pct = EntityMetadataCache.getPermissionControlType((String)entityNum);
        if (pct != null && (publishApps = pct.getPublishApps()) != null) {
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
            String currAppId = AppMetadataCache.getAppInfo((String)curAppId).getId();
            if (!currAppId.equals(appId) && !publishApps.contains(currAppId)) {
                return;
            }
        }
        if ((is = BcmBasePluginUtil.checkPermission(this.getUserId(), modelId, AppMetadataCache.getAppInfo((String)curAppId).getId(), entityNum, permItemId)) == 0) {
            if (this.isCurModelAdmin(modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    default public boolean isCurModelAdmin(Long modelId) {
        return MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(modelId));
    }

    default public void exportData(String entityName, QFilter[] qFilters, String filename, String templateNumber, String entityNum, String permItemId) {
        if (qFilters.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)filename)) {
            filename = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"BCMBaseFunction_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String entityNameImp = entityName;
        QFBuilder filters = new QFBuilder();
        if (StringUtil.isEmptyString((String)templateNumber)) {
            filters.add(new QFilter("bizobject.number", "=", (Object)entityNameImp));
        } else {
            filters.add(new QFilter("number", "=", (Object)templateNumber));
        }
        String tempLateType = "templatetype";
        filters.add(new QFilter(tempLateType, "=", (Object)"IMPT").or(new QFilter(tempLateType, "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(), (String)StringUtils.getEmpty(), (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters).values().toArray(new DynamicObject[0]);
            this.handleDys(dys);
            this.downloadFile(ExportUtil.export((DynamicObject[])dys, pkIds.get(0), (String)routeAppId, (String)entityNameImp, (String)(filename + ".xlsx")), entityNum, permItemId);
        }
        catch (KDBizException e) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode(StringUtils.getEmpty(), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"BCMBaseFunction_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    default public void downloadFile(String url, String entityNum, String permItemId) {
        if (StringUtils.isNotEmpty((String)url)) {
            DownFileUtil.authorizedDownLoadFileUrl((String)url, (long)this.getModelId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityNum, (String)permItemId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    default public void exportData(String entityName, QFilter[] qFilters, String filename, String entityNum, String permItemId) {
        this.exportData(entityName, qFilters, filename, StringUtils.getEmpty(), entityNum, permItemId);
    }

    default public void handleDys(DynamicObject[] dys) {
    }

    default public void resetDyValue(Page page) {
        if (page.isUnStable()) {
            page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> this.getView().getModel().getDataEntity().set(e.getSign(), this.getValue(e.getSign()))));
        }
    }

    default public void setF7Disable() {
        List f7Keys = (List)this.getPlugin().getView().getFormShowParameter().getCustomParam("f7_disable_list");
        if (CollectionUtils.isNotEmpty((Collection)f7Keys)) {
            for (String f7Key : f7Keys) {
                if (null == this.getPlugin().getView().getControl(f7Key)) continue;
                this.getPlugin().getView().setEnable(Boolean.valueOf(false), new String[]{f7Key});
            }
        }
    }

    default public void hideNoModelPermButton() {
        String bizAppId = this.getView().getFormShowParameter().getAppId();
        if (ApplicationTypeEnum.RPT.getAppnum().equals(bizAppId) && ConfigServiceHelper.getGlobalBoolParam((String)"isHideNoPermButton")) {
            try {
                long modelId = this.getModelId();
                if (modelId > 0L && !this.isCurModelAdmin(modelId)) {
                    this.getPlugin().getPageCache().put("hideNoModelPermButton", String.valueOf(modelId));
                    Map allPermItemMap = BcmPermSingleModel.getInstance().getPermitem();
                    String entityId = this.getPlugin().getView().getEntityId();
                    Map buttonItemMap = (Map)allPermItemMap.get(entityId);
                    if (buttonItemMap != null && !buttonItemMap.isEmpty()) {
                        Set<String> noModelPermButtonKeyFromPageCache = this.getNoModelPermButtonKeyFromPageCache();
                        if (!noModelPermButtonKeyFromPageCache.isEmpty()) {
                            this.getView().setVisible(Boolean.TRUE, noModelPermButtonKeyFromPageCache.toArray(new String[1]));
                        }
                        Map<String, Boolean> bizBtnVisibleFromPageCache = this.getBizVisibleFromPageCache();
                        HashSet<String> allShowButtonSet = new HashSet<String>(16);
                        HashSet<String> allHideButtonSet = new HashSet<String>(16);
                        for (Map.Entry<String, Boolean> entry : bizBtnVisibleFromPageCache.entrySet()) {
                            if (entry.getValue().booleanValue()) {
                                allShowButtonSet.add(entry.getKey());
                                continue;
                            }
                            allHideButtonSet.add(entry.getKey());
                        }
                        if (!allShowButtonSet.isEmpty()) {
                            this.getView().setVisible(Boolean.TRUE, allShowButtonSet.toArray(new String[1]));
                        }
                        if (!allHideButtonSet.isEmpty()) {
                            this.getView().setVisible(Boolean.FALSE, allHideButtonSet.toArray(new String[1]));
                        }
                        long userId = this.getUserId();
                        HashSet<String> noModelPermButtonSet = new HashSet<String>(16);
                        for (Map.Entry entry : buttonItemMap.entrySet()) {
                            int isHasPerm;
                            String buttonKey = (String)entry.getKey();
                            String permItemValue = (String)entry.getValue();
                            if (StringUtil.isEmptyString((String)buttonKey) || permItemValue == null || !permItemValue.contains("@")) continue;
                            String[] permArrayKey = permItemValue.split("@");
                            String permEntityId = permArrayKey[0];
                            String permItemId = permArrayKey[1];
                            if (StringUtil.isEmptyString((String)permEntityId) || StringUtil.isEmptyString((String)permItemId) || (isHasPerm = BcmBasePluginUtil.checkPermission(userId, modelId, AppMetadataCache.getAppInfo((String)bizAppId).getId(), permEntityId, permItemId)) != 0) continue;
                            noModelPermButtonSet.add(buttonKey);
                        }
                        if (!noModelPermButtonSet.isEmpty()) {
                            this.getPlugin().getPageCache().put("noModelPermButtonKey", SerializationUtils.serializeToBase64(noModelPermButtonSet));
                            this.getView().setVisible(Boolean.FALSE, noModelPermButtonSet.toArray(new String[1]));
                        }
                    }
                    this.getPlugin().getPageCache().remove("hideNoModelPermButton");
                }
            }
            catch (Exception e) {
                watchlogger.error(String.format("hideBcmButton error\uff1a%s", ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
            }
        }
    }

    default public Set<String> getNoModelPermButtonKeyFromPageCache() {
        String noModelPermButtonKeySerial = this.getPlugin().getPageCache().get("noModelPermButtonKey");
        if (!StringUtil.isEmptyString((String)noModelPermButtonKeySerial)) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)noModelPermButtonKeySerial);
        }
        return Collections.emptySet();
    }

    default public boolean isHidingNoModelPermButton() {
        return this.getPlugin().getPageCache().get("hideNoModelPermButton") != null;
    }

    default public Map<String, Boolean> getBizVisibleFromPageCache() {
        String visibleMapSerial = this.getPlugin().getPageCache().get("bizVisibleMap");
        if (StringUtil.isEmptyString((String)visibleMapSerial)) {
            HashMap<String, Boolean> buttonVisibleMap = new HashMap<String, Boolean>(16);
            this.getPlugin().getPageCache().put("bizVisibleMap", SerializationUtils.serializeToBase64(buttonVisibleMap));
            return buttonVisibleMap;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)visibleMapSerial);
    }

    default public void updateBizVisibleFromPageCache(Map<String, Boolean> buttonVisibleMap) {
        if (buttonVisibleMap != null) {
            this.getPlugin().getPageCache().put("bizVisibleMap", SerializationUtils.serializeToBase64(buttonVisibleMap));
        }
    }
}

