/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.common.util.PeriodUtils;

public class BcmBasePluginUtil {
    private static final String FIDM_APP_ID = "2IFNVZ0SS0W4";
    private static final String FAR_APP_ID = "2K++OWYYMS5J";

    public static void propertyChanged(AbstractFormPlugin plugin, PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("scenario".equals(propertyName)) {
            if (plugin.getView().getModel().getDataEntityType().getProperties().containsKey((Object)"period") && plugin.getView().getModel().getValue("period") instanceof DynamicObject) {
                Object obj = plugin.getView().getModel().getValue("scenario");
                DynamicObject periodObj = (DynamicObject)plugin.getView().getModel().getValue("period");
                boolean isNeedClean = false;
                if (obj == null) {
                    isNeedClean = true;
                } else if (obj instanceof DynamicObject) {
                    QFilter filter;
                    DynamicObject sceneObj = (DynamicObject)plugin.getView().getModel().getValue("scenario");
                    long sceneId = sceneObj.getLong("id");
                    long periodId = periodObj.getLong("id");
                    QFilter idFilter = new QFilter("id", "=", (Object)sceneId);
                    if (!QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])new QFilter[]{idFilter, filter = new QFilter("sceneperiod.fbasedataid", "=", (Object)periodId)})) {
                        isNeedClean = true;
                    }
                }
                if (isNeedClean) {
                    plugin.getView().getModel().getDataEntity().set("period", null);
                    plugin.getView().updateView("period");
                }
            }
        } else if ("year".equals(propertyName) && plugin.getView().getModel().getValue("year") instanceof DynamicObject && plugin.getView().getModel().getDataEntityType().getProperties().containsKey((Object)"period") && plugin.getView().getModel().getValue("period") instanceof DynamicObject) {
            DynamicObject yearObj = (DynamicObject)plugin.getView().getModel().getValue("year");
            DynamicObject periodObj = (DynamicObject)plugin.getView().getModel().getValue("period");
            if (yearObj == null || periodObj == null) {
                return;
            }
            String periodNum = periodObj.getString("number");
            if (periodNum.startsWith("M_M") && !PeriodUtils.isStandardMonthPeriod((String)periodNum)) {
                long periodId = periodObj.getLong("id");
                String yearNum = yearObj.getString("number");
                QFilter filter = new QFilter("useyear", "like", (Object)("%" + yearNum + "%"));
                filter.and(new QFilter("isadjust", "=", (Object)"1"));
                filter.or(new QFilter("isadjust", "!=", (Object)"1"));
                QFilter idFilter = new QFilter("id", "=", (Object)periodId);
                if (!QueryServiceHelper.exists((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{filter, idFilter})) {
                    plugin.getView().getModel().getDataEntity().set("period", null);
                    plugin.getView().updateView("period");
                }
            }
        }
    }

    public static int checkPermission(long userId, long dimObjId, String appId, String entityNum, String permItemId) {
        int is;
        String isGalaxySystem = System.getProperty("isGalaxySystem");
        if (isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase("true")) {
            is = PermissionServiceHelper.checkPermission((long)userId, (String)"bos_org", (long)0L, (String)appId, (String)entityNum, (String)permItemId);
        } else {
            String permIsoDimType = "bcm_model";
            if (Objects.equals(FIDM_APP_ID, appId) || Objects.equals(FAR_APP_ID, appId)) {
                permIsoDimType = "fidm_model";
            }
            is = PermissionServiceHelper.checkPermission((long)userId, (String)permIsoDimType, (long)dimObjId, (String)appId, (String)entityNum, (String)permItemId);
        }
        return is;
    }

    public static String sugarF7Key(String memberEntityNumber, String dimNumber) {
        return (BcmBasePluginUtil.isUserDefineDimension(memberEntityNumber) ? memberEntityNumber + "_" + dimNumber : memberEntityNumber).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isUserDefineDimension(String memberEntityNumber) {
        return memberEntityNumber.startsWith("bcm_userdefinedmembertree");
    }
}

