/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.common.auditlog.OpLogHelper;
import kd.fi.bcm.common.oplog.IBcmEventProxy;
import kd.fi.bcm.common.oplog.IWatchableEvent;
import kd.fi.bcm.common.oplog.IWatchableInstance;
import kd.fi.bcm.common.oplog.IWatchableMethod;
import kd.fi.bcm.common.oplog.MethodCallEvent;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.OpLogJoinPoint;

public class MethodOpProxy
implements IBcmEventProxy<MethodCallEvent> {
    private static final Log LOG = LogFactory.getLog(MethodOpProxy.class);
    private final Class<?> instanceClazz;
    private final String methodName;
    private IWatchableInstance source;

    private MethodOpProxy(final String bizAppId, final String modelNumber, final Class<?> instanceClazz, String methodName) {
        this.instanceClazz = instanceClazz;
        this.methodName = methodName;
        this.source = new IWatchableInstance(){

            public String getSourceKey() {
                return instanceClazz.getName();
            }

            public String getBizAppId() {
                return bizAppId;
            }

            public String getCurModelNumber() {
                return modelNumber;
            }
        };
    }

    public static MethodOpProxy createInstance(String bizAppId, String modelNumber, Class<?> instanceClazz, String methodName) {
        return new MethodOpProxy(bizAppId, modelNumber, instanceClazz, methodName);
    }

    public IWatchableInstance getWatchInstance() {
        return this.source;
    }

    public boolean isMonitor(MethodCallEvent eventMeta) {
        boolean isCare = OpLogHelper.checkEventEnable((String)this.getWatchInstance().getSourceKey(), (String)eventMeta.getSubSourceKey());
        if (isCare) {
            isCare = OpLogHelper.checkModelEnable((String)this.getWatchInstance().getCurModelNumber(), (String)this.getWatchInstance().getSourceKey(), (String)eventMeta.getSubSourceKey());
        }
        if (!isCare) {
            LOG.info(String.format("ignore op_log_event: %s[%s]", this.getWatchInstance().getSourceKey(), eventMeta.getSubSourceKey()));
        }
        return isCare;
    }

    public <R> R executeWithResult(IWatchableMethod<R> watchableMethod) {
        MethodCallEvent methodCallEvent = new MethodCallEvent(GlobalIdUtil.genStringId(), this.methodName);
        boolean isMonitor = this.isMonitor(methodCallEvent);
        if (!isMonitor) {
            return (R)watchableMethod.call();
        }
        int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)methodCallEvent.getSubSourceKey());
        OpLogJoinPoint.startEvent(this, (IWatchableEvent)methodCallEvent, opCategory);
        try {
            Object result = watchableMethod.call();
            OpLogJoinPoint.endEvent(this, (IWatchableEvent)methodCallEvent, null);
            return (R)result;
        }
        catch (Exception e) {
            OpLogJoinPoint.endEvent(this, (IWatchableEvent)methodCallEvent, e);
            throw e;
        }
    }

    public void execute(IWatchableMethod watchableMethod) {
        MethodCallEvent methodCallEvent = new MethodCallEvent(GlobalIdUtil.genStringId(), this.methodName);
        boolean isMonitor = this.isMonitor(methodCallEvent);
        if (!isMonitor) {
            watchableMethod.call();
        } else {
            int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)methodCallEvent.getSubSourceKey());
            OpLogJoinPoint.startEvent(this, (IWatchableEvent)methodCallEvent, opCategory);
            try {
                watchableMethod.call();
                OpLogJoinPoint.endEvent(this, (IWatchableEvent)methodCallEvent, null);
            }
            catch (Exception e) {
                OpLogJoinPoint.endEvent(this, (IWatchableEvent)methodCallEvent, e);
                throw e;
            }
        }
    }
}

