/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.oplog.IBcmEventProxy;
import kd.fi.bcm.common.oplog.IWatchableEvent;
import kd.fi.bcm.common.oplog.IWatchableInstance;
import kd.fi.bcm.common.oplog.OpLogs;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class OpLogJoinPoint {
    private static final Map<String, OpLogs.OpEventLog> UNDER_EVENTS = Collections.synchronizedMap(new LinkedHashMap(100, 0.75f, false));

    public static void startBeforeEvent(IBcmEventProxy eventProxy, IWatchableEvent evt, int opCategory) {
        String eventId = evt.getId();
        OpLogs.OpEventLog eventLog = OpLogJoinPoint.createLogByStart(eventProxy, evt, opCategory);
        eventLog.getPhases().add(OpLogJoinPoint.createPhaseLog(eventProxy.getWatchInstance().getClass().getName(), true));
        UNDER_EVENTS.put(eventId, eventLog);
    }

    public static void endBeforeEvent(IBcmEventProxy eventProxy, IWatchableEvent evt, Throwable e) {
        String eventId = evt.getId();
        if (!UNDER_EVENTS.containsKey(eventId)) {
            return;
        }
        OpLogs.OpEventLog eventLog = UNDER_EVENTS.get(eventId);
        if (evt.isCanceled() || Objects.nonNull(e)) {
            if (evt.isCanceled()) {
                eventLog.setStatus(OpLogs.OpStatus.CANCEL);
            } else {
                eventLog.setStatus(OpLogs.OpStatus.ABORT);
                eventLog.setErrMsg(ThrowableHelper.toString((Throwable)e));
            }
        } else {
            eventLog.doneOneValidate(eventProxy.getWatchInstance().getClass());
        }
        eventLog.setEndTime(new Date());
        OpLogJoinPoint.finishPhaseLog((OpLogs.EventPhaseLog)eventLog.getPhases().get(eventLog.getPhases().size() - 1), eventLog.getStatus());
        if (OpLogs.OpStatus.CANCEL == eventLog.getStatus() || OpLogs.OpStatus.ABORT == eventLog.getStatus()) {
            OpLogJoinPoint.postFinishEvent(eventId);
        }
    }

    public static void startEvent(IBcmEventProxy eventProxy, IWatchableEvent evt, int opCategory) {
        String eventId = evt.getId();
        if (Objects.isNull(UNDER_EVENTS.get(eventId))) {
            UNDER_EVENTS.put(eventId, OpLogJoinPoint.createLogByStart(eventProxy, evt, opCategory));
        }
        OpLogs.OpEventLog eventLog = UNDER_EVENTS.get(eventId);
        eventLog.getPhases().add(OpLogJoinPoint.createPhaseLog(eventProxy.getWatchInstance().getClass().getName(), false));
    }

    public static void endEvent(IBcmEventProxy eventProxy, IWatchableEvent evt, Throwable e) {
        String eventId = evt.getId();
        if (!UNDER_EVENTS.containsKey(eventId)) {
            return;
        }
        OpLogs.OpEventLog eventLog = UNDER_EVENTS.get(eventId);
        if (evt.isCanceled() || Objects.nonNull(e)) {
            if (evt.isCanceled()) {
                eventLog.setStatus(OpLogs.OpStatus.CANCEL);
            } else {
                eventLog.setStatus(OpLogs.OpStatus.ABORT);
                eventLog.setErrMsg(ThrowableHelper.toString((Throwable)e));
            }
        } else {
            eventLog.setStatus(OpLogs.OpStatus.DONE);
        }
        eventLog.setEndTime(new Date());
        eventLog.doneOneBiz();
        OpLogJoinPoint.finishPhaseLog((OpLogs.EventPhaseLog)eventLog.getPhases().get(eventLog.getPhases().size() - 1), eventLog.getStatus());
        if (eventLog.isFinished() || OpLogs.OpStatus.CANCEL == eventLog.getStatus() || OpLogs.OpStatus.ABORT == eventLog.getStatus()) {
            OpLogJoinPoint.postFinishEvent(eventId);
        }
    }

    private static OpLogs.EventPhaseLog createPhaseLog(String pluginClazz, boolean isValidator) {
        OpLogs.EventPhaseLog phaseLog = new OpLogs.EventPhaseLog(new Date());
        phaseLog.setPluginClass(pluginClazz);
        phaseLog.setIsValidator(isValidator);
        return phaseLog;
    }

    private static void finishPhaseLog(OpLogs.EventPhaseLog phaseLog, OpLogs.OpStatus opStatus) {
        if (phaseLog == null) {
            throw new KDBizException("param eventlog is null");
        }
        phaseLog.setStatus(opStatus);
        phaseLog.setEndTime(new Date());
    }

    private static OpLogs.OpEventLog createLogByStart(IBcmEventProxy eventProxy, IWatchableEvent evt, int opCategory) {
        OpLogs.OpEventLog eventLog = new OpLogs.OpEventLog(GlobalIdUtil.genStringId(), eventProxy.getClass().getSimpleName(), new Date(), RequestContext.get());
        IWatchableInstance watchableInstance = eventProxy.getWatchInstance();
        eventLog.setAppId(watchableInstance.getBizAppId());
        eventLog.setModelNumber(watchableInstance.getCurModelNumber());
        eventLog.setSourceKey(watchableInstance.getSourceKey());
        eventLog.setSubSourceKey(OpLogJoinPoint.getOpName(eventProxy, evt));
        eventLog.setOpCategory(Integer.valueOf(opCategory));
        return eventLog;
    }

    private static String getOpName(IBcmEventProxy eventProxy, IWatchableEvent evt) {
        IWatchableInstance watchableInstance = eventProxy.getWatchInstance();
        QFilter qf = new QFilter("billstatus", "=", (Object)"C");
        qf.and("enable", "=", (Object)"1");
        qf.and("sourcekey", "=", (Object)watchableInstance.getSourceKey());
        qf.and("subsourcekey", "=", (Object)evt.getSubSourceKey());
        DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_oplog_management", (String)"desc", (QFilter[])new QFilter[]{qf});
        return data.getString("desc");
    }

    private static void postFinishEvent(String eventId) {
        if (!UNDER_EVENTS.containsKey(eventId)) {
            return;
        }
        OpLogs.OpEventLog eventLog = UNDER_EVENTS.remove(eventId);
        MQCommonPublisher.publishOpEventLog((OpLogs.OpEventLog)eventLog);
    }
}

