/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import java.util.EventObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.common.auditlog.OpLogHelper;
import kd.fi.bcm.common.oplog.IBcmEventProxy;
import kd.fi.bcm.common.oplog.IWatchableClickPlugin;
import kd.fi.bcm.common.oplog.IWatchableEvent;
import kd.fi.bcm.formplugin.OpLogJoinPoint;

public class PluginClickProxy
implements IBcmEventProxy<OpClickEvent>,
ClickListener {
    private static final Log LOG = LogFactory.getLog(PluginClickProxy.class);
    private final IWatchableClickPlugin sourcePlugin;

    public PluginClickProxy(IWatchableClickPlugin plugin) {
        this.sourcePlugin = plugin;
    }

    public IWatchableClickPlugin getWatchInstance() {
        return this.sourcePlugin;
    }

    public boolean isMonitor(OpClickEvent eventMeta) {
        boolean isCare = OpLogHelper.checkEventEnable((String)this.getWatchInstance().getSourceKey(), (String)eventMeta.getSubSourceKey());
        if (isCare) {
            isCare = OpLogHelper.checkModelEnable((String)this.getWatchInstance().getCurModelNumber(), (String)this.getWatchInstance().getSourceKey(), (String)eventMeta.getSubSourceKey());
        }
        if (!isCare) {
            LOG.info(String.format("ignore op_log_event: %s[%s]", this.getWatchInstance().getSourceKey(), eventMeta.getSubSourceKey()));
        }
        return isCare;
    }

    public void beforeClick(BeforeClickEvent evt) {
        OpClickEvent opClickEvent = new OpClickEvent(evt);
        boolean isMonitor = this.isMonitor(opClickEvent);
        if (isMonitor) {
            int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)opClickEvent.getSubSourceKey());
            OpLogJoinPoint.startBeforeEvent(this, opClickEvent, opCategory);
        }
        try {
            this.sourcePlugin.beforeClick(evt);
            if (isMonitor) {
                OpLogJoinPoint.endBeforeEvent(this, opClickEvent, null);
            }
        }
        catch (Exception e) {
            if (isMonitor) {
                OpLogJoinPoint.endBeforeEvent(this, opClickEvent, e);
            }
            throw e;
        }
    }

    public void click(EventObject evt) {
        OpClickEvent opClickEvent = new OpClickEvent(evt);
        boolean isMonitor = this.isMonitor(opClickEvent);
        if (isMonitor) {
            int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)opClickEvent.getSubSourceKey());
            OpLogJoinPoint.startEvent(this, opClickEvent, opCategory);
        }
        try {
            this.sourcePlugin.click(evt);
            if (isMonitor) {
                OpLogJoinPoint.endEvent(this, opClickEvent, null);
            }
        }
        catch (Exception e) {
            if (isMonitor) {
                OpLogJoinPoint.endEvent(this, opClickEvent, e);
            }
            throw e;
        }
    }

    public static class OpClickEvent
    implements IWatchableEvent {
        private String id;
        private String subSourceKey;
        private boolean isCanceled;

        public OpClickEvent(BeforeClickEvent evt) {
            this.id = evt.getSource().toString();
            this.subSourceKey = ((Control)evt.getSource()).getKey();
            this.isCanceled = evt.isCancel();
        }

        public OpClickEvent(EventObject evt) {
            this.id = evt.getSource().toString();
            this.subSourceKey = ((Control)evt.getSource()).getKey();
            this.isCanceled = false;
        }

        public String getId() {
            return this.id;
        }

        public String getSubSourceKey() {
            return this.subSourceKey;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }
}

