/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.common.auditlog.OpLogHelper;
import kd.fi.bcm.common.oplog.IBcmEventProxy;
import kd.fi.bcm.common.oplog.IWatchableEvent;
import kd.fi.bcm.common.oplog.IWatchableItemClickPlugin;
import kd.fi.bcm.formplugin.OpLogJoinPoint;

public class PluginItemClickProxy
implements IBcmEventProxy<OpItemClickEvent>,
ItemClickListener {
    private static final Log LOG = LogFactory.getLog(PluginItemClickProxy.class);
    private final IWatchableItemClickPlugin sourcePlugin;

    public PluginItemClickProxy(IWatchableItemClickPlugin plugin) {
        this.sourcePlugin = plugin;
    }

    public IWatchableItemClickPlugin getWatchInstance() {
        return this.sourcePlugin;
    }

    public boolean isMonitor(OpItemClickEvent eventMeta) {
        boolean isCare = OpLogHelper.checkModelEnable((String)this.getWatchInstance().getCurModelNumber(), (String)this.getWatchInstance().getSourceKey(), (String)eventMeta.getSubSourceKey());
        if (!isCare) {
            LOG.info(String.format("ignore op_log_event: %s[%s]", this.getWatchInstance().getSourceKey(), eventMeta.getSubSourceKey()));
        }
        return isCare;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        OpItemClickEvent opItemClickEvent = new OpItemClickEvent(evt);
        boolean isMonitor = this.isMonitor(opItemClickEvent);
        if (isMonitor) {
            int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)opItemClickEvent.getSubSourceKey());
            OpLogJoinPoint.startBeforeEvent(this, opItemClickEvent, opCategory);
        }
        try {
            this.sourcePlugin.beforeItemClick(evt);
            if (isMonitor) {
                OpLogJoinPoint.endBeforeEvent(this, opItemClickEvent, null);
            }
        }
        catch (Exception e) {
            if (isMonitor) {
                OpLogJoinPoint.endBeforeEvent(this, opItemClickEvent, e);
            }
            throw e;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        OpItemClickEvent opItemClickEvent = new OpItemClickEvent(evt);
        boolean isMonitor = this.isMonitor(opItemClickEvent);
        if (isMonitor) {
            int opCategory = OpLogHelper.getOpCategory((String)this.getWatchInstance().getSourceKey(), (String)opItemClickEvent.getSubSourceKey());
            OpLogJoinPoint.startEvent(this, opItemClickEvent, opCategory);
        }
        try {
            this.sourcePlugin.itemClick(evt);
            this.sourcePlugin.afterItemClick(evt);
            if (isMonitor) {
                OpLogJoinPoint.endEvent(this, opItemClickEvent, null);
            }
        }
        catch (Exception e) {
            if (isMonitor) {
                OpLogJoinPoint.endEvent(this, opItemClickEvent, e);
            }
            throw e;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginItemClickProxy)) {
            return false;
        }
        PluginItemClickProxy p = (PluginItemClickProxy)obj;
        return this.sourcePlugin.equals(p.sourcePlugin);
    }

    public int hashCode() {
        int result = this.sourcePlugin == null ? 0 : this.sourcePlugin.hashCode();
        return result;
    }

    public static class OpItemClickEvent
    implements IWatchableEvent {
        private String id;
        private String subSourceKey;
        private boolean isCanceled;

        public OpItemClickEvent(BeforeItemClickEvent evt) {
            this.id = evt.getSource().toString();
            this.subSourceKey = evt.getItemKey();
            this.isCanceled = evt.isCancel();
        }

        public OpItemClickEvent(ItemClickEvent evt) {
            this.id = evt.getSource().toString();
            this.subSourceKey = evt.getItemKey();
            this.isCanceled = false;
        }

        public String getId() {
            return this.id;
        }

        public String getSubSourceKey() {
            return this.subSourceKey;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }
}

