/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.accountmember;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimensionnew.AccountMemberEdit;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class AccountMemberAddPlugin
extends AccountMemberEdit
implements RowClickEventListener {
    private static final String KEY_ITEMSETTING = "itemsetting";
    private static final String KEY_BTNFILLFORMULA = "btnfillformula";
    private static final String KEY_BTNFILLCASHFLOW = "btnfillcashflow";
    private static final String KEY_ACCTFORMULA = "acctformula";
    private static final String KEY_STARTACCTID = "startacctid";
    private static final String KEY_ACCTFORMULATXT = "acctformulatxt";
    private static final String KEY_CASHFLOWID = "cashflowid";
    private static final String KEY_ACCTTABLEID = "accttableid";
    private static final String KEY_DATARESOURCE = "dataresource";
    private static final String KEY_BTNCLEARFORCASH = "btnclearforcash";
    private static final String KEY_BTNCLEAR = "btnclear";
    private static final String KEY_BTNADD = "btnadd";
    private static final String KEY_BTNSUBTRACT = "btnsubtract";
    private static final String KEY_ACCOUNTTYPE = "accounttype";
    private static final String[] acctArrary = new String[]{"1", "2", "3", "10"};

    @Override
    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ITEMSETTING});
        BasedataEdit basedatafield = (BasedataEdit)this.getControl("basedatafield");
        basedatafield.addAfterF7SelectListener(afterF7SelectEvent -> {
            this.getModel().setValue("parentname", (Object)afterF7SelectEvent.getListSelectedRow().getName());
            this.getModel().setValue("parent", afterF7SelectEvent.getListSelectedRow().getPrimaryKeyValue());
            this.getView().updateView();
        });
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.hiddenControl();
        this.setItemSetting();
        this.setVisibleBydataSourceValue();
        this.setAcctFormulaTxtValue();
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (boolean)StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype")));
        if (StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"permclass"});
        }
    }

    private DynamicObjectCollection getRateAccount() {
        String modelId;
        Object model = this.getModel().getValue("model");
        if (model != null && (modelId = ((DynamicObject)model).getString("id")) != null) {
            DynamicObjectCollection defineDyc = ExportUtil.getAllRates((Long)Long.parseLong(modelId));
            return defineDyc;
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.hiddenControl();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        DynamicObjectCollection records = this.getModel().getEntryEntity("bizchangerds");
        if (records.size() == 1 && ((DynamicObject)records.get(0)).getDate("bizeffdate") == null) {
            records.clear();
        }
        if (e.getSource() instanceof Save && StringUtils.isEmpty((CharSequence)this.getModel().getValue("parentname").toString())) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMemberAddPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.getPageCache().remove("hasbizrow");
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"), (OperationStatus)this.getView().getFormShowParameter().getStatus());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("orgchangetoolbarap");
        this.addClickListeners(KEY_BTNFILLFORMULA, KEY_BTNFILLCASHFLOW, KEY_BTNCLEAR, KEY_BTNCLEARFORCASH, KEY_BTNADD, KEY_BTNSUBTRACT, KEY_STARTACCTID);
        this.addClickListeners("parentname");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.addAssoBeforeF7SelectListener(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnfillformula": {
                this.fillAcctFormula(KEY_STARTACCTID);
                break;
            }
            case "btnfillcashflow": {
                this.fillAcctFormula(KEY_CASHFLOWID);
                break;
            }
            case "btnclearforcash": 
            case "btnclear": {
                this.getModel().setValue(KEY_ACCTFORMULA, (Object)"");
                break;
            }
            case "btnadd": {
                this.fillOperator("+");
                break;
            }
            case "btnsubtract": {
                this.fillOperator("-");
                break;
            }
            case "parentname": {
                this.openAccountSingleF7();
                break;
            }
        }
    }

    private void openAccountSingleF7() {
        BasedataEdit basedatafield = (BasedataEdit)this.getControl("basedatafield");
        QFilter filter = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"))).and("storagetype", "!=", (Object)"3");
        basedatafield.setQFilter(filter);
        basedatafield.click();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject dyc;
        super.beforeF7Select(arg0);
        String fieldKey = arg0.getProperty().getName();
        if (fieldKey.equals(KEY_STARTACCTID) && (dyc = (DynamicObject)this.getModel().getValue(KEY_ACCTTABLEID)) != null) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("accounttable", "=", (Object)dyc.getLong("id")));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        this.getPageCache().put("lastNumber", this.getModel().getValue("number").toString());
        super.itemClick(evt);
        this.accountChangeRdControl(evt);
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        this.setVisibleBydataSourceValue();
        switch (key) {
            case "dataresource": {
                this.setAcctFormulaTxtValue();
                break;
            }
            case "acctformula": {
                this.setAcctFormulaTxtValue();
                break;
            }
            case "accounttype": {
                this.setItemSetting();
                break;
            }
            case "accttableid": {
                this.clearFormula();
                break;
            }
        }
        if ("bizeffdate".equals(key)) {
            this.checkDate("bizchangerds", "bizeffdate", "bizexpdate");
        } else if ("bizexpdate".equals(key)) {
            DynamicObjectCollection records = this.getModel().getEntryEntity("bizchangerds");
            ((DynamicObject)records.get(0)).set("modelid", this.getModel().getValue("model"));
            int idx = this.getModel().getEntryCurrentRowIndex("bizchangerds");
            Date effDate = ((DynamicObject)records.get(idx)).getDate("bizeffdate");
            if (effDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"AccountMemberAddPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date toChangeDate = ((DynamicObject)records.get(idx)).getDate("bizexpdate");
            if (toChangeDate != null && toChangeDate.compareTo(effDate) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AccountMemberAddPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkDate(String tableName, String effdate, String expdate) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(tableName);
        DynamicObjectCollection records = this.getModel().getEntryEntity(tableName);
        if (records.size() == 0) {
            return true;
        }
        ((DynamicObject)records.get(0)).set("modelid", this.getModel().getValue("model"));
        currentRowIndex = currentRowIndex < 0 ? 0 : currentRowIndex;
        Date toChangeDate = ((DynamicObject)records.get(currentRowIndex)).getDate(effdate);
        if (currentRowIndex > 0) {
            DynamicObject beforeData = (DynamicObject)records.get(currentRowIndex - 1);
            Date effDateBefore = beforeData.getDate(effdate);
            Date expDateBefore = beforeData.getDate(expdate);
            if (toChangeDate != null && expDateBefore != null && toChangeDate.compareTo(expDateBefore) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u66f4\u6539\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u6761\u8bb0\u5f55\u7684\u5931\u6548\u65e5\u671f\u3002", (String)"AccountMemberAddPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (effDateBefore == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"AccountMemberAddPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (toChangeDate != null && toChangeDate.compareTo(effDateBefore) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8981\u66f4\u6539\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u6761\u8bb0\u5f55\u7684\u5931\u6548\u65e5\u671f\u3002", (String)"AccountMemberAddPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            Object beforRowExpValue = this.getModel().getValue(expdate, currentRowIndex - 1);
            if (toChangeDate != null && beforRowExpValue == null) {
                this.getModel().setValue(expdate, (Object)DateTimeUtils.getDayBefore((Date)toChangeDate), currentRowIndex - 1);
            }
        }
        return true;
    }

    private void reloadPullDownList() {
        ComboEdit edit = (ComboEdit)this.getControl(KEY_ACCOUNTTYPE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7", (String)"AccountMemberAddPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "1"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d1f\u503a", (String)"AccountMemberAddPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "2"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6743\u76ca", (String)"AccountMemberAddPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "3"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u635f\u76ca", (String)"AccountMemberAddPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "10"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf", (String)"AccountMemberAddPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "7"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6c47\u7387\u7c7b", (String)"AccountMemberAddPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "8"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u8d22\u52a1\u7c7b", (String)"AccountMemberAddPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "9"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AccountMemberAddPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "11"));
        edit.setComboItems(items);
        ComboEdit edit1 = (ComboEdit)this.getControl("exchange");
        ComboEdit entryRate_edit = (ComboEdit)this.getControl("entryrate");
        ArrayList<ComboItem> items1 = new ArrayList<ComboItem>(10);
        DynamicObjectCollection userdefinedrateAccount = this.getRateAccount();
        if (userdefinedrateAccount != null) {
            for (DynamicObject account : userdefinedrateAccount) {
                if ("ClosingRate".equals(account.getString("number"))) {
                    items1.add(new ComboItem(new LocaleString(account.getString("name")), ExchangeEnum.TERMINAL.index));
                    continue;
                }
                if ("AverageRate".equals(account.getString("number"))) {
                    items1.add(new ComboItem(new LocaleString(account.getString("name")), ExchangeEnum.AVERAGE.index));
                    continue;
                }
                if ("UserdefinedRate".equals(account.getString("number"))) {
                    items1.add(new ComboItem(new LocaleString(account.getString("name")), ExchangeEnum.UserdefinedRate.index));
                    continue;
                }
                items1.add(new ComboItem(new LocaleString(account.getString("name")), account.getString("number")));
            }
        }
        ArrayList<ComboItem> items_entryRate = new ArrayList<ComboItem>(10);
        items_entryRate.addAll(items1);
        entryRate_edit.setComboItems(items_entryRate);
        if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("entryrate")))) {
            this.getModel().setValue("entryrate", (Object)ExchangeEnum.TERMINAL.index);
        }
        items1.add(new ComboItem(new LocaleString(ExchangeEnum.ONE.getName()), ExchangeEnum.ONE.index));
        items1.add(new ComboItem(new LocaleString(ExchangeEnum.NONE.getName()), ExchangeEnum.NONE.index));
        edit1.setComboItems(items1);
    }

    private void hiddenControl() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"selmetric"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimensionrange"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"selmetric"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimensionrange"});
        this.reloadPullDownList();
    }

    private void clearFormula() {
        this.getModel().setValue(KEY_ACCTFORMULA, (Object)"");
    }

    private void setVisibleBydataSourceValue() {
        String panelAcct = "panelacct";
        String panelCash = "panelcash";
        String dataResource = (String)this.getModel().getValue(KEY_DATARESOURCE);
        if (StringUtils.isBlank((CharSequence)dataResource)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ACCTTABLEID, panelCash, panelAcct});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ACCTFORMULA});
            return;
        }
        this.getView().setVisible(Boolean.valueOf("0".equals(dataResource)), new String[]{panelAcct, KEY_ACCTTABLEID});
        this.getView().setVisible(Boolean.valueOf("1".equals(dataResource)), new String[]{panelCash});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_ACCTFORMULA});
    }

    private void fillAcctFormula(String itemKey) {
        DynamicObject dyc = (DynamicObject)this.getModel().getValue(itemKey);
        if (dyc != null) {
            String oldAcctFormula = this.getModel().getValue(KEY_ACCTFORMULA) == null ? "" : this.getModel().getValue(KEY_ACCTFORMULA).toString();
            String number = dyc.getString("number");
            this.getModel().setValue(KEY_ACCTFORMULA, (Object)(oldAcctFormula + "[" + number + "]"));
            this.getModel().setValue(itemKey, null);
        }
    }

    private void setAcctFormulaTxtValue() {
        String formula = this.getModel().getValue(KEY_ACCTFORMULA).toString();
        if (this.getModel().getValue(KEY_DATARESOURCE) == null) {
            return;
        }
        String dataSource = this.getModel().getValue(KEY_DATARESOURCE).toString();
        DynamicObject dyAcctTable = (DynamicObject)this.getModel().getValue(KEY_ACCTTABLEID);
        Long acctTableId = dyAcctTable == null ? 0L : dyAcctTable.getLong("id");
        Pair<String, String> acctFormulaTxt = this.getAcctFormulaTxt(formula, dataSource, acctTableId);
        this.getModel().setValue(KEY_ACCTFORMULATXT, acctFormulaTxt.p2);
        this.getModel().setValue(KEY_ACCTFORMULA, acctFormulaTxt.p1);
    }

    private Pair<String, String> getAcctFormulaTxt(String formula, String dataSource, Long acctTableId) {
        String formulaTxt = formula;
        Map<String, String> numMap = AccountMemberAddPlugin.regexMatchTrim(formula, "(?<=\\[)(.*?)(?=\\])");
        if (!numMap.isEmpty()) {
            DynamicObjectCollection dyc = null;
            QFilter numf = new QFilter("number", "in", (Object)numMap.keySet().toArray(new String[0]));
            if (dataSource.equals("0")) {
                QFilter acctTablef = new QFilter("accounttable.id", "=", (Object)acctTableId);
                dyc = QueryServiceHelper.query((String)"bd_accountview", (String)"number,name", (QFilter[])new QFilter[]{numf, acctTablef});
            } else if (dataSource.equals("1")) {
                dyc = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"number,name", (QFilter[])new QFilter[]{numf});
            }
            if (dyc != null) {
                for (DynamicObject dynamicObject : dyc) {
                    String originNumber = String.format("[%s]", numMap.get(dynamicObject.getString("number")));
                    formulaTxt = formulaTxt.replace(originNumber, String.format("[%s]", dynamicObject.getString("name")));
                }
            }
            for (Map.Entry<String, String> entry : numMap.entrySet()) {
                formula = formula.replace(String.format("[%s]", entry.getValue()), String.format("[%s]", entry.getKey()));
            }
        }
        return Pair.onePair((Object)formula.trim(), (Object)formulaTxt.trim());
    }

    private void fillOperator(String operator) {
        String formula = this.getModel().getValue(KEY_ACCTFORMULA).toString();
        this.getModel().setValue(KEY_ACCTFORMULA, (Object)(formula.isEmpty() ? "" : formula + operator));
    }

    private void setItemSetting() {
        String type = this.getModel().getValue(KEY_ACCOUNTTYPE).toString();
        if (type.equals("7")) {
            this.getModel().setValue(KEY_DATARESOURCE, (Object)"1");
        } else if (Arrays.asList(acctArrary).contains(type)) {
            this.getModel().setValue(KEY_DATARESOURCE, (Object)"0");
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ITEMSETTING});
    }

    private static Map<String, String> regexMatchTrim(String source, String pattern) {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher matcher = Pattern.compile(pattern).matcher(source);
        while (matcher.find()) {
            result.put(matcher.group().trim(), matcher.group());
        }
        return result;
    }

    private void accountChangeRdControl(ItemClickEvent evt) {
        int bizRowCount;
        IPageCache pageCache = this.getPageCache();
        String key = evt.getItemKey();
        Tab t = (Tab)this.getControl("changetab");
        String currentTab = t.getCurrentTab();
        if ("addrow".equals(key)) {
            if ("bizchangerdstab".equals(currentTab)) {
                if (pageCache.get("hasbizrow") != null && "true".equals(pageCache.get("hasbizrow"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u6761\u65b0\u589e\u7684\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u8bf7\u5148\u586b\u5199\u5e76\u4fdd\u5b58\u3002", (String)"AccountMemberAddPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().createNewEntryRow("bizchangerds");
                pageCache.put("hasbizrow", "true");
            }
        } else if ("deleterow".equals(key) && "bizchangerdstab".equals(currentTab) && (bizRowCount = this.getModel().getEntryRowCount("bizchangerds")) - 1 >= 0) {
            this.getModel().deleteEntryRow("bizchangerds", bizRowCount - 1);
            pageCache.put("hasbizrow", "false");
        }
    }
}

