/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.accountmember;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.upgrade.DimNodeType;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;

public class AccountMemberDimMapPlugin
extends AbstractBaseBasicPlugIn
implements RowClickEventListener {
    private static final String DM_VAL = "dm_val";
    private static final String DM_VAL_STR = "dm_valstr";
    private static final String DM_DIM = "dm_dim";
    private static final String DM_ENTRY = "dm_entry";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{DM_VAL_STR});
        EntryGrid entryGrid = (EntryGrid)this.getControl(DM_ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection dync = this.getDimension();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(DM_DIM, new Object[0]);
        vs.addField(DM_VAL, new Object[0]);
        for (DynamicObject dyn : dync) {
            vs.addRow(new Object[]{dyn.getLong("id"), null});
        }
        model.deleteEntryData(DM_ENTRY);
        model.batchCreateNewEntryRow(DM_ENTRY, vs);
        this.getView().updateView(DM_ENTRY);
    }

    private DynamicObjectCollection getDimension() {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter typeFilter = new QFilter("number", "in", (Object)AccountMemberUtil.dimMapNumbers);
        typeFilter.or(new QFilter("fieldmapped", "!=", (Object)""));
        return QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{modelFilter, typeFilter}, (String)"dseq");
    }

    public void afterLoadData(EventObject e) {
        this.doLoad(true);
    }

    private void doLoad(boolean isLoad) {
        IDataModel model = this.getModel();
        DynamicObjectCollection dync = model.getEntryEntity(DM_ENTRY);
        ArrayList<Long> oldDimIds = new ArrayList<Long>(10);
        for (int i = 0; i < dync.size(); ++i) {
            String valStr;
            DynamicObject dyn = (DynamicObject)dync.get(i);
            if (isLoad && !StringUtils.isEmpty((String)(valStr = dyn.getString(DM_VAL)))) {
                List list = SerializationUtils.fromJsonStringToList((String)valStr, Map.class);
                StringBuilder sb = new StringBuilder();
                for (Object o : list) {
                    Map map = (Map)o;
                    this.buildPageViewShowName(sb, map);
                }
                model.setValue(DM_VAL_STR, (Object)sb.substring(0, sb.length() - 1), i);
            }
            if (StorageTypeEnum.SHARE.index.equals(this.getModel().getValue("storagetype"))) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{DM_VAL_STR});
            }
            oldDimIds.add(dyn.getLong("dm_dim_id"));
        }
        DynamicObjectType objectType = dync.getDynamicObjectType();
        DynamicObject[] dimensions = this.loadDimension();
        for (int i = 0; i < dimensions.length; ++i) {
            DynamicObject dim = dimensions[i];
            long dimId = dim.getLong("id");
            if (oldDimIds.contains(dimId)) continue;
            DynamicObject dd = new DynamicObject(objectType);
            dd.set(DM_DIM, (Object)dim);
            dync.add(i, dd);
        }
        int seq = 1;
        for (DynamicObject dyn : dync) {
            dyn.set("seq", (Object)seq++);
        }
        if (!isLoad) {
            this.getView().updateView(DM_ENTRY);
        }
        this.getModel().setDataChanged(false);
    }

    private DynamicObject[] loadDimension() {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter typeFilter = new QFilter("number", "in", (Object)AccountMemberUtil.dimMapNumbers);
        typeFilter.or(new QFilter("fieldmapped", "!=", (Object)""));
        return BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{modelFilter, typeFilter}, (String)"dseq");
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object value;
        TextEdit edit;
        String fieldKey;
        Object source = e.getSource();
        if (source instanceof TextEdit && DM_VAL_STR.equals(fieldKey = (edit = (TextEdit)source).getFieldKey()) && ((value = e.getValue()) == null || value.toString().equals(""))) {
            int rowIndex = e.getRowIndex();
            this.getModel().setValue(DM_VAL, null, rowIndex);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.clickHelper();
    }

    @Override
    public void click(EventObject evt) {
        TextEdit edit;
        String key;
        Object source = evt.getSource();
        if (source instanceof TextEdit && DM_VAL_STR.equals(key = (edit = (TextEdit)source).getKey())) {
            this.clickHelper();
        }
    }

    protected DimNodeType getNodeType() {
        String dimnodetype = (String)this.getView().getFormShowParameter().getCustomParam("dimnodetype");
        return DimNodeType.getType((String)dimnodetype);
    }

    private void clickHelper() {
        DimNodeType nodeType = this.getNodeType();
        if (nodeType == DimNodeType.STORE || nodeType == null) {
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex(DM_ENTRY);
            DynamicObject dimDyn = (DynamicObject)model.getValue(DM_DIM, currentRowIndex);
            this.showDimValF7(dimDyn, (String)model.getValue(DM_VAL, currentRowIndex));
        }
    }

    private void showDimValF7(DynamicObject dimDyn, String dimVal) {
        String name = dimDyn.getString("name");
        String memberNum = dimDyn.getString("membermodel");
        String dseq = dimDyn.getString("dseq");
        FormShowParameter para = new FormShowParameter();
        if (!memberNum.contains("bcm_icmembertree")) {
            para.setFormId("bcm_multiplememberf7_adj");
        } else {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>();
        String key = String.join((CharSequence)"_", memberNum, dseq);
        params.put("dimension", dseq);
        params.put("sign", key);
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"AccountMemberDimMapPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        IFormView view = this.getView();
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String modelId = pageCache.get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId)) {
            pageCache.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        }
        if (!StringUtils.isEmpty((String)dimVal)) {
            pageCache.put(key, dimVal);
        } else {
            pageCache.put(key, null);
        }
        view.showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String key = evt.getActionId();
        if (key.startsWith("bcm_") && (returnData = evt.getReturnData()) != null) {
            DynamicObjectCollection doc = (DynamicObjectCollection)evt.getReturnData();
            StringBuilder sb = new StringBuilder();
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(doc.size());
            for (DynamicObject dynamicObject : doc) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", dynamicObject.get(4).toString());
                map.put("scope", dynamicObject.get(5).toString());
                map.put("number", dynamicObject.get(2).toString());
                map.put("name", dynamicObject.get(3).toString());
                map.put("pid", dynamicObject.get(6).toString());
                this.buildPageViewShowName(sb, map);
                list.add(map);
            }
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex(DM_ENTRY);
            if (doc.isEmpty()) {
                model.setValue(DM_VAL_STR, null, currentRowIndex);
                model.setValue(DM_VAL, null, currentRowIndex);
            } else {
                model.setValue(DM_VAL_STR, (Object)sb.substring(0, sb.length() - 1), currentRowIndex);
                model.setValue(DM_VAL, (Object)SerializationUtils.toJsonString(list), currentRowIndex);
            }
        }
    }

    private void buildPageViewShowName(StringBuilder sb, Map<String, String> map) {
        String name = map.get("name");
        int val = Integer.parseInt(map.get("scope"));
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"AccountMemberDimMapPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean issuccess;
        String operateKey = args.getOperateKey();
        this.doLoad(false);
        OperationResult operationResult = args.getOperationResult();
        boolean bl = issuccess = operationResult.getValidateResult().isSuccess() && operationResult.isSuccess();
        if ("save".equals(operateKey) && issuccess) {
            List successPkIds = operationResult.getSuccessPkIds();
            long modelId = this.getModelId();
            for (Object successPkId : successPkIds) {
                AccountMemberUtil.rmvAccDimValMapGlobalCache((long)((Long)successPkId), (long)modelId);
            }
        }
    }
}

