/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.accountmember;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class AccountMemberList
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AccountMemberDataProvider());
    }

    private static final class DataSetMapper {
        private RowMeta rowMeta;
        private DynamicObjectType dt;
        private List<Row> rowList;
        private List<ListField> pkFields;
        private int pkIndex = -1;

        DataSetMapper(DynamicObjectType dt, RowMeta rowMeta, List<Row> rowList, List<ListField> pkFields) {
            this.dt = dt;
            this.rowMeta = rowMeta;
            this.rowList = rowList;
            this.pkFields = pkFields;
        }

        DynamicObjectCollection getDynamicObjectCollection() {
            int n = this.rowMeta.getFieldCount();
            for (int i = 0; i < n; ++i) {
                if (!this.rowMeta.getField(i).getName().equals(this.pkFields.get(0).getFieldName())) continue;
                this.pkIndex = i;
            }
            return this.createDynamicObjectCollection(this.pkIndex);
        }

        private DynamicObjectCollection createDynamicObjectCollection(int pkIndex) {
            return this.createDynamicObjectCollection();
        }

        private DynamicObjectCollection createDynamicObjectCollection() {
            int n = this.rowMeta.getFieldCount();
            Iterator<Row> iterator = this.rowList.iterator();
            DynamicObjectCollection ret = new DynamicObjectCollection(this.dt, null);
            ret.beginInit();
            while (iterator.hasNext()) {
                Row row = iterator.next();
                DynamicObject obj = new DynamicObject(this.dt);
                for (int i = 0; i < n; ++i) {
                    this.setPropertyValue(row, obj, i);
                }
                ret.add((Object)obj);
            }
            ret.endInit();
            BusinessDataReader.loadRefence((Object[])ret.toArray((Object[])new DynamicObject[ret.size()]), (IDataEntityType)this.dt);
            return ret;
        }

        private void setPropertyValue(Row row, DynamicObject obj, int i) {
            DynamicProperty property = this.dt.getProperty(this.rowMeta.getField(i).getName());
            if (property != null) {
                if (property instanceof BasedataProp) {
                    property = ((BasedataProp)property).getRefIdProp();
                }
                property.setValueFast((Object)obj, row.get(i));
            }
        }
    }

    class AccountMemberDataProvider
    extends ListDataProvider {
        private static final String COMMA = ",";

        AccountMemberDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            FormShowParameter showParam = AccountMemberList.this.getView().getFormShowParameter();
            String model = (String)showParam.getCustomParam("model_number");
            String dimension = (String)showParam.getCustomParam("dimension_number");
            Object isCustomObj = showParam.getCustomParam("isCustom");
            boolean isCustom = isCustomObj == null ? false : (Boolean)isCustomObj;
            Map scopes = (Map)showParam.getCustomParam("member_scope");
            if (isCustom || model == null || scopes == null || scopes.isEmpty() || !"number".equals(this.getQueryBuilder().getOrderBys()) || AccountMemberList.this.getPageCache().get("isInitialLoad") != null) {
                return super.getData(start, limit);
            }
            this.setQueryBuilder(QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false));
            List<Long> idList = this.getIDList(model, dimension, scopes);
            int rowCount = idList.size();
            DynamicObjectCollection collection = null;
            if (start >= rowCount) {
                collection = new DynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), null);
            } else {
                int end = start + limit;
                end = end < idList.size() ? end : idList.size();
                try (DataSet ds = this.getDataSetByPks(this.getQueryBuilder(), idList.subList(start, end));){
                    List<Row> dsLs = this.dataSetToRowList(ds);
                    collection = this.getDynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), dsLs, ds.getRowMeta(), this.getQueryBuilder().getPkFields());
                }
            }
            this.setQueryResult(collection, rowCount, rowCount, this.getQueryBuilder());
            String cacheKey = PageRowCacheUtils.getCacheKey();
            String controlKey = PageRowCacheUtils.getControlKey();
            String mapKeyPrfix = StringUtils.isEmpty((CharSequence)controlKey) ? "" : controlKey;
            PageRowCacheUtils.touchFlag();
            String cacheId = cacheKey + mapKeyPrfix;
            AccountMemberList.this.getPageCache().put(cacheId, String.valueOf(idList.size()));
            AccountMemberList.this.getPageCache().put("isInitialLoad", "true");
            return collection;
        }

        private List<Long> getIDList(String model, String dimension, Map<String, Integer> scopes) {
            String searchTxt = this.getSearchTxt();
            ArrayList<Long> nodeIds = new ArrayList<Long>();
            long modelId = MemberReader.findModelIdByNum((String)model);
            block11: for (Map.Entry<String, Integer> en : scopes.entrySet()) {
                List nodes = null;
                IDNumberTreeNode node = MemberReader.findMemberById((String)model, (String)this.getEntityType().getName(), (Long)Long.parseLong(en.getKey()));
                switch (en.getValue()) {
                    case 10: {
                        if (!this.isMatch(node, searchTxt)) break;
                        nodeIds.add(node.getId());
                        break;
                    }
                    case 20: {
                        nodes = node.getChildren();
                        for (IDNumberTreeNode child : nodes) {
                            if (!child.isLeaf() || !this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        nodeIds.remove(node.getId());
                        break;
                    }
                    case 30: {
                        nodes = node.getChildren();
                        for (IDNumberTreeNode child : nodes) {
                            if (!child.isLeaf() || !this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        continue block11;
                    }
                    case 40: {
                        nodes = node.getAllChildren();
                        for (IDNumberTreeNode child : nodes) {
                            if (!this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        nodeIds.remove(node.getId());
                        break;
                    }
                    case 50: {
                        nodes = node.getAllChildren();
                        for (IDNumberTreeNode child : nodes) {
                            if (!this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        continue block11;
                    }
                    case 60: {
                        List brothers;
                        IDNumberTreeNode parent = node.getParent();
                        if (parent != null) {
                            brothers = node.getParent().getChildren();
                            for (IDNumberTreeNode brother : brothers) {
                                if (!this.isMatch(brother, searchTxt)) continue;
                                nodeIds.add(brother.getId());
                            }
                        } else {
                            nodeIds.add(node.getId());
                        }
                        nodeIds.remove(node.getId());
                        break;
                    }
                    case 70: {
                        List brothers;
                        IDNumberTreeNode parent = node.getParent();
                        if (parent != null) {
                            brothers = node.getParent().getChildren();
                            for (IDNumberTreeNode brother : brothers) {
                                if (!this.isMatch(brother, searchTxt)) continue;
                                nodeIds.add(brother.getId());
                            }
                            continue block11;
                        }
                        nodeIds.add(node.getId());
                        break;
                    }
                    case 90: {
                        nodes = node.getAllChildren(2);
                        if (node.isLeaf()) {
                            nodeIds.add(node.getId());
                        }
                        for (IDNumberTreeNode child : nodes) {
                            if (!child.isLeaf() || !this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        continue block11;
                    }
                    case 110: {
                        nodes = node.getAllChildren(1);
                        if (!node.isLeaf()) {
                            nodeIds.add(node.getId());
                        }
                        for (IDNumberTreeNode child : nodes) {
                            if (child.isLeaf() || !this.isMatch(child, searchTxt)) continue;
                            nodeIds.add(child.getId());
                        }
                        continue block11;
                    }
                }
            }
            return PermissionServiceImpl.getInstance((Long)modelId).matchReadOrWritePermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)dimension), "bcm_accountmembertree", nodeIds).stream().collect(Collectors.toList());
        }

        private String getSearchTxt() {
            String searchTxt = null;
            for (QFilter qf : this.getQFilters()) {
                if (!qf.getCP().equals("ftlike")) continue;
                searchTxt = ((String)qf.getValue()).split("#")[1];
            }
            searchTxt = StringUtils.isNotEmpty(searchTxt) ? searchTxt : null;
            return searchTxt;
        }

        private boolean isMatch(IDNumberTreeNode node, String txt) {
            return txt == null || node.getSearchTxt().contains(txt);
        }

        private DataSet getDataSetByPks(QueryBuilder qb, List<Long> idList) {
            String[] tempStrs;
            List pkFields = qb.getPkFields();
            int pkSize = pkFields.size();
            int rowSize = idList.size();
            QFilter[] filters = new QFilter[pkSize];
            int index = 0;
            for (ListField field : pkFields) {
                ArrayList<Long> pkObjValues = new ArrayList<Long>(rowSize);
                String filterPk = field.getFieldName();
                for (int i = 0; i < rowSize; ++i) {
                    Long pkObj = idList.get(i);
                    pkObjValues.add(pkObj);
                }
                filters[index] = new QFilter(filterPk, "in", pkObjValues);
                ++index;
            }
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.addAll(Arrays.asList(filters));
            ArrayList selectFiledList = new ArrayList();
            selectFiledList.addAll(qb.getPkFields());
            HashSet<String> selectFiledSet = new HashSet<String>(selectFiledList.size());
            for (ListField field : selectFiledList) {
                selectFiledSet.add(field.getFieldName());
            }
            for (String temp : tempStrs = qb.getOrderBys().split(COMMA)) {
                selectFiledSet.add(temp.trim().split(" ")[0]);
            }
            String lowerSelectFields = qb.getSelectFields().toLowerCase(Locale.ENGLISH) + COMMA;
            StringBuilder selectFileds = new StringBuilder(qb.getSelectFields());
            selectFileds.append(COMMA);
            for (String field : selectFiledSet) {
                boolean exists = false;
                String lowerField = field.toLowerCase(Locale.ENGLISH);
                if (lowerSelectFields.startsWith(lowerField)) {
                    boolean bl = exists = lowerSelectFields.startsWith(lowerField + " ") || lowerSelectFields.startsWith(lowerField + COMMA);
                }
                if (!exists) {
                    boolean bl = exists = lowerSelectFields.indexOf(" " + lowerField + " ") != -1 || lowerSelectFields.indexOf(COMMA + lowerField + " ") != -1 || lowerSelectFields.indexOf(COMMA + lowerField + COMMA) != -1 || lowerSelectFields.indexOf(" " + lowerField + COMMA) != -1;
                }
                if (exists) continue;
                selectFileds.append(field);
                selectFileds.append(COMMA);
            }
            qb.setSelectFields(selectFileds.substring(0, selectFileds.length() - 1));
            ORM orm = ORM.create();
            orm.setDataEntityType(qb.getEntityName(), qb.getEntityType());
            return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), qb.getEntityName(), qb.getSelectFields(), qfs.toArray(new QFilter[0]), qb.getOrderBys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Row> dataSetToRowList(DataSet ds) {
            try {
                ArrayList<Row> dsLs = new ArrayList<Row>();
                for (Row row : ds) {
                    dsLs.add(RowUtil.persist((Row)row));
                }
                ArrayList<Row> arrayList = dsLs;
                return arrayList;
            }
            finally {
                ds.close();
            }
        }

        protected DataSet queryDB(QueryBuilder queryBuilder, int maxRowCount) {
            List pkFields = queryBuilder.getPkFields();
            HashSet<String> selectFiledSet = new HashSet<String>(pkFields.size());
            ArrayList selectFiledList = new ArrayList();
            selectFiledList.addAll(pkFields);
            for (ListField field : selectFiledList) {
                selectFiledSet.add(field.getFieldName());
            }
            String orderByStr = queryBuilder.getOrderBys();
            if (!StringUtils.isEmpty((CharSequence)orderByStr)) {
                String[] tempStrs = orderByStr.trim().split(COMMA);
                for (String temp : tempStrs) {
                    selectFiledSet.add(temp.trim().split(" ")[0].toLowerCase(Locale.ENGLISH));
                }
            }
            StringBuilder selectFileds = new StringBuilder();
            for (String field : selectFiledSet) {
                selectFileds.append(field);
                selectFileds.append(COMMA);
            }
            ORM orm = ORM.create();
            orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
            if (this.getDataEntityTypes() != null) {
                for (IDataEntityType iDataEntityType : this.getDataEntityTypes()) {
                    orm.setDataEntityType(iDataEntityType.getName(), iDataEntityType);
                }
            }
            String order = queryBuilder.getOrderBys();
            return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), queryBuilder.getEntityName(), selectFileds.substring(0, selectFileds.length() - 1), queryBuilder.getFilters(), order, maxRowCount, (Distinctable)WithEntityEntryDistinctable.get());
        }

        private DynamicObjectCollection getDynamicObjectCollection(DynamicObjectType dt, List<Row> rowList, RowMeta rowMeta, List<ListField> pkListFields) {
            DataSetMapper dataSetMapper = new DataSetMapper(dt, rowMeta, rowList, pkListFields);
            return dataSetMapper.getDynamicObjectCollection();
        }

        public void setQueryResult(DynamicObjectCollection collection, int dataCount, int billDataCount, QueryBuilder qb) {
            QueryResult qr = this.getQueryResult();
            qr.setCollection(collection);
            qr.setDataCount(dataCount);
            qr.setBillDataCount(billDataCount);
            List decimalFields = qb.getDecimalFields();
            ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(decimalFields.size());
            for (ListField field : decimalFields) {
                FmtField fmtField = new FmtField(field.getSrcFieldProp(), field.getListFieldKey().replace('.', '_'), field.getControlField() != null ? field.getControlField().getFieldName() : "");
                fmtField.setControlFieldKey(field.getControlField() != null ? field.getControlField().getListFieldKey() : "");
                fmtFields.add(fmtField);
            }
            NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, collection);
            qr.setNumberFormatProvider(numberFormatProvider);
        }

        public int getBillDataCount() {
            return this.getRealCount();
        }

        public int getRealCount() {
            String cacheKey = PageRowCacheUtils.getCacheKey();
            String controlKey = PageRowCacheUtils.getControlKey();
            String mapKeyPrfix = StringUtils.isEmpty((CharSequence)controlKey) ? "" : controlKey;
            PageRowCacheUtils.touchFlag();
            String cacheId = cacheKey + mapKeyPrfix;
            String rowCount = AccountMemberList.this.getPageCache().get(cacheId);
            return rowCount == null ? super.getRealCount() : Integer.parseInt(rowCount);
        }
    }
}

