/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.attachment.AdjustAttachmentHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustAttachmentPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static final String DEL_CACHE_ASIGN = "attachmentDeleteRecords";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void initialize() {
        super.initialize();
        long adjustId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
        Map adjust = AdjustAttachmentHelper.getAttachmentSrcAdjust(Collections.singletonList(adjustId));
        Long srcAdjustId = adjust.getOrDefault(adjustId, adjustId);
        if (!srcAdjustId.equals(adjustId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap", "btnok"});
        }
        this.getView().getFormShowParameter().setCustomParam("pkId", (Object)adjust.getOrDefault(adjustId, adjustId));
    }

    public void afterBindData(EventObject e) {
        this.showAttachmentPanel();
    }

    protected void showAttachmentPanel() {
        long adjustId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        ArrayList attachs = new ArrayList(16);
        attachs.addAll(AttachmentServiceHelper.getAttachments((String)"bcm_rptadjust", (Object)(adjustId + ""), (String)"attachmentpanelap"));
        attachmentPanel.bindData(attachs);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            long adjustId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
            PlatUtil.executeWithTX(tx -> {
                ArrayList<Object> deleteSet = new ArrayList<Object>(16);
                ArrayList<DynamicObject> urlList = new ArrayList<DynamicObject>(16);
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                List attachmentData = attachmentPanel.getAttachmentData();
                if (!CollectionUtils.isEmpty((Collection)attachmentData)) {
                    for (Map url : attachmentData) {
                        deleteSet.add(url.get("uid"));
                        urlList.add(AdjustAttachmentPlugin.createDynamicObject(url, adjustId));
                    }
                }
                deleteSet.addAll(this.getDeleteAndClearCache());
                if (!deleteSet.isEmpty()) {
                    QFBuilder qf = new QFBuilder("fInterID", "=", (Object)(adjustId + ""));
                    qf.add("fnumber", "in", deleteSet);
                    DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qf.toArray());
                }
                if (!urlList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])urlList.toArray(new DynamicObject[0]));
                }
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjustAttachmentPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterRemove(UploadEvent evt) {
        if (evt.getUrls() != null && evt.getUrls().length > 0) {
            this.cacheDelete((Consumer<Set<String>>)((Consumer)e -> e.addAll(Arrays.stream(evt.getUrls()).map(url -> ((Map)url).getOrDefault("uid", "").toString()).collect(Collectors.toList()))));
        }
    }

    public void cacheDelete(Consumer<Set<String>> consumer) {
        String cache = this.getPageCache().get(DEL_CACHE_ASIGN);
        Set set = cache != null ? (Set)ObjectSerialUtil.deSerializedBytes((String)cache) : new HashSet(16);
        consumer.accept(set);
        this.getPageCache().put(DEL_CACHE_ASIGN, ObjectSerialUtil.toByteSerialized(set));
    }

    public Set<String> getDeleteAndClearCache() {
        String cache = this.getPageCache().get(DEL_CACHE_ASIGN);
        this.getPageCache().remove(DEL_CACHE_ASIGN);
        return cache != null ? (Set)ObjectSerialUtil.deSerializedBytes((String)cache) : new HashSet(16);
    }

    public static DynamicObject createDynamicObject(Map<String, Object> url, Long pkId) {
        String urlstr = AttachmentServiceHelper.saveTempToFileService((String)url.get("url").toString(), (String)"bcm", (String)"bcm_rptadjust", (Object)pkId, (String)url.get("name").toString());
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynObj.set("fBillType", (Object)"bcm_rptadjust");
        dynObj.set("fnumber", url.get("uid"));
        dynObj.set("fInterID", (Object)pkId);
        dynObj.set("fFileId", (Object)urlstr);
        dynObj.set("fAttachmentName", url.get("name"));
        String name = (String)url.getOrDefault("name", "");
        String[] split = name.split("\\.");
        if (split.length > 1) {
            dynObj.set("fExtName", (Object)split[split.length - 1]);
        } else {
            dynObj.set("fExtName", url.get("type"));
        }
        dynObj.set("fAttachmentSize", url.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", (Object)RequestContext.get().getCurrUserId());
        dynObj.set("fCreateTime", url.get("createdate"));
        dynObj.set("fModifyMen_Id", (Object)RequestContext.get().getCurrUserId());
        dynObj.set("fModifyTime", url.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        dynObj.set("fdescription", url.get("description"));
        return dynObj;
    }
}

