/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustBatchCreateParam;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class AdjustCreateAutoElimSetPlugin
extends AbstractBaseFormPlugin {
    private static final String COMMON_PAPERS = "commonpapers";
    private static final String INVESTED_TEMPLATES = "investedtemplates";

    @Override
    public void initialize() {
        super.initialize();
        if (BlackListUtils.hasFeatureInCm((String)"CMRpt")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"iscommonpaperselected", "isinvsheetpaperselected"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        MulBasedataEdit commonPapers = (MulBasedataEdit)this.getControl(COMMON_PAPERS);
        commonPapers.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object modelId = this.getFormCustomParam("model");
            TemplateCatalogEnum catalogEnum = TemplateCatalogEnum.PRTADJUST;
            QFBuilder qfBuilder = new QFBuilder("model", "=", modelId).add("longnumber", "like", (Object)(catalogEnum.getLongnumber() + "%"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])qfBuilder.toArray());
            Set catalogIds = dynamicObjects.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            QFilter customQFilter = new QFilter("model", "=", modelId);
            customQFilter.and("status", "=", (Object)"1");
            customQFilter.and("templatecatalog", "in", catalogIds);
            beforeF7SelectEvent.addCustomQFilter(customQFilter);
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("catalog", (Object)catalogEnum.getNumber());
        });
        MulBasedataEdit investedTemplates = (MulBasedataEdit)this.getControl(INVESTED_TEMPLATES);
        investedTemplates.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter customQFilter = new QFilter("model", "=", this.getFormCustomParam("model"));
            customQFilter.and("billstatus", "=", (Object)"C");
            beforeF7SelectEvent.addCustomQFilter(customQFilter);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getFormCustomParam("model"));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String btnKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(btnKey)) {
            AdjustBatchCreateParam dataCreateParam = new AdjustBatchCreateParam();
            dataCreateParam.setScope(Integer.parseInt(this.getModel().getValue("orgscope").toString()));
            dataCreateParam.setCreateAdjust(((Boolean)this.getValue("createadjust")).booleanValue());
            dataCreateParam.setCreateElim(((Boolean)this.getValue("createelim")).booleanValue());
            if (!dataCreateParam.isCreateElim() && !dataCreateParam.isCreateAdjust()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCreateAutoElimSetPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            dataCreateParam.setCommonPaperSelected(((Boolean)this.getValue("iscommonpaperselected")).booleanValue());
            dataCreateParam.setInvestTempSelected(((Boolean)this.getValue("isinvesttempselected")).booleanValue());
            dataCreateParam.setInvSheetPaperSelected(((Boolean)this.getValue("isinvsheetpaperselected")).booleanValue());
            if (!(dataCreateParam.isCommonPaperSelected() || dataCreateParam.isInvestTempSelected() || dataCreateParam.isInvSheetPaperSelected())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCreateAutoElimSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection commonPapers = (DynamicObjectCollection)this.getModel().getValue(COMMON_PAPERS);
            Set commonPaperIds = commonPapers.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            dataCreateParam.setCommonPaperIds(commonPaperIds);
            DynamicObjectCollection investedTemplates = (DynamicObjectCollection)this.getModel().getValue(INVESTED_TEMPLATES);
            Set investedTemplateIds = investedTemplates.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            dataCreateParam.setInvestedTemplateIds(investedTemplateIds);
            this.getView().returnDataToParent((Object)dataCreateParam);
            this.getView().close();
        }
    }
}

