/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class AdjustFormulaRegisterHelper {
    public static boolean checkFormulaValid(String funcName, long modelId) {
        return AdjustFormulaRegisterHelper.getRegisterFormulaList(modelId).parallelStream().anyMatch(p -> funcName.equalsIgnoreCase((String)p.get("number")) || funcName.equalsIgnoreCase((String)p.get(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k())));
    }

    public static List<Map<String, Object>> getRegisterFormulaList(Long modelId) {
        List formulaListResult = (List)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getAdjustRegisterFormulaList", () -> {
            ArrayList formulaList = new ArrayList(16);
            ResourcesLoaderUtil.getMapListFromResources((String)"bcmformula/rpt_formulas_list.json").forEach(f -> formulaList.add(AdjustFormulaRegisterHelper.createFormulaMap(AdjustFormulaRegisterHelper.getFormulaFromResources(f.get("number").toString()))));
            ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(cfg -> cfg.getFormulas().forEach(f -> formulaList.add(AdjustFormulaRegisterHelper.createFormulaMap(f))));
            return formulaList;
        });
        formulaListResult.forEach(f -> AdjustFormulaRegisterHelper.dealFunction(modelId, f));
        return formulaListResult;
    }

    private static Map<String, Object> createFormulaMap(final Formula f) {
        return new HashMap(){
            {
                this.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), f.getNumber());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), f.getParam().size());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
                if (f.getMinArgs() != null) {
                    this.put("minArgs", f.getMinArgs());
                }
                HashMap<String, Object> description = new HashMap<String, Object>();
                description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), f.getName());
                description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), f.getParam());
                this.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
            }
        };
    }

    private static Map<String, Object> createFormulaMap(final Map formula) {
        return new HashMap(){
            {
                this.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), formula.get("number"));
                Object param = formula.get("param");
                int argsum = 0;
                if (param instanceof JSONArray) {
                    argsum = ((JSONArray)param).size();
                }
                this.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), argsum);
                this.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
                if (formula.get("minArgs") != null) {
                    this.put("minArgs", formula.get("minArgs"));
                }
                HashMap description = new HashMap();
                description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), formula.get("name"));
                description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), param);
                this.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
            }
        };
    }

    private static void dealFunction(Long modelId, Map<String, Object> f) {
        String name = (String)f.get(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k());
        if (name == null) {
            name = (String)f.get("number");
        }
        if ("v".equalsIgnoreCase(name)) {
            if (modelId == null || modelId == 0L) {
                return;
            }
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"name,shortnumber", (QFilter[])new QFilter[]{QFilter.of((String)"model =?", (Object[])new Object[]{modelId})});
            f.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), dcs.size());
            Map description = (Map)f.get(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k());
            ArrayList<Map> params = new ArrayList<Map>(dcs.size());
            params.add(MapInitHelper.ofMap((Object)SpreadProperties.RegisterCustomFormulaMethod.NAME.k(), (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u7b80\u7801.\u7ef4\u5ea6\u6210\u5458\u7f16\u7801,...", (String)"MultiViewTemplateProcess_76", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), params);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dimension : dcs) {
                sb.append(dimension.getString("shortnumber")).append(":").append(dimension.getString("name")).append("  ");
            }
            description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), sb.toString());
            f.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
        }
    }

    private static Formula getFormulaFromResources(String formulaNum) {
        return ResourcesLoaderUtil.getFormulaFromResources((String)("bcmformula/" + formulaNum.toLowerCase() + ".json"));
    }
}

