/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperationStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.IOperationLog;

public class AdjustOperationProgressPlugin
extends AbstractBaseListPlugin
implements ProgresssListener,
HyperLinkClickListener,
IOperationLog {
    private static final String scenario = "scenario";
    private static final String year = "year";
    private static final String period = "period";
    private final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String BILL_LIST_AP = "billlistap";
    private List<String> f7Keys = Arrays.asList("model", "year", "period", "scenario");

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("progrefresh", "progclose");
        ((BillList)this.getControl(BILL_LIST_AP)).addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        ((BillList)this.getControl(BILL_LIST_AP)).addListRowClickListener((ListRowClickListener)this);
        ((BillList)this.getControl(BILL_LIST_AP)).addHyperClickListener((HyperLinkClickListener)this);
        ((ProgressBar)this.getControl("progressbarap")).addProgressListener((ProgresssListener)this);
        ((ProgressBar)this.getControl("progressbarap")).start();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        HashMap map = new HashMap();
        this.asMapF7toType(this.dimKeys, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", Long.toString(this.getModelId()));
        this.getModel().setValue(scenario, this.getView().getFormShowParameter().getCustomParam(scenario));
        this.getModel().setValue(year, this.getView().getFormShowParameter().getCustomParam(year));
        this.getModel().setValue(period, this.getView().getFormShowParameter().getCustomParam(period));
        this.getModel().setValue("operationtype", this.getView().getFormShowParameter().getCustomParam("operationtype"));
        this.refreshBillist();
        this.refreshPercent();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "progclose": {
                this.getView().close();
                break;
            }
            case "progrefresh": {
                this.refreshBillist();
                this.refreshPercent();
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() > 0) {
            ((ProgressBar)this.getControl("progressbarap")).getPercent();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.refreshBillist();
        this.refreshPercent();
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"status")) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    row.set("status", (Object)row.getString("status").trim());
                    row.set("failedlog", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"AdjustOperationProgressPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                return rows;
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        ListSelectedRow row;
        if ("failedlog".equals(e.getFieldName()) && (row = ((BillList)this.getView().getControl(BILL_LIST_AP)).getCurrentSelectedRowInfo()) != null) {
            AdjustOperationThreadHelper.showDetailLogForm((IFormView)this.getView(), (long)LongUtil.toLong((Object)row.getPrimaryKeyValue()));
        }
    }

    public void onProgress(ProgressEvent e) {
        Control control = (Control)e.getSource();
        if ("progressbarap".equals(control.getKey())) {
            try {
                BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                if (billList.getCurrentListAllRowCollection() != null && !billList.getCurrentListAllRowCollection().isEmpty()) {
                    Pair<Integer, String> result = billList.getCurrentSelectedRowInfo() == null ? this.refreshProcess(billList.getCurrentListAllRowCollection().get(0).getPrimaryKeyValue()) : this.refreshProcess(billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                    e.setProgress(((Integer)result.p1).intValue());
                    e.setText((String)result.p2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refreshPercent() {
        ((ProgressBar)this.getControl("progressbarap")).getPercent();
    }

    private void refreshBillist() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        Map<String, Object> f7Map = this.collectF7ValueMap();
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("1", "=", (Object)1);
        f7Map.forEach((key, value) -> filter.and(key, "=", value));
        if (!((Boolean)this.getModel().getValue("showsuccess")).booleanValue()) {
            filter.and("status", "!=", (Object)Integer.toString(AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus()));
        }
        if (!((Boolean)this.getModel().getValue("showfailed")).booleanValue()) {
            filter.and("status", "!=", (Object)Integer.toString(AdjustOperationStatusEnum.ERRORSTATUS.getStatus()));
        }
        filter.and("status", "in", Arrays.stream(AdjustOperationStatusEnum.values()).map(integer -> Integer.toString(integer.getStatus())).collect(Collectors.toList()));
        Object op = this.getValue("operationtype");
        if (!ObjectUtils.isEmpty((Object)op)) {
            if (op.toString().equals(Integer.toString(AdjustOperTypeEnum.PERIODCONTINUEOPERATION.getValue())) || op.toString().equals(Integer.toString(AdjustOperTypeEnum.YEARCONTINUEOPERATION.getValue()))) {
                filter.and("operationtype", "in", (Object)new String[]{"" + AdjustOperTypeEnum.PERIODCONTINUEOPERATION.getValue(), "" + AdjustOperTypeEnum.YEARCONTINUEOPERATION.getValue()});
            } else {
                filter.and("operationtype", "=", (Object)op.toString());
            }
        }
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
    }

    private Map<String, Object> collectF7ValueMap() {
        HashMap<String, Object> f7Map = new HashMap<String, Object>();
        this.f7Keys.forEach(f7Key -> {
            DynamicObject dim = (DynamicObject)this.getModel().getValue(f7Key);
            if (dim == null) {
                f7Map.put((String)f7Key, 0L);
            } else {
                f7Map.put((String)f7Key, dim.getLong("id"));
            }
        });
        return f7Map;
    }

    private Pair<Integer, String> refreshProcess(Object progressId) {
        DynamicObject record = AdjustOperationThreadHelper.getAdjLogFromCache((Long)((Long)progressId));
        int successcount = record.getInt("successcount");
        int errorcount = record.getInt("errorcount");
        int count = record.getInt("count");
        int status = Integer.parseInt(record.getString("status").trim());
        int percent = count == 0 ? 0 : (errorcount + successcount) * 100 / count;
        AdjustOperationStatusEnum statusEnum = AdjustOperationStatusEnum.getStatusByIndex((int)status);
        switch (statusEnum) {
            case SUCCESSSTATUS: 
            case ERRORSTATUS: 
            case COMPLETEDSTATUS: {
                percent = count == 0 ? 100 : percent;
                break;
            }
            default: {
                percent = Math.min(99, percent);
            }
        }
        AdjustOperTypeEnum operType = AdjustOperTypeEnum.getEnumByValue((int)record.getInt("operationtype"));
        Pair result = null;
        if (operType == AdjustOperTypeEnum.BATCHCREATEINVESTOPERATION || operType == AdjustOperTypeEnum.CREATEAUTOOPERATION) {
            ((Label)this.getControl("count")).setText(ResManager.loadKDString((String)"\u603b\u7ec4\u7ec7\u6570\uff1a%s", (String)"AdjustOperationProgressPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[]{count}));
            ((Label)this.getControl("successcount")).setText(ResManager.loadKDString((String)"\u5b8c\u6210\u7ec4\u7ec7\u6570\uff1a%s", (String)"AdjustOperationProgressPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[]{successcount}));
            ((Label)this.getControl("errorcount")).setText("");
        } else {
            ((Label)this.getControl("count")).setText(ResManager.loadKDString((String)"\u603b\u5206\u5f55\u6570\uff1a%s", (String)"AdjustOperationProgressPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[]{count}));
            ((Label)this.getControl("successcount")).setText(ResManager.loadKDString((String)"\u6210\u529f\u5206\u5f55\u6570\uff1a%s", (String)"AdjustOperationProgressPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{successcount}));
            ((Label)this.getControl("errorcount")).setText(ResManager.loadKDString((String)"\u5931\u8d25\u5206\u5f55\u6570\uff1a%s", (String)"AdjustOperationProgressPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[]{errorcount}));
        }
        result = Pair.onePair((Object)percent, (Object)(statusEnum.getText() + " : " + percent + "%"));
        Date beginTime = record.getDate("begintime");
        Date endTime = record.getDate("endtime");
        this.dealCostTime(beginTime, endTime);
        if ("BACKOPERATION".equals(operType.toString())) {
            if (status == 3) {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6253\u56de", "AdjustOperationProgressPlugin_3", "fi-bcm-formplugin", "back"), new OPDescMultiLangEnumBridge("\u6253\u56de\u5931\u8d25", "AdjustOperationProgressPlugin_4", "fi-bcm-formplugin"));
            }
            if (status == 5) {
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6253\u56de", "AdjustOperationProgressPlugin_3", "fi-bcm-formplugin", "back"), new OPDescMultiLangEnumBridge("\u6253\u56de\u6210\u529f", "AdjustOperationProgressPlugin_5", "fi-bcm-formplugin"));
            }
        }
        return result;
    }

    private void dealCostTime(Date beginTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String costTimeStr = "";
        String endTimeStr = "";
        String beginTimeStr = sdf.format(beginTime);
        if (endTime != null) {
            beginTimeStr = sdf.format(beginTime);
            endTimeStr = sdf.format(endTime);
            long costTalTime = (endTime.getTime() - beginTime.getTime()) / 1000L;
            long hours = costTalTime / 3600L;
            long min = (costTalTime - hours * 3600L) / 60L;
            Long second = costTalTime - hours * 3600L - min * 60L;
            if (hours > 0L) {
                String hourStr = ResManager.loadKDString((String)"\u5c0f\u65f6\u3001", (String)"AdjustOperationProgressPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                costTimeStr = costTimeStr + hours + hourStr;
            }
            if (min > 0L) {
                String minStr = ResManager.loadKDString((String)"\u5206\u949f\u3001", (String)"AdjustOperationProgressPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                costTimeStr = costTimeStr + min + minStr;
            }
            String sceStr = ResManager.loadKDString((String)"\u79d2", (String)"AdjustOperationProgressPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            costTimeStr = costTimeStr + second + sceStr;
        }
        ((Label)this.getControl("begintime")).setText(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a%s", (String)"AdjustOperationProgressPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), beginTimeStr));
        ((Label)this.getControl("endtime")).setText(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\uff1a%s", (String)"AdjustOperationProgressPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), endTimeStr));
        ((Label)this.getControl("costtime")).setText(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%s", (String)"AdjustOperationProgressPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), costTimeStr));
    }
}

