/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Margin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.formula.calculate.adjust.GetJLEntryCalculate;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.ComboEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class GetJLEntryFormulaPlugin
extends AbstractBaseFormPlugin
implements DynamicPage,
SingleMemberF7Util.ISingleMemberF7Handle {
    private SchemeContext sctx;

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_")) {
            String dimKey = ctrlKey.replace("bcm_", "");
            Dimension dim = this.getSctx().getDimensionByNumber("merge".equals(dimKey) ? "Entity" : dimKey);
            if (dim != null) {
                BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), ctrlKey, this, false, SingleF7TypeEnum.COMMON);
                sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"GetJLEntryFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                sf7.setDisplayAllFyOrPeriodMemb(true);
                sf7.addBeforeF7SelectListener(this);
                e.setControl((Control)sf7);
            }
        }
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof BasedataEditSingleMemberF7) {
            ((BasedataEditSingleMemberF7)((Object)source)).setCustomFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        if (e.getSource() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 sf7 = (BasedataEditSingleMemberF7)((Object)e.getSource());
            e.getCustomQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()));
            if ("bcm_userdefinedmembertree".equals(sf7.getEntity())) {
                e.getCustomQFilters().add(new QFilter("dimension.id", "=", (Object)sf7.getDimId()));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createSingleF7Area();
        this.refreshFomulaValue();
    }

    private void createSingleF7Area() {
        Area area = new Area("membfieldpanel");
        BaseEditElement mergeElement = new BaseEditElement(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"GetJLEntryFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_merge", "bcm_entitymembertree");
        mergeElement.getStyle().setMargin(this.createMarginStyle());
        mergeElement.setDisplayProp("number,name");
        area.addElement((Element)mergeElement);
        ComboEditElement mergeScopeElement = new ComboEditElement("mergescope", ResManager.loadKDString((String)"\u5408\u5e76\u8303\u56f4", (String)"GetJLEntryFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (List)Lists.newArrayList());
        mergeScopeElement.getStyle().setMargin(this.createMarginStyle());
        mergeScopeElement.getItems().add(new ComboItem(new LocaleString(RangeEnum.VALUE_10.getName()), RangeEnum.VALUE_10.getNumber()));
        mergeScopeElement.getItems().add(new ComboItem(new LocaleString(RangeEnum.VALUE_110.getName()), RangeEnum.VALUE_110.getNumber()));
        mergeScopeElement.setMustinput(Boolean.FALSE.booleanValue());
        area.addElement((Element)mergeScopeElement);
        for (Dimension p2 : this.getSctx().getDimensions()) {
            BaseEditElement dimElement = new BaseEditElement(p2.getName(), "bcm_" + p2.getNumber().toLowerCase(), p2.getEntity());
            dimElement.getStyle().setMargin(this.createMarginStyle());
            dimElement.setDisplayProp("number,name");
            dimElement.setNumber(p2.getNumber());
            if ("Entity".equals(p2.getNumber()) || "Scenario".equals(p2.getNumber()) || "Year".equals(p2.getNumber()) || "Period".equals(p2.getNumber())) {
                dimElement.setMustInput(Boolean.FALSE.booleanValue());
            } else {
                dimElement.setMustInput(Boolean.TRUE.booleanValue());
            }
            area.addElement((Element)dimElement);
        }
        ComboEditElement computeTypeElement = new ComboEditElement("computetype", ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u5f0f", (String)"GetJLEntryFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (List)Lists.newArrayList());
        computeTypeElement.getStyle().setMargin(this.createMarginStyle());
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"GetJLEntryFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "-"));
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u5ba1\u6838", (String)"GetJLEntryFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "0"));
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"GetJLEntryFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "1"));
        computeTypeElement.setMustinput(Boolean.FALSE.booleanValue());
        area.addElement((Element)computeTypeElement);
        area.getElementListList().forEach(p -> {
            p.setLabelDirection("v");
            p.setLabelWidth(new LocaleString("100%"));
        });
        Page page = new Page();
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void refreshFomulaValue() {
        String formula = (String)this.getFormCustomParam("formula");
        if (formula != null) {
            try {
                FunctionExpr expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                String mergeNum = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("merge")));
                IDNumberTreeNode memeNode = MemberReader.findEntityMemberByNum((String)this.getSctx().getModelNumber(), (String)mergeNum);
                if (memeNode != IDNumberTreeNode.NotFoundTreeNode) {
                    DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
                    o.set("id", (Object)memeNode.getId());
                    o.set("name", (Object)memeNode.getName());
                    o.set("number", (Object)memeNode.getNumber());
                    this.setValue("bcm_merge", o);
                }
                this.setValue("mergescope", AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("mergescope"))));
                String dimensionField = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("dimensionMem")));
                for (String itemStr : dimensionField.split(",")) {
                    String[] dimFieldPath = GetJLEntryFormula.splitDimAndMemb((String)itemStr);
                    if (dimFieldPath.length != 2) continue;
                    Dimension dim = this.getSctx().getDimensionByShortNum(dimFieldPath[0]);
                    IDNumberTreeNode dimNode = MemberReader.findMemberByNumber((String)this.getSctx().getModelNumber(), (String)dim.getNumber(), (String)AdjustFormulaParseHelper.handelParam((Object)dimFieldPath[1]));
                    if (dimNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)dim.getEntity());
                    o.set("id", (Object)dimNode.getId());
                    o.set("name", (Object)dimNode.getName());
                    o.set("number", (Object)dimNode.getNumber());
                    this.setValue("bcm_" + dim.getNumber().toLowerCase(), o);
                }
                String computetype = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("computetype")));
                this.setValue("computetype", StringUtils.isEmpty((CharSequence)computetype) ? "-" : computetype);
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u65e0\u6548\u516c\u5f0f\u3002", (String)"GetJLEntryFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprtId = args.getOperateKey();
        if ("confirm".equals(oprtId)) {
            DynamicObject mergeDy = this.getModel().getDataEntity().getDynamicObject("bcm_merge");
            String mergeNum = mergeDy == null ? "" : mergeDy.getString("number");
            Object mergeScope = this.getModel().getValue("mergescope");
            Object computetype = this.getModel().getValue("computetype");
            this.getView().returnDataToParent((Object)InvestFormulaParseHelper.createFunctionExpr((String)"GETJLENTRY", (Object[])new Object[]{new StringExpr(mergeNum), new StringExpr(mergeScope == null ? "" : mergeScope.toString()), new StringExpr(this.createDimensionStr()), new StringExpr(computetype == null ? "" : computetype.toString())}).toString());
        }
        this.getView().close();
    }

    private String createDimensionStr() {
        StringJoiner sb = new StringJoiner(",");
        for (Dimension dim : this.getSctx().getDimensions()) {
            DynamicObject dyna = this.getModel().getDataEntity().getDynamicObject("bcm_" + dim.getNumber());
            if (dyna == null) continue;
            String memeNum = dyna.getString("number");
            if (memeNum.contains(".")) {
                memeNum = "[" + memeNum + "]";
            }
            sb.add(dyna.getString("dimension.shortnumber") + '.' + memeNum);
        }
        return sb.toString();
    }

    private Margin createMarginStyle() {
        Margin margin = new Margin();
        margin.setTop("5px");
        margin.setLeft("60px");
        return margin;
    }

    private SchemeContext getSctx() {
        if (this.sctx == null) {
            this.sctx = new SchemeContext(this.getModelId());
        }
        return this.sctx;
    }
}

