/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.cslscheme.RptAdjustEntryCopyHelper;
import kd.fi.bcm.formplugin.database.MultipleMemberF7BasePlugin;
import kd.fi.bcm.formplugin.dimensionnew.ChangeTypeMemberEdit;

public class MultipleMemberF74AdjustPlugin
extends MultipleMemberF7BasePlugin {
    private static final String cache_org = "cache_org";
    private static final String cache_commonSetting = "cache_commonSetting";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.putAdjustOrg2Cache();
    }

    private void putAdjustOrg2Cache() {
        this.getOrCreateAdjust2OrgMappingFromCache();
    }

    private Map<String, Pair<Long, Long>> getOrCreateAdjust2OrgMappingFromCache() {
        Map cache = Maps.newHashMap();
        IPageCache pageCache = this.getPageCache();
        String cacheString = pageCache.get(cache_org);
        if (StringUtils.isEmpty((CharSequence)cacheString)) {
            JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
            if (ids != null) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id, number, belongorg.id, belongorg.cslscheme", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
                Map _cache = cache;
                query.forEach(q -> _cache.put(q.getString("number"), Pair.onePair((Object)q.getLong("belongorg.id"), (Object)q.getLong("belongorg.cslscheme"))));
                pageCache.put(cache_org, ObjectSerialUtil.toByteSerialized((Object)cache));
            }
        } else {
            cache = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheString);
        }
        return cache;
    }

    @Override
    public void click(EventObject evt) {
        this.setCurrentTabPage();
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        IDataModel model = this.getModel();
        if (key.equals("deloneb")) {
            EntryGrid eg = (EntryGrid)this.getControl(this.entryentity);
            int[] rows = eg.getEntryState().getSelectedRows();
            if (rows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MultipleMemberF74AdjustPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            model.deleteEntryRows(this.entryentity, rows);
        } else if (key.equals("btn_covernew")) {
            this.coverNew();
        } else if (key.equals("btn_createnew")) {
            if (this.canCreateNew()) {
                this.createNew();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u5171\u4eab\u7ec4\u7ec7\u4e0e\u539f\u5173\u8054\u5171\u4eab\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5", (String)"MultipleMemberF74AdjustPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            super.click(evt);
        }
    }

    private void coverNew() {
        this._createNew(true);
    }

    private void _createNew(boolean isCover) {
        this.checkIllegal();
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        Multimap<Long, Long> adjustShareOrgIdsMapping = this.getAdjustShareOrgIdsMapping(ids);
        Map customData = (Map)this.getFormCustomParam("customData");
        Map commonDims = (Map)this.getFormCustomParam("commonDim");
        long modelId = (Long)this.getFormCustomParam("modelId");
        customData.put("yearId", commonDims.get("year"));
        customData.put("periodId", commonDims.get("period"));
        customData.put("scenarioId", commonDims.get("scenario"));
        this.checkCopyEntryByExchange(adjustShareOrgIdsMapping, customData, modelId);
        DynamicObject changeType = null;
        if (RptAdjustEntryCopyHelper.isEntryExchangeRate(this.getModelId()) && (changeType = ChangeTypeMemberEdit.getChangetypeDoc(this.getModelId())) == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u6ca1\u6709\u627e\u5230\u7528\u4e8e\u751f\u6210\u6c47\u7387\u5dee\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7ef4\u5ea6\u7ba1\u7406-\u53d8\u52a8\u7c7b\u578b\u4e2d\u7ef4\u62a4\u3002", (String)"MultipleMemberF74AdjustPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        customData.put("changeType", changeType);
        if (adjustShareOrgIdsMapping.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5171\u4eab\u8c03\u6574\u62b5\u6d88\u5206\u5f55\u3002", (String)"MultipleMemberF74AdjustPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Long> f7Map = new HashMap<String, Long>();
            f7Map.put("model", modelId);
            f7Map.put("scenario", (Long)commonDims.get("scenario"));
            f7Map.put("year", (Long)commonDims.get("year"));
            f7Map.put("period", (Long)commonDims.get("period"));
            AdjustOperationThreadHelper.shareAdjustOperation(f7Map, (boolean)isCover, adjustShareOrgIdsMapping, (Map)customData);
            f7Map.put("adjustIds", (Long)ids);
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    private void checkCopyEntryByExchange(Multimap<Long, Long> adjustShareOrgIdsMapping, Map<String, Object> paramMap, long modelId) {
        DynamicObject defaultRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_adjustconvertset", (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray());
        String rateNumber = defaultRate != null ? defaultRate.getString("defaultrate") : "ClosingRate";
        DynamicObject adjustHeader = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"belongorg.id", (QFilter[])new QFBuilder("id", "in", (Object)adjustShareOrgIdsMapping.keySet()).toArray());
        if (adjustHeader == null) {
            return;
        }
        Long sourceOrgId = adjustHeader.getLong("belongorg.id");
        ArrayList dimensionNums = Lists.newArrayList((Object[])new String[]{"account", "changetype", "mycompany", "internalcompany", "multigaap", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6"});
        DynamicObject sourceCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)sourceOrgId, (Long)((Long)paramMap.get("yearId")), (Long)((Long)paramMap.get("periodId")));
        Collection targetOrgIds = adjustShareOrgIdsMapping.values();
        targetOrgIds.forEach(d -> {
            DynamicObject targetCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)d, (Long)((Long)paramMap.get("yearId")), (Long)((Long)paramMap.get("periodId")));
            if ("EntryExchangeRate".equals(rateNumber) && sourceCurrency.getLong("id") != targetCurrency.getLong("id")) {
                DynamicObject exchange = RptAdjustEntryCopyHelper.queryEntryExChange(modelId);
                dimensionNums.forEach(e -> {
                    if (exchange == null || exchange.get(e) == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5916\u5e01\u62a5\u8868\u6298\u7b97\u5dee\u8bbe\u7f6e\u4e2d\u7684\u7ef4\u5ea6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"MultipleMemberF74AdjustPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                });
            }
        });
    }

    private Multimap<Long, Long> getAdjustShareOrgIdsMapping(JSONArray ids) {
        Multimap<Long, Long> commonSetting = null;
        IPageCache pageCache = this.getPageCache();
        String commonSettingCacheSerial = pageCache.get(cache_commonSetting);
        if (StringUtils.isEmpty((CharSequence)commonSettingCacheSerial)) {
            Map commonDims = (Map)this.getFormCustomParam("commonDim");
            commonDims.put("model", this.getModelId());
            commonSetting = CslSchemeUtils.getCommonSettingOrgs((Collection<Object>)ids, commonDims);
            pageCache.put(cache_commonSetting, ObjectSerialUtil.toByteSerialized(commonSetting));
        } else {
            commonSetting = (Multimap<Long, Long>)ObjectSerialUtil.deSerializedBytes((String)commonSettingCacheSerial);
        }
        DynamicObjectCollection entryEntityDynCollection = this.getModel().getEntryEntity(this.entryentity);
        Multimap<Long, Long> commonSettingTemp = commonSetting;
        if (entryEntityDynCollection.size() > 0) {
            entryEntityDynCollection.forEach(e -> ids.forEach(r -> commonSettingTemp.put((Object)((Long)r), (Object)e.getLong("mid1"))));
        }
        return commonSetting;
    }

    private void createNew() {
        this._createNew(false);
    }

    private boolean canCreateNew() {
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        Multimap<Long, Long> adjustShareOrgIdsMapping = this.getAdjustShareOrgIdsMapping(ids);
        Map<Long, Long> existsCreateOrgs = this.getExistsCreateOrgs(ids);
        if (existsCreateOrgs.size() > 0) {
            HashSet currentOrgs = Sets.newHashSet();
            adjustShareOrgIdsMapping.forEach((k, v) -> {
                if (existsCreateOrgs.containsKey(v)) {
                    existsCreateOrgs.remove(v);
                }
                currentOrgs.add(v);
            });
            if (currentOrgs.size() > 0) {
                DynamicObjectCollection belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"member", (QFilter[])new QFilter("id", "in", existsCreateOrgs.keySet()).toArray());
                if ((belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"cslscheme, member", (QFilter[])new QFilter("member", "in", belongorgs.stream().map(v -> v.getLong("member")).collect(Collectors.toSet())).toArray())) != null && belongorgs.size() > 0) {
                    Set cslSchemes = belongorgs.stream().map(v -> v.getLong("cslscheme")).collect(Collectors.toSet());
                    belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"member", (QFilter[])new QFilter("id", "in", (Object)currentOrgs).toArray());
                    return !QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFilter("member", "in", belongorgs.stream().map(v -> v.getLong("member")).collect(Collectors.toSet())).and(new QFilter("cslscheme", "in", cslSchemes)).toArray());
                }
            }
        }
        return true;
    }

    private void checkIllegal() {
        DynamicObjectCollection entryEntityDynCollection = this.getModel().getEntryEntity(this.entryentity);
        if (entryEntityDynCollection.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u5e76\u79fb\u5165\u5df2\u9009\u533a\u540e\u518d\u64cd\u4f5c", (String)"MultipleMemberF74AdjustPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, Long> getExistsCreateOrgs(JSONArray ids) {
        DynamicObjectCollection queryCollection = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id, shareentry.id, shareentry.shareorg, shareentry.shareadjust, shareentry.seq", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        HashMap result = Maps.newHashMap();
        queryCollection.forEach(r -> result.put(r.getLong("shareentry.shareorg"), r.getLong("shareentry.shareorg")));
        return result;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getControl("membertreeap");
        tree.addTreeNodeCheckListener(eo -> {
            String nodeId = (String)eo.getNodeId();
            if (eo.getChecked().booleanValue() && !this.isAllowCheck(nodeId)) {
                tree.uncheckNode(nodeId);
            }
        });
        this.addClickListeners("btn_covernew", "btn_createnew");
    }

    private boolean isAllowCheck(String nodeId) {
        this.setCurrentTabPage();
        HashSet selectedOrgIds = Sets.newHashSet();
        TreeView tree = (TreeView)this.getControl("membertreeap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds.size() > 0) {
            checkedNodeIds.forEach(c -> selectedOrgIds.add(Long.valueOf(c)));
        }
        Long shareOrgId = Long.valueOf(nodeId);
        selectedOrgIds.add(shareOrgId);
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        Multimap<Long, Long> adjustShareOrgIdsMapping = this.getAdjustShareOrgIdsMapping(ids);
        adjustShareOrgIdsMapping.forEach((k, v) -> selectedOrgIds.add(v));
        HashSet sourceOrgs = Sets.newHashSet();
        Map<String, Pair<Long, Long>> adjustBelongsOrgs = this.getOrCreateAdjust2OrgMappingFromCache();
        adjustBelongsOrgs.forEach((k, v) -> {
            sourceOrgs.add(v.p1);
            selectedOrgIds.add(v.p1);
        });
        DynamicObjectCollection belongorgs = CslSchemeUtils.getAllEntityContainShareDynCollection(selectedOrgIds);
        HashMap id2NameMapping = Maps.newHashMap();
        ArrayListMultimap member2DynMapping = ArrayListMultimap.create();
        long selectNodeMemberId = 0L;
        for (DynamicObject temp : belongorgs) {
            if (StringUtils.equals((CharSequence)temp.getString("id"), (CharSequence)nodeId)) {
                selectNodeMemberId = temp.getLong("member");
                continue;
            }
            member2DynMapping.put((Object)temp.getLong("member"), (Object)temp.getLong("id"));
            id2NameMapping.put(temp.getLong("cslscheme"), temp.getString("name"));
        }
        Map<Long, DynamicObject> id2DynMapping = belongorgs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObject share = id2DynMapping.get(shareOrgId);
        Long shareSchemeId = share.getLong("cslscheme");
        String tip = (String)id2NameMapping.get(shareSchemeId);
        Collection selectNodeContainsShareCollection = member2DynMapping.get((Object)selectNodeMemberId);
        if (selectNodeContainsShareCollection == null) {
            selectNodeContainsShareCollection = Sets.newLinkedHashSet();
        }
        selectNodeContainsShareCollection.add(shareOrgId);
        Map commonDims = (Map)this.getFormCustomParam("commonDim");
        Map batchGetMcStatus = McStatus.batchGetMcStatus(commonDims.get("model"), (Collection)Lists.newArrayList((Iterable)selectNodeContainsShareCollection), commonDims.get("scenario"), commonDims.get("year"), commonDims.get("period"));
        if (batchGetMcStatus.values().stream().anyMatch(status -> status.getFlow().isSubmit() || status.getConvertFlow().isSubmit())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6d41\u7a0b\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u518d\u751f\u6210\u5171\u4eab\u5206\u5f55\u3002", (String)"MultipleMemberF74AdjustPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), id2DynMapping.get(selectNodeContainsShareCollection.iterator().next()).getString("name")));
            return false;
        }
        return true;
    }

    @Override
    protected void cslSchemeCtrl() {
    }
}

