/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.fi.bcm.business.adjust.model.AdjustCopySetParam;
import kd.fi.bcm.business.adjust.operation.AdjustCopyOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.operation.AdjustSkipOrgCopyOperaiton;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ReportAdjustCopyFromPlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_INVANNACC = "btn_invannacc";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setPageId(String.format("%s_%s_%s", "copyFrom", this.getView().getPageId(), RequestContext.get().getUserId()));
        parameter.setFormId("bcm_rptadjust_list");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap");
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(parameter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_INVANNACC, "btn_copy", "btn_skiporgcopy");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        boolean isExcuteLossScheme = StringUtil.equals((String)BTN_INVANNACC, (String)((Control)evt.getSource()).getKey());
        IFormView parent = this.getView().getView(String.format("%s_%s_%s", "copyFrom", this.getView().getPageId(), RequestContext.get().getUserId()));
        BillList billList = (BillList)parent.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Object[] ids = listSelectedRows.getPrimaryKeyValues();
        if (ids == null || ids.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ReportAdjustCopyFromPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long model = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        long tarYear = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_fymembertree");
        long tarPeriod = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_periodmembertree");
        long tarScene = (Long)this.getView().getFormShowParameter().getCustomParam("bcm_scenemember");
        List idList = Arrays.stream(ids).map(LongUtil::toLong).collect(Collectors.toList());
        switch (((Control)evt.getSource()).getKey()) {
            case "btn_invannacc": 
            case "btn_copy": 
            case "btn_skiporgcopy": {
                AdjustCopyOperation acs;
                if ("btn_skiporgcopy".equals(((Control)evt.getSource()).getKey())) {
                    AdjustCopySetParam param = new AdjustCopySetParam();
                    param.setCsl((Long)this.getView().getFormShowParameter().getCustomParam("cslscheme"));
                    param.setTarPeriod(Long.valueOf(tarPeriod));
                    param.setTarScene(Long.valueOf(tarScene));
                    param.setTarYear(Long.valueOf(tarYear));
                    param.setNewInputCurrency(LongUtil.toLong((Object)parent.getModel().getValue("currency_id")));
                    param.setTarCalLog((Long)this.getView().getFormShowParameter().getCustomParam("bcm_templatecatalog"));
                    param.setTarOrg(LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bcm_entitymembertree")));
                    acs = new AdjustSkipOrgCopyOperaiton(Long.valueOf(model), idList, param);
                } else {
                    acs = new AdjustCopyOperation(Long.valueOf(model), Long.valueOf(tarScene), Long.valueOf(tarYear), Long.valueOf(tarPeriod), idList, isExcuteLossScheme);
                }
                acs.asynexcute();
                HashMap<String, Long> f7Map = new HashMap<String, Long>();
                f7Map.put("model", model);
                f7Map.put("scenario", tarScene);
                f7Map.put("year", tarYear);
                f7Map.put("period", tarPeriod);
                AdjustOperationThreadHelper.openAdjustOperLog((IFormView)this.getView(), (AdjustOperTypeEnum)AdjustOperTypeEnum.COPYOPERATION, f7Map, null);
            }
        }
    }
}

