/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.report.AbstractAdjustBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;

public class ReportAdjustDiffQueryPlugin
extends AbstractAdjustBaseListPlugin
implements MainPage {
    public static final String FILTER_CONDITION = "query_condition";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        if (grid != null) {
            grid.addHyperClickListener(new HyperLinkClickListener(){

                public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
                    List hyId;
                    String adjustNumber = ReportAdjustDiffQueryPlugin.this.getModel().getValue(hyperLinkClickEvent.getFieldName(), hyperLinkClickEvent.getRowIndex()).toString();
                    QFilter qf = new QFilter("number", "=", (Object)adjustNumber).and("model", "=", (Object)ReportAdjustDiffQueryPlugin.this.getModelId());
                    if ("adjustnumber".equals(hyperLinkClickEvent.getFieldName())) {
                        qf.and("year", "=", (Object)((DynamicObject)ReportAdjustDiffQueryPlugin.this.getModel().getValue("year", hyperLinkClickEvent.getRowIndex())).getLong("id")).and("period", "=", (Object)((DynamicObject)ReportAdjustDiffQueryPlugin.this.getModel().getValue("period", hyperLinkClickEvent.getRowIndex())).getLong("id"));
                    }
                    if ((hyId = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])qf.toArray(), null, (int)1)).isEmpty()) {
                        ReportAdjustDiffQueryPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ReportAdjustDiffQueryPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    } else {
                        ReportAdjustDiffQueryPlugin.this.openAdjustPage((Long)hyId.get(0));
                    }
                }
            });
        }
    }

    protected void openAdjustPage(Object pkId) {
        AdjustModel adjust;
        DynamicObject adjustDy = BusinessDataServiceHelper.loadSingle((String)"bcm_rptadjust", (String)"entity,multiplecurrency,process", (QFilter[])new QFilter("id", "=", pkId).toArray());
        String sProcess = adjustDy.getString("process");
        String opentype = this.getOpenTypeByProcess(sProcess);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_adjustoffset_entry");
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        param.setCustomParam("opentype", (Object)opentype);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("OpenSource", (Object)"offsetSearchHyperLink");
        param.setCustomParam("selectedNodeId", (Object)adjustDy.getString("entity.id"));
        param.setCustomParam("multiplecurrency", (Object)adjustDy.getString("multiplecurrency"));
        param.setCustomParam("process", (Object)sProcess);
        AdjustModel am = this.getAdjustModel(pkId);
        if (am == null) {
            adjust = this.buildDefaultAdjustModel();
        } else {
            if (am.getCheckrecordId() != 0L) {
                this.setCheckrecordInfo(am);
            }
            adjust = am;
        }
        int maxgroup = AdjustModelUtil.getMaxGroupIndex(adjust.getId());
        param.setCustomParam("maxgroup", (Object)maxgroup);
        param.setCustomParam("adjust_model", (Object)ObjectSerialUtil.toByteSerialized((Object)adjust));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPage"));
        this.getView().showForm(param);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.resetDiffEntry(null);
    }

    private void resetDiffEntry(QFBuilder qfBuilder) {
        ((ComboEdit)this.getControl("adjustbussnesstype")).setComboItems(AdjustBusinessTypeUtil.getConfigCM005ComboEditList((long)this.getModelId(), (boolean)false, (boolean)false));
        if (qfBuilder != null) {
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm_adjustdatadiff", (String)"bcm_rptadjustdata", (String)"adjust,adjust.number as number,adjust.journaltype as journaltype,adjust.belongorg as belongorg,year,period,adjust.bussnesstype as bussnesstype,adjust.extendfrom as extendfrom,adjust.sourcetype as sourcetype,adjust.name as name,currency,adjust.status as status,debit,credit", (QFilter[])qfBuilder.toArray(), null).groupBy(new String[]{"adjust", "currency", "year", "period", "number", "name", "journaltype", "belongorg", "bussnesstype", "extendfrom", "sourcetype", "status"}).sum("credit").sum("debit").finish();){
                this.refreshAdjustDiffEntry(rows);
            }
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void refreshAdjustDiffEntry(DataSet result) {
        this.getModel().deleteEntryData("entryentity");
        if (!result.isEmpty()) {
            ArrayList data = new ArrayList(16);
            result.forEachRemaining(data::add);
            this.getModel().batchCreateNewEntryRow("entryentity", data.size());
            for (int row = 0; row < data.size(); ++row) {
                Row e = (Row)data.get(row);
                this.getModel().setValue("adjustnumber", e.get("number"), row);
                this.getModel().setValue("adjustjournaltype", e.get("journaltype"), row);
                this.getModel().setValue("adjustbelongorg", e.get("belongorg"), row);
                this.getModel().setValue("year", e.get("year"), row);
                this.getModel().setValue("period", e.get("period"), row);
                this.getModel().setValue("adjustbussnesstype", e.get("bussnesstype"), row);
                this.getModel().setValue("extend", e.get("extendfrom"), row);
                this.getModel().setValue("adjustsourcetype", e.get("sourcetype"), row);
                this.getModel().setValue("adjustname", e.get("name"), row);
                this.getModel().setValue("currency", e.get("currency"), row);
                this.getModel().setValue("debit", e.get("debit"), row);
                this.getModel().setValue("adjuststatus", e.get("status"), row);
                this.getModel().setValue("crebit", e.get("credit"), row);
                this.getModel().setValue("diff", (Object)e.getBigDecimal("debit").subtract(e.getBigDecimal("credit")), row);
            }
        }
        this.getModel().clearNoDataRow();
        this.getView().updateView();
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("query".equals(com.getOperation())) {
            QFBuilder qfBuilder = (QFBuilder)com.getParam().get(0);
            this.resetDiffEntry(qfBuilder);
        }
    }
}

