/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AdjustOperTaskSchedulePlan;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.cslscheme.RptAdjustEntryCopyHelper;
import kd.fi.bcm.formplugin.dimensionnew.ChangeTypeMemberEdit;
import org.apache.commons.collections4.CollectionUtils;

public class ReportAdjustShareFromPlugin
extends AbstractBaseFormPlugin {
    private static final String CACHE_COMMON_SETTING = "cache_commonSetting";
    private static final String SHARE_FROM = "shareFrom";
    private static final String PERIOD = "period";
    private static final String PERIOD_ID = "periodId";
    private static final String YEAR_ID = "yearId";
    private static final String SCENARIO = "scenario";
    private static final String NUMBER = "number";
    private static final String MEMBER = "member";
    private static final String CSL_SCHEME = "cslscheme";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setPageId(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
        parameter.setFormId("bcm_rptadjust_list");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap");
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(parameter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_covernew", "btn_createnew", "btn_splitnew");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String nodeid = (String)this.getFormCustomParam("selectorgid");
        switch (((Control)evt.getSource()).getKey()) {
            case "btn_covernew": {
                if (!this.isSelectRows() || !this.isAllowCheck(nodeid, true)) break;
                this.coverNew();
                break;
            }
            case "btn_createnew": {
                if (!this.isSelectRows() || !this.isAllowCheck(nodeid, true)) break;
                this.createNew();
                break;
            }
            case "btn_splitnew": {
                if (!this.isSelectRows() || !this.isAllowCheck(nodeid, false)) break;
                Map<String, Long> commonDims = this.getCommonDims();
                IFormView parent = this.getView().getView(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
                BillList billList = (BillList)parent.getControl("billlistap");
                List pkIds = Arrays.stream(billList.getSelectedRows().getPrimaryKeyValues()).map(p -> LongUtil.toLong((Object)p)).collect(Collectors.toList());
                AdjustOperationContext _ctx = new AdjustOperationContext(this.getModelId(), commonDims.get(SCENARIO).longValue(), commonDims.get("year").longValue(), commonDims.get(PERIOD).longValue());
                AdjustOperTaskSchedulePlan.dispatchOperTaskUnSync((AdjustOperationContext)_ctx, (AdjustOperTypeEnum)AdjustOperTypeEnum.SHAREOPERATION, pkIds, (Map)MapInitHelper.ofMap((Object)"mergeorg", (Object)LongUtil.toLong((Object)nodeid)));
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
                break;
            }
        }
    }

    private boolean isSelectRows() {
        IFormView parent = this.getView().getView(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
        BillList billList = (BillList)parent.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u8c03\u6574\u62b5\u9500\u5206\u5f55", (String)"ReportAdjustShareFromPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        DynamicObject period = (DynamicObject)parent.getModel().getValue(PERIOD);
        DynamicObject year = (DynamicObject)parent.getModel().getValue("year");
        DynamicObject scenario = (DynamicObject)parent.getModel().getValue(SCENARIO);
        if (scenario == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f", (String)"ReportAdjustShareFromPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (year == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74", (String)"ReportAdjustShareFromPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4", (String)"ReportAdjustShareFromPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Object> getSelectRowsIds() {
        IFormView parent = this.getView().getView(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
        BillList billList = (BillList)parent.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Object[] ids = listSelectedRows.getPrimaryKeyValues();
        return Arrays.asList(ids);
    }

    private Map<String, Object> getCustomData() {
        IFormView parent = this.getView().getView(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
        HashMap customData = Maps.newHashMap();
        DynamicObject period = (DynamicObject)parent.getModel().getValue(PERIOD);
        DynamicObject year = (DynamicObject)parent.getModel().getValue("year");
        DynamicObject scenario = (DynamicObject)parent.getModel().getValue(SCENARIO);
        long periodId = period.getLong("id");
        customData.put(PERIOD_ID, periodId);
        customData.put("yearNum", year.getString(NUMBER));
        customData.put("scenarioNum", scenario.getString(NUMBER));
        customData.put("periodNum", period.getString(NUMBER));
        return customData;
    }

    private Map<String, Long> getCommonDims() {
        IFormView parent = this.getView().getView(String.format("%s_%s", SHARE_FROM, RequestContext.get().getUserId()));
        HashMap commonDim = Maps.newHashMap();
        DynamicObject period = (DynamicObject)parent.getModel().getValue(PERIOD);
        DynamicObject year = (DynamicObject)parent.getModel().getValue("year");
        DynamicObject scenario = (DynamicObject)parent.getModel().getValue(SCENARIO);
        commonDim.put("model", Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        commonDim.put("year", year.getLong("id"));
        commonDim.put(SCENARIO, scenario.getLong("id"));
        commonDim.put(PERIOD, period.getLong("id"));
        return commonDim;
    }

    private void coverNew() {
        this.createNew(true);
    }

    private void createNew(boolean isCover) {
        IDNumberTreeNode tree;
        Map<String, Object> customData = this.getCustomData();
        Map<String, Long> commonDims = this.getCommonDims();
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        customData.put(YEAR_ID, commonDims.get("year"));
        customData.put(PERIOD_ID, commonDims.get(PERIOD));
        customData.put("scenarioId", commonDims.get(SCENARIO));
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM012") && !PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)(tree = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)Long.parseLong(this.getFormCustomParam("selectorgid").toString()))).getNumber(), (long)commonDims.get(SCENARIO), (long)commonDims.get("year"), (long)commonDims.get(PERIOD), (String)"entrystatus")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u671f\u95f4\u662f\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportAdjustShareFromPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        List<Object> ids = this.getSelectRowsIds();
        Multimap<Long, Long> adjustShareOrgIdsMapping = this.getAdjustShareOrgIdsMapping(ids);
        this.checkCopyEntryByExchange(adjustShareOrgIdsMapping, customData, modelId);
        DynamicObject changeType = null;
        if (RptAdjustEntryCopyHelper.isEntryExchangeRate(modelId) && (changeType = ChangeTypeMemberEdit.getChangetypeDoc(modelId)) == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u6ca1\u6709\u627e\u5230\u7528\u4e8e\u751f\u6210\u6c47\u7387\u5dee\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7ef4\u5ea6\u7ba1\u7406-\u53d8\u52a8\u7c7b\u578b\u4e2d\u7ef4\u62a4\u3002", (String)"ReportAdjustShareFromPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), new Object[0]));
            return;
        }
        customData.put("changeType", changeType);
        if (adjustShareOrgIdsMapping.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5171\u4eab\u8c03\u6574\u62b5\u6d88\u5206\u5f55\u3002", (String)"ReportAdjustShareFromPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            HashMap<String, Long> f7Map = new HashMap<String, Long>(16);
            f7Map.put("model", modelId);
            f7Map.put(SCENARIO, commonDims.get(SCENARIO));
            f7Map.put("year", commonDims.get("year"));
            f7Map.put(PERIOD, commonDims.get(PERIOD));
            customData.put("selectorgid", this.getFormCustomParam("selectorgid"));
            AdjustOperationThreadHelper.shareAdjustOperation(f7Map, (boolean)isCover, adjustShareOrgIdsMapping, customData);
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    private void createNew() {
        this.createNew(false);
    }

    private Multimap<Long, Long> getAdjustShareOrgIdsMapping(List<Object> ids) {
        Multimap<Long, Long> commonSetting = null;
        IPageCache pageCache = this.getPageCache();
        String commonSettingCacheSerial = pageCache.get(CACHE_COMMON_SETTING);
        if (StringUtils.isEmpty((CharSequence)commonSettingCacheSerial)) {
            commonSetting = CslSchemeUtils.getCommonSettingOrgs(ids, this.getCommonDims());
            pageCache.put(CACHE_COMMON_SETTING, ObjectSerialUtil.toByteSerialized(commonSetting));
        } else {
            commonSetting = (Multimap<Long, Long>)ObjectSerialUtil.deSerializedBytes((String)commonSettingCacheSerial);
        }
        Multimap<Long, Long> commonSettingTemp = commonSetting;
        ids.forEach(r -> commonSettingTemp.put((Object)((Long)r), (Object)Long.valueOf((String)this.getFormCustomParam("selectorgid"))));
        return commonSetting;
    }

    private void checkCopyEntryByExchange(Multimap<Long, Long> adjustShareOrgIdsMapping, Map<String, Object> paramMap, long modelId) {
        String rateNumber = AdjustmentServiceHelper.getDefaultCvtRate((long)modelId);
        Set allAdjustIds = adjustShareOrgIdsMapping.keySet();
        DynamicObject[] adjustHeader = BusinessDataServiceHelper.load((Object[])allAdjustIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_rptadjust"));
        Long sourceOrgId = (Long)adjustHeader[0].get("belongorg_id");
        ArrayList dimensionNums = Lists.newArrayList((Object[])new String[]{"account", "changetype", "mycompany", "internalcompany", "multigaap", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6"});
        DynamicObject sourceCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)sourceOrgId, (Long)((Long)paramMap.get(YEAR_ID)), (Long)((Long)paramMap.get(PERIOD_ID)));
        if (sourceCurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ec4\u7ec7\u9ed8\u8ba4\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReportAdjustShareFromPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        Collection targetOrgIds = adjustShareOrgIdsMapping.values();
        targetOrgIds.stream().forEach(d -> {
            DynamicObject targetCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)d, (Long)((Long)paramMap.get(YEAR_ID)), (Long)((Long)paramMap.get(PERIOD_ID)));
            if (targetCurrency == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7ec4\u7ec7\u9ed8\u8ba4\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReportAdjustShareFromPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        });
    }

    private boolean isAllowCheck(String nodeId, boolean isOldShare) {
        Map batchGetMcStatus;
        Map<String, Long> commonDims = this.getCommonDims();
        long modelId = commonDims.get("model");
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)commonDims.get(SCENARIO));
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)commonDims.get("year"));
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)commonDims.get(PERIOD));
        if (LockScopeServiceHelper.isExistArchiving((long)modelId, (String)sceneNode.getNumber(), (String)fyNode.getNumber(), (String)periodNode.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u56e0\u4e3a\u5f53\u671f\u671f\u95f4\u5206\u9636\u6bb5\u65b9\u6848\u5df2\u5f52\u6863\u3002", (String)"ReportAdjustShareFromPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        HashSet selectedOrgIds = Sets.newHashSet();
        Long shareOrgId = Long.valueOf(nodeId);
        selectedOrgIds.add(shareOrgId);
        List<Object> ids = this.getSelectRowsIds();
        Multimap<Long, Long> adjustShareOrgIdsMapping = this.getAdjustShareOrgIdsMapping(ids);
        adjustShareOrgIdsMapping.forEach((k, v) -> selectedOrgIds.add(v));
        HashSet sourceOrgs = Sets.newHashSet();
        Map<String, Pair<Long, Long>> adjustBelongsOrgs = this.getOrCreateAdjust2OrgMappingFromCache();
        adjustBelongsOrgs.forEach((k, v) -> {
            sourceOrgs.add(v.p1);
            selectedOrgIds.add(v.p1);
        });
        DynamicObjectCollection belongorgs = CslSchemeUtils.getAllEntityContainShareDynCollection(selectedOrgIds);
        ArrayListMultimap member2DynMapping = ArrayListMultimap.create();
        long selectNodeMemberId = 0L;
        for (DynamicObject temp : belongorgs) {
            if (StringUtils.equals((CharSequence)temp.getString("id"), (CharSequence)nodeId)) {
                selectNodeMemberId = temp.getLong(MEMBER);
                continue;
            }
            member2DynMapping.put((Object)temp.getLong(MEMBER), (Object)temp.getLong("id"));
        }
        Map<Long, DynamicObject> id2DynMapping = belongorgs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObject share = id2DynMapping.get(shareOrgId);
        Collection selectNodeContainsShareCollection = member2DynMapping.get((Object)selectNodeMemberId);
        if (selectNodeContainsShareCollection == null) {
            selectNodeContainsShareCollection = Sets.newLinkedHashSet();
        }
        selectNodeContainsShareCollection.add(shareOrgId);
        if (isOldShare && (batchGetMcStatus = McStatus.batchGetMcStatus((Object)commonDims.get("model"), (Collection)Lists.newArrayList((Iterable)selectNodeContainsShareCollection), (Object)commonDims.get(SCENARIO), (Object)commonDims.get("year"), (Object)commonDims.get(PERIOD))).values().stream().anyMatch(status -> status.getFlow().isSubmit() || status.getConvertFlow().isSubmit())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u518d\u751f\u6210\u5171\u4eab\u5206\u5f55\u3002", (String)"ReportAdjustShareFromPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), id2DynMapping.get(selectNodeContainsShareCollection.iterator().next()).getString("name")));
            return false;
        }
        for (Long sourceId : sourceOrgs) {
            DynamicObject source = id2DynMapping.get(sourceId);
            String msg = CslSchemeUtils.validateAdjustShareSetting(source, share, share.getLong("model"), isOldShare);
            if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    private Map<String, Pair<Long, Long>> getOrCreateAdjust2OrgMappingFromCache() {
        HashMap cache = Maps.newHashMap();
        List<Object> ids = this.getSelectRowsIds();
        if (ids != null) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id, number, belongorg.id, belongorg.cslscheme", (QFilter[])new QFilter("id", "in", ids).toArray());
            HashMap pairCache = cache;
            query.forEach(q -> pairCache.put(q.getString(NUMBER), Pair.onePair((Object)q.getLong("belongorg.id"), (Object)q.getLong("belongorg.cslscheme"))));
        }
        return cache;
    }
}

