/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.integration.ExportFileRuleEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlanHelper;
import kd.fi.bcm.formplugin.adjust.export.FileNameStyle;

public class AdjustBatchExportFileRulePlugin
extends AbstractBaseFormPlugin {
    private Map<Character, List<FileNameStyle>> rihtSelects = Maps.newHashMap();
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String FIX_VALUE = "fixvalue";
    private static final String SELECTED_OBJ = "selectedobj";
    private static final String TO_SELECT_ENTRY_ENTITY = "toselectentryentity";
    private static final String SELECT_ENTRY_ENTITY = "selectentryentity";
    private static final String JOINER_STR = "joiner";
    private static final String TOBE_SELECT_OBJ = "tobeselectobj";
    private static final String TOBE_SELECT_NUMBER = "tobeselectnumber";
    private static final String SELECTED_NUMBER = "selectednumber";
    private static final String IS_SELECT = "isselect";

    private void initMap() {
        this.rihtSelects.putAll(AdjustBatchExportPlanHelper.getFileNameStyleMap());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btngo", "btnback", "bar_confirm");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initMap();
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(TO_SELECT_ENTRY_ENTITY);
        this.getModel().deleteEntryData(SELECT_ENTRY_ENTITY);
        String filestyleStr = (String)this.getView().getFormShowParameter().getCustomParam("filestyle");
        char filestyle = '1';
        if (StringUtils.isNotEmpty((String)filestyleStr)) {
            filestyle = filestyleStr.charAt(0);
        }
        boolean isSheetClick = true;
        if (this.getView().getFormShowParameter().getCustomParam("issheetclick") != null) {
            isSheetClick = (Boolean)this.getView().getFormShowParameter().getCustomParam("issheetclick");
        }
        List list = this.getView().getFormShowParameter().getCustomParam("defaultruleselect") != null ? (List)this.deSerializedBytes((String)this.getView().getFormShowParameter().getCustomParam("defaultruleselect")) : Lists.newArrayList();
        int fsize = 0;
        int fssize = 0;
        this.getView().setEnable(Boolean.FALSE, new String[]{FIX_VALUE});
        this.getModel().beginInit();
        if (!isSheetClick) {
            char connerChar = Joiner.getIndex((String)this.getView().getFormShowParameter().getCustomParam("connectstr"));
            if (connerChar == '0') {
                this.getModel().setValue(JOINER_STR, (Object)Character.valueOf(Joiner.getIndex("")));
            } else {
                this.getModel().setValue(JOINER_STR, (Object)Character.valueOf(connerChar));
            }
        } else {
            this.getModel().setValue(JOINER_STR, (Object)Character.valueOf(Joiner.getIndex((String)this.getView().getFormShowParameter().getCustomParam("connectstr"))));
        }
        for (Map.Entry<Character, List<FileNameStyle>> entry : this.rihtSelects.entrySet()) {
            int i;
            int j;
            int k;
            List<FileNameStyle> ls;
            if (isSheetClick) {
                ls = entry.getValue();
                ls = ls.stream().filter(f -> !ExportFileRuleEnum.SCHEMENAME.getCode().equals(f.getNumber())).collect(Collectors.toList());
                this.getModel().batchCreateNewEntryRow(TO_SELECT_ENTRY_ENTITY, ls.size());
                if (fsize == 0 && fssize == 0) {
                    this.getModel().batchCreateNewEntryRow(SELECT_ENTRY_ENTITY, list.size());
                }
                k = 0;
                j = 0;
                for (i = 0; i < ls.size(); ++i) {
                    if (!list.contains(ls.get(i).getNumber())) {
                        this.getModel().setValue(TOBE_SELECT_OBJ, (Object)ls.get(i).getName(), fsize + j);
                        this.getModel().setValue(TOBE_SELECT_NUMBER, (Object)ls.get(i).getNumber(), fsize + j);
                        ++j;
                        continue;
                    }
                    this.getModel().setValue(SELECTED_OBJ, (Object)ls.get(i).getName(), list.indexOf(ls.get(i).getNumber()));
                    this.getModel().setValue(SELECTED_NUMBER, (Object)ls.get(i).getNumber(), list.indexOf(ls.get(i).getNumber()));
                    this.getModel().deleteEntryRow(TO_SELECT_ENTRY_ENTITY, fsize + j);
                    ++k;
                }
                fssize += k;
                fsize = this.getModel().getEntryEntity(TO_SELECT_ENTRY_ENTITY).size();
                continue;
            }
            if (isSheetClick || entry.getKey().equals(Character.valueOf(filestyle))) continue;
            ls = entry.getValue();
            this.getModel().batchCreateNewEntryRow(TO_SELECT_ENTRY_ENTITY, ls.size());
            if (fsize == 0 && fssize == 0 && this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY).isEmpty()) {
                this.getModel().batchCreateNewEntryRow(SELECT_ENTRY_ENTITY, list.size());
            }
            k = 0;
            j = 0;
            for (i = 0; i < ls.size(); ++i) {
                if (!list.contains(ls.get(i).getNumber())) {
                    this.getModel().setValue(TOBE_SELECT_OBJ, (Object)ls.get(i).getName(), fsize + j);
                    this.getModel().setValue(TOBE_SELECT_NUMBER, (Object)ls.get(i).getNumber(), fsize + j);
                    ++j;
                    continue;
                }
                this.getModel().setValue(SELECTED_OBJ, (Object)ls.get(i).getName(), list.indexOf(ls.get(i).getNumber()));
                this.getModel().setValue(SELECTED_NUMBER, (Object)ls.get(i).getNumber(), list.indexOf(ls.get(i).getNumber()));
                this.getModel().deleteEntryRow(TO_SELECT_ENTRY_ENTITY, fsize + j);
                ++k;
            }
            fssize += k;
            fsize = this.getModel().getEntryEntity(TO_SELECT_ENTRY_ENTITY).size();
        }
        if (list.contains("txt")) {
            this.getModel().setValue(SELECTED_OBJ, (Object)this.rihtSelects.get(Character.valueOf('3')).get(0).getName(), list.indexOf("txt"));
            this.getModel().setValue(SELECTED_NUMBER, (Object)this.rihtSelects.get(Character.valueOf('3')).get(0).getNumber(), list.indexOf("txt"));
            this.getModel().setValue(FIX_VALUE, this.getView().getFormShowParameter().getCustomParam("txt"));
            this.getView().setEnable(Boolean.TRUE, new String[]{FIX_VALUE});
        }
        this.getModel().endInit();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                EntryGrid toEntryGrid = (EntryGrid)this.getView().getControl(TO_SELECT_ENTRY_ENTITY);
                int selectSize = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY).size();
                int[] selectRows = toEntryGrid.getSelectRows();
                int r = 0;
                this.getModel().beginInit();
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject toSelectEntryobj = this.getModel().getEntryRowEntity(TO_SELECT_ENTRY_ENTITY, selectRows[i]);
                    if (toSelectEntryobj.getBoolean(IS_SELECT)) continue;
                    this.getModel().createNewEntryRow(SELECT_ENTRY_ENTITY);
                    this.getModel().setValue(SELECTED_OBJ, toSelectEntryobj.get(TOBE_SELECT_OBJ), selectSize + r);
                    this.getModel().setValue(SELECTED_NUMBER, toSelectEntryobj.get(TOBE_SELECT_NUMBER), selectSize + r);
                    this.getModel().setValue(IS_SELECT, (Object)Boolean.TRUE, selectRows[i]);
                    this.getModel().deleteEntryRow(TO_SELECT_ENTRY_ENTITY, selectRows[i]);
                    ++r;
                }
                this.getModel().endInit();
                this.getModel().updateCache();
                this.setFixValueEnable(TO_SELECT_ENTRY_ENTITY);
                this.setFixValueEnable(SELECT_ENTRY_ENTITY);
                this.getView().updateView(TO_SELECT_ENTRY_ENTITY);
                this.getView().updateView(SELECT_ENTRY_ENTITY);
                break;
            }
            case "btnback": {
                EntryGrid sEntryGrid = (EntryGrid)this.getView().getControl(SELECT_ENTRY_ENTITY);
                DynamicObjectCollection toSDoc = this.getModel().getEntryEntity(TO_SELECT_ENTRY_ENTITY);
                DynamicObjectCollection sDoc = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY);
                int size = toSDoc.size();
                int[] selects = sEntryGrid.getSelectRows();
                this.getModel().beginInit();
                for (int i = 0; i < selects.length; ++i) {
                    this.getModel().createNewEntryRow(TO_SELECT_ENTRY_ENTITY);
                    this.getModel().setValue(TOBE_SELECT_OBJ, ((DynamicObject)sDoc.get(selects[i])).get(SELECTED_OBJ), size + i);
                    this.getModel().setValue(TOBE_SELECT_NUMBER, ((DynamicObject)sDoc.get(selects[i])).get(SELECTED_NUMBER), size + i);
                    this.getModel().setValue(IS_SELECT, (Object)Boolean.FALSE, size + i);
                }
                this.getModel().deleteEntryRows(SELECT_ENTRY_ENTITY, selects);
                this.getModel().endInit();
                this.getModel().updateCache();
                this.setFixValueEnable(TO_SELECT_ENTRY_ENTITY);
                this.setFixValueEnable(SELECT_ENTRY_ENTITY);
                this.getView().updateView(TO_SELECT_ENTRY_ENTITY);
                this.getView().updateView(SELECT_ENTRY_ENTITY);
                break;
            }
            case "bar_confirm": {
                if (!this.checkData()) {
                    return;
                }
                DynamicObjectCollection doc = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY);
                ArrayList ruleNumbers = Lists.newArrayListWithExpectedSize((int)doc.size());
                ArrayList ruleNames = Lists.newArrayListWithExpectedSize((int)doc.size());
                HashMap returnData = Maps.newHashMap();
                for (int i = 0; i < doc.size(); ++i) {
                    String selectednumber = ((DynamicObject)doc.get(i)).getString(SELECTED_NUMBER);
                    ruleNumbers.add(selectednumber);
                    if ("txt".equals(selectednumber)) {
                        String fixvalue = (String)this.getModel().getValue(FIX_VALUE);
                        ruleNames.add(fixvalue);
                        returnData.put("txt", fixvalue);
                        continue;
                    }
                    ruleNames.add(((DynamicObject)doc.get(i)).getString(SELECTED_OBJ));
                }
                char joinerIndex = ((String)this.getModel().getValue(JOINER_STR)).charAt(0);
                String joiner = Joiner.getJoiner(joinerIndex);
                returnData.put(JOINER_STR, joiner);
                returnData.put("ruleNumbers", ruleNumbers);
                returnData.put("ruleNames", ruleNames);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkData() {
        boolean result;
        block38: {
            if (this.rihtSelects.isEmpty()) {
                this.initMap();
            }
            result = true;
            IDataModel model = this.getModel();
            DynamicObjectCollection selectEntryEntity = model.getEntryEntity(SELECT_ENTRY_ENTITY);
            int size = selectEntryEntity.size();
            String filestyleStr = (String)this.getView().getFormShowParameter().getCustomParam("filestyle");
            char filestyle = '1';
            if (StringUtils.isNotEmpty((String)filestyleStr)) {
                filestyle = filestyleStr.charAt(0);
            }
            boolean isSheetClick = true;
            if (this.getView().getFormShowParameter().getCustomParam("issheetclick") != null) {
                isSheetClick = (Boolean)this.getView().getFormShowParameter().getCustomParam("issheetclick");
            }
            if (isSheetClick) {
                if (size == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"MultiExportFileRulePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    result = false;
                } else if (size > 3) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u4e0d\u53ef\u8d85\u8fc73\u4e2a\u3002", (String)"MultiExportFileRulePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    result = false;
                } else {
                    ArrayList<String> selectNumbers = new ArrayList<String>(10);
                    for (int i = 0; i < selectEntryEntity.size(); ++i) {
                        selectNumbers.add(((DynamicObject)selectEntryEntity.get(i)).getString(SELECTED_NUMBER));
                        if (!"txt".equals(((DynamicObject)selectEntryEntity.get(i)).getString(SELECTED_NUMBER)) || model.getValue(FIX_VALUE) != null && !"".equals(model.getValue(FIX_VALUE))) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u4e0d\u53ef\u4e3a\u7a7a", (String)"MultiExportFileRulePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        return false;
                    }
                    for (Map.Entry<Character, List<FileNameStyle>> entry : this.rihtSelects.entrySet()) {
                        if (!entry.getKey().equals(Character.valueOf(filestyle))) continue;
                        List<FileNameStyle> ls = entry.getValue();
                        ArrayList<String> compareNumbers = new ArrayList<String>(10);
                        ArrayList<String> yearNumbers = new ArrayList<String>(10);
                        ArrayList<String> peroidNumbers = new ArrayList<String>(10);
                        for (FileNameStyle fileNameStyle : ls) {
                            if (filestyle == '2') {
                                if ("yearnumber".equals(fileNameStyle.getNumber()) || "yearname".equals(fileNameStyle.getNumber())) {
                                    yearNumbers.add(fileNameStyle.getNumber());
                                    continue;
                                }
                                peroidNumbers.add(fileNameStyle.getNumber());
                                continue;
                            }
                            compareNumbers.add(fileNameStyle.getNumber());
                        }
                        List intersection = selectNumbers.stream().filter(item -> compareNumbers.contains(item)).collect(Collectors.toList());
                        int interSize = intersection.size();
                        switch (filestyle) {
                            case '1': {
                                if (interSize == 0) {
                                    result = false;
                                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u81f3\u5c11\u8981\u6709\u7ec4\u7ec7\u7c7b\u4e2d\u7684\u4e00\u4e2a\u3002", (String)"MultiExportFileRulePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                                    break;
                                }
                                break block38;
                            }
                            case '2': {
                                List yearsection = selectNumbers.stream().filter(item -> yearNumbers.contains(item)).collect(Collectors.toList());
                                int yearSize = yearsection.size();
                                List periodsection = selectNumbers.stream().filter(item -> peroidNumbers.contains(item)).collect(Collectors.toList());
                                int peroidSize = periodsection.size();
                                if (yearSize == 0 || peroidSize == 0) {
                                    result = false;
                                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u81f3\u5c11\u8981\u6709\u8d22\u5e74\u3001\u671f\u95f4\u7c7b\u5404\u4e00\u4e2a\u3002", (String)"MultiExportFileRulePlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                                    break;
                                }
                                break block38;
                            }
                        }
                        break;
                    }
                }
            } else if (size == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"MultiExportFileRulePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                result = false;
            } else if (size > 10) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u4e0d\u53ef\u8d85\u8fc710\u4e2a\u3002", (String)"MultiExportFileRulePlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                result = false;
            } else {
                ArrayList<String> selectNumbers = new ArrayList<String>(10);
                for (int i = 0; i < selectEntryEntity.size(); ++i) {
                    selectNumbers.add(((DynamicObject)selectEntryEntity.get(i)).getString(SELECTED_NUMBER));
                    if (!"txt".equals(((DynamicObject)selectEntryEntity.get(i)).getString(SELECTED_NUMBER)) || model.getValue(FIX_VALUE) != null && !"".equals(model.getValue(FIX_VALUE))) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u4e0d\u53ef\u4e3a\u7a7a", (String)"MultiExportFileRulePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
                ArrayList<String> yearNumbers = new ArrayList<String>(10);
                ArrayList<String> periodNumbers = new ArrayList<String>(10);
                ArrayList<String> orgNumbers = new ArrayList<String>(10);
                block16: for (Map.Entry<Character, List<FileNameStyle>> entry : this.rihtSelects.entrySet()) {
                    List<FileNameStyle> ls = entry.getValue();
                    switch (entry.getKey().charValue()) {
                        case '1': {
                            for (FileNameStyle fileNameStyle : ls) {
                                orgNumbers.add(fileNameStyle.getNumber());
                            }
                            continue block16;
                        }
                        case '2': {
                            for (FileNameStyle fileNameStyle : ls) {
                                if ("yearnumber".equals(fileNameStyle.getNumber()) || "yearname".equals(fileNameStyle.getNumber())) {
                                    yearNumbers.add(fileNameStyle.getNumber());
                                    continue;
                                }
                                periodNumbers.add(fileNameStyle.getNumber());
                            }
                            continue block16;
                        }
                    }
                }
                List orgsection = selectNumbers.stream().filter(item -> orgNumbers.contains(item)).collect(Collectors.toList());
                int orgSize = orgsection.size();
                List yearsection = selectNumbers.stream().filter(item -> yearNumbers.contains(item)).collect(Collectors.toList());
                int yearSize = yearsection.size();
                List periodsection = selectNumbers.stream().filter(item -> periodNumbers.contains(item)).collect(Collectors.toList());
                int periodSize = periodsection.size();
                switch (filestyle) {
                    case '1': {
                        if (periodSize == 0 || yearSize == 0) {
                            result = false;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u81f3\u5c11\u8981\u6709\u8d22\u5e74\u3001\u671f\u95f4\u5404\u4e00\u4e2a\u3002", (String)"AdjustBatchExportFileRulePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        }
                        break;
                    }
                    case '2': {
                        if (orgSize != 0) break;
                        result = false;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9009\u9879\u81f3\u5c11\u8981\u6709\u7ec4\u7ec7\u7c7b\u4e2d\u7684\u4e00\u4e2a\u3002", (String)"MultiExportFileRulePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void setFixValueEnable(String key) {
        boolean hasTxt;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(SELECT_ENTRY_ENTITY);
        if (SELECT_ENTRY_ENTITY.equals(key)) {
            if (doc != null && !doc.isEmpty()) {
                hasTxt = doc.stream().anyMatch(d -> "txt".equals(d.getString(SELECTED_NUMBER)));
                this.getView().setEnable(Boolean.valueOf(hasTxt), new String[]{FIX_VALUE});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FIX_VALUE});
            }
        }
        if (TO_SELECT_ENTRY_ENTITY.equals(key)) {
            if (doc != null && !doc.isEmpty()) {
                hasTxt = doc.stream().anyMatch(d -> "txt".equals(d.getString(SELECTED_NUMBER)));
                this.getView().setEnable(Boolean.valueOf(!hasTxt), new String[]{FIX_VALUE});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{FIX_VALUE});
            }
        }
    }

    public static enum Joiner {
        nullStr('0', ""),
        underlineStr('1', "_"),
        minusStr('2', "-"),
        pointStr('3', ".");

        private char index;
        private String joiner;

        private Joiner(char index, String joiner) {
            this.index = index;
            this.joiner = joiner;
        }

        public static String getJoiner(char index) {
            for (Joiner value : Joiner.values()) {
                if (value.index != index) continue;
                return value.joiner;
            }
            return "";
        }

        public static char getIndex(String joiner) {
            for (Joiner value : Joiner.values()) {
                if (!value.joiner.equals(joiner)) continue;
                return value.index;
            }
            return '0';
        }
    }
}

