/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.export.AdjustExportConstant;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DownFileUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlan;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportService;
import kd.fi.bcm.formplugin.adjust.export.FileNameStyle;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import org.jetbrains.annotations.NotNull;

public class AdjustBatchExportPlanHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AdjustBatchExportPlanHelper.class);
    public static final String SPLITSTR = "|";
    public static final Map<String, String> BOX_STATUS = MapInitHelper.ofMap((Object)"box_tempsave", (Object)RptAdjustStatusEnum.TEMPSAVE.status(), (Object)"box_save", (Object)RptAdjustStatusEnum.SAVE.status(), (Object)"box_audit", (Object)RptAdjustStatusEnum.AUDIT.status(), (Object)"box_commit", (Object)RptAdjustStatusEnum.COMMIT.status(), (Object)"box_back", (Object)RptAdjustStatusEnum.BACK.status());

    public static String getSelectField() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        fields.add("name");
        fields.add("applyscope");
        fields.add("model");
        fields.add("description");
        fields.add("creator");
        fields.add("createtime");
        fields.add("modifier");
        fields.add("modifytime");
        fields.add("dataconfig");
        fields.add("rowconfig");
        fields.add("columnconfig");
        fields.add("entryentity");
        fields.add("entryentity.entity");
        fields.add("entryentity.propertyvalue");
        fields.add("entryentity.scope");
        return String.join((CharSequence)",", fields);
    }

    public static AdjustBatchExportPlan getExportPlanById(Long id) {
        DynamicObject dyn;
        if (id != 0L && (dyn = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_adjustexportplan", (String)AdjustBatchExportPlanHelper.getSelectField())) != null) {
            DynamicObjectCollection orgs;
            String columnConfigStr;
            String rowConfigStr;
            AdjustBatchExportPlan plan = new AdjustBatchExportPlan();
            plan.setId(dyn.getLong("id"));
            plan.setName(dyn.getString("name"));
            plan.setApplyScope(dyn.getString("applyscope"));
            plan.setModelId(dyn.getLong("model.id"));
            String dataConfigStr = dyn.getString("dataconfig");
            if (StringUtils.isNotEmpty((CharSequence)dataConfigStr)) {
                Map map = (Map)ObjectSerialUtil.parseObject((String)dataConfigStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                plan.setExcelFileType(map.getOrDefault("excelFileType", "1"));
                plan.setFileType(map.getOrDefault("fileType", "3"));
                plan.setPackDownload(Boolean.parseBoolean(map.getOrDefault("isPackDownload", "true")));
                String sheetJoiner = map.getOrDefault("sheetconectstr", "");
                String fileJoiner = map.getOrDefault("connectstr", "");
                List sheetRuleList = (List)ObjectSerialUtil.parseObject((String)((String)map.get("sheetRuleList")), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
                List fileRuleList = (List)ObjectSerialUtil.parseObject((String)((String)map.get("fileRuleList")), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
                String sheetTex = map.getOrDefault("sheetruletxt", "");
                String fileTex = map.getOrDefault("fileruletxt", "");
                String fileRue = String.join((CharSequence)fileJoiner, fileRuleList);
                String sheetRue = String.join((CharSequence)sheetJoiner, sheetRuleList);
                String fileRuleSelect = ObjectSerialUtil.toByteSerialized((Object)fileRuleList);
                String sheetRuleSelect = ObjectSerialUtil.toByteSerialized((Object)sheetRuleList);
                String sheetLabeName = AdjustBatchExportPlanHelper.getLableName(sheetRuleList, sheetTex, sheetJoiner);
                String fileLabeName = AdjustBatchExportPlanHelper.getLableName(fileRuleList, fileTex, fileJoiner);
                map.put("filerule", fileRue);
                map.put("sheetrule", sheetRue);
                map.put("fileruleselect", fileRuleSelect);
                map.put("sheetruleselect", sheetRuleSelect);
                map.put("sheetclick", sheetLabeName);
                map.put("fileclick", fileLabeName);
                plan.setFileAndSheetCache(map);
                plan.setFileruleStr(fileRue);
                plan.setSheetruleStr(sheetRue);
                plan.setFiletxt(fileTex);
                plan.setSheettxt(sheetTex);
            }
            if (StringUtils.isNotEmpty((CharSequence)(rowConfigStr = dyn.getString("rowconfig")))) {
                Map map = (Map)ObjectSerialUtil.parseObject((String)rowConfigStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                plan.setIncludeLink(Boolean.parseBoolean(map.getOrDefault("isIncludeLink", "true")));
                plan.setRepeatHead(Boolean.parseBoolean(map.getOrDefault("isRepeatHead", "false")));
                String status = (String)map.get("selectStatus");
                if (StringUtils.isNotEmpty((CharSequence)status)) {
                    plan.setSelectStatus(Arrays.stream(status.split(",")).collect(Collectors.toSet()));
                } else {
                    plan.setSelectStatus(new HashSet<String>(BOX_STATUS.values()));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(columnConfigStr = dyn.getString("columnconfig")))) {
                String allAmountFieldListStr;
                String allDimFieldListStr;
                Map map = (Map)ObjectSerialUtil.parseObject((String)columnConfigStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String allBaseFieldListStr = (String)map.get("allBaseFieldList");
                if (StringUtils.isNotEmpty((CharSequence)allBaseFieldListStr)) {
                    List allBaseFieldList = (List)ObjectSerialUtil.parseObject((String)allBaseFieldListStr, (TypeReference)new TypeReference<List<Pair<String, Boolean>>>(){}, (Feature[])new Feature[0]);
                    plan.setAllBaseFieldList(allBaseFieldList);
                    plan.setBaseFieldList(allBaseFieldList.stream().filter(p -> (Boolean)p.p2).map(e -> Pair.onePair((Object)e.p1, (Object)((Pair)AdjustExportConstant.getBaseFields().get((Object)e.p1)).p1)).collect(Collectors.toList()));
                }
                if (StringUtils.isNotEmpty((CharSequence)(allDimFieldListStr = (String)map.get("allDimFieldList")))) {
                    Map dimFieldMap = new SchemeContext(plan.getModelId().longValue()).getDimensions().stream().collect(Collectors.toMap(Dimension::getFieldmapped, v -> Tuple.create((Object)v.getName(), (Object)IntrDimDisplayModeEnum.NUMBERANDNAME.value, (Object)true), (e1, e2) -> e2, LinkedHashMap::new));
                    List allDimFieldList = (List)ObjectSerialUtil.parseObject((String)allDimFieldListStr, (TypeReference)new TypeReference<List<Tuple<String, String, Boolean>>>(){}, (Feature[])new Feature[0]);
                    dimFieldMap.entrySet().stream().filter(entry -> !allDimFieldList.stream().map(e -> (String)e.p1).collect(Collectors.toSet()).contains(entry.getKey())).forEach(entry -> allDimFieldList.add(Tuple.create(entry.getKey(), (Object)((Tuple)entry.getValue()).p2, (Object)((Tuple)entry.getValue()).p3)));
                    plan.setAllDimFieldList(allDimFieldList);
                    plan.setDimFieldList(allDimFieldList.stream().filter(t -> (Boolean)t.p3).map(e -> Tuple.create((Object)e.p1, (Object)((Tuple)dimFieldMap.get((Object)e.p1)).p1, (Object)e.p2)).collect(Collectors.toList()));
                }
                if (StringUtils.isNotEmpty((CharSequence)(allAmountFieldListStr = (String)map.get("allAmountFieldList")))) {
                    List allAmountFieldList = (List)ObjectSerialUtil.parseObject((String)allAmountFieldListStr, (TypeReference)new TypeReference<List<Pair<String, Boolean>>>(){}, (Feature[])new Feature[0]);
                    plan.setAllAmountFieldList(allAmountFieldList);
                    plan.setAmountFieldList(AdjustBatchExportPlanHelper.getAmountField(allAmountFieldList.stream().filter(p -> (Boolean)p.p2).collect(Collectors.toList())));
                }
            }
            if (!(orgs = dyn.getDynamicObjectCollection("entryentity")).isEmpty()) {
                ArrayList<Map<String, String>> orgList = new ArrayList<Map<String, String>>(16);
                orgs.forEach(o -> {
                    HashMap<String, String> m = new HashMap<String, String>(16);
                    long orgId = o.getLong("entity.id");
                    long propertyValueId = o.getLong("propertyvalue.id");
                    String scope = o.getString("scope");
                    if (orgId == 0L && propertyValueId != 0L) {
                        m.put("id", propertyValueId + "");
                        m.put("pid", "");
                        m.put("scope", scope);
                    } else if (orgId != 0L && propertyValueId == 0L) {
                        m.put("id", orgId + "");
                        m.put("scope", scope);
                    }
                    if (!m.isEmpty()) {
                        orgList.add(m);
                    }
                });
                plan.setOrgList(orgList);
            }
            return plan;
        }
        return null;
    }

    private static String getLableName(List<String> ruleList, String tex, String joiner) {
        ArrayList name = new ArrayList(16);
        Map<String, String> nameMap = AdjustBatchExportPlanHelper.getFileNameStyleMap().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(k -> k.getNumber(), v -> v.getName(), (v1, v2) -> v1));
        ruleList.forEach(num -> {
            if ("txt".equals(num)) {
                name.add(tex);
            } else {
                name.add(nameMap.getOrDefault(num, ""));
            }
        });
        return String.join((CharSequence)joiner, name);
    }

    public static AdjustBatchExportPlan getDefaultExportPlan(Long modelId) {
        AdjustBatchExportPlan exportPlan;
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_adjustuserconfig", (String)"id,adjustexportplan.id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId())), new QFilter("model", "=", (Object)modelId)});
        if (config != null && (exportPlan = AdjustBatchExportPlanHelper.getExportPlanById(config.getLong("adjustexportplan.id"))) != null) {
            return exportPlan;
        }
        AdjustBatchExportPlan plan = new AdjustBatchExportPlan();
        plan.setModelId(modelId);
        plan.setExcelFileType("1");
        plan.setFileType("3");
        ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"orgnumber"});
        ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname"});
        plan.setFileruleStr(String.join((CharSequence)"_", fileRuleNumbers));
        plan.setSheetruleStr(String.join((CharSequence)"_", sheetRuleNumbers));
        plan.setFiletxt("");
        plan.setSheettxt("");
        plan.setPackDownload(true);
        plan.setIncludeLink(true);
        plan.setSelectStatus(new HashSet<String>(BOX_STATUS.values()));
        List<Pair<String, Boolean>> allBaseFields = AdjustExportConstant.getBaseFields().entrySet().stream().map(entry -> Pair.onePair(entry.getKey(), (Object)((Pair)entry.getValue()).p2)).collect(Collectors.toList());
        plan.setAllBaseFieldList(allBaseFields);
        plan.setBaseFieldList(allBaseFields.stream().filter(p -> (Boolean)p.p2).map(e -> Pair.onePair((Object)e.p1, (Object)((Pair)AdjustExportConstant.getBaseFields().get((Object)e.p1)).p1)).collect(Collectors.toList()));
        Map dimFieldMap = new SchemeContext(modelId.longValue()).getDimensions().stream().collect(Collectors.toMap(Dimension::getFieldmapped, v -> Tuple.create((Object)v.getName(), (Object)IntrDimDisplayModeEnum.NUMBERANDNAME.value, (Object)true), (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<Tuple<String, String, Boolean>> dimFields = new ArrayList<Tuple<String, String, Boolean>>(16);
        dimFieldMap.forEach((key, value) -> dimFields.add(Tuple.create((Object)key, (Object)value.p2, (Object)value.p3)));
        plan.setAllDimFieldList(dimFields);
        plan.setDimFieldList(dimFields.stream().filter(t -> (Boolean)t.p3).map(e -> Tuple.create((Object)e.p1, (Object)((Tuple)dimFieldMap.get((Object)e.p1)).p1, (Object)e.p2)).collect(Collectors.toList()));
        List<Pair<String, Boolean>> amountFields = AdjustExportConstant.getAmountFields().entrySet().stream().map(entry -> Pair.onePair(entry.getKey(), (Object)((Pair)entry.getValue()).p2)).collect(Collectors.toList());
        plan.setAllAmountFieldList(amountFields);
        plan.setAmountFieldList(AdjustBatchExportPlanHelper.getAmountField(amountFields.stream().filter(p -> (Boolean)p.p2).collect(Collectors.toList())));
        return plan;
    }

    public static List<FYPeriodPair> getFyPeriodPairs(AdjustBatchExportPlan plan) {
        ArrayList<FYPeriodPair> fyPeriodKeys = new ArrayList<FYPeriodPair>(10);
        if (plan.getModelId() != null && plan.getScenarioId() != null && plan.getStartYearId() != null && plan.getStartPeriodId() != null && plan.getEndYearId() != null && plan.getEndPeriodId() != null) {
            IDNumberTreeNode startYearNode = MemberReader.findFyMemberById((Long)plan.getModelId(), (Long)plan.getStartYearId());
            IDNumberTreeNode endYearNode = MemberReader.findFyMemberById((Long)plan.getModelId(), (Long)plan.getEndYearId());
            IDNumberTreeNode startPeriodNode = MemberReader.findPeriodMemberById((Long)plan.getModelId(), (Long)plan.getStartPeriodId());
            IDNumberTreeNode endPeriodNode = MemberReader.findPeriodMemberById((Long)plan.getModelId(), (Long)plan.getEndPeriodId());
            if (startYearNode != IDNumberTreeNode.NotFoundTreeNode && endYearNode != IDNumberTreeNode.NotFoundTreeNode && startPeriodNode != IDNumberTreeNode.NotFoundTreeNode && endPeriodNode != IDNumberTreeNode.NotFoundTreeNode) {
                List<DynamicObject> years = AdjustBatchExportPlanHelper.getEffectiveYear(plan.getModelId(), startYearNode, endYearNode);
                boolean isOneYear = years.size() == 1;
                List<DynamicObject> periods = AdjustBatchExportPlanHelper.getEffectivePeriodByScenario(plan.getModelId(), plan.getScenarioId());
                Optional<DynamicObject> startOp = periods.stream().filter(e -> startPeriodNode.getId().equals(e.get("id"))).findFirst();
                Optional<DynamicObject> endOp = periods.stream().filter(e -> endPeriodNode.getId().equals(e.get("id"))).findFirst();
                if (startOp.isPresent() && endOp.isPresent()) {
                    List<DynamicObject> largePs = periods.stream().filter(AdjustBatchExportPlanHelper.getLargePeriodPredicate(startOp.get())).collect(Collectors.toList());
                    List<DynamicObject> lessPs = periods.stream().filter(AdjustBatchExportPlanHelper.getLessPeriodPredicate(endOp.get())).collect(Collectors.toList());
                    ArrayList<DynamicObject> retainPs = new ArrayList<DynamicObject>(largePs);
                    retainPs.retainAll(lessPs);
                    for (DynamicObject year : years) {
                        if (year.getString("number").equals(startYearNode.getNumber())) {
                            if (isOneYear) {
                                retainPs.forEach(p -> {
                                    FYPeriodPair fyPeriodPair = new FYPeriodPair(year.getString("number") + SPLITSTR + p.getString("number"), year, (DynamicObject)p);
                                    fyPeriodKeys.add(fyPeriodPair);
                                });
                                continue;
                            }
                            largePs.forEach(p -> {
                                FYPeriodPair fyPeriodPair = new FYPeriodPair(year.getString("number") + SPLITSTR + p.getString("number"), year, (DynamicObject)p);
                                fyPeriodKeys.add(fyPeriodPair);
                            });
                            continue;
                        }
                        if (year.getString("number").equals(endYearNode.getNumber())) {
                            lessPs.forEach(p -> {
                                FYPeriodPair fyPeriodPair = new FYPeriodPair(year.getString("number") + SPLITSTR + p.getString("number"), year, (DynamicObject)p);
                                fyPeriodKeys.add(fyPeriodPair);
                            });
                            continue;
                        }
                        periods.forEach(p -> {
                            FYPeriodPair fyPeriodPair = new FYPeriodPair(year.getString("number") + SPLITSTR + p.getString("number"), year, (DynamicObject)p);
                            fyPeriodKeys.add(fyPeriodPair);
                        });
                    }
                }
            }
        }
        return fyPeriodKeys;
    }

    @NotNull
    private static Predicate<DynamicObject> getLessPeriodPredicate(DynamicObject end) {
        return dy -> {
            int startMonth = dy.getInt("expmonth");
            int startDay = dy.getInt("expday");
            int startMonth2 = end.getInt("expmonth");
            int startDay2 = end.getInt("expday");
            int diffMonth = startMonth - startMonth2;
            if (diffMonth == 0) {
                return startDay - startDay2 <= 0;
            }
            return diffMonth <= 0;
        };
    }

    @NotNull
    private static Predicate<DynamicObject> getLargePeriodPredicate(DynamicObject start) {
        return dy -> {
            int startMonth = dy.getInt("effmonth");
            int startDay = dy.getInt("effday");
            int startMonth2 = start.getInt("effmonth");
            int startDay2 = start.getInt("effday");
            int diffMonth = startMonth - startMonth2;
            if (diffMonth == 0) {
                return startDay - startDay2 >= 0;
            }
            return diffMonth >= 0;
        };
    }

    private static List<DynamicObject> getEffectiveYear(Long modelId, IDNumberTreeNode startYearNode, IDNumberTreeNode endYearNode) {
        String selectProperties = "id,number,name,dimension.membermodel";
        QFilter filter3 = new QFilter("model", "=", (Object)modelId);
        QFilter filter1 = new QFilter("number", ">=", (Object)startYearNode.getNumber());
        QFilter filter2 = new QFilter("number", "<=", (Object)endYearNode.getNumber());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter3, filter1, filter2});
        return Lists.newArrayList(map.values());
    }

    public static List<DynamicObject> getEffectivePeriodByScenario(Long modelId, Long scenarioId) {
        String selectProperties = "id,number,name,dimension.membermodel,effmonth,effday,expmonth,expday";
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod((long)modelId, (long)scenarioId);
        Long[] periodIds = DynamicObjectCollectionUtil.getFieldPKArray((DynamicObjectCollection)coll, (String)"fbasedataid");
        QFilter filter3 = new QFilter("model", "=", (Object)modelId);
        QFilter filter0 = new QFilter("id", "in", (Object)periodIds);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter3, filter0}, (String)"dseq");
        return Lists.newArrayList(map.values());
    }

    public static Map<String, Pair<String, Boolean>> orderFieldMapByConfig(Map<String, Pair<String, Boolean>> baseFieldMap, List<Pair<String, Boolean>> fieldOrderConfig) {
        if (fieldOrderConfig != null && !fieldOrderConfig.isEmpty()) {
            LinkedHashMap<String, Pair<String, Boolean>> result = new LinkedHashMap<String, Pair<String, Boolean>>(baseFieldMap.size());
            for (Pair<String, Boolean> dbConfig : fieldOrderConfig) {
                Pair<String, Boolean> temp = baseFieldMap.get(dbConfig.p1);
                if (temp == null) continue;
                result.put((String)dbConfig.p1, (Pair<String, Boolean>)Pair.onePair((Object)temp.p1, (Object)dbConfig.p2));
            }
            baseFieldMap.forEach((k, v) -> {
                if (!result.containsKey(k)) {
                    result.put((String)k, (Pair<String, Boolean>)v);
                }
            });
            return result;
        }
        return baseFieldMap;
    }

    public static Map<String, Tuple<String, String, Boolean>> orderDimFieldMapByConfig(Map<String, Tuple<String, String, Boolean>> dimFieldMap, AdjustBatchExportPlan exportPlan) {
        List<Tuple<String, String, Boolean>> allDimFieldList = exportPlan.getAllDimFieldList();
        LinkedHashMap<String, Tuple<String, String, Boolean>> result = new LinkedHashMap<String, Tuple<String, String, Boolean>>(dimFieldMap.size());
        if (allDimFieldList != null && !allDimFieldList.isEmpty()) {
            for (Tuple<String, String, Boolean> dbConfig : allDimFieldList) {
                Tuple<String, String, Boolean> temp = dimFieldMap.get(dbConfig.p1);
                if (temp == null) continue;
                result.put((String)dbConfig.p1, (Tuple<String, String, Boolean>)Tuple.create((Object)temp.p1, (Object)dbConfig.p2, (Object)dbConfig.p3));
            }
        }
        dimFieldMap.forEach((k, v) -> {
            if (!result.containsKey(k)) {
                result.put((String)k, (Tuple<String, String, Boolean>)v);
            }
        });
        return result;
    }

    public static void dispatch(AdjustBatchExportService service, AbstractFormPlugin plugin) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(plugin.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(AdjustBatchExportPlanHelper.getTaskJobInfoName());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(AdjustBatchExportPlanHelper.getTaskClassName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 100);
        params.put("service", ObjectSerialUtil.toByteSerialized((Object)service));
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "taskcloseback");
        AdjustBatchExportPlanHelper.dispatch(jobInfo, plugin.getView(), closeCallBack);
    }

    private static void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setCanStop(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setClickClassName("kd.fi.bcm.formplugin.adjust.export.AdjustExportTaskClickPlugin");
        clientJobInfo.setParentPageId(view.getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    private static String getTaskClassName() {
        return "kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportTask";
    }

    private static String getTaskJobInfoName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ReportMultiExportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static void taskCompleteCallback(ClosedCallBackEvent e, AbstractFormPlugin plugin, Long modelId) {
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Object returnData;
        Map result;
        if (e.getReturnData() != null && (result = (Map)(returnData = e.getReturnData())).containsKey("taskinfo") && kd.bos.util.StringUtils.isNotEmpty((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && plugin.getPageCache().get("download") == null && (data = taskInfo.getData()) != null) {
            JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
            JSONArray urls = dataObj.getJSONArray("data");
            String message = (String)dataObj.get((Object)"message");
            String excelMsg = (String)dataObj.get((Object)"excelMsg");
            plugin.getPageCache().put("download", "1");
            if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
                AdjustBatchExportPlanHelper.writeLog(OpItemEnum.EXPORT.getName(), OpItemEnum.EXPORT.getName() + ResultStatusEnum.FAIL.getName(), modelId, "bcm_rptadjust");
                plugin.getView().showErrorNotification(message);
            } else {
                AdjustBatchExportPlanHelper.writeLog(OpItemEnum.EXPORT.getName(), OpItemEnum.EXPORT.getName() + ResultStatusEnum.SUCCESS.getName(), modelId, "bcm_rptadjust");
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)excelMsg)) {
                String str = ResManager.loadKDString((String)"\u6709\u90e8\u5206\u6570\u636e\u751f\u6210\u5f02\u5e38\uff0c\u4fe1\u606f\u5982\u4e0b\uff1a\n", (String)"AdjustBatchExportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                plugin.getView().showTipNotification(str + excelMsg);
            }
            if (urls != null && urls.size() > 0) {
                for (Object o : urls.toArray()) {
                    DownFileUtil.authorizedDownLoadFileUrl((String)o.toString(), (long)modelId, (String)plugin.getView().getFormShowParameter().getAppId(), (String)"bcm_rptadjust_list", (String)"44W56EJ0U031");
                    ((IClientViewProxy)plugin.getView().getService(IClientViewProxy.class)).addAction("download", (Object)o.toString());
                }
            } else {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u5bfc\u51fa\u7684\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u8bbe\u7f6e\u3002", (String)"AdjustBatchExportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static List<Pair<String, String>> getAmountField(List<Pair<String, Boolean>> amountfieldnum) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>(16);
        List temfields = amountfieldnum.stream().map(e -> (String)e.p1).filter(e -> "debit-credit".equalsIgnoreCase((String)e) || "summoney".equalsIgnoreCase((String)e)).collect(Collectors.toList());
        for (Pair<String, Boolean> field : amountfieldnum) {
            if ("debit-credit".equalsIgnoreCase((String)field.p1)) {
                result.add((Pair<String, String>)Pair.onePair((Object)"debit", (Object)ResManager.loadKDString((String)"\u501f\u65b9", (String)"AdjustBatchExportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                result.add((Pair<String, String>)Pair.onePair((Object)"credit", (Object)ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AdjustBatchExportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                continue;
            }
            if ("cvtbefore".equalsIgnoreCase((String)field.p1)) {
                for (String temfield : temfields) {
                    if ("debit-credit".equalsIgnoreCase(temfield)) {
                        result.add((Pair<String, String>)Pair.onePair((Object)"cvtbeforedebit", (Object)ResManager.loadKDString((String)"\u6298\u7b97\u524d\u501f\u65b9", (String)"AdjustBatchExportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        result.add((Pair<String, String>)Pair.onePair((Object)"cvtbeforecredit", (Object)ResManager.loadKDString((String)"\u6298\u7b97\u524d\u8d37\u65b9", (String)"AdjustBatchExportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    }
                    if (!"summoney".equalsIgnoreCase(temfield)) continue;
                    result.add((Pair<String, String>)Pair.onePair((Object)"cvtbeforesummoney", (Object)ResManager.loadKDString((String)"\u6298\u7b97\u524d\u91d1\u989d", (String)"AdjustBatchExportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                }
                continue;
            }
            result.add((Pair<String, String>)Pair.onePair((Object)field.p1, (Object)((Pair)AdjustExportConstant.getAmountFields().get((Object)field.p1)).p1));
        }
        return result;
    }

    private static void writeLog(String opName, String opDescriotion, Long modelId, String entityNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)modelId, (String)entityNumber);
        logService.addLog(logInfo);
    }

    public static Map<Character, List<FileNameStyle>> getFileNameStyleMap() {
        HashMap rihtSelects = Maps.newHashMap();
        ArrayList ls1 = Lists.newArrayList();
        FileNameStyle fns11 = new FileNameStyle('1', "orgnumber", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"MultiExportFileRulePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns12 = new FileNameStyle('1', "orgname", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"MultiExportFileRulePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns13 = new FileNameStyle('1', "orgsimplename", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7b80\u79f0", (String)"MultiExportFileRulePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns14 = new FileNameStyle('1', "orgcode", ResManager.loadKDString((String)"\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801", (String)"MultiExportFileRulePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ls1.add(fns11);
        ls1.add(fns12);
        ls1.add(fns13);
        ls1.add(fns14);
        ArrayList ls2 = Lists.newArrayList();
        FileNameStyle fns21 = new FileNameStyle('2', "yearnumber", ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801", (String)"MultiExportFileRulePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns22 = new FileNameStyle('2', "yearname", ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0", (String)"MultiExportFileRulePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns23 = new FileNameStyle('2', "periodnumber", ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801", (String)"MultiExportFileRulePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns24 = new FileNameStyle('2', "periodname", ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"MultiExportFileRulePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ls2.add(fns21);
        ls2.add(fns22);
        ls2.add(fns23);
        ls2.add(fns24);
        ArrayList ls3 = Lists.newArrayList();
        FileNameStyle fns31 = new FileNameStyle('3', "txt", ResManager.loadKDString((String)"\u56fa\u5b9a\u503c", (String)"MultiExportFileRulePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns32 = new FileNameStyle('3', "currencynumber", ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801", (String)"MultiExportFileRulePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns33 = new FileNameStyle('3', "currencyname", ResManager.loadKDString((String)"\u5e01\u79cd\u540d\u79f0", (String)"MultiExportFileRulePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        FileNameStyle fns34 = new FileNameStyle('3', "systemtime", ResManager.loadKDString((String)"\u7cfb\u7edf\u65f6\u95f4", (String)"MultiExportFileRulePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ls3.add(fns31);
        ls3.add(fns32);
        ls3.add(fns33);
        ls3.add(fns34);
        rihtSelects.put(Character.valueOf('1'), ls1);
        rihtSelects.put(Character.valueOf('2'), ls2);
        rihtSelects.put(Character.valueOf('3'), ls3);
        return rihtSelects;
    }
}

