/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class AdjustBatchExportPlanListPlugin
extends AbstractBaseListPlugin {
    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilter(this.getBillListFilter());
        billList.addSetFilterListener(this::setFilter);
        billList.addBeforePackageDataListener(this::beforePackageData);
        billList.addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = LongUtil.toLong((Object)this.getFormCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_delete", "btn_default");
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_adjustuserconfig", (String)"id,adjustexportplan.id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId())), new QFilter("model", "=", (Object)this.getModelId())});
        if (config != null) {
            Optional<DynamicObject> optional = pageData.stream().filter(r -> r.get("id").equals(config.getLong("adjustexportplan.id"))).findFirst();
            optional.ifPresent(dy -> dy.set("defaultflag", (Object)true));
        }
    }

    private void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        BillList billList = (BillList)evt.getSource();
        Object id = billList.getFocusRowPkId();
        if ("name".equals(fieldName)) {
            if (QueryServiceHelper.exists((String)"bcm_adjustexportplan", (Object)id)) {
                HashMap<String, String> m = new HashMap<String, String>(16);
                m.put("id", id.toString());
                this.getView().returnDataToParent(m);
                this.getView().close();
            } else {
                billList.refresh();
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"AdjustBatchExportPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_delete".equals(key)) {
            this.deletePlan();
        } else if ("btn_default".equals(key)) {
            this.setDefaultPlan();
        }
    }

    private void setDefaultPlan() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5904\u7406\u7684\u65b9\u6848\u3002", (String)"AdjustBatchExportPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Object id = selectedRows.get(0).getPrimaryKeyValue();
        if (!QueryServiceHelper.exists((String)"bcm_adjustexportplan", (Object)id)) {
            billList.refresh();
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"AdjustBatchExportPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_adjustexportplan", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        DeleteServiceHelper.delete((String)"bcm_adjustuserconfig", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("model", "=", (Object)this.getModelId())});
        DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjustuserconfig");
        config.set("user", (Object)userId);
        config.set("adjustexportplan", selectedRows.get(0).getPrimaryKeyValue());
        config.set("model", (Object)this.getModelId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        this.writeLogWithEntityNumber("bcm_adjustexportplan", new OpNameMultiLangEnumBridge("\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848", "AdjustBatchExportPlugin_41", "fi-bcm-formplugin", "set default scheme"), new OPDescMultiLangEnumBridge("%s\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u65b9\u6848\u6210\u529f\u3002", "AdjustBatchExportPlugin_42", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dynamicObject.getString("name")})));
        billList.refresh();
    }

    private void deletePlan() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5904\u7406\u7684\u65b9\u6848\u3002", (String)"AdjustBatchExportPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!QueryServiceHelper.exists((String)"bcm_adjustexportplan", (Object)selectedRows.get(0).getPrimaryKeyValue())) {
            billList.refresh();
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"AdjustBatchExportPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"CheckTmplListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbackid_del_confirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("callbackid_del_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Long id = LongUtil.toLong((Object)selectedRows.get(0).getPrimaryKeyValue());
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_adjustexportplan", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            DeleteServiceHelper.delete((String)"bcm_adjustexportplan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            DeleteServiceHelper.delete((String)"bcm_adjustuserconfig", (QFilter[])new QFilter[]{new QFilter("adjustexportplan", "=", (Object)id)});
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RptAdjustdListPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.writeLogWithEntityNumber("bcm_adjustexportplan", OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DELETE.getMultiLangEnumBridge(), (String)"delete"), new OPDescMultiLangEnumBridge("%s\u5220\u9664\u6210\u529f\u3002", "RptAdjustdListPlugin_140", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dynamicObject.getString("name")})));
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        if (qFilters != null) {
            qFilters.add(this.getBillListFilter());
        }
    }

    private QFilter getBillListFilter() {
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("creator", "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        filter2.or("applyscope", "=", (Object)"2");
        filter1.and(filter2);
        return filter1;
    }
}

