/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.export.AdjustExportConstant;
import kd.fi.bcm.business.adjust.model.export.QueryOrgRange;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlan;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlanHelper;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;

public class AdjustBatchExportPlugin
extends AbstractBaseFormPlugin {
    private static final String KEY_EXPORTPLAN_ID = "key_exportplan_id";
    protected static final String SPLITSTR = "|";
    protected static final String SHEETRULE = "sheetrule";
    protected static final String FILERULE = "filerule";
    protected static final String SHEETRULESELECT = "sheetruleselect";
    protected static final String FILERULESELECT = "fileruleselect";
    protected static final String START_YEAR = "startyear";
    protected static final String END_YEAR = "endyear";
    public static final String BASE_FIELD_ENTITY = "basefieldentity";
    public static final String DIME_NTITY = "dimentity";
    public static final String AMOUNT_ENTITY = "amountentity";
    public static final String START_PERIOD = "startperiod";
    public static final String BASE_FIELD_NUM = "basefieldnum";
    public static final String AMOUNT_FIELD_NUM = "amountfieldnum";
    protected String periodKey = "startperiod";
    public static final String END_PERIOD = "endperiod";
    protected static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "startyear", "startperiod", "endyear", "endperiod"});
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    protected static final String MODEL = "model";
    protected static final String NUMBER = "number";
    protected static final String ORG_ENTRY = "orgentry";
    protected static final String ORG_NUMBER = "org_number";
    protected static final String SHEET_CLICK = "sheetclick";
    protected static final String FILE_CLICK = "fileclick";
    protected static final String CONNECT_STR = "connectstr";
    private static final String DOWNLOADED = "downloaded";
    protected static final String FILETYPE = "filetype";
    protected static final String DEFINEDPROP_NUMBER = "definedprop_number";
    private List<Integer> baseFieldSelected = new ArrayList<Integer>(16);
    private List<Integer> dimFieldSelected = new ArrayList<Integer>(16);
    private List<Integer> amountFieldSelected = new ArrayList<Integer>(16);
    public static List<String> fileAndSheetKeys = Arrays.asList("sheetruleselect", "fileruleselect", "sheetconectstr", "connectstr", "sheetruletxt", "fileruletxt");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(SHEET_CLICK, FILE_CLICK, "bar_confirm");
        this.addItemClickListeners("toolbarap");
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("cslscheme");
        edit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter(NUMBER, "!=", (Object)"DefaultRateScheme");
            listShowParameter.getListFilterParameter().setFilter(qf);
        });
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new SpreadDataModel(this));
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>();
        f7Key2Dim.put(START_YEAR, DimTypesEnum.YEAR.getNumber());
        f7Key2Dim.put(START_PERIOD, DimTypesEnum.PERIOD.getNumber());
        f7Key2Dim.put(END_YEAR, DimTypesEnum.YEAR.getNumber());
        f7Key2Dim.put(END_PERIOD, DimTypesEnum.PERIOD.getNumber());
        f7Key2Dim.put("scenario", "scenario");
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.getModel().setValue(MODEL, (Object)modelId);
        Label sheetclicklabel = (Label)this.getView().getControl(SHEET_CLICK);
        Label fileclicklabel = (Label)this.getView().getControl(FILE_CLICK);
        fileclicklabel.setText(ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0", (String)"AdjustBatchExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        sheetclicklabel.setText(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"AdjustBatchExportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        AdjustBatchExportPlan defaultExportPlan = AdjustBatchExportPlanHelper.getDefaultExportPlan(this.getModelId());
        if (defaultExportPlan.getId() != null) {
            this.getPageCache().put(KEY_EXPORTPLAN_ID, defaultExportPlan.getId().toString());
        }
        this.refreshPage(defaultExportPlan);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid baseentry = (EntryGrid)this.getView().getControl(BASE_FIELD_ENTITY);
        baseentry.selectRows(this.baseFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
        EntryGrid dimentry = (EntryGrid)this.getView().getControl(DIME_NTITY);
        dimentry.selectRows(this.dimFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
        EntryGrid amountentry = (EntryGrid)this.getView().getControl(AMOUNT_ENTITY);
        amountentry.selectRows(this.amountFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
    }

    private void refreshPage(AdjustBatchExportPlan exportPlan) {
        Long yearId;
        Long scenarioId;
        Long cslSchemeId;
        if (exportPlan == null && (exportPlan = AdjustBatchExportPlanHelper.getExportPlanById(LongUtil.toLong((Object)this.getPageCache().get(KEY_EXPORTPLAN_ID)))) == null) {
            exportPlan = AdjustBatchExportPlanHelper.getDefaultExportPlan(this.getModelId());
        }
        if (StringUtils.isNotEmpty((String)exportPlan.getName())) {
            this.getModel().setValue("currentplan", (Object)exportPlan.getName());
        }
        if ((cslSchemeId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("cslscheme"))) != 0L && this.getModel().getValue("cslscheme") == null) {
            this.getModel().setValue("cslscheme", (Object)cslSchemeId);
        }
        if ((scenarioId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("scenario"))) != 0L && this.getModel().getValue("scenario") == null) {
            this.getModel().setValue("scenario", (Object)scenarioId);
        }
        if ((yearId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("year"))) != 0L && this.getModel().getValue(START_YEAR) == null) {
            this.getModel().setValue(START_YEAR, (Object)yearId);
        }
        if (yearId != 0L && this.getModel().getValue(END_YEAR) == null) {
            this.getModel().setValue(END_YEAR, (Object)yearId);
        }
        Long periodId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("period"));
        if (yearId != 0L && this.getModel().getValue(START_PERIOD) == null) {
            this.getModel().setValue(START_PERIOD, (Object)periodId);
        }
        if (yearId != 0L && this.getModel().getValue(END_PERIOD) == null) {
            this.getModel().setValue(END_PERIOD, (Object)periodId);
        }
        this.getModel().setValue("excelfiletype", (Object)exportPlan.getExcelFileType());
        Map<String, String> fileAndSheetCache = exportPlan.getFileAndSheetCache();
        if (fileAndSheetCache == null) {
            this.setLabelName(exportPlan.getExcelFileType());
        } else {
            Label sheetclicklabel = (Label)this.getView().getControl(SHEET_CLICK);
            Label fileclicklabel = (Label)this.getView().getControl(FILE_CLICK);
            sheetclicklabel.setText(fileAndSheetCache.get(SHEET_CLICK));
            fileclicklabel.setText(fileAndSheetCache.get(FILE_CLICK));
            this.getPageCache().put(fileAndSheetCache);
        }
        this.getModel().setValue(FILETYPE, (Object)exportPlan.getFileType());
        this.getModel().setValue("pack_download", (Object)exportPlan.isPackDownload());
        this.initOrgEntry(exportPlan);
        this.getModel().setValue("isincludelink", (Object)exportPlan.isIncludeLink());
        this.getModel().setValue("isrepeathead", (Object)exportPlan.isRepeatHead());
        Set<String> selectStatus = exportPlan.getSelectStatus();
        AdjustBatchExportPlanHelper.BOX_STATUS.forEach((k, v) -> this.getModel().setValue(k, (Object)selectStatus.contains(v)));
        this.getModel().setValue("box_all", (Object)selectStatus.containsAll(AdjustBatchExportPlanHelper.BOX_STATUS.values()));
        this.initFieldConfig(exportPlan);
    }

    private void initFieldConfig(AdjustBatchExportPlan exportPlan) {
        Map<String, Pair<String, Boolean>> baseFieldMap = AdjustExportConstant.getBaseFields();
        baseFieldMap = AdjustBatchExportPlanHelper.orderFieldMapByConfig(baseFieldMap, exportPlan.getAllBaseFieldList());
        this.getModel().deleteEntryData(BASE_FIELD_ENTITY);
        this.getModel().batchCreateNewEntryRow(BASE_FIELD_ENTITY, baseFieldMap.size());
        int i = 0;
        for (Map.Entry<String, Pair<String, Boolean>> entry : baseFieldMap.entrySet()) {
            this.getModel().setValue(BASE_FIELD_NUM, (Object)entry.getKey(), i);
            this.getModel().setValue("basefieldname", entry.getValue().p1, i);
            if (((Boolean)entry.getValue().p2).booleanValue()) {
                this.baseFieldSelected.add(i);
            }
            ++i;
        }
        Map<String, Tuple<String, String, Boolean>> dimFieldMap = new SchemeContext(this.getModelId()).getDimensions().stream().collect(Collectors.toMap(Dimension::getFieldmapped, v -> Tuple.create((Object)v.getName(), (Object)IntrDimDisplayModeEnum.NUMBERANDNAME.value, (Object)true), (e1, e2) -> e2, LinkedHashMap::new));
        dimFieldMap = AdjustBatchExportPlanHelper.orderDimFieldMapByConfig(dimFieldMap, exportPlan);
        this.getModel().deleteEntryData(DIME_NTITY);
        this.getModel().batchCreateNewEntryRow(DIME_NTITY, dimFieldMap.size());
        i = 0;
        for (Map.Entry<String, Tuple<String, String, Boolean>> entry : dimFieldMap.entrySet()) {
            this.getModel().setValue("dimnum", (Object)entry.getKey(), i);
            this.getModel().setValue("dimname", entry.getValue().p1, i);
            this.getModel().setValue("display", entry.getValue().p2, i);
            if (((Boolean)entry.getValue().p3).booleanValue()) {
                this.dimFieldSelected.add(i);
            }
            ++i;
        }
        Map map = AdjustExportConstant.getAmountFields();
        Map<String, Pair<String, Boolean>> map2 = AdjustBatchExportPlanHelper.orderFieldMapByConfig(map, exportPlan.getAllAmountFieldList());
        this.getModel().deleteEntryData(AMOUNT_ENTITY);
        this.getModel().batchCreateNewEntryRow(AMOUNT_ENTITY, map2.size());
        i = 0;
        for (Map.Entry<String, Pair<String, Boolean>> entry : map2.entrySet()) {
            this.getModel().setValue(AMOUNT_FIELD_NUM, (Object)entry.getKey(), i);
            this.getModel().setValue("amountfieldname", entry.getValue().p1, i);
            if (((Boolean)entry.getValue().p2).booleanValue()) {
                this.amountFieldSelected.add(i);
            }
            ++i;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BASE_FIELD_ENTITY);
        entryGrid.selectRows(this.baseFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
        EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl(DIME_NTITY);
        entryGrid2.selectRows(this.dimFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
        EntryGrid amountentry = (EntryGrid)this.getView().getControl(AMOUNT_ENTITY);
        amountentry.selectRows(this.amountFieldSelected.stream().mapToInt(j -> j).toArray(), 0);
    }

    public void initOrgEntry(AdjustBatchExportPlan exportPlan) {
        EntryGrid orgEntryGrid = (EntryGrid)this.getView().getControl(ORG_ENTRY);
        orgEntryGrid.getModel().deleteEntryData(ORG_ENTRY);
        if (!exportPlan.getOrgList().isEmpty()) {
            orgEntryGrid.getModel().batchCreateNewEntryRow(ORG_ENTRY, exportPlan.getOrgList().size());
            for (int row = 0; row < exportPlan.getOrgList().size(); ++row) {
                Map<String, String> rowData = exportPlan.getOrgList().get(row);
                if (rowData.containsKey("pid")) {
                    orgEntryGrid.getModel().setValue(DEFINEDPROP_NUMBER, (Object)LongUtil.toLong((Object)rowData.get("id")), row);
                } else {
                    orgEntryGrid.getModel().setValue(ORG_NUMBER, (Object)LongUtil.toLong((Object)rowData.get("id")), row);
                }
                orgEntryGrid.getModel().setValue("membrange", (Object)rowData.get("scope"), row);
            }
        } else {
            Object orgStr = this.getView().getFormShowParameter().getCustomParam("org");
            Object orgscope = this.getView().getFormShowParameter().getCustomParam("orgscope");
            if (orgStr != null && orgscope != null) {
                Long orgId = LongUtil.toLong((Object)orgStr);
                DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"number,name,isleaf,currency.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
                orgEntryGrid.getModel().batchCreateNewEntryRow(ORG_ENTRY, 1);
                orgEntryGrid.getModel().setValue(ORG_NUMBER, (Object)orgDyn, 0);
                orgEntryGrid.getModel().setValue("membrange", orgscope, 0);
            }
        }
        this.initShowFiledControl();
        this.getView().updateView(ORG_ENTRY);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.equals(START_PERIOD) || key.equals(END_PERIOD)) {
            this.periodKey = key;
        }
        super.onGetControl(e);
    }

    @Override
    public String getPeriodLogo() {
        return this.periodKey;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_confirm": {
                this.exportExcel();
                break;
            }
            case "bar_download": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("bcm_exporturllist");
                OpenStyle openStyle = showParameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960");
                css.setHeight("580");
                openStyle.setInlineStyleCss(css);
                showParameter.setMultiSelect(true);
                showParameter.setShowTitle(true);
                showParameter.setLookUp(false);
                showParameter.setCustomParam("modelId", (Object)this.getModelId());
                ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())});
                filters.add(new QFilter("creater", "=", (Object)this.getUserId()));
                int type = ExportPageSourceEnum.ADJUST.getIndex();
                filters.add(new QFilter("type", "=", (Object)Integer.toString(type)));
                showParameter.setCustomParam("ExportPageSource", (Object)Integer.toString(type));
                showParameter.getListFilterParameter().setQFilters((List)filters);
                showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u5f55\u5bfc\u51fa\u4e0b\u8f7d\u6e05\u5355", (String)"AdjustBatchExportPlugin_31", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "bar_plansave": {
                this.savePlan(false);
                break;
            }
            case "bar_plansaveas": {
                this.savePlan(true);
                break;
            }
            case "bar_planlist": {
                this.openPlanList();
                break;
            }
        }
    }

    private void openPlanList() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPlanList"));
        parameter.setFormId("bcm_adjustexportplanlist");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void savePlan(boolean isNew) {
        AdjustBatchExportPlan plan = this.getPlanByCurrentView();
        if (isNew) {
            plan.setId(0L);
            plan.setName("");
            plan.setDescription("");
            plan.setApplyScope("1");
        } else {
            Long id = LongUtil.toLong((Object)this.getPageCache().get(KEY_EXPORTPLAN_ID));
            plan.setId(id);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("plan", (Object)ObjectSerialUtil.toJson((Object)plan));
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savePlan"));
        parameter.setFormId("bcm_adjustexportedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (args.getSource() instanceof NewEntry) {
            args.setCancel(true);
            if ("orgnewentry".equals(operateKey)) {
                this.showSelectOrgView();
            }
        }
    }

    private void showSelectOrgView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_tem");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"DistributionPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("isFilterRateScheme", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("sign", (Object)"Entity");
        formShowParameter.setCustomParam("isUpDownBtn", (Object)true);
        List<Map<String, String>> orgList = this.getOrgList();
        if (orgList != null) {
            formShowParameter.setCustomParam("Entity", (Object)SerializationUtils.toJsonString(orgList));
        } else {
            formShowParameter.setCustomParam("Entity", (Object)SerializationUtils.toJsonString(new ArrayList(10)));
        }
        Object cslscheme = this.getModel().getValue("cslscheme");
        if (cslscheme != null) {
            formShowParameter.setCustomParam("cslscheme", (Object)((DynamicObject)cslscheme).getLong("id"));
            formShowParameter.setCustomParam("lockcslscheme", (Object)true);
        }
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private List<Map<String, String>> getOrgList() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORG_ENTRY);
        if (entryEntity.size() > 0) {
            ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>(entryEntity.size());
            if (((DynamicObject)entryEntity.get(0)).get(ORG_NUMBER) != null) {
                for (DynamicObject object : entryEntity) {
                    HashMap<String, String> m = new HashMap<String, String>(10);
                    m.put("id", Long.toString(object.getLong("org_number_id")));
                    m.put("scope", object.getString("membrange"));
                    m.put(NUMBER, object.getString("org_number.number"));
                    m.put("name", object.getString("org_number.name"));
                    maps.add(m);
                }
            } else {
                for (DynamicObject object : entryEntity) {
                    HashMap<String, String> m = new HashMap<String, String>(10);
                    m.put("id", Long.toString(object.getLong("definedprop_number_id")));
                    m.put("scope", object.getString("membrange"));
                    m.put(NUMBER, object.getString(NUMBER));
                    m.put("name", object.getString("name"));
                    m.put("pid", object.getDynamicObject(DEFINEDPROP_NUMBER).getString("propertyid.id"));
                    maps.add(m);
                }
            }
            return maps;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionKey = e.getActionId();
        if ("selectmember".equals(actionKey)) {
            this.fillBackOrgEntrys(e);
        } else if (SHEET_CLICK.equals(actionKey)) {
            this.setClickLable(e, SHEET_CLICK, SHEETRULE);
        } else if (FILE_CLICK.equals(actionKey)) {
            this.setClickLable(e, FILE_CLICK, FILERULE);
        } else if ("taskcloseback".equals(actionKey)) {
            AdjustBatchExportPlanHelper.taskCompleteCallback(e, this, this.getModelId());
        } else if (("savePlan".equals(actionKey) || "openPlanList".equals(actionKey)) && e.getReturnData() != null && e.getReturnData() instanceof Map) {
            String id = (String)((Map)e.getReturnData()).get("id");
            this.getPageCache().put(KEY_EXPORTPLAN_ID, id);
            this.refreshPage(null);
        }
    }

    public void fillBackOrgEntrys(ClosedCallBackEvent e) {
        DynamicObjectCollection newdoc;
        if (e.getReturnData() != null && (newdoc = (DynamicObjectCollection)e.getReturnData()) != null && !newdoc.isEmpty()) {
            Object pid1 = ((DynamicObject)newdoc.get(0)).get("pid1");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(pid1 == null ? null : pid1.toString()))) {
                this.fillBackOrgProp(newdoc);
            } else {
                this.fillBackDefinedProp(newdoc);
            }
            this.initShowFiledControl();
        }
    }

    private void fillBackOrgProp(DynamicObjectCollection newdoc) {
        List ids = DynamicObjectCollectionUtil.getPKList((DynamicObjectCollection)newdoc, (String)"mid1");
        Map<Long, String> id2Ranges = newdoc.stream().collect(Collectors.toMap(k -> k.getLong("mid1"), v -> v.getString("filltypevalue1")));
        QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
        Map id2newDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"number,name,isleaf,currency.number", (QFilter[])qf.toArray());
        int newSize = ids.size();
        this.getModel().deleteEntryData(ORG_ENTRY);
        if (newSize > 0 && id2newDys != null && !id2newDys.isEmpty()) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY, newSize);
            this.getModel().beginInit();
            int i = 0;
            for (Long id : ids) {
                DynamicObject object = (DynamicObject)id2newDys.get(id);
                if (object == null) continue;
                this.getModel().setValue(ORG_NUMBER, (Object)object, rows[i]);
                this.getModel().setValue("org_number_id", (Object)object.getLong("id"), rows[i]);
                this.getModel().setValue("membrange", (Object)id2Ranges.get(id), rows[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ORG_ENTRY);
        }
    }

    private void fillBackDefinedProp(DynamicObjectCollection newdoc) {
        List ids = DynamicObjectCollectionUtil.getPKList((DynamicObjectCollection)newdoc, (String)"mid1");
        Map<Long, String> id2Ranges = newdoc.stream().collect(Collectors.toMap(k -> k.getLong("mid1"), v -> v.getString("filltypevalue1")));
        QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
        Map id2newDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"id,number,name,propertyid.number,propertyid.name", (QFilter[])qf.toArray());
        int newSize = ids.size();
        this.getModel().deleteEntryData(ORG_ENTRY);
        if (newSize > 0 && id2newDys != null && !id2newDys.isEmpty()) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY, newSize);
            this.getModel().beginInit();
            int i = 0;
            for (Long id : ids) {
                DynamicObject object = (DynamicObject)id2newDys.get(id);
                if (object == null) continue;
                this.getModel().setValue(DEFINEDPROP_NUMBER, (Object)object, rows[i]);
                this.getModel().setValue("definedprop_number_id", (Object)object.getLong("id"), rows[i]);
                this.getModel().setValue("membrange", (Object)id2Ranges.get(id), rows[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ORG_ENTRY);
        }
    }

    private void initShowFiledControl() {
        DynamicObject pid1;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ORG_ENTRY);
        int count = this.getModel().getEntryRowCount(ORG_ENTRY);
        this.getModel().beginInit();
        HashMap<Long, DynamicObject> id2PropDys = new HashMap<Long, DynamicObject>(16);
        if (count > 0 && (pid1 = ((DynamicObject)doc.get(0)).getDynamicObject(DEFINEDPROP_NUMBER)) != null) {
            List pids = doc.stream().filter(d -> d.getDynamicObject(DEFINEDPROP_NUMBER) != null).map(d -> d.getDynamicObject(DEFINEDPROP_NUMBER).getLong("propertyid_id")).collect(Collectors.toList());
            QFBuilder qfBuilder = new QFBuilder("id", "in", pids);
            DynamicObjectCollection customs = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
            for (DynamicObject custom : customs) {
                id2PropDys.put(custom.getLong("id"), custom);
            }
        }
        for (int i = 0; i < count; ++i) {
            if (((DynamicObject)doc.get(i)).get(ORG_NUMBER) != null) {
                Object org_number = this.getModel().getValue(ORG_NUMBER, i);
                if (org_number == null) continue;
                this.getModel().setValue(NUMBER, (Object)((DynamicObject)org_number).getString(NUMBER), i);
                this.getModel().setValue("name", (Object)((DynamicObject)org_number).getString("name"), i);
                this.getModel().setValue("basetype", (Object)"0", i);
                this.getModel().setValue("cynumber", (Object)((DynamicObject)org_number).getString("currency.number"), i);
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"membrange"});
                continue;
            }
            Object definedprop_number = this.getModel().getValue(DEFINEDPROP_NUMBER, i);
            if (definedprop_number == null) continue;
            DynamicObject definedpropDy = (DynamicObject)definedprop_number;
            DynamicObject propertyidId = (DynamicObject)id2PropDys.get(definedpropDy.getLong("propertyid_id"));
            String propNumber = propertyidId != null ? propertyidId.getString(NUMBER) : "";
            String propName = propertyidId != null ? propertyidId.getString("name") : "";
            this.getModel().setValue(NUMBER, (Object)(propNumber + ":" + definedpropDy.getString(NUMBER)), i);
            this.getModel().setValue("name", (Object)(propName + ":" + definedpropDy.getString("name")), i);
            this.getModel().setValue("basetype", (Object)"1", i);
            this.getModel().setValue("cynumber", (Object)"-", i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"membrange"});
        }
        this.getModel().endInit();
        this.getView().updateView(ORG_ENTRY);
    }

    private void setClickLable(ClosedCallBackEvent e, String ctrlKey, String cacheKey) {
        if (e.getReturnData() == null) {
            return;
        }
        if (SHEET_CLICK.equals(ctrlKey) || FILE_CLICK.equals(ctrlKey)) {
            Map returnData = (Map)e.getReturnData();
            String joiner = (String)returnData.get("joiner");
            List ruleNumbers = (List)returnData.get("ruleNumbers");
            List ruleNames = (List)returnData.get("ruleNames");
            String fixvalue = (String)returnData.get("txt");
            this.getPageCache().put(cacheKey, String.join((CharSequence)joiner, ruleNumbers));
            if (SHEET_CLICK.equals(ctrlKey)) {
                this.getPageCache().put(SHEETRULESELECT, this.toByteSerialized(ruleNumbers));
                this.getPageCache().put("sheetconectstr", joiner);
            } else if (FILE_CLICK.equals(ctrlKey)) {
                this.getPageCache().put(FILERULESELECT, this.toByteSerialized(ruleNumbers));
                this.getPageCache().put(CONNECT_STR, joiner);
            }
            this.getPageCache().put(cacheKey + "txt", fixvalue);
            Label label = (Label)this.getView().getControl(ctrlKey);
            label.setText(String.join((CharSequence)joiner, ruleNames));
            this.getPageCache().put(ctrlKey, String.join((CharSequence)joiner, ruleNames));
        }
    }

    private Map<String, String> getFileAndSheetCache() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        fileAndSheetKeys.forEach(key -> {
            String value = this.getPageCache().get(key);
            if (StringUtils.isNotEmpty((String)value)) {
                if (SHEETRULESELECT.equals(key)) {
                    List sheetRuleList = (List)this.deSerializedBytes(value);
                    map.put("sheetRuleList", ObjectSerialUtil.toJson((Object)sheetRuleList));
                } else if (FILERULESELECT.equals(key)) {
                    List fileRuleList = (List)this.deSerializedBytes(value);
                    map.put("fileRuleList", ObjectSerialUtil.toJson((Object)fileRuleList));
                } else {
                    map.put((String)key, value);
                }
            }
        });
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("excelfiletype".equals(propertyName)) {
            String excelfiletype = (String)e.getChangeSet()[0].getNewValue();
            this.setLabelName(excelfiletype);
        } else if ("pack_download".equals(propertyName)) {
            boolean value = (Boolean)e.getChangeSet()[0].getNewValue();
            this.setCheckbox("pack_download", value);
        } else if (AdjustBatchExportPlanHelper.BOX_STATUS.containsKey(propertyName)) {
            boolean value = AdjustBatchExportPlanHelper.BOX_STATUS.keySet().stream().allMatch(item -> (Boolean)this.getModel().getValue(item));
            this.getModel().beginInit();
            this.setCheckbox("box_all", value);
            this.getModel().endInit();
        } else if ("box_all".equals(propertyName)) {
            boolean value = (Boolean)this.getModel().getValue("box_all");
            this.getModel().beginInit();
            AdjustBatchExportPlanHelper.BOX_STATUS.keySet().forEach(item -> this.setCheckbox((String)item, value));
            this.getModel().endInit();
        }
    }

    private void setCheckbox(String key, boolean value) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)key);
        if (iDataEntityProperty != null) {
            this.getModel().setValue(key, (Object)value);
            this.getView().updateView(key);
        }
    }

    private void setLabelName(String excelfiletype) {
        Label sheetclicklabel = (Label)this.getView().getControl(SHEET_CLICK);
        Label fileclicklabel = (Label)this.getView().getControl(FILE_CLICK);
        if ("1".equals(excelfiletype)) {
            ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"orgnumber"});
            ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname"});
            HashMap<String, String> caches = new HashMap<String, String>(16);
            caches.put(FILERULESELECT, this.toByteSerialized(fileRuleNumbers));
            caches.put(SHEETRULESELECT, this.toByteSerialized(sheetRuleNumbers));
            caches.put(FILERULE, String.join((CharSequence)"_", fileRuleNumbers));
            caches.put(SHEETRULE, String.join((CharSequence)"", sheetRuleNumbers));
            String fileClick = ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0", (String)"AdjustBatchExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            String sheetClick = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            fileclicklabel.setText(fileClick);
            sheetclicklabel.setText(sheetClick);
            caches.put(SHEET_CLICK, sheetClick);
            caches.put(FILE_CLICK, fileClick);
            this.getPageCache().put(caches);
        } else if ("2".equals(excelfiletype)) {
            ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname"});
            ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"orgnumber", "orgname"});
            HashMap<String, String> caches = new HashMap<String, String>(16);
            caches.put(FILERULESELECT, this.toByteSerialized(fileRuleNumbers));
            caches.put(SHEETRULESELECT, this.toByteSerialized(sheetRuleNumbers));
            caches.put(FILERULE, String.join((CharSequence)"_", fileRuleNumbers));
            caches.put(SHEETRULE, String.join((CharSequence)"", sheetRuleNumbers));
            String fileClick = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801_\u7ec4\u7ec7\u540d\u79f0", (String)"AdjustBatchExportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            String sheetClick = ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0\u671f\u95f4\u540d\u79f0", (String)"ReportMultiExportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            fileclicklabel.setText(fileClick);
            sheetclicklabel.setText(sheetClick);
            caches.put(SHEET_CLICK, sheetClick);
            caches.put(FILE_CLICK, fileClick);
            this.getPageCache().put(caches);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bar_confirm".equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d", (String)"ReportMultiExportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            this.exportExcel();
            this.getView().hideLoading();
        } else {
            this.showFileSheetNameRuleView(key);
        }
    }

    public void showFileSheetNameRuleView(String key) {
        FormShowParameter fp = new FormShowParameter();
        fp.setFormId("bcm_adjexportfilerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        fp.setCloseCallBack(closeCallBack);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("filestyle", this.getModel().getValue("excelfiletype"));
        if (FILE_CLICK.equals(key)) {
            String connetStr = this.getPageCache().get(CONNECT_STR);
            params.put(CONNECT_STR, connetStr == null ? "_" : connetStr);
            params.put("txt", this.getPageCache().get("fileruletxt") == null ? "" : this.getPageCache().get("fileruletxt"));
            params.put("defaultruleselect", this.getPageCache().get(FILERULESELECT));
            params.put("issheetclick", Boolean.FALSE);
            fp.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u540d", (String)"ReportMultiExportPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (SHEET_CLICK.equals(key)) {
            String sheetconectstr = this.getPageCache().get("sheetconectstr");
            params.put(CONNECT_STR, sheetconectstr == null ? "" : sheetconectstr);
            params.put("txt", this.getPageCache().get("sheetruletxt") == null ? "" : this.getPageCache().get("sheetruletxt"));
            params.put("defaultruleselect", this.getPageCache().get(SHEETRULESELECT));
            params.put("issheetclick", Boolean.TRUE);
            fp.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u5185sheet\u5de5\u4f5c\u8868\u540d", (String)"ReportMultiExportPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        fp.setCustomParams(params);
        this.getView().showForm(fp);
    }

    public void exportExcel() {
        this.getPageCache().remove("download");
        AdjustBatchExportPlan plan = this.getPlanByCurrentView();
        AdjustBatchExportService service = new AdjustBatchExportService(plan);
        AdjustBatchExportPlanHelper.dispatch(service, this);
    }

    private AdjustBatchExportPlan getPlanByCurrentView() {
        AdjustBatchExportPlan plan = new AdjustBatchExportPlan();
        plan.setModelId(this.getModelId());
        if (this.getModel().getValue("scenario") == null) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AdjustBatchExportPlugin_33", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setScenarioId(((DynamicObject)this.getModel().getValue("scenario")).getLong("id"));
        if (this.getModel().getValue("cslscheme") != null) {
            plan.setCslSchemeId(((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"));
        }
        if (this.getModel().getValue(START_YEAR) == null || this.getModel().getValue(END_YEAR) == null || this.getModel().getValue(START_PERIOD) == null || this.getModel().getValue(END_PERIOD) == null) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ReportMultiExportPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.getPageCache().remove(DOWNLOADED);
        Set<String> selectStatus = this.getAdjStatus();
        if (CollectionUtils.isEmpty(selectStatus)) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5206\u5f55\u72b6\u6001\u3002", (String)"AdjustBatchExportPlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setSelectStatus(selectStatus);
        plan.setIncludeLink((Boolean)this.getModel().getValue("isincludelink"));
        List<Pair<String, Boolean>> tmpBaseFieldList = this.getFileds(BASE_FIELD_ENTITY, BASE_FIELD_NUM, false);
        if (tmpBaseFieldList.stream().noneMatch(item -> NUMBER.equalsIgnoreCase((String)item.p1) || "name".equalsIgnoreCase((String)item.p1))) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u201c\u5355\u636e\u7f16\u53f7\u201d\u6216\u8005\u201c\u540d\u79f0\u201d\u3002", (String)"AdjustBatchExportPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setBaseFieldList(tmpBaseFieldList.stream().map(e -> Pair.onePair((Object)e.p1, (Object)((Pair)AdjustExportConstant.getBaseFields().get((Object)e.p1)).p1)).collect(Collectors.toList()));
        plan.setAllBaseFieldList(this.getFileds(BASE_FIELD_ENTITY, BASE_FIELD_NUM, true));
        List<Tuple<String, String, String>> dimFieldList = this.getDimFileds(false).stream().map(e -> Tuple.create((Object)e.item1, (Object)e.item2, (Object)e.item3)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dimFieldList)) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"AdjustBatchExportPlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setDimFieldList(dimFieldList);
        plan.setAllDimFieldList(this.getDimFileds(true).stream().map(e -> Tuple.create((Object)e.item1, (Object)e.item3, (Object)e.item4)).collect(Collectors.toList()));
        List<Pair<String, Boolean>> amountfieldnum = this.getFileds(AMOUNT_ENTITY, AMOUNT_FIELD_NUM, false);
        if (amountfieldnum.stream().noneMatch(item -> "debit-credit".equalsIgnoreCase((String)item.p1) || "summoney".equalsIgnoreCase((String)item.p1))) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u201c\u501f\u8d37\u201d\u6216\u8005\u201c\u91d1\u989d\u201d\u3002", (String)"AdjustBatchExportPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setAllAmountFieldList(this.getFileds(AMOUNT_ENTITY, AMOUNT_FIELD_NUM, true));
        plan.setAmountFieldList(AdjustBatchExportPlanHelper.getAmountField(amountfieldnum));
        plan.setFileType((String)this.getModel().getValue(FILETYPE));
        plan.setStartYearId(((DynamicObject)this.getModel().getValue(START_YEAR)).getLong("id"));
        plan.setEndYearId(((DynamicObject)this.getModel().getValue(END_YEAR)).getLong("id"));
        plan.setStartPeriodId(((DynamicObject)this.getModel().getValue(START_PERIOD)).getLong("id"));
        plan.setEndPeriodId(((DynamicObject)this.getModel().getValue(END_PERIOD)).getLong("id"));
        List<FYPeriodPair> fyPeriodPairs = AdjustBatchExportPlanHelper.getFyPeriodPairs(plan);
        if (fyPeriodPairs.isEmpty()) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u8d22\u5e74\u671f\u95f4\u8303\u56f4\u3002", (String)"ReportMultiExportPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        Pair<Set<Long>, QueryOrgRange> effectOrgsPair = this.getEffectOrgs();
        if (((Set)effectOrgsPair.p1).isEmpty()) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u89e3\u6790\u51fa\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u7684\u9009\u62e9\u914d\u7f6e\u3002", (String)"AdjustBatchExportPlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        plan.setEffectOrgs((Set)effectOrgsPair.p1);
        plan.setOrgRange((QueryOrgRange)effectOrgsPair.p2);
        String excelFileType = (String)this.getModel().getValue("excelfiletype");
        plan.setExcelFileType(excelFileType);
        plan.setExcelFileType((String)this.getModel().getValue("excelfiletype"));
        plan.setFileruleStr(this.getPageCache().get(FILERULE));
        plan.setSheetruleStr(this.getPageCache().get(SHEETRULE));
        plan.setFiletxt(this.getPageCache().get("fileruletxt"));
        plan.setSheettxt(this.getPageCache().get("sheetruletxt"));
        plan.setFileAndSheetCache(this.getFileAndSheetCache());
        plan.setOrgList(this.getOrgList());
        plan.setPackDownload((Boolean)this.getModel().getValue("pack_download"));
        plan.setRepeatHead((Boolean)this.getModel().getValue("isrepeathead"));
        return plan;
    }

    private Set<String> getAdjStatus() {
        HashSet<String> status = new HashSet<String>(5);
        for (Map.Entry<String, String> kv : AdjustBatchExportPlanHelper.BOX_STATUS.entrySet()) {
            if (!((Boolean)this.getModel().getValue(kv.getKey())).booleanValue()) continue;
            status.add(kv.getValue());
        }
        return status;
    }

    private List<Pair<String, Boolean>> getFileds(String fieldEntity, String fileNum, boolean isGetAll) {
        ArrayList<Pair<String, Boolean>> result = new ArrayList<Pair<String, Boolean>>(16);
        EntryGrid baseentry = (EntryGrid)this.getView().getControl(fieldEntity);
        Set selectRows = Arrays.stream(baseentry.getSelectRows()).boxed().collect(Collectors.toSet());
        if (isGetAll) {
            DynamicObjectCollection fields = this.getModel().getEntryEntity(fieldEntity);
            for (int i = 0; i < fields.size(); ++i) {
                result.add((Pair<String, Boolean>)Pair.onePair((Object)((DynamicObject)fields.get(i)).getString(fileNum), (Object)selectRows.contains(i)));
            }
        } else {
            Iterator iterator = selectRows.iterator();
            while (iterator.hasNext()) {
                int selectRow = (Integer)iterator.next();
                result.add((Pair<String, Boolean>)Pair.onePair((Object)this.getModel().getValue(fileNum, selectRow).toString(), (Object)true));
            }
        }
        return result;
    }

    private List<FourTuple<String, String, String, Boolean>> getDimFileds(boolean isGetAll) {
        ArrayList<FourTuple<String, String, String, Boolean>> result = new ArrayList<FourTuple<String, String, String, Boolean>>(16);
        EntryGrid baseentry = (EntryGrid)this.getView().getControl(DIME_NTITY);
        Set selectRows = Arrays.stream(baseentry.getSelectRows()).boxed().collect(Collectors.toSet());
        if (isGetAll) {
            DynamicObjectCollection fields = this.getModel().getEntryEntity(DIME_NTITY);
            for (int i = 0; i < fields.size(); ++i) {
                result.add((FourTuple<String, String, String, Boolean>)new FourTuple((Object)((DynamicObject)fields.get(i)).getString("dimnum"), (Object)((DynamicObject)fields.get(i)).getString("dimname"), (Object)((DynamicObject)fields.get(i)).getString("display"), (Object)selectRows.contains(i)));
            }
        } else {
            Iterator iterator = selectRows.iterator();
            while (iterator.hasNext()) {
                int selectRow = (Integer)iterator.next();
                result.add((FourTuple<String, String, String, Boolean>)new FourTuple((Object)this.getModel().getValue("dimnum", selectRow).toString(), (Object)this.getModel().getValue("dimname", selectRow).toString(), (Object)this.getModel().getValue("display", selectRow).toString(), (Object)true));
            }
        }
        return result;
    }

    private Pair<Set<Long>, QueryOrgRange> getEffectOrgs() {
        DynamicObjectCollection orgs = this.getModel().getEntryEntity(ORG_ENTRY);
        HashSet effectOrgIds = new HashSet(16);
        boolean isCustom = false;
        ArrayList<Pair> rangeItems = new ArrayList<Pair>(orgs.size());
        for (DynamicObject org : orgs) {
            long mid = 0L;
            String number = "";
            if ("1".equals(org.getString("basetype"))) {
                mid = org.getLong("definedprop_number_id");
                number = org.getDynamicObject(DEFINEDPROP_NUMBER).getString(NUMBER);
                isCustom = true;
            } else {
                mid = org.getLong("org_number_id");
                number = org.getDynamicObject(ORG_NUMBER).getString(NUMBER);
            }
            rangeItems.add(Pair.onePair((Object)mid, (Object)org.getInt("membrange")));
            new MembRangeItem("bcm_entitymembertree", Long.valueOf(mid), number, org.getInt("membrange"), isCustom, (Object)this.getModelId()).matchItems(e -> effectOrgIds.add(e.getId()));
        }
        return Pair.onePair(effectOrgIds, (Object)new QueryOrgRange(isCustom, rangeItems));
    }

    @Override
    public void destory() {
        this.getView().hideLoading();
        super.destory();
    }
}

