/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.export.QueryAdjustParam;
import kd.fi.bcm.business.adjust.model.export.QueryAdjustResult;
import kd.fi.bcm.business.adjust.model.export.QueryOrgRange;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.YesOrNoEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlan;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportPlanHelper;
import kd.fi.bcm.formplugin.innertrade.export.IntrReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class AdjustBatchExportService
implements Serializable {
    private static final long serialVersionUID = -2899882734365392773L;
    private static final Log log = LogFactory.getLog(IntrReportMultiExportService.class);
    public static final int ROW_ACCESS_WINDOW_SIZE = 50000;
    public static final int MAX_SHEET_COUNT = 200;
    public static final int TASK_BATCH_SIZE = 200;
    private Long modelId;
    private String modelNum;
    private Long userId;
    private Long sceneId;
    private List<FYPeriodPair> fyPeriodPairs;
    private List<Pair<String, String>> baseFieldList = new ArrayList<Pair<String, String>>(16);
    private List<Tuple<String, String, String>> dimFieldList = new ArrayList<Tuple<String, String, String>>(16);
    private List<Pair<String, String>> amountFieldList = new ArrayList<Pair<String, String>>(16);
    private String exportType;
    private String excelType;
    private Set<Long> effectOrgIds;
    private DynamicObjectCollection effectOrgs;
    private QueryOrgRange orgRange;
    private boolean isPackDownload;
    private boolean isRepeatHead;
    private String fileRuleStr;
    private String sheetRuleStr;
    private String filetxt;
    private String sheettxt;
    private boolean isIncludeLink;
    public Set<String> selectStatus = new HashSet<String>(16);
    private ConcurrentHashMap<String, String> fileMap = new ConcurrentHashMap(16);
    private Integer allSheetCount;
    private AtomicInteger completeSheet = new AtomicInteger(0);
    ConcurrentHashMap<String, SXSSFWorkbook> allWorkbooxMap = new ConcurrentHashMap(16);
    Map<String, AtomicInteger> fileSheetCount = new HashMap<String, AtomicInteger>(16);
    private Supplier<Boolean> isTaskStop;
    private BiConsumer<Integer, String> taskConsumer;
    private HashMultimap<String, String> fileNames = HashMultimap.create();
    private LinkedHashMap<String, PermPackageList> dimPermMap = new LinkedHashMap(1);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private SimpleDateFormat sdfss = new SimpleDateFormat("yyyyMMddHHmmss");
    private StringBuffer errorMsg = new StringBuffer();
    private static final int DEFAULT_WIDTH = 3840;
    private Map<String, String> bizType = null;
    private boolean isAdmin = false;
    private Pair<Set<Long>, String> adjustFilter;

    public AdjustBatchExportService(AdjustBatchExportPlan plan) {
        this.modelId = plan.getModelId();
        this.modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        this.userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        this.sceneId = plan.getScenarioId();
        this.baseFieldList = plan.getBaseFieldList();
        this.dimFieldList = plan.getDimFieldList();
        this.amountFieldList = plan.getAmountFieldList();
        this.fyPeriodPairs = AdjustBatchExportPlanHelper.getFyPeriodPairs(plan);
        this.exportType = plan.getExcelFileType();
        this.excelType = plan.getFileType();
        this.effectOrgIds = plan.getEffectOrgs();
        this.orgRange = plan.getOrgRange();
        Set orgIdSet = this.effectOrgIds.stream().map(s -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((String)this.modelNum, (Long)s);
            return node.getBaseTreeNode().getId();
        }).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.modelId);
        qf.add("id", "in", orgIdSet);
        this.effectOrgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,longnumber,name,simplename,orgcode,currency.number,currency.name", (QFilter[])qf.toArray());
        this.isPackDownload = plan.isPackDownload();
        this.isRepeatHead = plan.isRepeatHead();
        this.isIncludeLink = plan.isIncludeLink();
        this.selectStatus = plan.getSelectStatus();
        this.fileRuleStr = plan.getFileruleStr();
        this.sheetRuleStr = plan.getSheetruleStr();
        this.filetxt = plan.getFiletxt();
        this.sheettxt = plan.getSheettxt();
        this.allSheetCount = this.effectOrgIds.size() * this.fyPeriodPairs.size();
        this.adjustFilter = plan.getAdjustFilter();
        this.bizType = AdjustBusinessTypeUtil.getBizType((long)this.modelId);
        this.isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)this.userId, (String)String.valueOf(this.modelId));
        if (!this.isAdmin) {
            PermissionService permService = PermissionServiceImpl.getInstance((Long)this.modelId);
            SchemeContext dimctx = new SchemeContext(this.modelId.longValue());
            this.dimPermMap = dimctx.getDimensions().stream().collect(Collectors.toMap(Dimension::getFieldmapped, v -> permService.getDimPermSet(v.getId()), (e1, e2) -> e2, LinkedHashMap::new));
        }
    }

    public Map<String, String> doExportExcels() {
        String finalFileName;
        XSSFCellStyle finalDataCellStyle;
        XSSFCellStyle finalHeadCellStyle;
        SXSSFSheet sheet;
        String sheetName;
        AtomicInteger sheetCount;
        SetMultimap sheetNames;
        XSSFCellStyle dataCellStyle;
        XSSFCellStyle headCellStyle;
        SXSSFWorkbook workbook;
        String fileName;
        QueryAdjustParam param = this.getQueryParam();
        QueryAdjustResult adjustData = this.getAdjustData(param);
        Map<Object, Object> permclassMap = param.isContainPermClass() ? PermClassEntityHelper.queryTotalDimensionPermissionClass((long)this.modelId, (String)"bcm_rptadjust", (Collection)adjustData.getAdjustPkSet()).stream().collect(Collectors.toMap(k -> k.getLong("entityid"), v -> v.getString("permclass.number"), (e1, e2) -> e2)) : new HashMap(1);
        this.taskConsumer.accept(0, ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u6587\u4ef6\u2026\u2026", (String)"AdjustBatchExportService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ArrayList<IRunner> taskList = new ArrayList<IRunner>(16);
        if ("1".equals(this.exportType)) {
            for (FYPeriodPair fyPeriodPair : this.fyPeriodPairs) {
                fileName = this.getFileName((SetMultimap<String, String>)this.fileNames, null, fyPeriodPair, this.fileRuleStr, this.filetxt);
                this.fileSheetCount.put(fileName, new AtomicInteger(0));
                workbook = new SXSSFWorkbook(50000);
                this.allWorkbooxMap.put(fileName, workbook);
                headCellStyle = this.getHeadCellStyle(workbook);
                dataCellStyle = this.getDataCellStyle(workbook);
                sheetNames = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
                for (DynamicObject org : this.effectOrgs) {
                    sheetCount = this.fileSheetCount.get(fileName);
                    if (sheetCount.get() >= 200) {
                        fileName = this.getFileName((SetMultimap<String, String>)this.fileNames, null, fyPeriodPair, this.fileRuleStr, this.filetxt);
                        workbook = new SXSSFWorkbook(50000);
                        this.allWorkbooxMap.put(fileName, workbook);
                        headCellStyle = this.getHeadCellStyle(workbook);
                        dataCellStyle = this.getDataCellStyle(workbook);
                        sheetNames = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
                        sheetCount = new AtomicInteger(0);
                        this.fileSheetCount.put(fileName, sheetCount);
                    }
                    sheetName = this.getSheetName((SetMultimap<String, String>)sheetNames, org, fyPeriodPair, this.sheetRuleStr, this.sheettxt);
                    if (!adjustData.isEmpty(this.getFyPeriodKey(fyPeriodPair), org.getString("number"))) {
                        sheet = workbook.createSheet(sheetName);
                        sheet.createFreezePane(0, 1, 0, 1);
                        finalHeadCellStyle = headCellStyle;
                        finalDataCellStyle = dataCellStyle;
                        finalFileName = fileName;
                        taskList.add(() -> this.createSheet(finalFileName, sheet, finalHeadCellStyle, finalDataCellStyle, permclassMap, fyPeriodPair, org, adjustData));
                        sheetCount.incrementAndGet();
                        continue;
                    }
                    this.closeBackCompleteOneSheet(fileName, false);
                    log.info("\u6ca1\u627e\u5230" + org.getString("number") + "_" + this.getFyPeriodKey(fyPeriodPair) + "\u7684\u5206\u5f55\u6570\u636e\u3002");
                }
                if (taskList.size() < 200 || this.isTaskStop.get().booleanValue()) continue;
                ThreadPoolService.runInWaitingAdjExportTaskThread((IRunner[])taskList.toArray(new IRunner[0]));
                taskList.clear();
            }
        }
        if ("2".equals(this.exportType)) {
            for (DynamicObject org : this.effectOrgs) {
                fileName = this.getFileName((SetMultimap<String, String>)this.fileNames, org, null, this.fileRuleStr, this.filetxt);
                this.fileSheetCount.put(fileName, new AtomicInteger(0));
                workbook = new SXSSFWorkbook(50000);
                this.allWorkbooxMap.put(fileName, workbook);
                headCellStyle = this.getHeadCellStyle(workbook);
                dataCellStyle = this.getDataCellStyle(workbook);
                sheetNames = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
                for (FYPeriodPair fyPeriodPair : this.fyPeriodPairs) {
                    sheetCount = this.fileSheetCount.get(fileName);
                    if (sheetCount.get() >= 200) {
                        fileName = this.getFileName((SetMultimap<String, String>)this.fileNames, org, null, this.fileRuleStr, this.filetxt);
                        workbook = new SXSSFWorkbook(50000);
                        this.allWorkbooxMap.put(fileName, workbook);
                        headCellStyle = this.getHeadCellStyle(workbook);
                        dataCellStyle = this.getDataCellStyle(workbook);
                        sheetNames = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
                        sheetCount = new AtomicInteger(0);
                        this.fileSheetCount.put(fileName, sheetCount);
                    }
                    sheetName = this.getSheetName((SetMultimap<String, String>)sheetNames, org, fyPeriodPair, this.sheetRuleStr, this.sheettxt);
                    if (!adjustData.isEmpty(this.getFyPeriodKey(fyPeriodPair), org.getString("number"))) {
                        sheet = workbook.createSheet(sheetName);
                        sheet.createFreezePane(0, 1, 0, 1);
                        finalHeadCellStyle = headCellStyle;
                        finalDataCellStyle = dataCellStyle;
                        finalFileName = fileName;
                        taskList.add(() -> this.createSheet(finalFileName, sheet, finalHeadCellStyle, finalDataCellStyle, permclassMap, fyPeriodPair, org, adjustData));
                        sheetCount.incrementAndGet();
                        continue;
                    }
                    this.closeBackCompleteOneSheet(fileName, false);
                    log.info("\u6ca1\u627e\u5230" + org.getString("number") + "_" + this.getFyPeriodKey(fyPeriodPair) + "\u7684\u5206\u5f55\u6570\u636e\u3002");
                }
            }
            if (taskList.size() >= 200 && !this.isTaskStop.get().booleanValue()) {
                ThreadPoolService.runInWaitingAdjExportTaskThread((IRunner[])taskList.toArray(new IRunner[0]));
                taskList.clear();
            }
        }
        if (!this.isTaskStop.get().booleanValue()) {
            ThreadPoolService.runInWaitingAdjExportTaskThread((IRunner[])taskList.toArray(new IRunner[0]));
        } else {
            this.taskConsumer.accept(100, null);
        }
        return this.fileMap;
    }

    private List<Pair<IDynamicObjectModel, List<Row>>> searchAdjData(FYPeriodPair fyPeriodPair, DynamicObject org, QueryAdjustResult adjustData) {
        try {
            return adjustData.search(this.getFyPeriodKey(fyPeriodPair), org.getString("number"));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s_%2$s:\u83b7\u53d6\u6570\u636e\u5931\u8d25\u3002", (String)"AdjustBatchExportService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), org.getString("number"), this.getFyPeriodKey(fyPeriodPair));
            log.error(msg, (Throwable)e);
            this.errorMsg.append(msg);
            return null;
        }
    }

    private String getFyPeriodKey(FYPeriodPair fyPeriodPair) {
        return fyPeriodPair.getFy().getString("number") + "_" + fyPeriodPair.getPeriod().getString("number");
    }

    private QueryAdjustParam getQueryParam() {
        boolean isContainPermClass = false;
        ArrayList<Object> baseFields = new ArrayList<Object>(this.baseFieldList.size());
        for (Pair<String, String> field : this.baseFieldList) {
            if ("permission.number".equalsIgnoreCase((String)field.p1)) {
                isContainPermClass = true;
                continue;
            }
            if ("belongorg".equalsIgnoreCase((String)field.p1)) {
                baseFields.add("belongorg");
                baseFields.add("belongorg.number");
                baseFields.add("belongorg.name");
                continue;
            }
            baseFields.add(field.p1);
        }
        List amountFields = this.amountFieldList.stream().map(e -> (String)e.p1).collect(Collectors.toList());
        amountFields.add("groupnum");
        amountFields.add("dseq");
        QueryAdjustParam param = new QueryAdjustParam(this.modelId.longValue(), this.orgRange, this.sceneId.longValue(), this.fyPeriodPairs.stream().map(e -> Pair.onePair((Object)e.getFy().getLong("id"), (Object)e.getPeriod().getLong("id"))).collect(Collectors.toList()), this.isIncludeLink, this.selectStatus, baseFields, this.dimFieldList.stream().map(e -> (String)e.p1).collect(Collectors.toList()), amountFields, isContainPermClass);
        if (this.adjustFilter != null) {
            param.setAdjustIds((Set)this.adjustFilter.p1);
            param.setOrderBy((String)this.adjustFilter.p2);
        }
        return param;
    }

    private QueryAdjustResult getAdjustData(QueryAdjustParam param) {
        long startTime = System.currentTimeMillis();
        QueryAdjustResult result = AdjustQueryServiceHelper.queryDataForExport((QueryAdjustParam)param);
        long endTime = System.currentTimeMillis();
        log.info("\u5206\u5f55\u6279\u91cf\u5bfc\u51fa\u83b7\u53d6\u5206\u5f55\u6570\u636e\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff0c\u5206\u5f55\u6761\u6570\uff1a" + result.getAdjustPkSet().size());
        return result;
    }

    private String getFileName(SetMultimap<String, String> sheetNames, DynamicObject org, FYPeriodPair fyPeriodPair, String nameRuleStr, String fixTxt) {
        return this.getCustomName(sheetNames, org, fyPeriodPair, nameRuleStr, fixTxt) + "." + this.getFileSuffix();
    }

    private String getSheetName(SetMultimap<String, String> sheetNames, DynamicObject org, FYPeriodPair fyPeriodPair, String sheetRuleStr, String sheettxt) {
        return AdjustBatchExportService.createSafeSheetName(this.getCustomName(sheetNames, org, fyPeriodPair, sheetRuleStr, sheettxt), '_');
    }

    private void addToResultMap(String fileDownloadUrl, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileDownloadUrl)) {
            this.fileMap.put(fileDownloadUrl, fileName);
        }
    }

    private String getCustomName(SetMultimap<String, String> sheetNames, DynamicObject org, FYPeriodPair fyPeriodPair, String nameRuleStr, String fixTxt) {
        String customName = nameRuleStr;
        if (org != null) {
            customName = customName.replace("orgnumber", org.getString("number"));
            customName = customName.replace("orgname", org.getString("name"));
            customName = customName.replace("orgcode", org.getString("orgcode"));
            customName = customName.replace("orgsimplename", org.getString("simplename"));
            customName = customName.replace("currencynumber", org.getString("number"));
            customName = customName.replace("currencyname", org.getString("name"));
        }
        if (fyPeriodPair != null) {
            if (fyPeriodPair.getFy() != null) {
                customName = customName.replace("yearnumber", fyPeriodPair.getFy().getString("number"));
                customName = customName.replace("yearname", fyPeriodPair.getFy().getString("name"));
            }
            if (fyPeriodPair.getFy() != null) {
                customName = customName.replace("periodnumber", fyPeriodPair.getPeriod().getString("number"));
                customName = customName.replace("periodname", fyPeriodPair.getPeriod().getString("name"));
            }
        }
        customName = customName.replace("systemtime", this.sdf.format(new Date()));
        String safeName = customName = customName.replace("txt", StringUtils.isEmpty((CharSequence)fixTxt) ? "" : fixTxt);
        if (!sheetNames.get((Object)customName).isEmpty()) {
            String addr = "(" + sheetNames.get((Object)customName).size() + ")";
            int length = customName.length();
            int addrLength = addr.length();
            if (length >= 29) {
                safeName = safeName.substring(0, 31 - addrLength);
            }
            safeName = safeName + addr;
        }
        sheetNames.put((Object)customName, (Object)safeName);
        return safeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFileDownloadUrl(String fileName, SXSSFWorkbook workbook) {
        if (workbook == null || !workbook.iterator().hasNext()) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            String string = this.downloadFile(out, fileName);
            return string;
        }
        catch (IOException e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (workbook != null) {
                    try {
                        workbook.dispose();
                        workbook.close();
                    }
                    catch (IOException e) {
                        log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                    }
                }
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        return "";
    }

    public String getFileSuffix() {
        switch (this.excelType) {
            case "0": {
                return "xls";
            }
            case "3": {
                return "xlsx";
            }
        }
        return "xlsx";
    }

    public String downloadFile(ByteArrayOutputStream oo, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return cache.saveAsUrl(fileName, oo.toByteArray(), 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createSheet(String fileName, SXSSFSheet sheet, XSSFCellStyle headCellStyle, XSSFCellStyle finalDataCellStyle, Map<Long, String> permclassMap, FYPeriodPair fyPeriodPair, DynamicObject org, QueryAdjustResult adjustData) {
        try {
            if (this.isTaskStop.get().booleanValue()) {
                this.taskConsumer.accept(100, null);
                return;
            }
            List<Pair<IDynamicObjectModel, List<Row>>> data = this.searchAdjData(fyPeriodPair, org, adjustData);
            if (data != null) {
                this.buildHead(sheet, headCellStyle);
                int rowIndex = 1;
                int allRowSize = this.baseFieldList.size() + this.dimFieldList.size() + this.amountFieldList.size() + 2;
                for (int i = 0; i < data.size(); ++i) {
                    void var17_19;
                    Pair<IDynamicObjectModel, List<Row>> rowData = data.get(i);
                    SXSSFRow row = this.getOrCreateRow(sheet, rowIndex);
                    int baseColIndex = 0;
                    for (Pair<String, String> pair : this.baseFieldList) {
                        String value = this.dealValue(pair, (IDynamicObjectModel)rowData.p1, permclassMap);
                        this.getCell(row, baseColIndex, finalDataCellStyle).setCellValue(value);
                        ++baseColIndex;
                    }
                    if (rowData.p2 == null || ((List)rowData.p2).isEmpty()) {
                        ++rowIndex;
                    } else {
                        String groupNum = null;
                        for (Row entryData : (List)rowData.p2) {
                            int entryColIndex = baseColIndex;
                            boolean isNoPerm = this.isNoPerm(entryData);
                            String tmpGroupNum = entryData.getString("groupnum");
                            if (groupNum != null && !groupNum.equalsIgnoreCase(tmpGroupNum)) {
                                SXSSFRow rowSplit = this.getOrCreateRow(sheet, rowIndex);
                                for (int c = this.baseFieldList.size(); c < allRowSize; ++c) {
                                    this.getCell(rowSplit, c, finalDataCellStyle).setCellValue("---------------------------------------");
                                }
                                ++rowIndex;
                            }
                            groupNum = tmpGroupNum;
                            SXSSFRow entryRow = this.getOrCreateRow(sheet, rowIndex);
                            if (this.isRepeatHead && entryRow.getRowNum() > row.getRowNum()) {
                                int repeatBaseColIndex = 0;
                                for (Pair<String, String> baseField2 : this.baseFieldList) {
                                    String value = this.dealValue(baseField2, (IDynamicObjectModel)rowData.p1, permclassMap);
                                    this.getCell(entryRow, repeatBaseColIndex, finalDataCellStyle).setCellValue(value);
                                    ++repeatBaseColIndex;
                                }
                            }
                            this.getCell(entryRow, entryColIndex, finalDataCellStyle).setCellValue(tmpGroupNum);
                            this.getCell(entryRow, ++entryColIndex, finalDataCellStyle).setCellValue(entryData.getString("dseq"));
                            ++entryColIndex;
                            for (Tuple<String, String, String> tuple : this.dimFieldList) {
                                this.getCell(entryRow, entryColIndex, finalDataCellStyle).setCellValue(IntrReportHelper.getDisplayName((String)entryData.getString((String)tuple.p1 + ".number"), (String)entryData.getString((String)tuple.p1 + ".name"), (String)((String)tuple.p3)));
                                ++entryColIndex;
                            }
                            for (Pair pair : this.amountFieldList) {
                                BigDecimal value = entryData.getBigDecimal((String)pair.p1);
                                if (isNoPerm) {
                                    this.getCell(entryRow, entryColIndex, null).setCellValue("***");
                                } else if (value == null) {
                                    this.getCell(entryRow, entryColIndex, null).setCellValue("");
                                } else {
                                    this.getCell(entryRow, entryColIndex, null).setCellValue(value.stripTrailingZeros().doubleValue());
                                }
                                ++entryColIndex;
                            }
                            ++rowIndex;
                        }
                    }
                    SXSSFRow rowSplit = this.getOrCreateRow(sheet, rowIndex);
                    boolean bl = false;
                    while (var17_19 < allRowSize) {
                        this.getCell(rowSplit, (int)var17_19, finalDataCellStyle).setCellValue("---------------------------------------");
                        ++var17_19;
                    }
                    ++rowIndex;
                }
            }
        }
        catch (Throwable e) {
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u6210sheet\u5931\u8d25\u3002", (String)"AdjustBatchExportService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), org.getString("number") + "_" + this.getFyPeriodKey(fyPeriodPair));
            log.error(msg, e);
            this.errorMsg.append(msg);
        }
        finally {
            this.closeBackCompleteOneSheet(fileName, true);
        }
    }

    private String dealValue(Pair<String, String> baseField, IDynamicObjectModel headData, Map<Long, String> permclassMap) {
        String value = null;
        switch ((String)baseField.p1) {
            case "belongorg": {
                value = IntrReportHelper.getDisplayName((String)headData.getString((String)baseField.p1 + ".number"), (String)headData.getString((String)baseField.p1 + ".name"), (IntrDimDisplayModeEnum)IntrDimDisplayModeEnum.NUMBERANDNAME);
                break;
            }
            case "journaltype": {
                JournalTypeEnum jtype = JournalTypeEnum.getEumByKey((String)headData.getString((String)baseField.p1));
                value = jtype == null ? "" : jtype.getValue();
                break;
            }
            case "balancetype": {
                BalanceTypeEnum btype = BalanceTypeEnum.getEnumByIndex((int)headData.getInt((String)baseField.p1));
                value = btype == null ? "" : btype.getName();
                break;
            }
            case "linkcreatetype": {
                AdjustLinkCreateEnum linkType = AdjustLinkCreateEnum.searchByStatus((String)headData.getString((String)baseField.p1));
                value = linkType == null ? "" : linkType.getName();
                break;
            }
            case "multiplecurrency": {
                YesOrNoEnum ynType = YesOrNoEnum.getEnumByIndex((String)headData.getString((String)baseField.p1));
                value = ynType == null ? "" : ynType.getName();
                break;
            }
            case "permission.number": {
                value = permclassMap.get(headData.getLong("id"));
                break;
            }
            case "bussnesstype": {
                value = IntrReportHelper.getDisplayName((String)headData.getString((String)baseField.p1), (String)this.bizType.get(headData.getString((String)baseField.p1)), (IntrDimDisplayModeEnum)IntrDimDisplayModeEnum.NUMBERANDNAME);
                break;
            }
            default: {
                value = headData.getString((String)baseField.p1);
            }
        }
        return value;
    }

    private boolean isNoPerm(Row entryRow) {
        if (this.isAdmin) {
            return false;
        }
        for (Map.Entry<String, PermPackageList> kv : this.dimPermMap.entrySet()) {
            Long memberId = entryRow.getLong(kv.getKey().toLowerCase(Locale.ENGLISH) + ".id");
            if (PermEnum.NOPERM != kv.getValue().getPermEnum(memberId.longValue(), this.userId.longValue())) continue;
            return true;
        }
        return false;
    }

    private void buildHead(SXSSFSheet sheet, XSSFCellStyle headCellStyle) {
        SXSSFCell cell;
        SXSSFRow headRow = this.getOrCreateRow(sheet, 0);
        int colIndex = 0;
        for (Pair<String, String> baseField : this.baseFieldList) {
            SXSSFCell cell2 = this.getHeadCell(sheet, headCellStyle, colIndex, headRow);
            cell2.setCellValue((String)baseField.p2);
            ++colIndex;
        }
        SXSSFCell groupNumCell = this.getHeadCell(sheet, headCellStyle, colIndex, headRow);
        groupNumCell.setCellValue(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7", (String)"AdjustBatchExportService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        SXSSFCell seqCell = this.getHeadCell(sheet, headCellStyle, ++colIndex, headRow);
        seqCell.setCellValue(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AdjustBatchExportService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ++colIndex;
        for (Tuple<String, String, String> tuple : this.dimFieldList) {
            cell = this.getHeadCell(sheet, headCellStyle, colIndex, headRow);
            cell.setCellValue((String)tuple.p2);
            ++colIndex;
        }
        for (Pair pair : this.amountFieldList) {
            cell = this.getHeadCell(sheet, headCellStyle, colIndex, headRow);
            cell.setCellValue((String)pair.p2);
            ++colIndex;
        }
    }

    private SXSSFCell getHeadCell(SXSSFSheet sheet, XSSFCellStyle headCellStyle, int colIndex, SXSSFRow headRow) {
        sheet.setColumnWidth(colIndex, 3840);
        SXSSFCell cell = this.getCell(headRow, colIndex, null);
        cell.setCellStyle((CellStyle)headCellStyle);
        return cell;
    }

    private XSSFCellStyle getHeadCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle headStyle = wb.getXSSFWorkbook().createCellStyle();
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setFillForegroundColor(this.getXSSFColor("c2c2c2"));
        return headStyle;
    }

    private XSSFCellStyle getDataCellStyle(SXSSFWorkbook wb) {
        XSSFCellStyle dataStyle = wb.getXSSFWorkbook().createCellStyle();
        dataStyle.setDataFormat(wb.createDataFormat().getFormat("@"));
        return dataStyle;
    }

    private XSSFColor getXSSFColor(String colorHex) {
        int r = Integer.parseInt(colorHex.substring(0, 2), 16);
        int g = Integer.parseInt(colorHex.substring(2, 4), 16);
        int b = Integer.parseInt(colorHex.substring(4, 6), 16);
        return new XSSFColor(new Color(r, g, b), (IndexedColorMap)new DefaultIndexedColorMap());
    }

    private SXSSFRow getOrCreateRow(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private SXSSFCell getCell(SXSSFRow row, int colIndex, XSSFCellStyle dataCellStyle) {
        SXSSFCell cell = row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        if (dataCellStyle != null) {
            cell.setCellStyle((CellStyle)dataCellStyle);
        }
        return cell;
    }

    public static String createSafeSheetName(String nameProposal, char replaceChar) {
        if (nameProposal == null) {
            return "null";
        }
        if (nameProposal.length() < 1) {
            return "empty";
        }
        nameProposal = nameProposal.replaceAll("\n", "");
        int length = Math.min(31, nameProposal.length());
        String shortenname = nameProposal.substring(0, length);
        StringBuilder result = new StringBuilder(shortenname);
        block4: for (int i = 0; i < length; ++i) {
            char ch = result.charAt(i);
            switch (ch) {
                case '\u0000': 
                case '\u0003': 
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '\uff1a': {
                    result.setCharAt(i, replaceChar);
                    continue block4;
                }
                case '\'': {
                    if (i != 0 && i != length - 1) continue block4;
                    result.setCharAt(i, replaceChar);
                }
            }
        }
        return result.toString();
    }

    private void closeBackCompleteOneSheet(String fileName, boolean isCreateFile) {
        this.taskConsumer.accept(this.completeSheet.incrementAndGet() * 100 / this.allSheetCount, ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u6587\u4ef6\u2026\u2026", (String)"AdjustBatchExportService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (isCreateFile) {
            AtomicInteger sheetCount = this.fileSheetCount.get(fileName);
            SXSSFWorkbook workbook = this.allWorkbooxMap.get(fileName);
            if (sheetCount != null && sheetCount.decrementAndGet() <= 0 && workbook != null) {
                this.fileMap.put(this.createFileDownloadUrl(fileName, workbook), fileName);
                this.allWorkbooxMap.remove(fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> zipFiles() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        String fileName = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u5206\u5f55\u6587\u4ef6%s.zip", (String)"AdjustBatchExportService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.sdfss.format(new Date()));
        byte[] buffer = new byte[512];
        int readLength = 0;
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        InputStream inputStream = null;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (!this.fileMap.isEmpty()) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)oo, Charset.forName("GBK"));){
                for (Map.Entry<String, String> entry : this.fileMap.entrySet()) {
                    ZipEntry z = new ZipEntry(entry.getValue());
                    zipOutputStream.putNextEntry(z);
                    inputStream = cache.getInputStream(entry.getKey());
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    inputStream.close();
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.finish();
                result.put(cache.saveAsUrl(fileName, oo.toByteArray(), 5000), fileName);
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
            finally {
                try {
                    oo.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return result;
    }

    public void setTaskConsumer(BiConsumer<Integer, String> taskConsumer) {
        this.taskConsumer = taskConsumer;
    }

    public boolean isPackDownload() {
        return this.isPackDownload;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setIsTaskStop(Supplier<Boolean> isTaskStop) {
        this.isTaskStop = isTaskStop;
    }

    public StringBuffer getErrorMsg() {
        return this.errorMsg;
    }
}

