/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.export;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.adjust.export.AdjustBatchExportService;
import org.apache.commons.lang3.StringUtils;

public class AdjustBatchExportTask
extends AbstractTask {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AdjustBatchExportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        log.startWatch();
        Recorder serviceRecord = new Recorder(null);
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u6570\u636e\u2026\u2026", (String)"AdjustBatchExportTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        Map<Object, Object> data = new HashMap(16);
        String message = "";
        Date now = TimeServiceHelper.now();
        try {
            if (this.isStop()) {
                this.stop();
            }
            if (params.containsKey("service")) {
                String serviceStr = (String)params.get("service");
                serviceRecord.setRecord(ObjectSerialUtil.deSerializedBytes((String)serviceStr));
                ((AdjustBatchExportService)serviceRecord.getRecord()).setIsTaskStop(() -> ((AdjustBatchExportTask)this).isStop());
                ((AdjustBatchExportService)serviceRecord.getRecord()).setTaskConsumer((percent, msg) -> {
                    if (this.isStop()) {
                        this.feedbackProgress((int)percent, ResManager.loadKDString((String)"\u6b63\u5728\u505c\u6b62\u4efb\u52a1\u2026\u2026", (String)"AdjustBatchExportTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                        this.stop();
                    } else {
                        this.feedbackProgress((int)percent, (String)msg, null);
                    }
                });
                if (((AdjustBatchExportService)serviceRecord.getRecord()).isPackDownload()) {
                    ((AdjustBatchExportService)serviceRecord.getRecord()).doExportExcels();
                    data.putAll(((AdjustBatchExportService)serviceRecord.getRecord()).zipFiles());
                } else {
                    data = ((AdjustBatchExportService)serviceRecord.getRecord()).doExportExcels();
                }
            }
        }
        catch (Exception e) {
            message = ThrowableHelper.toString((Exception)e);
            log.error((Throwable)e);
        }
        if (!this.isStop()) {
            ArrayList<DynamicObject> urlDys = new ArrayList<DynamicObject>(16);
            SimpleDateFormat sdfss = new SimpleDateFormat("yyyyMMddHHmmss");
            for (Map.Entry kv : data.entrySet()) {
                DynamicObject urlDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exporturllist");
                urlDy.set("url", kv.getKey());
                urlDy.set("filename", (Object)this.addTimeStamp(sdfss, (String)kv.getValue()));
                urlDy.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                urlDy.set("createdate", (Object)now);
                urlDy.set("modifydate", (Object)now);
                urlDy.set("type", (Object)ExportPageSourceEnum.ADJUST.getIndex());
                urlDy.set("log", (Object)message);
                urlDy.set("model", (Object)((AdjustBatchExportService)serviceRecord.getRecord()).getModelId());
                urlDys.add(urlDy);
            }
            SaveServiceHelper.save((DynamicObject[])urlDys.toArray(new DynamicObject[0]));
            Set urls = data.keySet();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", "true");
            result.put("data", urls);
            result.put("excelMsg", ((AdjustBatchExportService)serviceRecord.getRecord()).getErrorMsg().toString());
            result.put("message", message);
            log.infoEnd("\u5206\u5f55\u6279\u91cf\u5bfc\u51fa\u6587\u4ef6\u8def\u5f84\uff1a" + String.join((CharSequence)",", urls));
            this.feedbackCustomdata(result);
        }
    }

    private String addTimeStamp(SimpleDateFormat sdfss, String fileName) {
        String name = StringUtils.substringBeforeLast((String)fileName, (String)".");
        String ext = StringUtils.substringAfterLast((String)fileName, (String)".");
        return name + "_" + sdfss.format(new Date()) + "." + ext;
    }
}

