/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.model.AreaPositionManger;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.lang3.math.NumberUtils;

public class AdjComTplBatchImportPlugin
extends AbsCommonImport {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjComTplBatchImportPlugin.class);
    public static final String DEFAULT_SELECTED_FIELD_MODEL = "model";
    public static final String DEFAULT_SELECTED_FIELD_NUMBER = "number";
    private static final Set<String> IGNORE_DIM = Sets.newHashSet((Object[])new String[]{"Entity", "Scenario", "Year", "Period"});
    private static final Set<String> MY_COMPANY_IGNORE_MEMBER = Sets.newHashSet((Object[])new String[]{SystemVarsEnum.PR_NONE.getNumber(), SystemVarsEnum.CURRENT.getNumber(), SystemVarsEnum.MC_INV_UNIT.getNumber(), SystemVarsEnum.MC_SUB_UNIT.getNumber()});

    @Override
    public List<ComboItem> getOverrideFieldsConfig() {
        return Lists.newArrayList((Object[])new ComboItem[]{new ComboItem(ResManager.getLocaleString((String)"\u4f53\u7cfb", (String)"AdjComTplBatchImportPlugin_2", (String)"fi-bcm-formplugin"), DEFAULT_SELECTED_FIELD_MODEL), new ComboItem(ResManager.getLocaleString((String)"\u6a21\u677f\u7f16\u7801", (String)"AdjComTplBatchImportPlugin_1", (String)"fi-bcm-formplugin"), DEFAULT_SELECTED_FIELD_NUMBER)});
    }

    @Override
    public String getDefaultKeyFields() {
        return "model,number";
    }

    public List<String> getDefaultLockUIs() {
        return Lists.newArrayList((Object[])new String[]{"keyfields"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        JSONArray effective;
        ArrayListMultimap catalogPerm;
        DynamicObject adjcatalogDyn;
        String modelShowNumber = ImportHelper.getImportBillProp(bill, "model.shownumber").toString();
        String modelNumber = null;
        try {
            modelNumber = MemberReader.findModelNumberByShowNum((String)modelShowNumber);
        }
        catch (Exception e) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u4f53\u7cfb\u3002", (String)"AdjComTplBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelShowNumber));
        }
        if (StringUtils.isEmpty((CharSequence)modelNumber)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u4f53\u7cfb\u3002", (String)"AdjComTplBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelShowNumber));
        }
        Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        String number = ImportHelper.getImportBillProp(bill, DEFAULT_SELECTED_FIELD_NUMBER).toString();
        if (!BCMNumberRule.checkNumber((String)number)) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (!this.checkMaxLength(number, 50)) {
            return Optional.of(ResManager.loadKDString((String)"\u201c\u6a21\u677f\u7f16\u7801\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,50]\u3002", (String)"AdjComTplBatchImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.checkMaxLength(ImportHelper.getImportBillProp(bill, "name.zh_CN").toString(), 255)) {
            return Optional.of(ResManager.loadKDString((String)"\u201c\u6a21\u677f\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,255]\u3002", (String)"AdjComTplBatchImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.checkMaxLength(ImportHelper.getImportBillProp(bill, "desc").toString(), 2000)) {
            return Optional.of(ResManager.loadKDString((String)"\u201c\u8bf4\u660e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", (String)"AdjComTplBatchImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String bussnesstype = ImportHelper.getImportBillProp(bill, "bussnesstype").toString();
        BusinessTypeEnum bisTypeEnum = BusinessTypeEnum.searchByName((String)bussnesstype);
        if (bisTypeEnum == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"AdjComTplBatchImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bussnesstype));
        }
        if (!this.checkBisType(modelId, bussnesstype)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u652f\u6301\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"AdjComTplBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bisTypeEnum.getText()));
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (ImportOperateType.NEW == importType && QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])new QFilter[]{new QFilter(DEFAULT_SELECTED_FIELD_MODEL, "=", (Object)modelId), new QFilter(DEFAULT_SELECTED_FIELD_NUMBER, "=", (Object)number), new QFilter("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype())})) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb[%1$s]\u4e2d\u5df2\u5b58\u5728\u7f16\u7801\u4e3a[%2$s]\u7684\u901a\u7528\u5206\u5f55\u6a21\u677f\u3002", (String)"AdjComTplBatchImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelShowNumber, number));
        }
        String executeorder = ImportHelper.getImportBillProp(bill, "executeorder").toString();
        if (!(StringUtils.isBlank((CharSequence)executeorder) || NumberUtils.isCreatable((String)executeorder) && new BigDecimal(99999).compareTo(new BigDecimal(executeorder)) >= 0 && new BigDecimal("1").compareTo(new BigDecimal(executeorder)) < 0 && new BigDecimal(executeorder).scale() <= 2)) {
            return Optional.of(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53ea\u80fd\u8f93\u5165\u8303\u56f4\u4e3a[1,99998]\u5185\u6700\u591a2\u4f4d\u5c0f\u6570\u7684\u6570\u5b57\u3002", (String)"AdjComTplBatchImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String catalogNum = ImportHelper.getImportBillProp(bill, "templatecatalog.number").toString();
        DynamicObject catalogDyn = this.getCatalogDyn(modelId, catalogNum);
        if (catalogDyn == null || TemplateCatalogEnum.PRTADJUST != PaperTemplateService.getCatalogEnumByLongnumber((String)catalogDyn.getString("longnumber"))) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u6a21\u677f\u5206\u7c7b\u3002", (String)"AdjComTplBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), catalogNum));
        }
        String adjustCatalogNum = ImportHelper.getImportBillProp(bill, "adjustcatalog.number").toString();
        if (StringUtils.isNotEmpty((CharSequence)adjustCatalogNum) && (adjcatalogDyn = AdjustCatalogUtil.getAdjustCatalogDyn(modelId, adjustCatalogNum)) == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b\u7f16\u7801\u65e0\u6743\u6216\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]), catalogNum));
        }
        if (!(PermissionServiceImpl.getInstance((Long)modelId).isAdmin() || CollectionUtils.isEmpty((Collection)(catalogPerm = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_papertemplatecatalog", (String)String.valueOf(modelId), (String)String.valueOf(RequestContext.get().getCurrUserId()), (List)Lists.newArrayList((Object[])new Long[]{catalogDyn.getLong("id")}))).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())) && CollectionUtils.isEmpty((Collection)catalogPerm.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue())))) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u6a21\u677f\u5206\u7c7b\u6ca1\u6709\u8bfb\u5199\u6743\u9650\u3002", (String)"AdjComTplBatchImportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), catalogNum));
        }
        String bisType = ImportHelper.getImportBillProp(bill, "bussnesstype").toString();
        BusinessTypeEnum bisTypeEunm = BusinessTypeEnum.searchByName((String)bisType);
        if (bisTypeEunm == null) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"AdjComTplBatchImportPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bisType));
        }
        String processNumber = bisTypeEunm.getProcessNumber();
        Object multiplecurrency = ImportHelper.getImportBillProp(bill, "multiplecurrency");
        String cvtbeforecurrency = ImportHelper.getImportBillProp(bill, "cvtbeforecurrency").toString();
        if ("1".equals(multiplecurrency)) {
            if (!OrgRelaProcessMembPool.isRelaProcess((String)processNumber)) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u3010%s\u3011\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u3002", (String)"AdjComTplBatchImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bisTypeEunm.getText()));
            }
            if (StringUtils.isBlank((CharSequence)cvtbeforecurrency)) {
                return Optional.of(ResManager.loadKDString((String)"\u591a\u5e01\u79cd\u7684\u5206\u5f55\uff0c\u201c\u8f93\u5165\u5e01\u201d\u4e0d\u80fd\u7a7a\u3002", (String)"AdjComTplBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if ("EC".equalsIgnoreCase(cvtbeforecurrency) || "DC".equalsIgnoreCase(cvtbeforecurrency) || "PC".equalsIgnoreCase(cvtbeforecurrency) || "OC".equalsIgnoreCase(cvtbeforecurrency)) {
                return Optional.of(ResManager.loadKDString((String)"\u201c\u8f93\u5165\u5e01\u201d\u8bf7\u586b\u5199\u5177\u4f53\u7684\u5e01\u79cd\u3002", (String)"AdjComTplBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            IDNumberTreeNode currency = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)cvtbeforecurrency);
            if (IDNumberTreeNode.NotFoundTreeNode == currency) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a[%s]\u7684\u5e01\u79cd\u3002", (String)"AdjComTplBatchImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), cvtbeforecurrency));
            }
        }
        JSONArray sceneArray = bill.getData().getJSONArray("tmplscenario");
        ArrayList sceneList = new ArrayList(16);
        if (sceneArray != null && !sceneArray.isEmpty()) {
            for (int i = 0; i < sceneArray.size(); ++i) {
                JSONObject scene = sceneArray.getJSONObject(i);
                String sceneNum = scene.getJSONObject("scenario").getString(DEFAULT_SELECTED_FIELD_NUMBER);
                IDNumberTreeNode sceneNode = MemberReader.findMemberByNumber((String)modelNumber, (String)PresetConstant.SCENE_DIM, (String)sceneNum);
                if (IDNumberTreeNode.NotFoundTreeNode == sceneNode) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a[%s]\u7684\u60c5\u666f\u3002", (String)"AdjComTplBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sceneNum));
                }
                HashMap<String, Object> item = new HashMap<String, Object>(16);
                item.put("id", sceneNode.getId());
                item.put(DEFAULT_SELECTED_FIELD_NUMBER, sceneNode.getNumber());
                item.put("scope", scene.getString("scope"));
                item.put("isleaf", sceneNode.isLeaf());
                item.put("isexcept", scene.getString("isexcept"));
                sceneList.add(item);
            }
            if (!PaperTemplateHelper.checkEffectiveScenario((long)modelId, sceneList)) {
                return Optional.of(ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"AdjComTplBatchImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        HashMultimap dimMembers = HashMultimap.create();
        Map<String, String> requestDimMap = this.getRequestDim(modelId);
        HashMap<String, Integer> allDimCountMap = new HashMap<String, Integer>(16);
        JSONArray commembentry = bill.getData().getJSONArray("commembentry");
        boolean isExistProcess = false;
        if (commembentry != null && !commembentry.isEmpty()) {
            for (int i = 0; i < commembentry.size(); ++i) {
                String memberNum;
                JSONObject item = commembentry.getJSONObject(i);
                String dimNum = item.getJSONObject("comdimension").getString(DEFAULT_SELECTED_FIELD_NUMBER);
                if (IGNORE_DIM.contains(dimNum)) continue;
                if ("Account".equalsIgnoreCase(dimNum)) {
                    return Optional.of(ResManager.loadKDString((String)"\u201c\u79d1\u76ee\u201d\u4e0d\u5141\u8bb8\u586b\u5199\u5728\u901a\u7528\u7ef4\u3002", (String)"AdjComTplBatchImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if ("Process".equalsIgnoreCase(dimNum)) {
                    isExistProcess = true;
                }
                if (!StringUtils.isBlank((CharSequence)(memberNum = item.getString("commembnumber")))) {
                    Optional<String> msg = this.checkExistMember(modelNumber, dimNum, memberNum);
                    if (msg.isPresent()) {
                        return msg;
                    }
                    dimMembers.put((Object)dimNum, (Object)memberNum);
                }
                allDimCountMap.put(dimNum, allDimCountMap.getOrDefault(dimNum, 0) + 1);
                requestDimMap.remove(dimNum);
            }
        }
        if (!isExistProcess) {
            return Optional.of(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u5fc5\u987b\u8981\u6709\u201c\u8fc7\u7a0b\u201d\u7ef4\u5ea6\u3002", (String)"AdjComTplBatchImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Dimension> spreadDimList = new ArrayList<Dimension>(16);
        JSONArray spreadmembentry = bill.getData().getJSONArray("spreadmembentry");
        if (spreadmembentry != null && spreadmembentry.size() > 0) {
            for (int i = 0; i < spreadmembentry.size(); ++i) {
                String dimNum = spreadmembentry.getJSONObject(i).getJSONObject("spreaddimension").getString(DEFAULT_SELECTED_FIELD_NUMBER);
                Dimension dim = this.getDimension(modelId, dimNum);
                if (dim == null) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a[%s]\u7684\u7ef4\u5ea6\u3002", (String)"AdjComTplBatchImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNum));
                }
                allDimCountMap.put(dimNum, allDimCountMap.getOrDefault(dimNum, 0) + 1);
                if (!"Entity".equalsIgnoreCase(dimNum)) {
                    spreadDimList.add(dim);
                }
                requestDimMap.remove(dimNum);
            }
        }
        if (!CollectionUtils.isEmpty(requestDimMap)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u6216\u8005\u8868\u683c\u5185\u7ef4\u5ea6\u90fd\u6ca1\u6709\u5305\u542b%s\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AdjComTplBatchImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), requestDimMap.values()));
        }
        Set duplicateDim = allDimCountMap.entrySet().stream().filter(kv -> (Integer)kv.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(duplicateDim)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u7ef4\u5ea6%s\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u4e8e\u901a\u7528\u7ef4\u4e0e\u884c\u5217\u7ef4\u3002", (String)"AdjComTplBatchImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), duplicateDim));
        }
        HashMap<String, AtomicInteger> indexMap = new HashMap<String, AtomicInteger>(16);
        JSONArray dataArray = bill.getData().getJSONArray("data");
        if (dataArray != null && !dataArray.isEmpty()) {
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject item = dataArray.getJSONObject(i);
                String groupNum = item.getString("groupnum");
                if (!StringUtils.isBlank((CharSequence)groupNum) && !groupNum.matches("^[0-9]{0,6}$")) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u201c\u5206\u7ec4\u53f7\u201d\u3010%s\u3011\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u6309\u7167\u6b63\u786e\u683c\u5f0f\uff1b\u957f\u5ea6\u4e0d\u8d85\u8fc76\u4f4d\u7684\u6570\u503c\uff1b\u5982\uff1a1,2,3,4,5..\u3002", (String)"AdjComTplBatchImportPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupNum));
                }
                for (Dimension dim : spreadDimList) {
                    String fieldKey = (StringUtils.isBlank((CharSequence)dim.getFieldmapped()) ? dim.getNumber() : dim.getFieldmapped()).toLowerCase(Locale.ENGLISH);
                    JSONObject dimObj = item.getJSONObject(fieldKey);
                    if (dimObj == null || IGNORE_DIM.contains(dim.getNumber())) continue;
                    String memberNum = dimObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
                    if (PresetConstant.MYCOMPANY_DIM.equalsIgnoreCase(dim.getNumber()) && MY_COMPANY_IGNORE_MEMBER.contains(memberNum)) {
                        return Optional.of(String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u586b\u7684\u6210\u5458\u3010%s\u3011\u4e0d\u7b26\u5408\u5206\u5f55\u7684\u8981\u6c42\u3002", (String)"AdjComTplBatchImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberNum));
                    }
                    Optional<String> msg = this.checkExistMember(modelNumber, dim.getNumber(), memberNum);
                    if (msg.isPresent()) {
                        return msg;
                    }
                    if (StringUtils.isBlank((CharSequence)memberNum)) continue;
                    dimMembers.put((Object)dim.getNumber(), (Object)memberNum);
                }
                String val = "";
                if ("1".equals(multiplecurrency)) {
                    boolean isCvtDebitBlank;
                    String cvtCredit = item.getString("cvtbeforecredit");
                    String cvtDebit = item.getString("cvtbeforedebit");
                    boolean isCvtCreditBlank = StringUtils.isBlank((CharSequence)cvtCredit);
                    if (!(isCvtCreditBlank ^ (isCvtDebitBlank = StringUtils.isBlank((CharSequence)cvtDebit)))) return Optional.of(ResManager.loadKDString((String)"\u591a\u5e01\u79cd\u5206\u5f55\uff0c\u201c\u6298\u7b97\u524d\u501f\u65b9\u201d\u548c\u201c\u6298\u7b97\u524d\u8d37\u65b9\u201d\u5fc5\u987b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u6709\u503c\u3002", (String)"AdjComTplBatchImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    val = isCvtCreditBlank ? cvtDebit : cvtCredit;
                } else {
                    boolean isDebitBlank;
                    String credit = item.getString("credit");
                    String debit = item.getString("debit");
                    boolean isCreditBlank = StringUtils.isBlank((CharSequence)credit);
                    if (!(isCreditBlank ^ (isDebitBlank = StringUtils.isBlank((CharSequence)debit)))) return Optional.of(ResManager.loadKDString((String)"\u975e\u591a\u5e01\u79cd\u5206\u5f55\uff0c\u201c\u501f\u65b9\u201d\u548c\u201c\u8d37\u65b9\u201d\u5fc5\u987b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u6709\u503c\u3002", (String)"AdjComTplBatchImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    val = isCreditBlank ? debit : credit;
                }
                try {
                    String groupNumStr;
                    Expression expression = ExcelFormulaPaserHelper.parse((String)val);
                    AtomicBoolean isBlanceLine = new AtomicBoolean(false);
                    AdjustFormulaParseHelper.walkExpress((Expression)expression, p -> {
                        String funcName;
                        if (p instanceof FunctionExpr && "BN".equalsIgnoreCase(funcName = ((FunctionExpr)p).getFuncionName())) {
                            isBlanceLine.set(true);
                        }
                        return p;
                    });
                    if (!isBlanceLine.get() || indexMap.computeIfAbsent(groupNumStr = Optional.ofNullable(groupNum).orElseGet(() -> ResManager.loadKDString((String)"\u7a7a", (String)"RptAdjustTemplateEditPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0])), adjust -> new AtomicInteger()).getAndIncrement() <= 0) continue;
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u5206\u7ec4 %s \u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a\u5e73\u8861\u6570", (String)"RptAdjustTemplateEditPlugin_56", (String)"fi-bcm-formplugin", (Object[])new Object[0]), groupNumStr));
                }
                catch (Throwable t) {
                    return Optional.of(AdjustmentServiceHelper.toString_Adj((Throwable)t));
                }
            }
        }
        if (!dimMembers.isEmpty()) {
            PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
            for (String dimNum : dimMembers.keySet()) {
                Set errorMembers;
                Dimension dim = this.getDimension(modelId, dimNum);
                if (dim == null || CollectionUtils.isEmpty((Collection)(errorMembers = permService.matchNoOrReadPermMembersByNum(Long.valueOf(dim.getId()), dim.getMemberEntityNumber(), dimMembers.get((Object)dimNum))))) continue;
                return Optional.of(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u4f7f\u7528\u201c%1$s\u201d\u7ef4\u5ea6\u7684%2$s\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AdjComTplBatchImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getName(), errorMembers));
            }
        }
        if ((effective = bill.getData().getJSONArray("effective")) == null || effective.isEmpty()) return Optional.empty();
        HashMultimap allData = HashMultimap.create();
        for (int i = 0; i < effective.size(); ++i) {
            String yearNum;
            JSONObject item = effective.getJSONObject(i);
            if (StringUtils.isBlank((CharSequence)item.getString("applytype"))) {
                return Optional.of(ResManager.loadKDString((String)"\u9002\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjComTplBatchImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String yearscope = item.getString("yearscope");
            if (StringUtils.isBlank((CharSequence)yearscope)) {
                return Optional.of(ResManager.loadKDString((String)"\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjComTplBatchImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            JSONObject yearObj = item.getJSONObject("effectiveyear");
            if (yearObj == null && !"1".equals(yearscope)) {
                return Optional.of(ResManager.loadKDString((String)"\u8d22\u5e74\u4e3a\u7a7a\u65f6\uff0c\u8d22\u5e74\u8303\u56f4\u5fc5\u987b\u662f\u201c\u6240\u6709\u8d22\u5e74\u201d\u3002", (String)"AdjComTplBatchImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (yearObj != null && "1".equals(yearscope)) {
                return Optional.of(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u662f\u201c\u6240\u6709\u8d22\u5e74\u201d\u3002", (String)"AdjComTplBatchImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String string = yearNum = yearObj == null ? "" : yearObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
            if (!StringUtils.isBlank((CharSequence)yearNum) && "1".equals(yearscope)) {
                return Optional.of(ResManager.loadKDString((String)"\u8d22\u5e74\u8303\u56f4\u662f\u6240\u6709\u8d22\u5e74\u65f6\uff0c\u6709\u6548\u8d22\u5e74\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"AdjComTplBatchImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            Tuple rowKey = Tuple.create((Object)item.getString("applytype"), (Object)yearNum, (Object)yearscope);
            JSONObject periodObj = item.getJSONObject("effectiveperiod");
            String periodNum = periodObj == null ? "" : periodObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
            allData.put((Object)rowKey, (Object)periodNum);
        }
        EffectiveYearPeriodUtil.getEffectiveInfo(this.buildDoc(modelId, modelNumber, (Multimap<Tuple<String, String, String>, String>)allData));
        return Optional.empty();
    }

    private Map<String, String> getRequestDim(Long modelId) {
        HashMap<String, String> allDimMap = new HashMap<String, String>(MemberReader.getDimNumberMapNameById((long)modelId));
        IGNORE_DIM.forEach(allDimMap::remove);
        return allDimMap;
    }

    private boolean checkBisType(Long modelId, String bussnesstype) {
        Set bisTypes = (Set)ThreadCache.get((Object)String.format("adjtmpl_import_%s", modelId), () -> AdjustModelUtil.getBussinessType(modelId, false).stream().map(e -> (String)e.p2).collect(Collectors.toSet()));
        return bisTypes.contains(bussnesstype);
    }

    private boolean checkMaxLength(String str, int maxLength) {
        if (str == null) {
            return true;
        }
        return str.length() <= maxLength;
    }

    private DynamicObjectCollection buildDoc(Long modelId, String modelNumber, Multimap<Tuple<String, String, String>, String> allData) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_expire_date_f7");
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        Set yearNumSet = allData.keySet().stream().map(e -> (String)e.p2).collect(Collectors.toSet());
        Map<String, DynamicObject> yearMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (QFilter[])new QFilter[]{new QFilter(DEFAULT_SELECTED_FIELD_MODEL, "=", (Object)modelId), new QFilter(DEFAULT_SELECTED_FIELD_NUMBER, "in", yearNumSet)}).values().stream().collect(Collectors.toMap(k -> k.getString(DEFAULT_SELECTED_FIELD_NUMBER), v -> v, (e1, e2) -> e2));
        for (Tuple rowKey : allData.keySet()) {
            DynamicObject row = entryentity.addNew();
            row.set("applytypecol", rowKey.p1);
            row.set("yearcol", (Object)yearMap.get(rowKey.p2));
            row.set("yearscopecol", rowKey.p3);
            DynamicObjectCollection periods = row.getDynamicObjectCollection("periodcol");
            for (String periodNum : allData.get((Object)rowKey)) {
                if (StringUtils.isBlank((CharSequence)periodNum)) continue;
                IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
                DynamicObject periodDyn = periods.addNew();
                periodDyn.set("pkid", (Object)periodNode.getId());
            }
        }
        return entryentity;
    }

    private Optional<String> checkExistMember(String modelNumber, String dimNum, String memberNum) {
        if (StringUtils.isBlank((CharSequence)memberNum)) {
            return Optional.empty();
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memberNum);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ef4\u5ea6[%1$s]\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a[%2$s]\u7684\u6210\u5458\u3002", (String)"AdjComTplBatchImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNum, memberNum));
        }
        return Optional.empty();
    }

    private DynamicObject getCatalogDyn(Long modelId, String catalogNum) {
        return (DynamicObject)ThreadCache.get((Object)("PaperTemplateCatalogCache-" + catalogNum + modelId), () -> QueryServiceHelper.queryOne((String)"bcm_papertemplatecatalog", (String)"id,longnumber", (QFilter[])new QFilter[]{new QFilter(DEFAULT_SELECTED_FIELD_MODEL, "=", (Object)modelId), new QFilter(DEFAULT_SELECTED_FIELD_NUMBER, "=", (Object)catalogNum)}));
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        Long modelId = this.getModelId(rowData);
        String number = ImportHelper.getImportBillProp(rowData, DEFAULT_SELECTED_FIELD_NUMBER).toString();
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_papertemplate", (QFilter[])new QFilter[]{new QFilter(DEFAULT_SELECTED_FIELD_MODEL, "=", (Object)modelId), new QFilter(DEFAULT_SELECTED_FIELD_NUMBER, "=", (Object)number), new QFilter("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype())});
        if (dyn != null) {
            return Optional.of(dyn);
        }
        return Optional.empty();
    }

    private Long getModelId(ImportBillData rowData) {
        String modelShowNumber = ImportHelper.getImportBillProp(rowData, "model.shownumber").toString();
        String modelNumber = MemberReader.findModelNumberByShowNum((String)modelShowNumber);
        Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        return modelId;
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        ArrayList<DynamicObject> tmplList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> tmplSceneList = new ArrayList<DynamicObject>(16);
        for (ImportBillData bill : billDataList) {
            DynamicObject tmplDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplate");
            tmplDyn.set("group", (Object)GlobalIdUtil.genGlobalLongId());
            tmplDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            tmplDyn.set("createtime", (Object)new Date());
            this.initTmplData(tmplDyn, bill);
            tmplList.add(tmplDyn);
            tmplSceneList.addAll(this.createTmplScenario(bill, tmplDyn.getLong("group")));
        }
        if (!CollectionUtils.isEmpty(tmplSceneList)) {
            SaveServiceHelper.save((DynamicObject[])tmplSceneList.toArray(new DynamicObject[0]));
        }
        return tmplList.toArray(new DynamicObject[0]);
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        HashSet<Long> groupIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> tmplList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> tmplSceneList = new ArrayList<DynamicObject>(16);
        for (ImportBillData bill : billDataList) {
            DynamicObject tmplDyn = (DynamicObject)bill.getData().get((Object)"existingRecordDy");
            tmplDyn.set("spreadjson", null);
            groupIds.add(tmplDyn.getLong("group"));
            this.initTmplData(tmplDyn, bill);
            tmplList.add(tmplDyn);
            tmplSceneList.addAll(this.createTmplScenario(bill, tmplDyn.getLong("group")));
        }
        DeleteServiceHelper.delete((String)"bcm_tmplscenario", (QFilter[])new QFilter[]{new QFilter(DEFAULT_SELECTED_FIELD_MODEL, "=", (Object)this.getModelId(billDataList.get(0))), new QFilter("groupid", "in", groupIds), new QFilter("type", "=", (Object)PaperTemplateTypeEnum.PRTADJUST.getCode())});
        if (!CollectionUtils.isEmpty(tmplSceneList)) {
            SaveServiceHelper.save((DynamicObject[])tmplSceneList.toArray(new DynamicObject[0]));
        }
        return tmplList.toArray(new DynamicObject[0]);
    }

    private void initTmplData(DynamicObject tmplDyn, ImportBillData bill) {
        Long modelId = this.getModelId(bill);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        tmplDyn.set(DEFAULT_SELECTED_FIELD_MODEL, (Object)modelId);
        tmplDyn.set(DEFAULT_SELECTED_FIELD_NUMBER, (Object)ImportHelper.getImportBillProp(bill, DEFAULT_SELECTED_FIELD_NUMBER).toString());
        tmplDyn.set("name", (Object)LocaleString.fromMap((Map)((Map)ImportHelper.getImportBillProp(bill, "name"))));
        tmplDyn.set("templatecatalog", (Object)this.getCatalogDyn(modelId, ImportHelper.getImportBillProp(bill, "templatecatalog.number").toString()).getLong("id"));
        DynamicObject adjustCatalogDyn = AdjustCatalogUtil.getAdjustCatalogDyn(modelId, ImportHelper.getImportBillProp(bill, "adjustcatalog.number").toString());
        if (adjustCatalogDyn != null) {
            tmplDyn.set("adjustcatalog", (Object)adjustCatalogDyn.getLong("id"));
        }
        tmplDyn.set("templatetype", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype());
        tmplDyn.set("executeorder", (Object)new BigDecimal(ImportHelper.getImportBillProp(bill, "executeorder").toString()));
        tmplDyn.set("description", (Object)ImportHelper.getImportBillProp(bill, "desc").toString());
        String bisType = ImportHelper.getImportBillProp(bill, "bussnesstype").toString();
        tmplDyn.set("bussnesstype", (Object)bisType);
        tmplDyn.set("linkcreatetype", (Object)ImportHelper.getImportBillProp(bill, "linkcreatetype").toString());
        tmplDyn.set("balancetype", (Object)ImportHelper.getImportBillProp(bill, "balancetype").toString());
        tmplDyn.set("journaltype", (Object)ImportHelper.getImportBillProp(bill, "journaltype").toString());
        String multiplecurrency = ImportHelper.getImportBillProp(bill, "multiplecurrency").toString();
        tmplDyn.set("multiplecurrency", (Object)multiplecurrency);
        if ("1".equals(multiplecurrency)) {
            tmplDyn.set("cvtbeforecurrency", (Object)MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)ImportHelper.getImportBillProp(bill, "cvtbeforecurrency").toString()).getId());
        }
        tmplDyn.set("modifytime", (Object)new Date());
        tmplDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        tmplDyn.set("status", (Object)PaperTemplateStatusEnum.DISABLE.getStatusValue());
        JSONArray commembentry = bill.getData().getJSONArray("commembentry");
        DynamicObjectCollection comDoc = tmplDyn.getDynamicObjectCollection("commembentry");
        comDoc.clear();
        this.createComDim(modelId, modelNumber, 1, comDoc.addNew(), DimEntityNumEnum.SCENARIO.getNumber(), null);
        this.createComDim(modelId, modelNumber, 2, comDoc.addNew(), DimEntityNumEnum.YEAR.getNumber(), null);
        this.createComDim(modelId, modelNumber, 3, comDoc.addNew(), DimEntityNumEnum.PERIOD.getNumber(), null);
        String processNumber = Objects.requireNonNull(BusinessTypeEnum.searchByName((String)bisType)).getProcessNumber();
        for (int i = 0; i < commembentry.size(); ++i) {
            JSONObject item = commembentry.getJSONObject(i);
            String dimNum = item.getJSONObject("comdimension").getString(DEFAULT_SELECTED_FIELD_NUMBER);
            String memberNum = item.getString("commembnumber");
            if (IGNORE_DIM.contains(dimNum)) continue;
            DynamicObject comDyn = comDoc.addNew();
            if ("Process".equalsIgnoreCase(dimNum)) {
                memberNum = processNumber;
            }
            if (!"RAdj".equalsIgnoreCase(processNumber) && "Currency".equalsIgnoreCase(dimNum)) {
                memberNum = "EC";
            }
            this.createComDim(modelId, modelNumber, i + 4, comDyn, dimNum, memberNum);
        }
        DynamicObjectCollection spreadDoc = tmplDyn.getDynamicObjectCollection("spreadmembentry");
        spreadDoc.clear();
        JSONArray spreadmembentry = bill.getData().getJSONArray("spreadmembentry");
        DynamicObject entityDyn = spreadDoc.addNew();
        Dimension entityDim = this.getDimension(modelId, "Entity");
        entityDyn.set("seq", (Object)1);
        if (entityDim != null) {
            entityDyn.set("spreaddimension", (Object)entityDim.getId());
            entityDyn.set("spreadentitysign", (Object)entityDim.getMemberEntityNumber());
        }
        for (int i = 0; i < spreadmembentry.size(); ++i) {
            String dimNum = spreadmembentry.getJSONObject(i).getJSONObject("spreaddimension").getString(DEFAULT_SELECTED_FIELD_NUMBER);
            Dimension dim = this.getDimension(modelId, dimNum);
            if (dim == null || IGNORE_DIM.contains(dimNum)) continue;
            DynamicObject spreadDyn = spreadDoc.addNew();
            spreadDyn.set("seq", (Object)(i + 2));
            spreadDyn.set("spreaddimension", (Object)dim.getId());
            spreadDyn.set("spreadentitysign", (Object)dim.getMemberEntityNumber());
        }
        DynamicObjectCollection effectiveDoc = tmplDyn.getDynamicObjectCollection("effective");
        JSONArray effective = bill.getData().getJSONArray("effective");
        if (effective != null && !effective.isEmpty()) {
            this.initEffectiveData(modelNumber, effectiveDoc, effective);
        }
        SpreadManager sm = this.createSpreadManager(bill, modelId, modelNumber, processNumber);
        tmplDyn.set("data", (Object)ObjectSerialUtil.toByteSerialized((Object)sm));
    }

    private void initEffectiveData(String modelNumber, DynamicObjectCollection effectiveDoc, JSONArray effective) {
        for (int i = 0; i < effective.size(); ++i) {
            JSONObject item = effective.getJSONObject(i);
            JSONObject yearObj = item.getJSONObject("effectiveyear");
            String yearNum = yearObj == null ? "" : yearObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
            JSONObject periodObj = item.getJSONObject("effectiveperiod");
            String periodNum = periodObj == null ? "" : periodObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
            DynamicObject row = effectiveDoc.addNew();
            row.set("applytype", (Object)item.getString("applytype"));
            IDNumberTreeNode fyNode = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNum);
            if (IDNumberTreeNode.NotFoundTreeNode != fyNode) {
                row.set("effectiveyear", (Object)fyNode.getId());
            }
            row.set("yearscope", (Object)item.getString("yearscope"));
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
            if (IDNumberTreeNode.NotFoundTreeNode == periodNode) continue;
            row.set("effectiveperiod", (Object)periodNode.getId());
        }
    }

    private void createComDim(Long modelId, String modelNumber, int seq, DynamicObject comDyn, String dimNum, String memberNum) {
        Dimension dimension = this.getDimension(modelId, dimNum);
        if (dimension != null) {
            comDyn.set("seq", (Object)seq);
            comDyn.set("comdimension", (Object)dimension.getId());
            comDyn.set("comentitysign", (Object)dimension.getMemberEntityNumber());
            if (!StringUtils.isBlank((CharSequence)memberNum)) {
                comDyn.set("commembid", (Object)MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memberNum).getId());
            }
        }
    }

    private SpreadManager createSpreadManager(ImportBillData bill, Long modelId, String modelNumber, String processNumber) {
        boolean isMultipleCurrency;
        SpreadManager sm = new SpreadManager("sheet", null);
        AdjustModel adjust = new AdjustModel();
        adjust.setModelId(modelId.longValue());
        AdjustSpreadActionHandlerProxy handler = new AdjustSpreadActionHandlerProxy(null, adjust, sm, null, null);
        handler.addColumnAutoCalColNum("groupnum", ResManager.loadKDString((String)"\u5206\u7ec4\u53f7", (String)"RptAdjustTemplateEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, null);
        handler.addColumnAutoCalColNum("description", ResManager.loadKDString((String)"\u6458\u8981", (String)"RptAdjustTemplateEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, null);
        handler.addColumnAutoCalColNum("bcm_entitymembertree", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AdjComTplBatchImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, this.getDimension(modelId, "Entity"));
        JSONArray spreadmembentry = bill.getData().getJSONArray("spreadmembentry");
        ArrayList<Dimension> dimList = new ArrayList<Dimension>(16);
        if (spreadmembentry != null && !spreadmembentry.isEmpty()) {
            for (int i = 0; i < spreadmembentry.size(); ++i) {
                String dimNum = spreadmembentry.getJSONObject(i).getJSONObject("spreaddimension").getString(DEFAULT_SELECTED_FIELD_NUMBER);
                Dimension dim = this.getDimension(modelId, dimNum);
                if (dim == null || IGNORE_DIM.contains(dimNum)) continue;
                handler.addColumnAutoCalColNum(dim.getMemberEntityNumber(), dim.getName(), false, dim);
                dimList.add(dim);
            }
        }
        handler.addColumnAutoCalColNum("debit", ((isMultipleCurrency = "1".equals(ImportHelper.getImportBillProp(bill, "multiplecurrency").toString())) ? ResManager.loadKDString((String)"\u6298\u7b97\u524d", (String)"RptAdjustTemplateEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : "").concat(ResManager.loadKDString((String)"\u501f\u65b9", (String)"RptAdjustTemplateEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0])), false, null);
        handler.addColumnAutoCalColNum("credit", (isMultipleCurrency ? ResManager.loadKDString((String)"\u6298\u7b97\u524d", (String)"RptAdjustTemplateEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : "").concat(ResManager.loadKDString((String)"\u8d37\u65b9", (String)"RptAdjustTemplateEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0])), false, null);
        handler.addColumnAutoCalColNum("calculatecontent", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"RptAdjustTemplateEditPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false, null);
        AreaPositionManger areaPos = handler.getAreaPositionManger();
        JSONArray dataArray = bill.getData().getJSONArray("data");
        if (dataArray != null && !dataArray.isEmpty()) {
            for (int i = 0; i < dataArray.size(); ++i) {
                int rowIndex = i + 1;
                JSONObject item = dataArray.getJSONObject(i);
                handler.setCellValue(rowIndex, areaPos.getColIndexBySign("groupnum"), item.getString("groupnum"));
                handler.setCellValue(rowIndex, areaPos.getColIndexBySign("description"), item.getString("description"));
                handler.setCellValue(rowIndex, areaPos.getColIndexBySign("Entity"), "");
                for (Dimension dim : dimList) {
                    String fieldKey = (StringUtils.isBlank((CharSequence)dim.getFieldmapped()) ? dim.getNumber() : dim.getFieldmapped()).toLowerCase(Locale.ENGLISH);
                    JSONObject fieldObj = item.getJSONObject(fieldKey);
                    if (fieldObj == null || StringUtils.isBlank((CharSequence)fieldObj.getString(DEFAULT_SELECTED_FIELD_NUMBER))) continue;
                    String memberNum = fieldObj.getString(DEFAULT_SELECTED_FIELD_NUMBER);
                    if (!"RAdj".equalsIgnoreCase(processNumber) && "Currency".equalsIgnoreCase(dim.getNumber())) {
                        memberNum = "EC";
                    }
                    IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dim.getNumber(), (String)memberNum);
                    handler.setDimensionCellValue(rowIndex, areaPos.getColIndexBySign(dim.getNumber()), dim, IDNumberTreeNode.NotFoundTreeNode == node ? 0L : node.getId(), null);
                }
                String debit = isMultipleCurrency ? item.getString("cvtbeforedebit") : item.getString("debit");
                Integer debitIndex = areaPos.getColIndexBySign("debit");
                if (NumberUtil.isNumeric((String)debit)) {
                    handler.setCellValue(rowIndex, debitIndex, debit);
                } else {
                    handler.setFormula(rowIndex, debitIndex, debit);
                    try {
                        AdjustFormulaParseHelper.walkExpress((Expression)ExcelFormulaPaserHelper.parse((String)debit), p -> {
                            String funcName;
                            if (p instanceof FunctionExpr && "BN".equalsIgnoreCase(funcName = ((FunctionExpr)p).getFuncionName())) {
                                handler.getSpreadManager().getBook().getSheet(0).getCell(rowIndex, debitIndex.intValue()).setUserObject("isBlanceLine", (Object)"1");
                            }
                            return p;
                        });
                    }
                    catch (Throwable t) {
                        LOG.info(AdjustmentServiceHelper.toString_Adj((Throwable)t));
                    }
                }
                String credit = isMultipleCurrency ? item.getString("cvtbeforecredit") : item.getString("credit");
                Integer creditIndex = areaPos.getColIndexBySign("credit");
                if (NumberUtil.isNumeric((String)credit)) {
                    handler.setCellValue(rowIndex, creditIndex, credit);
                } else {
                    handler.setFormula(rowIndex, creditIndex, credit);
                    try {
                        AdjustFormulaParseHelper.walkExpress((Expression)ExcelFormulaPaserHelper.parse((String)credit), p -> {
                            String funcName;
                            if (p instanceof FunctionExpr && "BN".equalsIgnoreCase(funcName = ((FunctionExpr)p).getFuncionName())) {
                                handler.getSpreadManager().getBook().getSheet(0).getCell(rowIndex, creditIndex.intValue()).setUserObject("isBlanceLine", (Object)"1");
                            }
                            return p;
                        });
                    }
                    catch (Throwable t) {
                        LOG.info(AdjustmentServiceHelper.toString_Adj((Throwable)t));
                    }
                }
                handler.setCellValue(rowIndex, areaPos.getColIndexBySign("calculatecontent"), item.getString("calculatecontent"));
            }
        }
        return sm;
    }

    private Dimension getDimension(Long modelId, String dimNum) {
        Dimension dim = new Dimension();
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        DynamicObject dimDyn = MemberReader.getDimensionDynById((long)dimensionId);
        if (dimDyn == null) {
            return null;
        }
        dim.setId(dimDyn.getLong("id"));
        dim.setNumber(dimNum);
        dim.setName(dimDyn.getString("name"));
        dim.setShortNumber(dimDyn.getString("shortnumber"));
        dim.setMemberEntityNumber(dimDyn.getString("membermodel"));
        dim.setFieldmapped(dimDyn.getString("fieldmapped"));
        return dim;
    }

    private List<DynamicObject> createTmplScenario(ImportBillData bill, Long groupId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        Long modelId = this.getModelId(bill);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        JSONArray sceneArray = bill.getData().getJSONArray("tmplscenario");
        if (sceneArray != null && sceneArray.size() > 0) {
            for (int i = 0; i < sceneArray.size(); ++i) {
                JSONObject item = sceneArray.getJSONObject(i);
                DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tmplscenario");
                dyn.set(DEFAULT_SELECTED_FIELD_MODEL, (Object)modelId);
                dyn.set("scenario", (Object)MemberReader.findScenaMemberByNum((String)modelNumber, (String)item.getJSONObject("scenario").getString(DEFAULT_SELECTED_FIELD_NUMBER)).getId());
                dyn.set("scope", (Object)item.getString("scope"));
                dyn.set("isexcept", (Object)item.getString("isexcept"));
                dyn.set("groupid", (Object)groupId);
                dyn.set("type", (Object)PaperTemplateTypeEnum.PRTADJUST.getCode());
                result.add(dyn);
            }
        }
        return result;
    }
}

