/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.importplugin;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.xml.sax.SAXException;

public class AdjustBatchImportSheetHandler
extends BatchImportSheetHandler {
    private static final Log logger = LogFactory.getLog(AdjustBatchImportSheetHandler.class);
    Map<String, Field> sheetFieldMap = new HashMap<String, Field>(16);

    public AdjustBatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, HeartBeat heartbeat) {
        super(ctx2, mainEntityType2, url2, heartbeat);
    }

    public AdjustBatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, Map<String, Object> option, HeartBeat heartbeat) {
        super(ctx2, mainEntityType2, url2, option, heartbeat);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        SheetHandler.XSSFDataType nextDataType;
        if (name.equals("c") && Objects.requireNonNull(nextDataType = (SheetHandler.XSSFDataType)this.getFieldValueByName("nextDataType")) == SheetHandler.XSSFDataType.NUMBER) {
            String formatString;
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)this.getFieldValueByName("lastContents")))) {
                return;
            }
            String lastContents = (String)Objects.requireNonNull(this.getFieldValueByName("lastContents"));
            double n = Double.parseDouble(lastContents);
            int formatIndex = Integer.parseInt(Objects.requireNonNull(this.getFieldValueByName("formatIndex")).toString());
            if (!DateUtil.isADateFormat((int)formatIndex, (String)(formatString = (String)this.getFieldValueByName("formatString"))) && 31 != formatIndex && 28 != formatIndex) {
                if (formatIndex >= 0 && StringUtils.isNotBlank((CharSequence)formatString)) {
                    if (lastContents.endsWith("%")) {
                        String formatter = (String)this.getFieldValueByName("formatter");
                        this.setFieldValue("lastContents", DecimalProp.percentToDoubleString((String)formatter));
                    }
                    boolean isNegative = n < 0.0;
                    n = Double.parseDouble(lastContents);
                    if (isNegative && n >= 0.0) {
                        n = -n;
                    }
                }
                lastContents = new BigDecimal(Double.toString(n)).stripTrailingZeros().toPlainString();
            } else {
                Date date = DateUtil.getJavaDate((double)n);
                lastContents = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                if (StringUtils.equals((CharSequence)"yyyy\\-mm\\-dd", (CharSequence)formatString)) {
                    lastContents = new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
            }
            this.setFieldValue("lastContents", lastContents.replaceAll("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]", "").trim());
            if (lastContents.isEmpty()) {
                return;
            }
            int index = (Integer)this.getFieldValueByName("index");
            this.getRowHolder().getData().put(index, "NULL".equals(lastContents) ? null : lastContents);
            this.getRowHolder().getTypes().put(index, nextDataType);
            JSONObject style = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)formatString)) {
                style.put("fmt", (Object)formatString);
            }
            this.getRowHolder().getStyles().put(index, style);
            return;
        }
        super.endElement(uri, localName, name);
    }

    private <T> T getFieldValueByName(String fieldName) {
        try {
            Field field = this.getSheetHandlerField(fieldName);
            return (T)field.get((Object)this);
        }
        catch (Exception e) {
            logger.error(ThrowableHelper.toString((Exception)e));
            return null;
        }
    }

    private Field getSheetHandlerField(String fieldName) {
        return this.sheetFieldMap.computeIfAbsent(fieldName, k -> {
            try {
                Field field = SheetHandler.class.getDeclaredField(fieldName);
                ReflectionUtils.makeAccessible((Field)field);
                return field;
            }
            catch (NoSuchFieldException e) {
                logger.error(ThrowableHelper.toString((Exception)e));
                return null;
            }
        });
    }

    private void setFieldValue(String fieldName, Object v) {
        try {
            Field field = this.getSheetHandlerField(fieldName);
            field.set((Object)this, v);
        }
        catch (Exception e) {
            logger.error(ThrowableHelper.toString((Exception)e));
        }
    }
}

