/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.inputReader.AdjustInputMemberReader;
import kd.fi.bcm.business.adjust.inputReader.ConvertMoneyNode;
import kd.fi.bcm.business.adjust.inputReader.CurrencyMoneyNode;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustCheckStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.adjust.importplugin.AdjustBatchImportSheetHandler;
import kd.fi.bcm.formplugin.impexport.AbstractImpModel;
import kd.fi.bcm.formplugin.impexport.AdjustImportValidator;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.impexport.ImpBaseDataModel;
import kd.fi.bcm.formplugin.impexport.ImportPreDataModel;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;

public class AdjustCommonImportPlugin
extends BatchImportPlugin {
    private static final String OLAPORG = "olaporg";
    private static final String NUMBER = "number";
    private static final String ENTITY = "entity";
    private static final String SCENARIO = "scenario";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String MODEL = "model";
    private static final String SHOW_NUMBER = "shownumber";
    private static final String DEBIT = "debit";
    private static final String AUDIT_TRAIL = "audittrail";
    private static final String PROCESS_IMP = "process_imp";
    private static final String DIMENSION = "dimension";
    private static final String DATA_SORT = "datasort";
    private static final String ADJUST = "adjust";
    private static final String GROUP_NUM = "groupnum";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    private static final String SUM_MONEY = "summoney";
    private static final String CREDIT = "credit";
    private static final String VIEW_MEMB_ID = "viewmemb_Id";
    private Boolean isModelPerm = null;
    private SchemeContext sctx;
    private String modelShowNumber;
    private static final Log logger_orgin = LogFactory.getLog(AdjustCommonImportPlugin.class);
    private final AdjustInputMemberReader memberReader = new AdjustInputMemberReader();
    private AdjustImpModel adjustImpModel;
    private static final Map<String, String> masScheduleMapping = new HashMap<String, String>();
    private ConvertMoneyNode convertMoneyNode = new ConvertMoneyNode();
    public static Set<String> dimKeys;
    private static final String DEFAULT_DIM = "";

    private AdjustInputMemberReader getMemberReaderProxy(Long modelId, Long scene, Long year, Long period) {
        this.memberReader.getDefaultctx().setModelId(modelId.longValue());
        this.memberReader.getDefaultctx().setScenarioId(scene.longValue());
        this.memberReader.getDefaultctx().setFyId(year.longValue());
        this.memberReader.getDefaultctx().setPeriodId(period.longValue());
        return this.memberReader;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockUIs = new ArrayList<String>(2);
        lockUIs.add("radiofield1");
        lockUIs.add("radiofield2");
        return lockUIs;
    }

    public String getDefaultKeyFields() {
        return NUMBER;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 100000;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Object modeltemp;
        if (!CollectionUtils.isEmpty(billdatas) && (modeltemp = billdatas.get(0).getData().get((Object)MODEL)) != null) {
            QFBuilder qfBuilder = new QFBuilder();
            if (this.sctx == null) {
                JSONObject modelObj = (JSONObject)modeltemp;
                String shownumber = (String)modelObj.computeIfAbsent((Object)((String)modelObj.computeIfAbsent((Object)"importprop", e -> SHOW_NUMBER)), e -> DEFAULT_DIM);
                qfBuilder.add(SHOW_NUMBER, "=", (Object)shownumber);
                DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number,shownumber", (QFilter[])qfBuilder.toArray());
                if (model != null) {
                    this.sctx = new SchemeContext(model.getLong("id"));
                    this.modelShowNumber = shownumber;
                }
            }
        }
        if (this.sctx == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"AdjustCommonImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ComboProp comboProp = (ComboProp)this.mainEntityType.getProperty("bussnesstype");
        List<Pair<LocaleString, String>> bussinessType = AdjustModelUtil.getBussinessType(this.sctx.getModel(), Boolean.FALSE);
        List collect = bussinessType.stream().map(e -> new ValueMapItem(null, (String)e.p2, (LocaleString)e.p1)).collect(Collectors.toList());
        comboProp.setComboItems(collect);
        super.beforeSave(billdatas, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        Map option = this.ctx.getOption();
        for (String url : this.ctx.getAllUrls()) {
            try {
                Throwable cause;
                try {
                    InputStream in = service.getInputStream(url);
                    cause = null;
                    try {
                        MainEntityType mainEntityType = this.buildMainEntityType(null);
                        this.mainEntityType = mainEntityType = (MainEntityType)mainEntityType.clone();
                        if (mainEntityType instanceof QueryEntityType) {
                            mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                        }
                        reader.read(in, (SheetHandler)new AdjustBatchImportSheetHandler(this.ctx, mainEntityType, url, option, (HeartBeat)this.getFieldValueByName("heartbeat")));
                    }
                    catch (Throwable var25) {
                        cause = var25;
                        throw var25;
                    }
                    finally {
                        if (in == null) continue;
                        if (cause != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable var24) {
                                cause.addSuppressed(var24);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable var27) {
                    if (SystemParamServiceHelper.isShowStackTrace()) {
                        this.ctx.getLogger(url).log(Integer.valueOf(0), var27);
                    } else {
                        cause = var27.getCause();
                        String importErrMsg = cause instanceof KDBizException ? var27.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"AdjustCommonImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                        this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                    }
                    this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                }
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    private <T> T getFieldValueByName(String fieldName) {
        try {
            Field field = ((Object)((Object)this)).getClass().getDeclaredField(fieldName);
            ReflectionUtils.makeAccessible((Field)field);
            return (T)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger_orgin.error(ThrowableHelper.toString((Exception)e));
            return null;
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map<String, AdjustImpModel> num2AdjustModels = this.dealRowDatas(rowdatas);
        List<AdjustBillResult> billResults = this.readyDataForBatchSave(num2AdjustModels);
        return this.convert2AdjustModel(num2AdjustModels, billResults, logger);
    }

    private void excuteSave(List<DynamicObject> adjusts, List<DynamicObject> adjustDatas, DynamicObject[] adjDataDys) {
        try (TXHandle tx = TX.required();){
            try {
                BatchProcessHelper.batchConsume(adjusts, (int)1000, e -> SaveServiceHelper.save((DynamicObject[])e.toArray(new DynamicObject[0])));
                BatchProcessHelper.batchConsume(adjustDatas, (int)1000, e -> SaveServiceHelper.save((DynamicObject[])e.toArray(new DynamicObject[0])));
            }
            catch (Exception e2) {
                tx.markRollback();
                throw e2;
            }
        }
    }

    private ImpBaseDataModel getImpBaseDataModel(String field) {
        return this.getImpBaseDataModel(field, Boolean.TRUE);
    }

    private ImpBaseDataModel getImpBaseDataModel(String field, boolean isCheck) {
        ImpBaseDataModel baseDataModel = this.adjustImpModel.getBasedatas().get(field);
        if (baseDataModel == null && isCheck) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"AdjustCommonImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), field));
        }
        return baseDataModel;
    }

    /*
     * WARNING - void declaration
     */
    private ApiResult convert2AdjustModel(Map<String, AdjustImpModel> num2AdjustModels, List<AdjustBillResult> results, ImportLogger logger) {
        ArrayList<DynamicObject> adjusts = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> adjustDatas = new ArrayList<DynamicObject>(16);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AdjustImpModel> adjustModelEntry : num2AdjustModels.entrySet()) {
            AdjustBillResult result = new AdjustBillResult();
            try {
                ImpBaseDataModel belongOrgModel;
                void var11_12;
                this.adjustImpModel = adjustModelEntry.getValue();
                result.setNumber(this.adjustImpModel.getNumber());
                result.setSucess(true);
                result.setIndex(adjustModelEntry.getValue().getDindex());
                result.setData(this.adjustImpModel.getData());
                result.setScene(this.getImpBaseDataModel(SCENARIO).getId());
                result.setYear(this.getImpBaseDataModel(YEAR).getId());
                result.setPeriod(this.getImpBaseDataModel(PERIOD).getId());
                AdjustModel adjust = new AdjustModel();
                if (adjust.getId() != 0L) {
                    Long l = adjust.getId();
                } else {
                    Long l = GlobalIdUtil.genGlobalLongId();
                }
                adjust.setId(var11_12.longValue());
                adjust.setModelId(this.sctx.getModel());
                Map<String, Object> singleFields = adjustModelEntry.getValue().getSingleFields();
                adjust.setLinkCreateType(singleFields.getOrDefault("linkcreatetype", AdjustLinkCreateEnum.MANUALCREATEADJUST.getStatus()).toString());
                adjust.setScenarioId(this.getImpBaseDataModel(SCENARIO).getId());
                adjust.setYearId(this.getImpBaseDataModel(YEAR).getId());
                adjust.setPeriodId(this.getImpBaseDataModel(PERIOD).getId());
                ImpBaseDataModel entityModel = this.getImpBaseDataModel(ENTITY, Boolean.FALSE);
                if (entityModel != null) {
                    adjust.setMergeId(entityModel.getId());
                }
                if ((belongOrgModel = adjustModelEntry.getValue().getBasedatas().get("belongorg")) != null) {
                    this.checkBaseData(result, belongOrgModel);
                    adjust.setBelongOrg(Long.valueOf(belongOrgModel.getId()));
                }
                if (!result.isSucess()) continue;
                adjust.setBussnesstype(singleFields.getOrDefault("bussnesstype", "1").toString());
                BusinessTypeEnum bussEnum = BusinessTypeEnum.searchByName((String)adjust.getBussnesstype());
                boolean isMerge = OrgRelaProcessMembPool.isRelaProcess((String)bussEnum.getProcessNumber());
                adjust.setProcess(bussEnum.getProcessNumber());
                adjust.setNumber((String)adjustModelEntry.getValue().getSingleFields().get(NUMBER));
                adjust.setCreateTime(TimeServiceHelper.now());
                adjust.setCreatorId(Long.parseLong(RequestContext.getOrCreate().getUserId()));
                adjust.setStatus("0");
                adjust.setBalancetype(Integer.parseInt(singleFields.getOrDefault("balancetype", "1").toString()));
                adjust.setJournaltype(Integer.parseInt(singleFields.getOrDefault("journaltype", "0").toString()));
                adjust.setSpreadJson(DEFAULT_DIM);
                adjust.setModifierId(Long.parseLong(RequestContext.getOrCreate().getUserId()));
                adjust.setModifyTime(TimeServiceHelper.now());
                adjust.setCheckStatus(RptAdjustCheckStatusEnum.NOTCHECKED.getStatus());
                adjust.setIsContinuous(DEFAULT_DIM);
                adjust.setInputMode(DEBIT);
                adjust.setUpdatecycle(singleFields.getOrDefault("updatecycle", "0").toString());
                ImpBaseDataModel baseDataModel1 = adjustModelEntry.getValue().getBasedatas().get("cvtbeforecurrency");
                adjust.setCvtBeforeCurrencyId(baseDataModel1 == null ? 0L : baseDataModel1.getId());
                adjust.setEntrySource("0");
                Object multiplecurrency = adjustModelEntry.getValue().getSingleFields().get("multiplecurrency");
                adjust.setMultiplecurrency(this.getMultiplecurrencyValue(multiplecurrency));
                Map<String, Map<String, Object>> commons = this.getCommonMap(adjust, adjustModelEntry);
                Map<String, Map<String, Object>> spreads = this.getSpreadMap(adjust, adjustModelEntry);
                spreads.keySet().removeAll(commons.keySet());
                AdjustModelUtil.handleCommomEntryFilltoAdjustModel(adjust, new ArrayList<Map<String, Object>>(commons.values()));
                AdjustModelUtil.handleSpreadEntryFilltoAdjustModel(adjust, new ArrayList<Map<String, Object>>(spreads.values()));
                DynamicObject t = adjust.genDynamicObject();
                t.set("name", adjustModelEntry.getValue().getSingleFields().get("name"));
                ImpBaseDataModel catalog = adjustModelEntry.getValue().getBasedatas().get(TEMPLATE_CATALOG);
                t.set(TEMPLATE_CATALOG, (Object)(catalog == null ? 0L : catalog.getId()));
                t.set("iscontinuous", adjustModelEntry.getValue().getSingleFields().get("iscontinuous"));
                t.set("extend", adjust.get("extend"));
                t.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.IMPORT.getValue());
                ArrayList<AdjustBillResult> dataResultList = new ArrayList<AdjustBillResult>(16);
                ArrayList<DynamicObject> singleAdjustDatas = new ArrayList<DynamicObject>(16);
                Long mergeId = entityModel == null ? 0L : entityModel.getId();
                for (AdjustDataImpModel adjustDataImpModel : adjustModelEntry.getValue().getAdjustDataImpModels()) {
                    AdjustBillResult dataResult2 = new AdjustBillResult();
                    dataResult2.setSucess(true);
                    if (adjustDataImpModel.getSingleFields().containsKey("error")) {
                        dataResult2.setSucess(false);
                        dataResult2.setMessage(adjustDataImpModel.getSingleFields().get("error") + DEFAULT_DIM);
                        result.setSucess(false);
                    } else {
                        try {
                            DynamicObject adjustData = this.getAdjustDataDy(adjust, adjustDataImpModel, adjustModelEntry.getValue());
                            if (adjustData != null) {
                                if (mergeId == 0L || mergeId == -1L) {
                                    long entityId = adjustData.getLong(ENTITY);
                                    String[] entitys = MemberReader.findEntityMemberById((String)this.sctx.getModelNumber(), (Long)entityId).getLongNumber().split("!");
                                    if (entitys.length < 1) {
                                        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u957f\u7f16\u7801\u6570\u636e\u4e0d\u53ef\u89e3\u6790\u3002", (String)"AdjustCommonImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                    }
                                    mergeId = MemberReader.findEntityMemberByNum((String)this.sctx.getModelNumber(), (String)entitys[1]).getId();
                                    t.set(ENTITY, (Object)mergeId);
                                }
                                adjustData.set("merge", (Object)mergeId);
                                AdjustOperationHelper.fillAdjustDataOfOlapOrg((String)this.sctx.getModelNumber(), (DynamicObject)adjustData, (boolean)isMerge);
                                dataResult2.setId(adjustData.getLong("id"));
                                singleAdjustDatas.add(adjustData);
                            }
                        }
                        catch (Throwable e) {
                            dataResult2.setSucess(false);
                            dataResult2.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)e));
                            result.setSucess(false);
                        }
                    }
                    dataResult2.setIndex(adjustDataImpModel.index);
                    dataResult2.setData(adjustModelEntry.getValue().getData());
                    dataResultList.add(dataResult2);
                }
                if (result.isSucess()) {
                    AdjustOperationContext ctx = this.getMemberReaderProxy(adjust.getModelId(), adjust.getScenarioId(), adjust.getYearId(), adjust.getPeriodId()).getDefaultctx();
                    Pair result1 = AdjustmentServiceHelper.validateSceneVersion((AdjustOperationContext)ctx, (DynamicObject)t, singleAdjustDatas);
                    result.setSucess((Boolean)result1.p1);
                    result.setMessage(result.getMessage() + (String)result1.p2);
                }
                if (result.isSucess()) {
                    t.set("belongorg", t.get(ENTITY));
                    AdjustConvertUtil.resetSeq(singleAdjustDatas, (boolean)Boolean.TRUE, (AdjustDataSortRuleEnum)AdjustDataSortRuleEnum.GROUPSEQ_SORT);
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)t, singleAdjustDatas, (boolean)false);
                    adjustDatas.addAll(singleAdjustDatas);
                    adjusts.add(t);
                } else {
                    dataResultList.stream().filter(dataResult -> !dataResult.isSucess() && StringUtils.isNotBlank((CharSequence)dataResult.getMessage())).forEach(dataResult -> sb.append(ResManager.loadKDString((String)"\u7b2c", (String)"AdjustCommonImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(dataResult.getIndex()).append(ResManager.loadKDString((String)"\u884c\u5bfc\u5165\u5931\u8d25\uff1a\u5931\u8d25\u539f\u56e0\uff1a", (String)"AdjustCommonImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(dataResult.getMessage()));
                    result.setMessage(result.getMessage() + sb);
                    result.setSucess(false);
                    sb.setLength(0);
                }
            }
            catch (Throwable e) {
                if (e instanceof KDBizException) {
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e%s\u5b58\u5728\u5f02\u5e38\uff1a", (String)"AdjustCommonImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjustModelEntry.getKey()) + "\n" + AdjustmentServiceHelper.toString_Adj((Throwable)e));
                } else {
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u770b\u540e\u53f0\u65e5\u5fd7\uff1a%s", (String)"AdjustCommonImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjustModelEntry.getKey()));
                    logger_orgin.error(e);
                }
                result.setSucess(false);
            }
            results.add(result);
        }
        DynamicObject[] adjDataDys = this.dealNewOrOveride(adjusts, adjustDatas, results);
        this.excuteSave(adjusts, adjustDatas, adjDataDys);
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>(10);
        for (BillResult billResult : results) {
            if (!billResult.isSucess()) {
                apiResult.setSuccess(false);
            }
            billResults.add(billResult.toMap());
        }
        apiResult.setData(billResults);
        return apiResult;
    }

    private void checkBaseData(AdjustBillResult result, ImpBaseDataModel entityModel) {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)entityModel.get(NUMBER))) && entityModel.get(DIMENSION) == null) {
            result.setMessage(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728", (String)"AdjustCommonImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityModel.getDataEntityNumber() + ":" + entityModel.get(NUMBER)));
            result.setSucess(false);
        }
    }

    private String getMultiplecurrencyValue(Object multiplecurrency) {
        return multiplecurrency == null ? "0" : multiplecurrency.toString();
    }

    private DynamicObject[] dealNewOrOveride(List<DynamicObject> adjusts, List<DynamicObject> adjustDatas, List<AdjustBillResult> results) {
        Set adjnumbers = DynamicObjectCollectionUtil.getFieldSet(adjusts, (String)NUMBER);
        QFBuilder qfBuilder = new QFBuilder("model.id", "=", (Object)this.sctx.getModel());
        qfBuilder.add(NUMBER, "in", (Object)adjnumbers);
        DynamicObject[] adjustDys = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"id,number,status,scenario,year,period", (QFilter[])qfBuilder.toArray());
        if (adjustDys.length == 0) {
            return new DynamicObject[0];
        }
        this.reduceStatus(adjusts, results, adjustDys);
        return adjustDatas.toArray(new DynamicObject[0]);
    }

    private void reduceStatus(List<DynamicObject> adjusts, List<AdjustBillResult> results, DynamicObject[] adjustDys) {
        Set existNumbers = Arrays.stream(adjustDys).map(adjustDy -> adjustDy.getString(NUMBER).concat("_").concat(DynUtils.getBaseId((DynamicObject)adjustDy, (String)SCENARIO).toString()).concat("_").concat(DynUtils.getBaseId((DynamicObject)adjustDy, (String)YEAR).toString()).concat("_").concat(DynUtils.getBaseId((DynamicObject)adjustDy, (String)PERIOD).toString())).collect(Collectors.toSet());
        results.stream().filter(e -> e.isSucess()).forEach(e -> {
            if (existNumbers.contains(e.getNumber().concat("_").concat(e.getScene().toString()).concat("_").concat(e.getYear().toString()).concat("_").concat(e.getPeriod().toString()))) {
                e.setSucess(false);
                e.setMessage(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u5df2\u7ecf\u5b58\u5728\u4e0d\u53ef\u5bfc\u5165\u3002", (String)"AdjustCommonImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                existNumbers.add(e.getNumber());
            }
        });
        adjusts.removeIf(e -> existNumbers.contains(e.getString(NUMBER)));
    }

    private DynamicObject getAdjustDataDy(AdjustModel adjust, AdjustDataImpModel adjustDataImpModel, AdjustImpModel adjustImpModel) {
        IDNumberTreeNode memNode;
        if ("1".equals(adjustDataImpModel.getSingleFields().getOrDefault("islink", "0"))) {
            return null;
        }
        DynamicObject adjustData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
        adjustData.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        adjustData.set(ADJUST, (Object)adjust.getId());
        adjustData.set("dseq", adjustDataImpModel.getSingleFields().get("dseq_imp"));
        adjustData.set(GROUP_NUM, adjustDataImpModel.getSingleFields().get(GROUP_NUM));
        adjustData.set("description", adjustDataImpModel.getSingleFields().get("sumary_imp"));
        adjustData.set("entrysource", (Object)7);
        adjustData.set(MODEL, (Object)adjust.getModelId());
        this.sctx.getFieldMap().forEach((number, dimId) -> {
            switch (number) {
                case "year": {
                    adjustData.set(YEAR, adjust.get(YEAR));
                    break;
                }
                case "period": {
                    adjustData.set(PERIOD, adjust.get(PERIOD));
                    break;
                }
                case "scenario": {
                    adjustData.set(SCENARIO, adjust.get(SCENARIO));
                    break;
                }
                case "process": {
                    adjustData.set(number, (Object)MemberReader.findProcessMemberByNum((String)this.sctx.getModelNumber(), (String)adjust.getProcess()).getId());
                    break;
                }
                case "datasort": {
                    if (adjustImpModel.getBasedatas().get("datasort_imp") == null || adjustImpModel.getBasedatas().get("datasort_imp").getId() == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e%s\u7ef4\u5ea6\u672a\u586b\u5199\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCommonImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.sctx.getDimensionById(dimId.longValue()).getName()}));
                    }
                    adjustData.set(DATA_SORT, (Object)adjustImpModel.getBasedatas().get("datasort_imp").getId());
                    break;
                }
                case "entity": {
                    ImpBaseDataModel value1 = adjustDataImpModel.getBasedatas().get(masScheduleMapping.getOrDefault(number, number + "_imp"));
                    Long memId = value1 == null ? 0L : value1.getId();
                    if (memId == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e%s\u7ef4\u5ea6\u672a\u586b\u5199\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCommonImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.sctx.getDimensionById(dimId.longValue()).getName()}));
                    }
                    if (value1.get(OLAPORG) == null && OrgRelaProcessMembPool.isRelaProcess((String)adjust.getProcess())) {
                        memId = InvestServiceHelper.queryEffectiveOrg((Long)adjust.getModelId(), (Long)adjust.getScenarioId(), (Long)adjust.getYearId(), (Long)adjust.getPeriodId(), (Long)adjust.getMergeId(), (String)value1.getNumber());
                    }
                    if (memId == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ec4\u7ec7\u7ef4\u5ea6\u6570\u636e\u6ca1\u627e\u5230\u6709\u6548\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCommonImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    adjustData.set(ENTITY, (Object)memId);
                    break;
                }
                default: {
                    ImpBaseDataModel value = adjustDataImpModel.getBasedatas().get(masScheduleMapping.getOrDefault(number, number + "_imp"));
                    if (value == null || value.getId() == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e%s\u7ef4\u5ea6\u672a\u586b\u5199\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCommonImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.sctx.getDimensionById(dimId.longValue()).getName()}));
                    }
                    adjustData.set(number, (Object)value.getId());
                }
            }
        });
        if (("DEJE".equals(adjust.getProcess()) || "DADJ".equals(adjust.getProcess())) && (memNode = MemberReader.findEntityMemberById((Long)adjust.getModelId(), (Long)adjustData.getLong(ENTITY))).isLeaf()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u660e\u7ec6\u6210\u5458\u4e0d\u5141\u8bb8\u5bfc\u5165DADJ\u548cDEJE\u7b49\u62b5\u9500\u7c7b\u4e1a\u52a1\u7c7b\u578b\u7684\u5206\u5f55\u3002", (String)"AdjustCommonImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        adjustData.set("entryrowtype", adjustDataImpModel.getSingleFields().get("entryrowtype"));
        adjustData.set("isdefaultcurrency", adjustDataImpModel.getSingleFields().get("isdefaultcurrency"));
        adjustData.set("rate", adjustDataImpModel.getSingleFields().get("rate_imp"));
        adjustData.set("cvtbeforedebit", adjustDataImpModel.getSingleFields().get("cvtbeforedebit"));
        adjustData.set("cvtbeforecredit", adjustDataImpModel.getSingleFields().get("cvtbeforecredit"));
        adjustData.set("cvtbeforesummoney", adjustDataImpModel.getSingleFields().get("cvtbeforesummoney"));
        adjustData.set(DEBIT, adjustDataImpModel.getSingleFields().get("debit_imp"));
        adjustData.set(CREDIT, adjustDataImpModel.getSingleFields().get("credit_imp"));
        adjustData.set(SUM_MONEY, adjustDataImpModel.getSingleFields().get(SUM_MONEY));
        this.reconvertAdjustData(adjust, adjustData);
        return adjustData;
    }

    private void reconvertAdjustData(AdjustModel adjust, DynamicObject adjustData) {
        this.convertMoneyNode.clear();
        String accNum = MemberReader.findMemberById((long)adjust.getModelId(), (String)"bcm_accountmembertree", (Long)DynUtils.getBaseId((DynamicObject)adjustData, (String)"account")).getNumber();
        String defaultCurNum = MemberReader.findMemberById((long)adjust.getModelId(), (String)"bcm_currencymembertree", (Long)DynUtils.getBaseId((DynamicObject)adjustData, (String)"currency")).getNumber();
        this.convertMoneyNode.setAutoGainNewRate(false);
        this.convertMoneyNode.setCurrencyNumber(defaultCurNum);
        AdjustOperationHelper.resetMoneyNode((long)adjust.getModelId(), (String)accNum, (CurrencyMoneyNode)this.convertMoneyNode, (BigDecimal)adjustData.getBigDecimal(CREDIT), (BigDecimal)adjustData.getBigDecimal(DEBIT), (BigDecimal)adjustData.getBigDecimal(SUM_MONEY));
        if (adjust.getCvtBeforeCurrencyId() != 0L) {
            this.convertMoneyNode.setRate(adjustData.getBigDecimal("rate"));
            this.convertMoneyNode.getCvtBeforMoneyNode().setCurrencyNumber(defaultCurNum);
            AdjustOperationHelper.resetMoneyNode((long)adjust.getModelId(), (String)accNum, (CurrencyMoneyNode)this.convertMoneyNode.getCvtBeforMoneyNode(), (BigDecimal)adjustData.getBigDecimal("cvtbeforecredit"), (BigDecimal)adjustData.getBigDecimal("cvtbeforedebit"), (BigDecimal)adjustData.getBigDecimal("cvtbeforesummoney"));
            this.getMemberReaderProxy(adjust.getModelId(), adjust.getScenarioId(), adjust.getYearId(), adjust.getPeriodId()).resolveConvertInputMoney(this.convertMoneyNode);
        } else {
            this.getMemberReaderProxy(adjust.getModelId(), adjust.getScenarioId(), adjust.getYearId(), adjust.getPeriodId()).resolveInputMoney((CurrencyMoneyNode)this.convertMoneyNode);
        }
        adjustData.set("rate", (Object)this.convertMoneyNode.getRate());
        adjustData.set("cvtbeforedebit", (Object)this.convertMoneyNode.getCvtBeforMoneyNode().getDebit());
        adjustData.set("cvtbeforecredit", (Object)this.convertMoneyNode.getCvtBeforMoneyNode().getCredit());
        adjustData.set("cvtbeforesummoney", (Object)this.convertMoneyNode.getCvtBeforMoneyNode().getSummoney());
        adjustData.set(DEBIT, (Object)this.convertMoneyNode.getDebit());
        adjustData.set(CREDIT, (Object)this.convertMoneyNode.getCredit());
        adjustData.set(SUM_MONEY, (Object)this.convertMoneyNode.getSummoney());
    }

    private Map<String, Map<String, Object>> getCommonMap(AdjustModel adjust, Map.Entry<String, AdjustImpModel> adjustModelEntry) {
        DynamicObject dimension;
        HashMap<String, String> map;
        LinkedHashMap<String, Map<String, Object>> commons = new LinkedHashMap<String, Map<String, Object>>(16);
        for (Map.Entry<String, ImpBaseDataModel> baseDataEntry : adjustModelEntry.getValue().getBasedatas().entrySet()) {
            if (!dimKeys.contains(baseDataEntry.getKey()) || "cvtbeforecurrency".equals(baseDataEntry.getKey())) continue;
            map = new HashMap<String, String>();
            map.put(ENTITY, baseDataEntry.getValue().getDataEntityNumber());
            dimension = (DynamicObject)baseDataEntry.getValue().get(DIMENSION);
            if (dimension == null) continue;
            map.put("seq", dimension.getString("dseq"));
            map.put(DIMENSION, (String)dimension);
            if (PROCESS_IMP.equals(baseDataEntry.getKey())) {
                map.put(VIEW_MEMB_ID, DEFAULT_DIM + MemberReader.findProcessMemberByNum((String)this.sctx.getModelNumber(), (String)adjust.getProcess()).getId());
            } else {
                map.put(VIEW_MEMB_ID, DEFAULT_DIM + baseDataEntry.getValue().getId());
            }
            commons.put(dimension.getString(NUMBER), map);
        }
        String currencyNum = "RAdj".equals(adjust.getProcess()) ? "DC" : "EC";
        IDNumberTreeNode currencyMemberByNum = MemberReader.findCurrencyMemberByNum((String)this.sctx.getModelNumber(), (String)currencyNum);
        if (currencyMemberByNum != IDNumberTreeNode.NotFoundTreeNode) {
            map = new HashMap();
            map.put(ENTITY, "bcm_currencymembertree");
            dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyMemberByNum.getDimId(), (String)"bcm_dimension");
            map.put("seq", dimension.getString("dseq"));
            map.put(DIMENSION, (String)dimension);
            map.put(VIEW_MEMB_ID, DEFAULT_DIM + currencyMemberByNum.getId());
            commons.put("Currency", map);
        }
        return commons;
    }

    private Map<String, Map<String, Object>> getSpreadMap(AdjustModel model, Map.Entry<String, AdjustImpModel> adjustModelEntry) {
        ArrayList spreads = new ArrayList(16);
        for (AdjustDataImpModel adjustDataImpModel : adjustModelEntry.getValue().getAdjustDataImpModels()) {
            for (Map.Entry<String, ImpBaseDataModel> baseDataEntry : adjustDataImpModel.getBasedatas().entrySet()) {
                if (!dimKeys.contains(baseDataEntry.getKey())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ENTITY, baseDataEntry.getValue().getDataEntityNumber());
                Object dimension = baseDataEntry.getValue().get(DIMENSION);
                if (dimension == null) continue;
                map.put("seq", ((DynamicObject)dimension).getString("dseq"));
                map.put(DIMENSION, dimension);
                map.put("dimNum", ((DynamicObject)dimension).getString(NUMBER));
                map.put(VIEW_MEMB_ID, DEFAULT_DIM + baseDataEntry.getValue().getId());
                spreads.add(map);
            }
        }
        Collections.sort(spreads, Comparator.comparing(o -> Integer.valueOf(o.get("seq").toString())));
        LinkedHashMap<String, Map<String, Object>> spreadCopy = new LinkedHashMap<String, Map<String, Object>>(16);
        spreads.forEach(spread -> spreadCopy.put((String)spread.get("dimNum"), (Map<String, Object>)spread));
        return spreadCopy;
    }

    private Table<String, String, Set<String>> readyBaseInfos(Map<String, AdjustImpModel> num2AdjustModels) {
        HashBasedTable entity2Numbers = HashBasedTable.create();
        Consumer<Map.Entry> consumer = arg_0 -> AdjustCommonImportPlugin.lambda$readyBaseInfos$14((Table)entity2Numbers, arg_0);
        for (Map.Entry<String, AdjustImpModel> adjustModelEntry : num2AdjustModels.entrySet()) {
            for (Map.Entry<String, ImpBaseDataModel> impBaseModelEntry : adjustModelEntry.getValue().getBasedatas().entrySet()) {
                consumer.accept(impBaseModelEntry);
            }
            for (AdjustDataImpModel adjustDataImpModel : adjustModelEntry.getValue().getAdjustDataImpModels()) {
                for (Map.Entry<String, ImpBaseDataModel> impBaseModelEntry : adjustDataImpModel.getBasedatas().entrySet()) {
                    consumer.accept(impBaseModelEntry);
                }
            }
        }
        return entity2Numbers;
    }

    private List<AdjustBillResult> readyDataForBatchSave(Map<String, AdjustImpModel> num2AdjustModels) {
        Table<String, String, Set<String>> entity2Numbers = this.readyBaseInfos(num2AdjustModels);
        if (((Set)entity2Numbers.get((Object)"bcm_model", (Object)MODEL)).size() > 1 || ((Set)entity2Numbers.get((Object)"bcm_fymembertree", (Object)YEAR)).size() > 1 || ((Set)entity2Numbers.get((Object)"bcm_periodmembertree", (Object)PERIOD)).size() > 1 || ((Set)entity2Numbers.get((Object)"bcm_scenemembertree", (Object)SCENARIO)).size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5bfc\u5165\u53ea\u652f\u6301\u5728\u540c\u4e00\u4f53\u7cfb\u7684\u60c5\u666f\uff0c\u8d22\u5e74\u548c\u671f\u95f4\u4e0b\u3002", (String)"AdjustCommonImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!((Set)entity2Numbers.get((Object)"bcm_model", (Object)MODEL)).contains(this.modelShowNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u652f\u6301\u5728\u591a\u4e2a\u4f53\u7cfb\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\u3002", (String)"AdjustCommonImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder();
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)this.sctx.getModelNumber(), (String)((String)((Set)entity2Numbers.get((Object)"bcm_fymembertree", (Object)YEAR)).iterator().next()));
        long period = MemberReader.findPeriodMemberByNum((String)this.sctx.getModelNumber(), (String)((String)((Set)entity2Numbers.get((Object)"bcm_periodmembertree", (Object)PERIOD)).iterator().next())).getId();
        long scenario = MemberReader.findScenaMemberByNum((String)this.sctx.getModelNumber(), (String)((String)((Set)entity2Numbers.get((Object)"bcm_scenemembertree", (Object)SCENARIO)).iterator().next())).getId();
        ImportPreDataModel importPreDataModel = new ImportPreDataModel(this.sctx.getModel());
        AdjustImportValidator importValidator = new AdjustImportValidator(this.sctx);
        entity2Numbers.cellSet().stream().forEach(cell -> {
            if (((String)cell.getRowKey()).equals("bcm_model")) {
                importPreDataModel.put((String)cell.getRowKey(), (String)cell.getColumnKey(), (String)((Set)cell.getValue()).iterator().next(), this.sctx.getModel(), null);
            } else if (((String)cell.getRowKey()).equals("bcm_templatecatalog") && !CollectionUtils.isEmpty((Collection)((Collection)cell.getValue()))) {
                DynamicObject[] doc;
                qfBuilder.clear();
                qfBuilder.add(MODEL, "=", (Object)this.sctx.getModel());
                QFilter qf = new QFilter(NUMBER, "in", cell.getValue());
                qf.and("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.ADJCATALOG.getType()));
                if (((Set)cell.getValue()).contains(TemplateCatalogEnum.ROOT.getNumber())) {
                    qfBuilder.and(new QFBuilder(NUMBER, "=", (Object)TemplateCatalogEnum.ROOT.getNumber()).or(qf));
                } else {
                    qfBuilder.add(qf);
                }
                for (DynamicObject object : doc = BusinessDataServiceHelper.load((String)((String)cell.getRowKey()), (String)"id", (QFilter[])qfBuilder.toArray())) {
                    importPreDataModel.put((String)cell.getRowKey(), (String)cell.getColumnKey(), object.getString(NUMBER), object.getLong("id"), null);
                }
            } else if ("bcm_entitymembertree".equals(cell.getRowKey())) {
                qfBuilder.clear();
                qfBuilder.add(MODEL, "=", (Object)this.sctx.getModel());
                qfBuilder.add(NUMBER, "in", cell.getValue());
                qfBuilder.add("status", "!=", (Object)"A");
                Object[] docs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number,longnumber,dimension,currency", (QFilter[])qfBuilder.toArray());
                ArrayList docList = Lists.newArrayList((Object[])docs);
                if (yearNode.getId() != -1L && period != -1L && scenario != -1L) {
                    FilterOrgStructParam param = new FilterOrgStructParam(this.sctx.getModel(), scenario, yearNode.getNumber(), period);
                    EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)docList);
                }
                for (DynamicObject dy : docList) {
                    importPreDataModel.putOrg(dy.getString("longnumber"), dy.getLong("id"), dy.getLong("dimension.id"));
                    if (importPreDataModel.getOrgCurrency(dy.getString(NUMBER)) != null) continue;
                    DynamicObject cy = (DynamicObject)ThreadCache.get((Object)("currency_" + this.sctx.getModelNumber() + dy.get("currency.id")), () -> ReportServiceHelper.loadCurrencyMemberByDBCurrency((Object)dy.get("currency.id"), (Object)this.sctx.getModel(), (String)"id,number,dimension"));
                    if (cy == null) {
                        importValidator.addErrorMsg((String)cell.getRowKey(), dy.getLong("id"), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u9ed8\u8ba4\u5e01\u4e0d\u5b58\u5728", (String)"AdjustCommonImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.getString(NUMBER)));
                        continue;
                    }
                    importPreDataModel.addOrgCurrency(dy.getString(NUMBER), cy);
                    importPreDataModel.put("bcm_currencymembertree", "bcm_currencymembertree", cy.getString(NUMBER), cy.getLong("id"), cy.getLong(DIMENSION));
                }
            } else {
                String dimNum = DEFAULT_DIM;
                if ("bcm_userdefinedmembertree".equals(cell.getRowKey())) {
                    String dimStr = ((String)cell.getColumnKey()).split("_")[0];
                    Optional<Dimension> first = this.sctx.getDimensions().stream().filter(e -> e.getFieldmapped().equals(dimStr)).findFirst();
                    if (first.isPresent()) {
                        dimNum = first.get().getNumber();
                    }
                } else {
                    dimNum = DimEntityNumEnum.getNumberByEntieyNum((String)((String)cell.getRowKey()));
                }
                if (!StringUtils.isEmpty((CharSequence)dimNum)) {
                    String finalDimNum = dimNum;
                    ((Set)cell.getValue()).stream().map(e -> MemberReader.findMemberByNumber((String)this.sctx.getModelNumber(), (String)finalDimNum, (String)e)).filter(e -> IDNumberTreeNode.NotFoundTreeNode != e).collect(Collectors.toList()).stream().forEach(e -> {
                        importPreDataModel.put((String)cell.getRowKey(), (String)cell.getColumnKey(), e.getNumber(), e.getId(), e.getDimId());
                        if (!e.isLeaf()) {
                            importValidator.addErrorMsg((String)cell.getRowKey(), e.getId(), String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u4e0d\u53ef\u7528\u3002", (String)"AdjustCommonImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getNumber()));
                        } else if (e.getStorageType() == StorageTypeEnum.SHARE) {
                            importValidator.addErrorMsg((String)cell.getRowKey(), e.getId(), String.format(ResManager.loadKDString((String)"%s\u503c\u662f\u5171\u4eab\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u7528\u3002", (String)"AdjustCommonImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getNumber()));
                        } else if ("AuditTrail".equals(finalDimNum) && !"3".equals(e.getProperty("datasource") + DEFAULT_DIM)) {
                            importValidator.addErrorMsg((String)cell.getRowKey(), e.getId(), String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u6765\u6e90\u4e0d\u662f\u5206\u5f55\u8c03\u6574\uff0c\u4e0d\u53ef\u7528\u3002", (String)"AdjustCommonImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getNumber()));
                        }
                    });
                }
            }
        });
        this.initAdjustModel(importPreDataModel, importValidator, num2AdjustModels);
        importValidator.removeFailAdjust(num2AdjustModels);
        return importValidator.getFailBillResults();
    }

    public void initAdjustModel(ImportPreDataModel importPreDataModel, AdjustImportValidator importValidator, Map<String, AdjustImpModel> num2AdjustModels) {
        for (Map.Entry<String, AdjustImpModel> adjustModelEntry : num2AdjustModels.entrySet()) {
            importValidator.start(adjustModelEntry.getValue());
            importValidator.validatorSingleHead();
            for (Map.Entry<String, ImpBaseDataModel> impBaseModelEntry : adjustModelEntry.getValue().getBasedatas().entrySet()) {
                DynamicObject cyDy;
                ImpBaseDataModel value = impBaseModelEntry.getValue();
                boolean isOrg = value.getDataEntityNumber().equals("bcm_entitymembertree");
                Pair<Long, DynamicObject> id2Dim = null;
                id2Dim = isOrg ? this.getOrgIdFromEntityNumber2Ids(null, value.getNumber(), importPreDataModel) : importPreDataModel.get(value.getDataEntityNumber(), impBaseModelEntry.getKey(), value.getNumber());
                value.setId((Long)id2Dim.p1);
                value.put(DIMENSION, id2Dim.p2);
                if (isOrg && (cyDy = importPreDataModel.getOrgCurrency(value.getNumber())) != null) {
                    value.put("org.currency", cyDy);
                    value.put("org.currency.dimension", importPreDataModel.get((String)"bcm_currencymembertree", (String)"bcm_currencymembertree", (String)cyDy.getString((String)NUMBER)).p2);
                }
                importValidator.validatorBaseDataToHead(impBaseModelEntry.getKey(), value);
            }
            for (AdjustDataImpModel adjustDataImpModel : adjustModelEntry.getValue().getAdjustDataImpModels()) {
                for (Map.Entry<String, ImpBaseDataModel> impBaseModelEntry : adjustDataImpModel.getBasedatas().entrySet()) {
                    ImpBaseDataModel value = impBaseModelEntry.getValue();
                    boolean isOrg = value.getDataEntityNumber().equals("bcm_entitymembertree");
                    Pair<Long, DynamicObject> id2Dim = null;
                    if (isOrg) {
                        String olapOrg = null;
                        if (importValidator.isMerge()) {
                            olapOrg = (String)adjustDataImpModel.getSingleFields().get(OLAPORG);
                            value.put(OLAPORG, olapOrg);
                        }
                        if (olapOrg == null) {
                            olapOrg = adjustModelEntry.getValue().getMergeOrgNumber();
                        }
                        id2Dim = this.getOrgIdFromEntityNumber2Ids(olapOrg, value.getNumber(), importPreDataModel);
                    } else {
                        id2Dim = importPreDataModel.get(value.getDataEntityNumber(), impBaseModelEntry.getKey(), value.getNumber());
                    }
                    value.setId((Long)id2Dim.p1);
                    value.put(DIMENSION, id2Dim.p2);
                    importValidator.validatorBaseDataToBody(adjustDataImpModel, impBaseModelEntry.getKey(), value);
                }
            }
            importValidator.validatorEntryDataBatch();
            importValidator.end();
        }
    }

    private Pair<Long, DynamicObject> getOrgIdFromEntityNumber2Ids(String mergeOrgNumber, String orgnumber, ImportPreDataModel importPreDataModel) {
        boolean containsOlapOrg = mergeOrgNumber != null && mergeOrgNumber.contains("_");
        String olapOrg = containsOlapOrg ? mergeOrgNumber : null;
        mergeOrgNumber = containsOlapOrg ? mergeOrgNumber.split("_")[0] : mergeOrgNumber;
        Map<String, Pair<Long, DynamicObject>> entityMap = importPreDataModel.rowNumberAndId("bcm_entitymembertree", "bcm_entitymembertree");
        for (Map.Entry<String, Pair<Long, DynamicObject>> entityMaps : entityMap.entrySet()) {
            if (!entityMaps.getKey().endsWith("!" + orgnumber) || !(olapOrg == null ? orgnumber.equals(mergeOrgNumber) || mergeOrgNumber == null || entityMaps.getKey().contains("!" + mergeOrgNumber + "!") : olapOrg.equals(AdjustCheckServiceHelper.getParentDirectChild((String)mergeOrgNumber, (String)entityMaps.getKey())))) continue;
            return entityMaps.getValue();
        }
        return ImportPreDataModel.EMPTY_BASEDATA;
    }

    private Map<String, AdjustImpModel> dealRowDatas(List<ImportBillData> rowdatas) {
        ArrayList<ImportBillData> newRowdatas = new ArrayList<ImportBillData>(16);
        Predicate<Object> isEmpty = s -> s == null || StringUtils.isEmpty((CharSequence)s.toString());
        HashMap<String, AdjustImpModel> num2AdjustModels = new HashMap<String, AdjustImpModel>(16);
        int dataIndex = 0;
        for (ImportBillData billdata : rowdatas) {
            int index = 0;
            AdjustImpModel adjustImpModel = new AdjustImpModel();
            adjustImpModel.setData((Map<String, Object>)billdata.getData());
            adjustImpModel.setDindex(dataIndex++);
            adjustImpModel.setStartIndex(billdata.getStartIndex());
            adjustImpModel.setEndIndex(billdata.getEndIndex());
            for (Map.Entry entry : billdata.getData().entrySet()) {
                if (entry.getValue() instanceof JSONObject) {
                    JSONObject baseData = (JSONObject)entry.getValue();
                    if (isEmpty.test(baseData.get((Object)NUMBER)) && isEmpty.test(baseData.get((Object)SHOW_NUMBER))) continue;
                    ImpBaseDataModel baseDataModel = new ImpBaseDataModel();
                    baseDataModel.setNumber(!isEmpty.test(baseData.get((Object)NUMBER)) ? baseData.getString(NUMBER) : baseData.getString(SHOW_NUMBER));
                    baseDataModel.setDataEntityNumber(this.getEntity((String)entry.getKey()));
                    adjustImpModel.putBaseDatas((String)entry.getKey(), baseDataModel);
                    if (!ENTITY.equalsIgnoreCase((String)entry.getKey())) continue;
                    adjustImpModel.setMergeOrgNumber(baseData.getString(NUMBER));
                    continue;
                }
                if ("entryentity".equals(entry.getKey())) {
                    for (Object entryData : (JSONArray)entry.getValue()) {
                        AdjustDataImpModel adjustDataImpModel = new AdjustDataImpModel();
                        newRowdatas.add(billdata);
                        adjustDataImpModel.setIndex(billdata.getStartIndex() + index);
                        ++index;
                        for (Map.Entry dataObj : ((JSONObject)entryData).entrySet()) {
                            if (dataObj.getValue() instanceof JSONObject) {
                                JSONObject entryBaseData = (JSONObject)dataObj.getValue();
                                if (isEmpty.test(entryBaseData.get((Object)NUMBER))) continue;
                                ImpBaseDataModel baseDataModel = new ImpBaseDataModel();
                                baseDataModel.setNumber(entryBaseData.getString(NUMBER));
                                baseDataModel.setDataEntityNumber(this.getEntity((String)dataObj.getKey()));
                                adjustDataImpModel.putBaseDatas((String)dataObj.getKey(), baseDataModel);
                                continue;
                            }
                            if ("sumary_imp".equals(dataObj.getKey())) {
                                if (dataObj.getValue() != null) {
                                    if (dataObj.getValue() instanceof Map) {
                                        adjustDataImpModel.putSingeFields("sumary_imp", LocaleString.fromMap((Map)((Map)dataObj.getValue())).toString().trim());
                                        continue;
                                    }
                                    adjustDataImpModel.putSingeFields("sumary_imp", dataObj.getValue());
                                    continue;
                                }
                                adjustDataImpModel.putSingeFields("sumary_imp", DEFAULT_DIM);
                                continue;
                            }
                            adjustDataImpModel.putSingeFields((String)dataObj.getKey(), dataObj.getValue());
                        }
                        adjustImpModel.addAdjustDataImpModel(adjustDataImpModel);
                    }
                    continue;
                }
                if (entry.getValue() == null) continue;
                if ("sumary_imp".equals(entry.getKey()) || "name".equals(entry.getKey())) {
                    if (entry.getValue() instanceof Map) {
                        adjustImpModel.putSingeFields((String)entry.getKey(), LocaleString.fromMap((Map)((Map)entry.getValue())).toString().trim());
                        continue;
                    }
                    adjustImpModel.putSingeFields((String)entry.getKey(), entry.getValue());
                    continue;
                }
                adjustImpModel.putSingeFields((String)entry.getKey(), entry.getValue());
            }
            if (num2AdjustModels.get(adjustImpModel.getNumber()) != null) {
                ((AdjustImpModel)num2AdjustModels.get(adjustImpModel.getNumber())).addAdjustDataImpModel(adjustImpModel.getAdjustDataImpModels());
                continue;
            }
            num2AdjustModels.put(adjustImpModel.getNumber(), adjustImpModel);
        }
        return num2AdjustModels;
    }

    private String getEntity(String key) {
        switch (key) {
            case "scenario": {
                return "bcm_scenemembertree";
            }
            case "year": {
                return "bcm_fymembertree";
            }
            case "period": {
                return "bcm_periodmembertree";
            }
            case "audittrail": 
            case "audittrail_imp": 
            case "audittrail_imp1": {
                return "bcm_audittrialmembertree";
            }
            case "process_imp1": 
            case "process_imp": {
                return "bcm_processmembertree";
            }
            case "cvtbeforecurrency": 
            case "currency_imp": {
                return "bcm_currencymembertree";
            }
            case "entity": 
            case "belongorg": 
            case "org_imp": {
                return "bcm_entitymembertree";
            }
            case "account_imp": {
                return "bcm_accountmembertree";
            }
            case "changetype_imp": {
                return "bcm_changetypemembertree";
            }
            case "mycompany_imp": {
                return "bcm_mycompanymembertree";
            }
            case "icorg_imp": {
                return "bcm_icmembertree";
            }
            case "dim1_imp": 
            case "dim2_imp": 
            case "dim3_imp": 
            case "dim4_imp": 
            case "dim5_imp": 
            case "dim6_imp": {
                return "bcm_userdefinedmembertree";
            }
            case "multigaap_imp": {
                return "bcm_rulemembertree";
            }
            case "templatecatalog": {
                return "bcm_templatecatalog";
            }
            case "datasort_imp": {
                return "bcm_datasortmembertree";
            }
        }
        return "bcm_model";
    }

    private static /* synthetic */ void lambda$readyBaseInfos$14(Table entity2Numbers, Map.Entry e) {
        HashSet<String> vals;
        String dimStr = (String)e.getKey();
        ImpBaseDataModel value = (ImpBaseDataModel)((Object)e.getValue());
        if (value.getDataEntityNumber().equals("bcm_entitymembertree")) {
            dimStr = "bcm_entitymembertree";
        }
        if ((vals = (HashSet<String>)entity2Numbers.get((Object)value.getDataEntityNumber(), (Object)dimStr)) == null) {
            vals = new HashSet<String>(16);
            entity2Numbers.put((Object)value.getDataEntityNumber(), (Object)dimStr, vals);
        }
        vals.add(value.getNumber());
    }

    static {
        masScheduleMapping.put(ENTITY, "org_imp");
        masScheduleMapping.put("internalcompany", "icorg_imp");
        masScheduleMapping.put("process", "process_imp1");
        dimKeys = Sets.newHashSet((Object[])new String[]{SCENARIO, YEAR, PERIOD, AUDIT_TRAIL, "cvtbeforecurrency", PROCESS_IMP, "org_imp", "account_imp", "datasort_imp", "audittrail_imp", "changetype_imp", "mycompany_imp", "multigaap_imp", "icorg_imp", "datasort_imp", "dim1_imp", "dim2_imp", "dim3_imp", "dim4_imp", "dim5_imp", "dim6_imp"});
    }

    public static class AdjustDataImpModel
    extends AbstractImpModel {
        private int index = 0;

        public void setIndex(int i) {
            this.index = i;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class AdjustImpModel
    extends AbstractImpModel {
        private List<AdjustDataImpModel> adjustDataImpModels = new ArrayList<AdjustDataImpModel>(16);
        private Map<String, Object> data;
        private int startIndex = 0;
        private int endIndex = 0;
        private int dindex = 0;
        private String mergeOrgNumber;

        public int getStartIndex() {
            return this.startIndex;
        }

        public void setAdjustDataImpModels(List<AdjustDataImpModel> adjustDataImpModels) {
            this.adjustDataImpModels = adjustDataImpModels;
        }

        public String getMergeOrgNumber() {
            return this.mergeOrgNumber;
        }

        public void setMergeOrgNumber(String mergeOrgNumber) {
            this.mergeOrgNumber = mergeOrgNumber;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }

        public void addAdjustDataImpModel(AdjustDataImpModel a) {
            this.adjustDataImpModels.add(a);
        }

        public void addAdjustDataImpModel(List<AdjustDataImpModel> as) {
            this.adjustDataImpModels.addAll(as);
        }

        public List<AdjustDataImpModel> getAdjustDataImpModels() {
            return this.adjustDataImpModels;
        }

        public String getNumber() {
            return (String)this.singleFields.get(AdjustCommonImportPlugin.NUMBER);
        }

        public int getDindex() {
            return this.dindex;
        }

        public void setDindex(int dindex) {
            this.dindex = dindex;
        }
    }

    public static class AdjustBillResult
    extends BillResult {
        private Long scene;
        private Long year;
        private Long period;

        public Long getScene() {
            return this.scene;
        }

        public void setScene(Long scene) {
            this.scene = scene;
        }

        public Long getYear() {
            return this.year;
        }

        public void setYear(Long year) {
            this.year = year;
        }

        public Long getPeriod() {
            return this.period;
        }

        public void setPeriod(Long period) {
            this.period = period;
        }
    }
}

