/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.model;

import java.util.Collection;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustEditPageHyperLink {
    private DynamicObject adjust;
    private IFormView curPageView;
    private AdjustModel am;
    private OperationStatus operationStatus = OperationStatus.EDIT;
    private IFormView parentView;
    private CloseCallBack closeCallBack;

    public AdjustEditPageHyperLink(long adjustId, IFormView curPageView) {
        this.am = new AdjustModel();
        this.adjust = BusinessDataServiceHelper.loadSingle((Object)adjustId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        this.am.loadDynaObj2Model(this.adjust);
        this.curPageView = curPageView;
    }

    public AdjustEditPageHyperLink(DynamicObject adjust, IFormView curPageView) {
        this.am = new AdjustModel();
        this.adjust = adjust;
        this.am.loadDynaObj2Model(this.adjust);
        this.curPageView = curPageView;
    }

    public static long queryAdjustId(long modelId, long scenarioId, long fyId, long periodId, String adjustNumber) {
        QFilter[] qFilters = new QFilter("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)fyId).and("period", "=", (Object)periodId).and("number", "=", (Object)adjustNumber).toArray();
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])qFilters, null, (int)1);
        if (CollectionUtils.isNotEmpty((Collection)pkIds)) {
            return (Long)pkIds.get(0);
        }
        return 0L;
    }

    public void setOperationStatus(OperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void setParentView(IFormView parentView) {
        this.parentView = parentView;
    }

    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }

    private String getOpenTypeByProcess(String sProcess) {
        String opentype = "";
        opentype = "IRpt".equalsIgnoreCase(sProcess) || "CS".equalsIgnoreCase(sProcess) || "DADJ".equalsIgnoreCase(sProcess) || "DEJE".equalsIgnoreCase(sProcess) ? "rpt" : ("ADJ".equalsIgnoreCase(sProcess) || "CCADJ".equalsIgnoreCase(sProcess) || "CADJ".equalsIgnoreCase(sProcess) || "EJE".equalsIgnoreCase(sProcess) ? "adjust" : "elim");
        return opentype;
    }

    public void show() {
        IFormView mainPageView = this.curPageView.getMainView();
        if (this.parentView == null) {
            this.parentView = this.curPageView.getParentView();
        }
        boolean isLinkagePage = this.adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()) || this.adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue());
        String pageId = this.curPageView.getPageId() + this.curPageView.getFormShowParameter().getAppId() + RequestContext.get().getCurrUserId() + "-" + this.am.getId() + (isLinkagePage ? "link" : "source");
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            String opentype = this.getOpenTypeByProcess(this.adjust.getString("process"));
            FormShowParameter param = new FormShowParameter();
            param.setPageId(pageId);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCustomParam("KEY_MODEL_ID", (Object)(this.am.getModelId() + ""));
            param.setCustomParam("KEY_SCENARIO_ID", (Object)this.am.getScenarioId());
            param.setCustomParam("opentype", (Object)opentype);
            param.setCustomParam("model", (Object)this.am.getModelId());
            param.setCustomParam("modelNumber", (Object)MemberReader.findModelNumberById((Object)this.am.getModelId()));
            param.setCustomParam("OpenSource", (Object)"hyperLink");
            param.setCustomParam("selectedNodeId", (Object)(DynUtils.getBaseId((DynamicObject)this.adjust, (String)"entity") + ""));
            param.setCustomParam("process", (Object)this.adjust.getString("process"));
            param.setCustomParam("multiplecurrency", (Object)this.adjust.getString("multiplecurrency"));
            param.setCustomParam("templatecatalog", this.am != null ? this.am.getTemplatecatalog() : null);
            param.setCustomParam("inputMode", (Object)"summoney");
            this.am.put("isIncludeLinkage", (Object)isLinkagePage);
            if (isLinkagePage) {
                param.setCustomParam("yearNum", (Object)MemberReader.findFyMemberById((Long)this.am.getModelId(), (Long)this.am.getYearId()).getNumber());
                param.setCustomParam("periodId", (Object)this.am.getPeriodId());
            }
            param.setCustomParam("multiplecurrency", this.am != null ? this.am.getMultiplecurrency() : null);
            param.setFormId("bcm_adjustoffset_entry");
            int maxgroup = AdjustModelUtil.getMaxGroupIndex(this.am.getId());
            param.setCustomParam("maxgroup", (Object)maxgroup);
            param.setCustomParam("isLinkPage", (Object)isLinkagePage);
            param.setCustomParam("adjust_model", (Object)ObjectSerialUtil.toByteSerialized((Object)this.am));
            param.setCaption(isLinkagePage ? ResManager.loadKDString((String)"\u8054\u52a8\u5206\u5f55", (String)"RptAdjustdListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55", (String)"RptAdjustdListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (this.closeCallBack != null) {
                param.setCloseCallBack(this.closeCallBack);
            }
            param.setStatus(this.operationStatus);
            if (this.parentView == null) {
                this.curPageView.showForm(param);
            } else {
                this.parentView.getParentView().showForm(param);
                this.curPageView.sendFormAction(this.parentView.getParentView());
            }
        } else {
            IFormView childFormView = this.curPageView.getView(pageId);
            childFormView.activate();
            this.curPageView.sendFormAction(childFormView);
        }
    }

    public AdjustModel getAdjustModel() {
        return this.am;
    }
}

