/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.model;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.formplugin.adjust.model.ActionModel;
import kd.fi.bcm.formplugin.adjust.model.AreaPositionManger;
import kd.fi.bcm.formplugin.adjust.model.BatchActionModel;
import kd.fi.bcm.formplugin.adjust.model.CommonActionModel;
import kd.fi.bcm.formplugin.adjust.model.RangeActionModel;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.UserObject;

public class AdjustSpreadActionHandlerProxy {
    private String spreadkey;
    private IFormView view;
    private SpreadManager spreadManager;
    private AdjustModel adjust;
    private boolean needInvoke = false;
    private AreaPositionManger pos;
    private final List<Integer> insertColList = new ArrayList<Integer>(10);
    private final Map<String, ActionModel> commonActionQuene = new LinkedHashMap<String, ActionModel>(50);
    private final Map<String, Object> toUpValueMap = new HashMap<String, Object>(60);
    private final Map<String, Object> toUpFormulaMap = new HashMap<String, Object>(60);
    private int maxRow = 0;

    public AdjustSpreadActionHandlerProxy(IFormView view, String spreadkey) {
        this(view, null, null, null, spreadkey);
    }

    public AdjustSpreadActionHandlerProxy(IFormView view, AdjustModel adjust, SpreadManager spreadManager, AreaPositionManger pos, String spreadkey) {
        this.spreadkey = spreadkey;
        this.adjust = adjust;
        this.view = view;
        this.pos = pos;
        this.setSpreadManager(spreadManager);
    }

    public boolean invokeCommands() {
        return this.invokeCommands(true);
    }

    public boolean invokeCommands(Boolean needCache) {
        this.invokeAskExcuteCommand();
        this.invokeCommonCommand();
        this.invokeUpdateCellCommand();
        if (this.isNeedInvoke()) {
            this.getAreaPositionManger().updateCache();
            if (needCache.booleanValue()) {
                this.getView().getPageCache().put("KEY_SPREAD_MODEL", ObjectSerialUtil.toByteSerialized((Object)this.getSpreadManager()));
            }
            this.setNeedInvoke(false);
            return true;
        }
        return false;
    }

    public boolean isNeedInvoke() {
        return this.needInvoke;
    }

    private void invokeAskExcuteCommand() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        if (this.insertColList.size() > 0) {
            LinkedHashMap<String, ArrayList<Integer>> map = new LinkedHashMap<String, ArrayList<Integer>>();
            map.put("data", new ArrayList<Integer>(this.insertColList));
            SpreadClientInvoker.invokeInsertCol(clientViewProxy, this.spreadkey, map);
            this.insertColList.clear();
            this.setNeedInvoke(true);
        }
    }

    private void invokeCommonCommand() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        if (!this.commonActionQuene.isEmpty()) {
            this.commonActionQuene.forEach((actionSign, actionModel) -> SpreadClientInvoker.invokeMethod(clientViewProxy, actionModel.getActionSign(), this.spreadkey, actionModel.createInstruction()));
            this.commonActionQuene.clear();
            this.getAreaPositionManger().updateCache();
        }
    }

    private void invokeUpdateCellCommand() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        if (!this.toUpFormulaMap.isEmpty()) {
            List toUpFormulas = this.toUpFormulaMap.entrySet().parallelStream().map(p -> {
                Point point = ExcelUtils.pos2Point((String)((String)p.getKey()));
                return SpreadEasyInvoker.packedFormulaCellMap(point.y, point.x, p.getValue());
            }).collect(Collectors.toList());
            SpreadClientInvoker.invokeSetFormulaMethod(clientViewProxy, this.spreadkey, toUpFormulas);
            this.toUpFormulaMap.clear();
            this.setNeedInvoke(true);
        }
        if (!this.toUpValueMap.isEmpty()) {
            List toUpValues = this.toUpValueMap.entrySet().parallelStream().map(p -> {
                Point point = ExcelUtils.pos2Point((String)((String)p.getKey()));
                return AdjustModelUtil.packedUpdateCellMap(point.y, point.x, p.getValue());
            }).collect(Collectors.toList());
            SpreadClientInvoker.invokeUpdataValueMethod(clientViewProxy, this.spreadkey, toUpValues);
            this.toUpValueMap.clear();
            this.setNeedInvoke(true);
        }
    }

    public <T> T getCellValue(int r, int c, Class<T> clazz) {
        Object value = this.getEffectSheet().getCell(r, c).getValue();
        if (value == null) {
            return null;
        }
        if (clazz == String.class) {
            value = value.toString();
        } else if (clazz == Integer.class) {
            try {
                value = Integer.parseInt(value.toString());
            }
            catch (Throwable t) {
                value = null;
            }
        } else if (clazz == Double.class) {
            if (!(value instanceof BigDecimal)) {
                value = InvestUtils.convertToDouble((Object)value);
            }
        } else if (clazz == BigDecimal.class && !(value instanceof BigDecimal)) {
            value = InvestUtils.convertToBigDecimal((Object)value);
        }
        return value == null ? null : (T)clazz.cast(value);
    }

    public UserObject getUserObject(int r, int c) {
        return this.getEffectSheet().getCell(r, c).getUserObject();
    }

    public void setFormula(int r, int c, String formulaStr) {
        this.getEffectSheet().getCell(r, c).setFormula(formulaStr);
        this.toUpFormulaMap.put(ExcelUtils.xy2Pos((int)c, (int)r), formulaStr);
    }

    public Cell setCellValue(Integer row, Integer col, Object value) {
        return this.setCellValue(row, col, value, false);
    }

    public Cell setCellValue(Integer row, Integer col, Object value, Boolean isOnlyChangeFront) {
        return this.setCellValue(row, col, value, isOnlyChangeFront, false);
    }

    public Cell setCellValueCheckSame(Integer row, Integer col, Object value) {
        return this.setCellValue(row, col, value, false, true);
    }

    public Cell setCellValue(Integer row, Integer col, Object newValue, Boolean isOnlyChangeFront, Boolean isCheckSame) {
        boolean isSameValue;
        if (row == null || col == null) {
            return null;
        }
        Cell selectCell = this.getEffectSheet().getCell(row.intValue(), col.intValue());
        Object oldValue = selectCell.getValue();
        if (!isOnlyChangeFront.booleanValue()) {
            if (newValue instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)newValue) == 0) {
                newValue = null;
            }
            selectCell.setValue(newValue);
        }
        boolean bl = isSameValue = isCheckSame != false && Objects.equals(oldValue, newValue);
        if (isOnlyChangeFront.booleanValue() || !isSameValue) {
            this.toUpValueMap.put(ExcelUtils.xy2Pos((int)col, (int)row), newValue);
        }
        return selectCell;
    }

    public void setAlign(int r, int rc, int c, int cc, int horizontalAlign) {
        Map properties = MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.STYLE.k(), (Object)MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), (Object)horizontalAlign));
        this.joinBatchRangeActionQuene(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), r, c, rc, cc, properties);
    }

    public void setColumnFormat(int c, int cc, String style) {
        this.setRangeFormat(1, c, this.getMaxRow(), cc, style);
    }

    public void setRangeFormat(int r, int c, int rc, int cc, String style) {
        Map properties = MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.STYLE.k(), (Object)MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.FORMAT.k(), (Object)style));
        this.joinBatchRangeActionQuene(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), r, c, rc, cc, properties);
    }

    public void setCellColorStyle(int r, int rc, int c, int cc, String bgColor, int horizontalAlign) {
        this.setCellColorStyle(r, rc, c, cc, bgColor);
        this.setAlign(r, rc, c, cc, horizontalAlign);
    }

    public void setCellColorStyle(int r, int rc, int c, int cc, String bgColor) {
        Map properties = MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.STYLE.k(), (Object)MapInitHelper.ofMap((Object)SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), (Object)bgColor));
        this.joinBatchRangeActionQuene(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), r, c, rc, cc, properties);
    }

    public void setColumnF7Style(int c, int cc, int dst, int selectType) {
        this.setCellF7Style(1, c, this.getMaxRow(), cc, dst, selectType);
    }

    public void setCellF7Style(int r, int c, int rc, int cc, int dst, int selectType) {
        this.joinRangeActionQuene(SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), r, c, rc, cc, MapInitHelper.ofMap((Object)SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), (Object)dst, (Object)SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), (Object)selectType));
    }

    public void resetColumnStyle(int c, int cc) {
        this.resetCellStyle(0, c, this.getMaxRow(), cc);
    }

    public void resetCellStyle(int r, int c, int rc, int cc) {
        this.joinRangeActionQuene(SpreadProperties.ResetCellMethod.RESETCELL.k(), r, c, rc, cc, Maps.newHashMap());
    }

    public void setCornerMark(int r, int c, int rc, int cc, boolean visible, String text, String bc, String fc, int[] pos) {
        this.joinBatchRangeActionQuene("setCornerMark", r, c, rc, cc, MapInitHelper.ofMap((Object)"vi", (Object)visible, (Object)"text", (Object)text, (Object)"bc", (Object)bc, (Object)"fc", (Object)fc, (Object)"pos", (Object)pos));
    }

    public void setColumnLock(int col, int cc) {
        this.setCellLock(0, this.getMaxRow(), col, cc);
    }

    public void setCellLock(int r, int rc, int c, int cc) {
        Map properties = MapInitHelper.ofMap((Object)SpreadProperties.LockCellMethod.R.k(), (Object)r, (Object)SpreadProperties.LockCellMethod.C.k(), (Object)c, (Object)SpreadProperties.LockCellMethod.RC.k(), (Object)rc, (Object)SpreadProperties.LockCellMethod.CC.k(), (Object)cc);
        this.joinBatchCommonActionQuene(SpreadProperties.LockCellMethod.LOACKCELL.k(), properties, null);
    }

    public void setFrozenSheet(int r, int c, int tr, int tc, String flc, int si) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), r);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), c);
        features.put(SpreadProperties.SetFrozenSheetMethod.TR.k(), tr);
        features.put(SpreadProperties.SetFrozenSheetMethod.TC.k(), tc);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), flc);
        features.put(SpreadProperties.SetFrozenSheetMethod.SI.k(), si);
        this.joinActionQuene(((Object)features).toString(), actionModel -> {
            if (actionModel == null) {
                actionModel = new CommonActionModel(SpreadProperties.SetFrozenSheetMethod.FROZENSHEET.k());
                for (Map.Entry entry : features.entrySet()) {
                    actionModel.addProperty((String)entry.getKey(), entry.getValue());
                }
            }
            return actionModel;
        });
    }

    public void setColumnWidth(int col, int width) {
        this.joinActionQuene(SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + "_" + width, actionModel -> {
            if (actionModel == null) {
                actionModel = new CommonActionModel(SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k());
                actionModel.addProperty("index", new int[]{col});
                actionModel.addProperty("num", width);
            } else {
                int[] nums = (int[])actionModel.getProperty("index");
                nums = Arrays.copyOf(nums, nums.length + 1);
                nums[nums.length - 1] = col;
                actionModel.addProperty("index", nums);
            }
            return actionModel;
        });
    }

    public void setColumnVisible(int[] colArray, boolean visible) {
        this.joinActionQuene(SpreadProperties.SetColumnsVisible.SETCOLUMNSVISIBLE.k() + "_" + visible, actionModel -> {
            if (actionModel == null) {
                actionModel = new CommonActionModel(SpreadProperties.SetColumnsVisible.SETCOLUMNSVISIBLE.k());
                actionModel.addProperty(SpreadProperties.SetColumnsVisible.COLS.k(), colArray);
                actionModel.addProperty(SpreadProperties.SetColumnsVisible.VALUE.k(), visible);
            } else {
                int[] nums = (int[])actionModel.getProperty(SpreadProperties.SetColumnsVisible.COLS.k());
                int[] newNums = Arrays.copyOf(nums, nums.length + colArray.length);
                System.arraycopy(colArray, 0, newNums, nums.length, colArray.length);
                actionModel.addProperty(SpreadProperties.SetColumnsVisible.COLS.k(), newNums);
            }
            return actionModel;
        });
    }

    public Cell setCellValue(int row, String entitysign, Dimension dimension, Object value, Map<String, Object> userObject) {
        Integer col = this.getIndexMap().get(entitysign);
        if (col != null) {
            if (dimension == null) {
                return this.setCellValue(row, col, value);
            }
            return this.setDimensionCellValue(row, col, dimension, (Long)value, userObject);
        }
        return null;
    }

    public Cell setDimensionCellValue(int row, int col, Dimension dimension, long memberid, Map<String, Object> userObject) {
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)this.getAdjust().getModelId(), (String)dimension.getMemberEntityNumber(), (Long)memberid);
        Cell dimCell = this.setCellValue(row, col, treeNode.getName() + "|" + treeNode.getNumber());
        dimCell.getDimensions().clear();
        dimCell.addDimension(ObjectConvertUtils.toIDimension(dimension));
        if (userObject != null) {
            userObject.forEach((arg_0, arg_1) -> ((Cell)dimCell).setUserObject(arg_0, arg_1));
        }
        dimCell.setUserObject("entitysign", (Object)dimension.getMemberEntityNumber());
        if ("bcm_entitymembertree".equals(dimension.getMemberEntityNumber())) {
            dimCell.setUserObject("membid", (Object)treeNode.getId());
        } else {
            dimCell.setUserObject("membid", (Object)treeNode.getBaseTreeNode().getId());
        }
        dimCell.setUserObject("membname", (Object)treeNode.getName());
        dimCell.setUserObject("membnumber", (Object)treeNode.getNumber());
        dimCell.setUserObject("isleaf", (Object)treeNode.isLeaf());
        dimCell.addDim2UserObject((IDimMember)new DimMember(treeNode.getName(), treeNode.getNumber(), null, ObjectConvertUtils.toIDimension(dimension)));
        switch (dimension.getMemberEntityNumber()) {
            case "bcm_accountmembertree": {
                dimCell.setUserObject("drcrdirect", treeNode.getProperty("drcrdirect"));
                break;
            }
            case "bcm_entitymembertree": {
                dimCell.setUserObject("longnumber", (Object)treeNode.getLongNumber());
            }
        }
        return dimCell;
    }

    public int addColumnAutoCalColNum(String entitysign, String name, boolean isLock, Dimension dimension) {
        return this.addColumn(this.getCurrentMaxCol() + 1, entitysign, name, isLock, dimension);
    }

    public int addColumn(int col, String entitysign, String name, boolean isLock, Dimension dimension) {
        return this.addColumn(col, entitysign, name, isLock, dimension, Boolean.FALSE);
    }

    public int addColumn(int col, String entitysign, String name, boolean isLock, Dimension dimension, boolean isCreateColumn) {
        this.getSpreadManager().getBook().getSheet(0).insertColumn(col);
        if (isCreateColumn) {
            this.insertColList.add(col);
            this.resetColumnStyle(col, 1);
        }
        this.setCellValue(0, col, name);
        Cell selectcell = this.getSpreadManager().getBook().getSheet(0).getCell(0, col);
        selectcell.setUserObject("entitysign", (Object)entitysign);
        if (dimension != null) {
            selectcell.getDimensions().clear();
            selectcell.addDimension(ObjectConvertUtils.toIDimension(dimension));
            this.setColumnF7Style(col, 1, 0, 0);
            this.setColumnWidth(col, 150);
            if (!"bcm_mergenode".equals(entitysign)) {
                entitysign = dimension.getNumber();
            }
        }
        if (isLock) {
            this.setColumnLock(col, 1);
        }
        this.getAreaPositionManger().resetSignIndex(entitysign, col);
        return col;
    }

    public void addBeforeCvtMoneyColumn(int col, String currname) {
        int startcol = col + 1;
        int addColmns = 0;
        String cvtBeforeDebitName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u501f\u65b9", (String)"AdjustCheckFrontModel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + addColmns, "cvtbeforedebit", currname == null ? cvtBeforeDebitName : cvtBeforeDebitName + "(" + currname + ")", false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        String cvtBeforeCreditName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u8d37\u65b9", (String)"AdjustCheckFrontModel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + ++addColmns, "cvtbeforecredit", currname == null ? cvtBeforeCreditName : cvtBeforeCreditName + "(" + currname + ")", false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        String cvtBeforeSumMoney = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u91d1\u989d", (String)"AdjustCheckFrontModel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + ++addColmns, "cvtbeforesummoney", currname == null ? cvtBeforeSumMoney : cvtBeforeSumMoney + "(" + currname + ")", false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        this.setColumnFormat(startcol, ++addColmns, "#,##0.00");
        this.setAlign(1, 2000, startcol, addColmns, 0);
    }

    public void addCvtMoneyColumn(String srcCurrencyName, String currencyNumber, String currencyName) {
        boolean isMutiCurrName = currencyName != null && srcCurrencyName != null;
        boolean isMutiCurrNumber = currencyNumber != null;
        int startcol = this.getCurrentMaxCol() + 1;
        int addColmns = 0;
        String rateName = ResManager.loadKDString((String)"\u6c47\u7387", (String)"AdjustCheckFrontModel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + addColmns, "rate" + (isMutiCurrNumber ? "_" + currencyNumber : ""), rateName + (isMutiCurrName ? "(" + srcCurrencyName + "->" + currencyName + ")" : ""), false, null);
        this.setColumnFormat(startcol + addColmns, 1, "#,##0.0000");
        this.setColumnWidth(startcol + addColmns, 100);
        String debitName = ResManager.loadKDString((String)"\u501f\u65b9", (String)"AdjustCheckFrontModel_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + ++addColmns, "debit" + (isMutiCurrNumber ? "_" + currencyNumber : ""), debitName + (isMutiCurrName ? "(" + srcCurrencyName + "->" + currencyName + ")" : ""), false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        String creditName = ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AdjustCheckFrontModel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + ++addColmns, "credit" + (isMutiCurrNumber ? "_" + currencyNumber : ""), creditName + (isMutiCurrName ? "(" + srcCurrencyName + "->" + currencyName + ")" : ""), false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        String sumMoneyName = ResManager.loadKDString((String)"\u91d1\u989d", (String)"AdjustCheckFrontModel_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.addColumn(startcol + ++addColmns, "summoney" + (isMutiCurrNumber ? "_" + currencyNumber : ""), sumMoneyName + (isMutiCurrName ? "(" + srcCurrencyName + "->" + currencyName + ")" : ""), false, null);
        this.setColumnWidth(startcol + addColmns, 100);
        this.setColumnFormat(startcol + 1, ++addColmns - 1, "#,##0.00");
        this.setAlign(1, 2000, startcol, addColmns, 0);
    }

    public int getCurrentMaxCol() {
        return this.getAreaPositionManger().getCurrentMaxCol();
    }

    public String getSpreadkey() {
        return this.spreadkey;
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public AdjustModel getAdjust() {
        return this.adjust;
    }

    public Map<String, Integer> getIndexMap() {
        return this.getAreaPositionManger().createOrGetIndexMap();
    }

    public IFormView getView() {
        return this.view;
    }

    public void setNeedInvoke(boolean needInvoke) {
        this.needInvoke = needInvoke;
    }

    private Sheet getEffectSheet() {
        return this.getSpreadManager().getBook().getSheet(0);
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public Integer getMaxRow() {
        return this.maxRow;
    }

    public final void setSpreadManager(SpreadManager spreadManager) {
        this.spreadManager = spreadManager;
    }

    public AreaPositionManger getAreaPositionManger() {
        if (this.pos == null) {
            this.pos = new AreaPositionManger(this.getView(), this.getAdjust(), this.getSpreadManager());
        }
        return this.pos;
    }

    private void joinActionQuene(String actionSign, Function<ActionModel, ActionModel> function) {
        ActionModel actionModel = function.apply(this.commonActionQuene.get(actionSign));
        if (actionModel != null) {
            this.commonActionQuene.put(actionSign, actionModel);
        }
    }

    private void joinBatchCommonActionQuene(String actionSign, Map<String, Object> properties, Consumer<ActionModel> func) {
        String specialKey;
        BatchActionModel batchActionModel = (BatchActionModel)this.commonActionQuene.computeIfAbsent(actionSign, a -> new BatchActionModel(actionSign));
        CommonActionModel childActionModel = (CommonActionModel)batchActionModel.searchActionBySign(specialKey = actionSign + "_" + properties);
        if (childActionModel == null) {
            childActionModel = new CommonActionModel(specialKey);
            childActionModel.setProperties(properties);
            batchActionModel.addSingleAction(childActionModel);
        }
        if (func != null) {
            func.accept(childActionModel);
        }
    }

    private void joinBatchRangeActionQuene(String actionSign, int r, int c, int rc, int cc, Map<String, Object> properties) {
        String specialKey;
        BatchActionModel batchActionModel = (BatchActionModel)this.commonActionQuene.computeIfAbsent(actionSign, a -> new BatchActionModel(actionSign));
        RangeActionModel childActionModel = batchActionModel.searchRangeActionBySign(specialKey = properties.toString());
        if (childActionModel == null) {
            childActionModel = new RangeActionModel(specialKey);
            childActionModel.setProperties(properties);
            batchActionModel.addSingleAction(childActionModel);
        }
        childActionModel.addRange(r, c, rc, cc);
    }

    private void joinRangeActionQuene(String actionSign, int r, int c, int rc, int cc, Map<String, Object> properties) {
        this.joinRangeActionQuene(actionSign, SpreadProperties.SetCellStyleMethod.RANGE.k(), r, c, rc, cc, properties);
    }

    private void joinRangeActionQuene(String actionSign, String rangeKey, int r, int c, int rc, int cc, Map<String, Object> properties) {
        String specialKey = actionSign + "_" + rangeKey + "_" + properties;
        RangeActionModel rangeActionModel = (RangeActionModel)this.commonActionQuene.computeIfAbsent(specialKey, a -> new RangeActionModel(actionSign, rangeKey).setProperties(properties));
        rangeActionModel.addRange(r, c, rc, cc);
    }
}

