/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.model.AdjustTabDataInfo;

public class AdjustSpreadDataCacheManager {
    private final IPageCache cache;
    private final Map<String, AdjustTabDataInfo> tabInfoMap = new HashMap<String, AdjustTabDataInfo>(10);

    public AdjustSpreadDataCacheManager(IPageCache cache) {
        this.cache = cache;
    }

    public BigDecimal putValueInCache(String tabKey, int row, int col, Object value) {
        return this.getInfoByTabKey(tabKey).updateEntryList(row, col, value);
    }

    public void clearInfoByTabKey(String tabKey) {
        this.tabInfoMap.remove(tabKey);
        this.cache.remove(this.packKey(tabKey));
    }

    public AdjustTabDataInfo getInfoByTabKey(String tabKey) {
        return this.tabInfoMap.computeIfAbsent(tabKey, a -> {
            AdjustTabDataInfo info = this.queryInfoByTabKey(tabKey);
            return info == null ? new AdjustTabDataInfo() : info;
        });
    }

    public AdjustTabDataInfo queryInfoByTabKey(String tabKey) {
        String cacheStr = this.cache.get(this.packKey(tabKey));
        return StringUtils.isEmpty((CharSequence)cacheStr) ? null : (AdjustTabDataInfo)ObjectSerialUtil.deSerializedBytes((String)cacheStr);
    }

    public void updateCache() {
        this.tabInfoMap.forEach((tabKey, info) -> {
            if (info.isEmpty()) {
                this.cache.remove(this.packKey((String)tabKey));
            } else {
                this.cache.put(this.packKey((String)tabKey), ObjectSerialUtil.toByteSerialized((Object)info));
            }
        });
    }

    private String packKey(String tabKey) {
        return "AdjustSpreadDataCacheManager_" + tabKey;
    }
}

