/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class AdjustSpreadToolModel {
    private boolean isMultiCurrency = false;
    private Collection<String> spreadDims;
    private Sheet sheet;
    private long mergeId;
    private long modelId;
    private boolean isTemplate;
    private Map<String, Integer> indexMap;
    private Pattern p = Pattern.compile("^[-]+$");

    public AdjustSpreadToolModel(Sheet sheet, Collection<String> spreadDims) {
        this.sheet = sheet;
        this.spreadDims = spreadDims;
    }

    public AdjustSpreadToolModel(Sheet sheet, Collection<String> spreadDims, long mergeId, long modelId) {
        this(sheet, spreadDims);
        this.mergeId = mergeId;
        this.modelId = modelId;
    }

    public void setTemplate(boolean template) {
        this.isTemplate = template;
    }

    public List<Integer> getEffectRows() {
        ArrayList<Integer> effectRows = new ArrayList<Integer>(16);
        int maxRow = this.sheet.getMaxRowCount();
        for (int row = 1; row <= maxRow; ++row) {
            if (!this.isEffectiveRow(row)) continue;
            effectRows.add(row);
        }
        return effectRows;
    }

    protected Sheet getEffectiveSheet() {
        return this.sheet;
    }

    private boolean isEffectiveRow(int rowIndex) {
        return !this.isEmpty4DimensionCol(rowIndex) || !this.isEmpty4Value(rowIndex);
    }

    private boolean isEmpty4DimensionCol(int rowIndex) {
        return this.spreadDims.stream().anyMatch(number -> this.p.matcher(this.getCell(rowIndex, (String)number).getValue() + "").find()) || this.spreadDims.stream().allMatch(number -> CollectionUtils.isEmpty((Collection)this.getCell(rowIndex, (String)number).getMemberFromUserObject()));
    }

    public Cell getCell(int row, String colkey) {
        Integer colIndex = this.getIndexMap().get(colkey);
        if (colIndex == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5230\u5bf9\u5e94\u7ef4\u5ea6\u5217%s\u3002", (String)"AdjustSpreadToolModel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), colkey));
        }
        return this.getCell(row, colIndex);
    }

    public Map<String, Integer> getIndexMap() {
        if (this.indexMap == null) {
            this.indexMap = AdjustModelUtil.createOrGetIndexMap(this.sheet);
        }
        return this.indexMap;
    }

    protected Cell getCell(int row, int col) {
        return this.getEffectiveSheet().getCell(row, col);
    }

    protected boolean isEmpty4Value(int rowIndex) {
        boolean isCheck;
        Cell debit = this.getCell(rowIndex, "debit");
        Cell credit = this.getCell(rowIndex, "credit");
        if (this.isTemplate) {
            return debit.getValue() == null && credit.getValue() == null;
        }
        Cell summeryCell = this.getCell(rowIndex, "summoney");
        Cell rateCell = this.getCell(rowIndex, "rate");
        Cell beforeDebitCell = this.getCell(rowIndex, "cvtbeforedebit");
        Cell beforeCreditCell = this.getCell(rowIndex, "cvtbeforecredit");
        Cell beforeSummoneyCell = this.getCell(rowIndex, "cvtbeforesummoney");
        boolean bl = isCheck = beforeDebitCell.getValue() == null && beforeCreditCell.getValue() == null && beforeSummoneyCell.getValue() == null && debit.getValue() == null && credit.getValue() == null && summeryCell.getValue() == null && rateCell.getValue() == null;
        if (isCheck && this.isMultiCurrency()) {
            List<String> multipleCurrency = this.getMultipleCurrency(false);
            for (String dimMember : multipleCurrency) {
                if (!isCheck) continue;
                Cell debit4MulCur = this.getCell(rowIndex, "summoney_" + dimMember);
                Cell credit4MulCur = this.getCell(rowIndex, "credit_" + dimMember);
                Cell summeryCell4MulCur = this.getCell(rowIndex, "debit_" + dimMember);
                Cell rateCell4MulCur = this.getCell(rowIndex, "rate_" + dimMember);
                if (credit4MulCur.getValue() == null && debit4MulCur.getValue() == null && summeryCell4MulCur.getValue() == null && rateCell4MulCur.getValue() == null) continue;
                isCheck = false;
            }
        }
        return isCheck;
    }

    protected List<String> getMultipleCurrency(boolean isContainDefaultCurrency) {
        HashSet<String> result = new HashSet<String>(16);
        if (this.isMultiCurrency()) {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.modelId), (Long)this.mergeId);
            result.add(org.getCurrency());
            this.getIndexMap().forEach((key, index) -> {
                if (key.startsWith("rate_") || key.startsWith("credit_") || key.startsWith("debit_") || key.startsWith("summoney_")) {
                    result.add(key.split("_")[1]);
                }
            });
        }
        ArrayList<String> currencyList = new ArrayList<String>(result);
        if (!isContainDefaultCurrency) {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.modelId), (Long)this.mergeId);
            currencyList.remove(org.getCurrency());
        }
        return currencyList;
    }

    private boolean isMultiCurrency() {
        return this.isMultiCurrency;
    }
}

