/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.model;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.adjust.model.Colmun;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class AreaPositionManger {
    private IFormView view;
    private AdjustModel adjust;
    private SpreadManager spreadManager;
    private Map<String, Integer> indexMap = new LinkedHashMap<String, Integer>();
    private Map<String, Colmun> colmunMap = new LinkedHashMap<String, Colmun>();

    public AreaPositionManger(IFormView view, AdjustModel adjust, SpreadManager spreadManager) {
        this.adjust = adjust;
        this.view = view;
        this.spreadManager = spreadManager;
    }

    public void setSpreadManager(SpreadManager spreadManager, boolean isClearCache) {
        this.spreadManager = spreadManager;
        if (isClearCache) {
            this.clear();
        }
    }

    public void clear() {
        this.clearIndexMap();
        this.clearColmunMap();
    }

    private void clearIndexMap() {
        this.indexMap.clear();
    }

    private void clearColmunMap() {
        this.colmunMap.clear();
        this.view.getPageCache().remove("colmunMap");
    }

    public Map<String, Integer> createOrGetIndexMap() {
        if (CollectionUtil.isEmpty(this.indexMap.keySet())) {
            int maxCol = this.getEffectSheet().getMaxColumnCount();
            this.getEffectSheet().iteratorRangeCells(0, 0, 0, maxCol, cell -> {
                String sign = (String)cell.getUserObject("entitysign");
                if (StringUtils.isNotEmpty((String)sign)) {
                    if (sign.startsWith("bcm_")) {
                        this.indexMap.put(cell.getDimension(0).getNumber(), cell.getCol());
                    } else {
                        this.indexMap.put(sign, cell.getCol());
                    }
                }
            });
        }
        return this.indexMap;
    }

    public Map<String, Colmun> createOrGetColmunMap() {
        if (CollectionUtil.isEmpty(this.colmunMap.keySet())) {
            String hidenColmunMapCache = this.view.getPageCache().get("colmunMap");
            if (StringUtils.isNotEmpty((String)hidenColmunMapCache)) {
                this.colmunMap = (Map)ObjectSerialUtil.deSerializedBytes((String)hidenColmunMapCache);
            }
            int maxCol = this.getEffectSheet().getMaxColumnCount();
            this.getEffectSheet().iteratorRangeCells(0, 0, 0, maxCol, cell -> {
                String colKey = (String)cell.getUserObject("entitysign");
                if (StringUtils.isNotEmpty((String)colKey)) {
                    if (colKey.startsWith("bcm_")) {
                        String dimNum = cell.getDimension(0).getNumber();
                        this.colmunMap.computeIfAbsent(dimNum, a -> new Colmun(dimNum, cell.getDimension(0)));
                    } else {
                        this.colmunMap.computeIfAbsent(colKey, a -> new Colmun(colKey));
                    }
                }
            });
        }
        return this.colmunMap;
    }

    public Colmun getColmunBySign(String sign) {
        return this.createOrGetColmunMap().get(sign);
    }

    public Integer getColIndexBySign(String sign) {
        return this.createOrGetIndexMap().get(sign);
    }

    public void resetSignIndex(String sign, Integer index) {
        this.createOrGetIndexMap().put(sign, index);
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    private Sheet getEffectSheet() {
        return this.getSpreadManager().getBook().getSheet(0);
    }

    public int getCurrentMaxCol() {
        return this.createOrGetIndexMap().values().stream().max(Integer::compareTo).orElseGet(() -> -1);
    }

    public void updateCache() {
        if (!this.createOrGetColmunMap().isEmpty()) {
            this.getView().getPageCache().put("colmunMap", ObjectSerialUtil.toByteSerialized(this.createOrGetColmunMap()));
        }
    }

    public IFormView getView() {
        return this.view;
    }

    public AdjustModel getAdjust() {
        return this.adjust;
    }
}

