/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.operationLog;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.AdjustLockOperFactory;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.AdjustRedisOperLocker;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.BcmMutexLockDataInfo;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.IOperLocker;
import kd.fi.bcm.business.adjust.model.AdjustApplicationLocker;
import kd.fi.bcm.common.enums.adjust.AdjustLockOperTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;

public class AdjustMutexLockQueryPlugin
extends MainQueryPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.doQuery();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_query": {
                this.doQuery();
                break;
            }
            case "btn_deletelock": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                IOperLocker locker = AdjustLockOperFactory.getLockerInstance((AdjustLockOperTypeEnum.LOCKTYPE)AdjustLockOperTypeEnum.LOCKTYPE.LOCK_ADJUSTREDIS);
                ArrayList<Map> lockers = new ArrayList<Map>(entryGrid.getSelectRows().length);
                for (int row : entryGrid.getSelectRows()) {
                    lockers.add(MapInitHelper.ofMap((Object)"dataObjId", (Object)this.getModel().getValue("dataobjid", row), (Object)"groupId", (Object)this.getModel().getValue("groupid", row), (Object)"entityKey", (Object)this.getModel().getValue("entitykey", row), (Object)"isStrict", (Object)true, (Object)"operationKey", (Object)this.getModel().getValue("operationkey", row)));
                }
                locker.batchRelease(lockers);
                this.doQuery();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9501\u91ca\u653e\u6210\u529f\u3002", (String)"AdjustMutexLockQueryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doQuery() {
        ArrayList lockDataInfoList = new ArrayList(16);
        for (AdjustLockOperTypeEnum lockOperType : AdjustLockOperTypeEnum.values()) {
            IOperLocker locker = AdjustLockOperFactory.getLockerInstance((AdjustLockOperTypeEnum.LOCKTYPE)AdjustApplicationLocker.getLockType((AdjustLockOperTypeEnum)lockOperType));
            if (!(locker instanceof AdjustRedisOperLocker)) continue;
            lockDataInfoList.addAll(locker.getAllLockInfos(lockOperType.entityKey()).values());
        }
        this.getModel().deleteEntryRows("entryentity", IntStream.range(0, this.getModel().getEntryRowCount("entryentity")).toArray());
        if (!CollectionUtil.isEmpty(lockDataInfoList)) {
            int row = 0;
            this.getModel().batchCreateNewEntryRow("entryentity", lockDataInfoList.size());
            this.getModel().beginInit();
            for (BcmMutexLockDataInfo lockDataInfo : lockDataInfoList) {
                this.getModel().setValue("operationkey", (Object)lockDataInfo.getOperationKey(), row);
                this.getModel().setValue("entitykey", (Object)lockDataInfo.getEntityNumber(), row);
                this.getModel().setValue("groupid", (Object)lockDataInfo.getGroupId(), row);
                this.getModel().setValue("dataobjid", (Object)lockDataInfo.getDataObjId(), row);
                this.getModel().setValue("user", (Object)LongUtil.toLong((Object)lockDataInfo.getUserId()), row);
                this.getModel().setValue("locketime", (Object)new Date(LongUtil.toLong((Object)lockDataInfo.getLockedTime())), row);
                this.getModel().setValue("client", (Object)lockDataInfo.getClient(), row);
                ++row;
            }
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
    }

    @Override
    protected void setMsg(String msg) {
    }
}

