/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.operationLog;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.trace.TraceLogUtil;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;

public class AdjustOperationLogQueryPlugin
extends MainQueryPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle {
    protected static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final Map<String, String> newOperLogMap = new HashMap<String, String>(16);
    private AdjustOperationContext ctx;

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        Dimension dim;
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_") && (dim = this._ctx().getSctx().getDimensionByField(ctrlKey.replace("bcm_", ""))) != null) {
            BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), ctrlKey, this, false, SingleF7TypeEnum.COMMON);
            sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"AdjustOperationLogQueryPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("Currency".equals(dim.getNumber())) {
                sf7.setCustomFilter(new QFilter("number", "not in", (Object)new String[]{"DC", "EC", "PC"}));
            }
            sf7.setCustomData(MapInitHelper.ofMap((Object)"isNotPermFilterF7", (Object)"1"));
            sf7.addBeforeF7SelectListener(this);
            e.setControl((Control)sf7);
        }
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        super.initBasedataEditSingleMemberF7(f7Key, f7);
        if (f7Key.equals("scenario") || f7Key.equals("year") || f7Key.equals("period")) {
            f7.setCustomData(MapInitHelper.ofMap((Object)"isNotPermFilterF7", (Object)"1"));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAdjustOperTypeList();
        this.setDefaultValue();
        this.initDimensionArea();
    }

    private void initAdjustOperTypeList() {
        ((ComboEdit)this.getControl("opertype")).setComboItems(AdjustOperTypeEnum.getDataOperationLogEnums().stream().map(logEnum -> new ComboItem(new LocaleString(logEnum.getName()), String.valueOf(logEnum.getValue()))).collect(Collectors.toList()));
    }

    private void setDefaultValue() {
        this.setValue("model", this.getFormCustomParam("model"));
        this.setValue("scenario", this.getFormCustomParam("scenario"));
        this.setValue("year", this.getFormCustomParam("year"));
        this.setValue("period", this.getFormCustomParam("period"));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if ("model".equals(fieldKey)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.setValue("model", e.getChangeSet()[0].getOldValue());
                this.setMsg(ResManager.loadKDString((String)"\u4f53\u7cfb\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AdjustOperationLogQueryPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.initDimensionArea();
            }
        }
    }

    private void initDimensionArea() {
        Area area = new Area("flex_dimension");
        this._ctx().getSctx().getDimensions().forEach(dim -> {
            if (!dimKeys.contains(dim.getFieldmapped())) {
                TextEditElement element = null;
                if ("Entity".equals(dim.getNumber())) {
                    element = new TextEditElement(dim.getName(), dim.getFieldmapped(), null);
                    element.setEditStyle(0);
                } else {
                    element = new BaseEditElement(dim.getName(), "bcm_" + dim.getFieldmapped(), dim.getEntity());
                }
                Style style = element.getStyle();
                Margin margin = new Margin();
                margin.setRight("50px");
                margin.setBottom("10px");
                style.setMargin(margin);
                element.setWidth(new LocaleString("15%"));
                area.addElement((Element)element);
            }
        });
        area.getElementListList().forEach(p -> {
            p.setLabelDirection("v");
            p.setLabelWidth(new LocaleString("100%"));
        });
        Page page = new Page();
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.resetSqlPage();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_reset": {
                this.doReset();
                break;
            }
            case "btn_query": {
                this.doQuery();
            }
        }
    }

    private void doQuery() {
        this.resetSqlPage();
        HashMap<String, String> dim2MemNumMap = new HashMap<String, String>(16);
        block12: for (Dimension dim : this._ctx().getSctx().getDimensions()) {
            switch (dim.getNumber()) {
                case "Entity": {
                    String entityNum = (String)this.getValue(dim.getFieldmapped());
                    if (!StringUtils.isNotEmpty((CharSequence)entityNum)) continue block12;
                    dim2MemNumMap.put("Entity", entityNum);
                    continue block12;
                }
                case "Scenario": {
                    if (this._ctx().getScenarioId() != 0L) continue block12;
                    throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u8f93\u5165\u3002", (String)"AdjustOperationLogQueryPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                case "Year": {
                    if (this._ctx().getFyId() != 0L) continue block12;
                    throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u8f93\u5165\u3002", (String)"AdjustOperationLogQueryPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                case "Period": {
                    if (this._ctx().getPeriodId() != 0L) continue block12;
                    throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u8f93\u5165\u3002", (String)"AdjustOperationLogQueryPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            DynamicObject dimMemDy = (DynamicObject)this.getValue("bcm_" + dim.getFieldmapped());
            if (dimMemDy == null) continue;
            dim2MemNumMap.put(dim.getNumber(), dimMemDy.getString("number"));
        }
        final String excuteSql = (Boolean)this.getValue("issearcholddata") != false ? this.buildOldQuerySqlFilter(dim2MemNumMap) : this.buildQuerySqlFilter(dim2MemNumMap);
        String tabKey = String.valueOf(UUID.randomUUID().hashCode());
        String tabName = ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u7ed3\u679c", (String)"AdjustOperationLogQueryPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getQueryDataTabManger().addSqlQueryDataTabInfo(tabKey, tabName, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("dbRoute", "bcm");
                this.put("sql", excuteSql);
                this.put("type", 3);
                this.put("colNames", newOperLogMap);
                this.put("limit", AdjustOperationLogQueryPlugin.this.getValue("limit"));
            }
        }).showTabView(this.getView());
        this.cacheQueryDataTabManger();
        this.setMsg(excuteSql);
    }

    private void doReset() {
        this._ctx().getSctx().getDimensions().forEach(dim -> {
            if (dimKeys.contains(dim.getFieldmapped()) || "Entity".equals(dim.getNumber())) {
                this.setValue(dim.getFieldmapped(), null);
            } else {
                this.setValue("bcm_" + dim.getFieldmapped(), null);
            }
        });
        this.setValue("user", null);
        this.setValue("startoptime", null);
        this.setValue("endoptime", null);
        this.setValue("traceid", null);
        this.setValue("opertype", null);
        this.resetSqlPage();
    }

    private String buildOldQuerySqlFilter(Map<String, String> dim2MemNumMap) {
        String opertype;
        String traceid;
        Date endoptime;
        StringBuilder sqlBuilder = new StringBuilder("select fbiztype as fopertype,fcreatorid as fuserid,fcreatetime as foptime,ftraceid as ftraceid,fmessage as fdetaillog from t_bcm_errorlog where");
        sqlBuilder.append(" fmodelid = ").append(this.getModelId());
        Long userId = (Long)this.getValue("user_id");
        if (userId != null && userId != 0L) {
            sqlBuilder.append(" and fcreatorid = ").append(userId);
        }
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
        Date startoptime = (Date)this.getValue("startoptime");
        if (startoptime != null) {
            sqlBuilder.append(" and fcreatetime >= ").append(String.format("{ts'%s'}", df.format(startoptime)));
        }
        if ((endoptime = (Date)this.getValue("endoptime")) != null) {
            sqlBuilder.append(" and fcreatetime <= ").append(String.format("{ts'%s'}", df.format(endoptime)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(traceid = (String)this.getValue("traceid")))) {
            sqlBuilder.append(String.format(" and ftraceid = '%s'", traceid));
        }
        if ("15".equals(opertype = (String)this.getValue("opertype"))) {
            String clearStr = ResManager.getLocaleString((String)"\u6e05\u9664", (String)"AdjustOperationLogQueryPlugin_18", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN();
            sqlBuilder.append(" and fbiztype like '%").append(clearStr).append("%'");
        } else if ("2".equals(opertype)) {
            String repulStr = ResManager.getLocaleString((String)"\u6253\u56de", (String)"AdjustOperationLogQueryPlugin_19", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN();
            sqlBuilder.append(" and fbiztype like '%").append(repulStr).append("%'");
        } else if ("7".equals(opertype)) {
            String audiStr = ResManager.getLocaleString((String)"\u5ba1\u6838", (String)"AdjustOperationLogQueryPlugin_20", (String)"fi-bcm-formplugin").getLocaleValue_zh_CN();
            sqlBuilder.append(" and fbiztype like '%").append(audiStr).append("%'");
        }
        String dimensionKey = TraceLogUtil.packDimIndexKey((Collection)this._ctx().getSctx().getDimensions().stream().map(Dimension::getNumber).collect(Collectors.toList()));
        sqlBuilder.append(String.format(" and fmessage like '%s'", "%" + this.buildDetaillogKey(dimensionKey, ",", dim2MemNumMap) + "%"));
        sqlBuilder.append(" order by fcreatetime desc");
        return sqlBuilder.toString();
    }

    private String buildQuerySqlFilter(Map<String, String> dim2MemNumMap) {
        String traceid;
        Date endoptime;
        Long userId;
        StringBuilder sqlBuilder = new StringBuilder("select fopertype,fsource,fuserid,foptime,ftraceid,fdimensionkey,fdetaillog from t_bcm_adjustoperlog where");
        sqlBuilder.append(" fmodelid = ").append(this.getModelId());
        sqlBuilder.append(" and fscenarioid = ").append(this._ctx().getScenarioId());
        sqlBuilder.append(" and fyearid = ").append(this._ctx().getFyId());
        sqlBuilder.append(" and fperiodid = ").append(this._ctx().getPeriodId());
        String opertype = (String)this.getValue("opertype");
        if (StringUtils.isNotEmpty((CharSequence)opertype)) {
            sqlBuilder.append(String.format(" and fopertype = '%s'", opertype));
        }
        if ((userId = (Long)this.getValue("user_id")) != null && userId != 0L) {
            sqlBuilder.append(" and fuserid = ").append(userId);
        }
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
        Date startoptime = (Date)this.getValue("startoptime");
        if (startoptime != null) {
            sqlBuilder.append(" and foptime >= ").append(String.format("{ts'%s'}", df.format(startoptime)));
        }
        if ((endoptime = (Date)this.getValue("endoptime")) != null) {
            sqlBuilder.append(" and foptime <= ").append(String.format("{ts'%s'}", df.format(endoptime)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(traceid = (String)this.getValue("traceid")))) {
            sqlBuilder.append(String.format(" and ftraceid = '%s'", traceid));
        }
        if (!dim2MemNumMap.isEmpty()) {
            sqlBuilder.append(" and (");
            String dimensionKey = TraceLogUtil.packDimIndexKey(this._ctx().getSctx().getNumberMap().keySet());
            sqlBuilder.append(String.format("fdimensionkey = '%s' and fdetaillog like '%s'", dimensionKey, "%" + this.buildDetaillogKey(dimensionKey, "|", dim2MemNumMap) + "=%"));
            sqlBuilder.append(" )");
        }
        sqlBuilder.append(" order by foptime desc");
        return sqlBuilder.toString();
    }

    private String buildDetaillogKey(String dimensionkey, String separator, Map<String, String> dim2MemNumMap) {
        ArrayList<Object> dimList = new ArrayList<Object>();
        if (StringUtils.isEmpty((CharSequence)dimensionkey)) {
            dimList.addAll(this._ctx().getSctx().getNumberMap().keySet());
        } else {
            dimList.addAll(Arrays.asList(dimensionkey.split(",")));
        }
        CharSequence[] dimMemKey = new String[dimList.size()];
        for (int i = 0; i < dimList.size(); ++i) {
            String dimKey = (String)dimList.get(i);
            dimMemKey[i] = "Scenario".equals(dimKey) ? this._ctx().getScenariodNum() : ("Year".equals(dimKey) ? this._ctx().getFyNum() : ("Period".equals(dimKey) ? this._ctx().getPeriodNum() : dim2MemNumMap.getOrDefault(dimKey, "%")));
        }
        return String.join((CharSequence)separator, dimMemKey);
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        BasedataEditSingleMemberF7 sf7;
        Object source = arg0.getSource();
        if (source instanceof BasedataEditSingleMemberF7 && "bcm_userdefinedmembertree".equals((sf7 = (BasedataEditSingleMemberF7)((Object)source)).getEntity())) {
            sf7.setCustomFilter(new QFilter("dimension.id", "=", (Object)sf7.getDimId()));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEditSingleMemberF7 sf7;
        super.beforeF7Select(e);
        if (e.getSource() instanceof BasedataEditSingleMemberF7 && "bcm_userdefinedmembertree".equals((sf7 = (BasedataEditSingleMemberF7)((Object)e.getSource())).getEntity())) {
            e.getCustomQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()));
            e.getCustomQFilters().add(new QFilter("dimension.id", "=", (Object)sf7.getDimId()));
        }
    }

    @Override
    protected void setMsg(String msg) {
        if (DebugServiceHelper.isDebugModel()) {
            this.setValue("infomationtextarea", msg);
        }
    }

    @SDKMark
    protected AdjustOperationContext _ctx() {
        if (this.ctx == null) {
            long scenarioId = this.getObjId(this.getModel().getValue("scenario"));
            long yearId = this.getObjId(this.getModel().getValue("year"));
            long periodId = this.getObjId(this.getModel().getValue("period"));
            this.ctx = new AdjustOperationContext(this.getModelId(), scenarioId, yearId, periodId);
        }
        return this.ctx;
    }

    private Long getObjId(Object dy) {
        Predicate isNull = Predicates.isNull();
        return isNull.test(dy) ? 0L : ((DynamicObject)dy).getLong("id");
    }

    static {
        newOperLogMap.put("fopertype", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"AdjustOperationLogQueryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperLogMap.put("fsource", ResManager.loadKDString((String)"\u64cd\u4f5c\u6765\u6e90\u6807\u8bb0", (String)"AdjustOperationLogQueryPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperLogMap.put("fuserid", ResManager.loadKDString((String)"\u64cd\u4f5c\u7528\u6237", (String)"AdjustOperationLogQueryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperLogMap.put("foptime", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"AdjustOperationLogQueryPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperLogMap.put("ftraceid", "traceid");
        newOperLogMap.put("fdimensionkey", ResManager.loadKDString((String)"\u7ef4\u5ea6\u987a\u5e8f", (String)"AdjustOperationLogQueryPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperLogMap.put("fdetaillog", ResManager.loadKDString((String)"\u660e\u7ec6\u65e5\u5fd7", (String)"AdjustOperationLogQueryPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }
}

