/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.provider;

import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AdjustDimensionScopeProvider {
    public static QFilter getManualDimensionScopeQFilter(AdjustOperationContext _ctx, AdjustModel adjustModel, long dimId, boolean isNeedFilterNoPerm, boolean isContainsShare, Consumer<QFilter> consumer) {
        if (!LongUtil.isvalidLong((Object)dimId)) {
            return new QFilter("1", "=", (Object)0);
        }
        Dimension dim = _ctx.getSctx().getDimensionById(dimId);
        if (dim == null) {
            return new QFilter("1", "=", (Object)0);
        }
        QFilter qf = new QFilter("model", "=", (Object)_ctx.getModelId());
        switch (dim.getNumber()) {
            case "AuditTrail": {
                qf.and("isleaf", "=", (Object)"1");
                qf.and("datasource", "=", (Object)"3");
                break;
            }
            case "Account": {
                qf.and(QFilter.of((String)" isleaf = '0' or iscaltype = '0'", (Object[])new Object[0]));
                break;
            }
            case "Entity": {
                qf.and("isexchangerate", "=", (Object)"0");
                if (OrgRelaProcessMembPool.isRelaProcess((String)adjustModel.getProcess())) {
                    IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)_ctx.getModelNum(), (String)"Entity", (long)adjustModel.getMergeId());
                    qf.and(new QFilter("longnumber", "like", (Object)(orgNode.getLongNumber() + "!%")));
                    break;
                }
                qf.and(new QFilter("id", "=", (Object)adjustModel.getMergeId()));
                break;
            }
            case "InternalCompany": {
                VersionParam versionParam = AdjustOperationHelper.createVersionParam((long)_ctx.getModelId(), (long)adjustModel.getScenarioId(), (long)adjustModel.getYearId(), (long)adjustModel.getPeriodId());
                IDNumberTreeNode rootNode = BcmThreadCache.findMemberByNum((String)_ctx.getModelNum(), (String)dim.getNumber(), (String)dim.getNumber());
                MembRangeItem item = new MembRangeItem(dim.getEntity(), rootNode.getId(), rootNode.getLongNumber(), dim.getNumber(), RangeEnum.VALUE_50.getValue(), false, (Object)_ctx.getModelId());
                qf.and("isleaf", "=", (Object)"1");
                qf.and(item.buildFilterByScope4Ic(versionParam));
                break;
            }
        }
        if (!dim.isIssys()) {
            qf.and("dimension.id", "=", (Object)dimId);
        }
        if (!isContainsShare) {
            qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        }
        if (consumer != null) {
            consumer.accept(qf);
        }
        if (isNeedFilterNoPerm) {
            qf.and(PermissionServiceImpl.getInstance((Long)_ctx.getModelId()).getReadOrWritePermFilter(Long.valueOf(dimId), dim.getEntity(), "id"));
        }
        return qf;
    }
}

