/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AbjustExportUtil {
    private static final Map<String, String> masScheduleMapping = new HashMap<String, String>();
    private static final Map<String, String> masScheduleDIMMapping = new HashMap<String, String>();
    private static final Map<String, String> rowName2FieldMapped = new HashMap<String, String>();
    private static final String[] SRC_DIM_ORDER = new String[]{"Account", "AuditTrail", "ChangeType", "MultiGAAP", "InternalCompany", "MyCompany", "DataSort", "C1", "C2", "C3", "C4", "C5", "C6"};
    private static final String DIM_1 = "dim1";
    private static final String DIM_2 = "dim2";
    private static final String DIM_3 = "dim3";
    private static final String DIM_4 = "dim4";
    private static final String DIM_5 = "dim5";
    private static final String DIM_6 = "dim6";

    public static String export(long modelId, String routeAppId, QFBuilder filterParam, boolean needDetail, boolean needLink, String orderBy) throws IOException {
        if (filterParam == null) {
            filterParam = new QFBuilder();
        }
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"AbjustExportUtil.export", (String)"bcm_rptadjust", (QFilter[])filterParam.toArray(), (String)orderBy, (int)-1);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"bcm_rptadjust_IMPT_ZSJ"), new QFilter("bizobject.number", "=", (Object)"bcm_rptadjust")};
        List templates = QueryServiceHelper.queryPrimaryKeys((String)"AbjustExportUtil.export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)-1);
        if (templates.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbjustExportUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return AbjustExportUtil.export(modelId, routeAppId, pkIds, templates.toArray(), needDetail, needLink, orderBy).get(templates.get(0));
    }

    public static Map<Object, String> export(long modelId, String routeAppId, List<Object> pkids, Object[] templateids, boolean needDetail, boolean needLink, String orderBy) throws IOException {
        HashMap<Object, String> result = new HashMap<Object, String>(16);
        for (Object templateid : templateids) {
            result.put(templateid, AbjustExportUtil.batchExport(modelId, pkids, needDetail, needLink, templateid, routeAppId, "bcm_rptadjust", ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u5bfc\u51fa\u6570\u636e.xlsx", (String)"AbjustExportUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orderBy, (Consumer<ExportWriterFormat>)((Consumer)e -> {
                if (e != null && e.properties.containsKey("bussnesstype")) {
                    ((Map)e.properties.get("bussnesstype")).compute("InputType", (k, v) -> {
                        if (v instanceof JSONArray) {
                            ((JSONArray)v).clear();
                            List<Pair<LocaleString, String>> bussinessType = AdjustModelUtil.getBussinessType(modelId, Boolean.FALSE);
                            bussinessType.forEach(b -> ((JSONArray)v).add((Object)(b.p1 + " # " + (String)b.p2)));
                        }
                        return v;
                    });
                }
            })));
        }
        return result;
    }

    public static String batchExport(long modelId, List<Object> pkIds, boolean needDetail, boolean needLink, Object template, String routeAppId, String formId, String fileName, String orderBy, Consumer<ExportWriterFormat> consumer) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        DynamicObject[] dys = new DynamicObject[]{new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_rptadjust"))};
        dys[0].set("model", (Object)modelId);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadAndClearCTAndAT((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (String)routeAppId, (Object)formId, (Object)template, (Object)formId, (DynamicObject[])dys, consumer);
        if (format != null) {
            AtomicInteger rowIndex = new AtomicInteger(4);
            try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
                BatchProcessHelper.batchConsume(pkIds, (int)1000, ids -> {
                    JSONArray jsonArray = AbjustExportUtil.queryCovertAdjusts(modelId, ids, needDetail, needLink, orderBy);
                    if (jsonArray != null) {
                        Iterator iterator = jsonArray.iterator();
                        while (iterator.hasNext()) {
                            JSONObject bill = AbjustExportUtil.getJSONObject(iterator.next());
                            if (bill != null) {
                                ExportUtil.billFormatConfig((JSONObject)bill);
                                int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex.get(), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                                rowIndex.addAndGet(Math.max(offset, 1) + 1);
                            }
                            iterator.remove();
                        }
                    }
                });
            }
        }
        return ExportUtil.writeFile((SXSSFWorkbook)wb, (String)fileName);
    }

    public static JSONObject getJSONObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        return obj instanceof Map ? new JSONObject((Map)obj) : (JSONObject)JSON.toJSON((Object)obj);
    }

    private static JSONArray queryCovertAdjusts(long modelId, List<Object> adjustIds, boolean needDetail, boolean needLink, String orderBy) {
        JSONArray adjusts = AbjustExportUtil.serializeAndParseJson(() -> {
            String selectFields = "id,process,status,audittrail,journaltype,balancetype,name,description,createtime,number,modifystatus,belongorg,entrysource,bussnesstype,multiplecurrency,linkagelinksource,linkcreatetype,sourcetype,submittime,cancelsubmittime,ratifytime,reviewtime,callbacktime,modifytime,cancelratifytime,reviewer,modifier,creator,ratifier,submitter,callbacker,cancelsubmitter,cancelratifier,model.id,model.shownumber,model.name,scenario.id,year.id,period.id,entity.id,cvtbeforecurrency.id,templatecatalog.id,templatecatalog.number,templatecatalog.name";
            QFilter qf = new QFilter("id", "in", (Object)adjustIds);
            if (!needLink) {
                qf.and("sourcetype", "!=", (Object)(ElimRptAdjSourceTypeEnum.LINK.getValue() + ""));
            }
            return QueryServiceHelper.query((String)"bcm_rptadjust", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)orderBy);
        });
        if (CollectionUtils.isNotEmpty((Collection)adjusts)) {
            Map<Long, List<DynamicObject>> rptLayOutMap = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id,commembentry,commembentry.commembid,commembentry.comdimension.number,commembentry.comentitysign", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustIds)}, (String)orderBy).stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
            Map<Long, DynamicObject> nameMap = Arrays.asList(BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustIds)}, (String)orderBy)).stream().collect(Collectors.toMap(key -> key.getLong("id"), v -> v, (v1, v2) -> v1));
            QFilter permQFilter = new QFilter("entityname", "=", (Object)"bcm_rptadjust");
            permQFilter.and("entityid", "in", adjustIds);
            permQFilter.and("model", "=", (Object)modelId);
            DynamicObject[] permClassDys = BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"permclass,entityid", (QFilter[])permQFilter.toArray());
            Map<Long, JSONObject> adjId2permClassDysMap = Arrays.stream(permClassDys).collect(Collectors.toMap(k -> k.getLong("entityid"), v -> {
                DynamicObject permclass = v.getDynamicObject("permclass");
                if (permclass != null) {
                    JSONObject os = new JSONObject();
                    os.put("id", (Object)permclass.getLong("id"));
                    os.put("number", (Object)permclass.getString("number"));
                    return os;
                }
                return null;
            }, (v1, v2) -> v1));
            boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
            HashMap<String, Long> fixDim = new HashMap<String, Long>(16);
            HashMap<String, Long> spreadDim = new HashMap<String, Long>(16);
            for (Dimension dim : new SchemeContext(modelId).getDimensions()) {
                if (DimTypesEnum.YEAR.getNumber().equals(dim.getNumber()) || DimTypesEnum.SCENARIO.getNumber().equals(dim.getNumber()) || DimTypesEnum.PROCESS.getNumber().equals(dim.getNumber()) || DimTypesEnum.PERIOD.getNumber().equals(dim.getNumber())) {
                    fixDim.put(dim.getFieldmapped(), dim.getId());
                    continue;
                }
                spreadDim.put(dim.getFieldmapped(), dim.getId());
            }
            Map<Long, List<DynamicObject>> details = null;
            if (needDetail) {
                QFilter qf = new QFilter("adjust", "in", adjustIds);
                if (!needLink) {
                    qf.and("entrysource", "not in", (Object)EntrySourceEnum.getLinkListToString());
                }
                qf.and("entryrowtype", "not in", (Object)new Object[]{"1", "2"});
                String selectFieldStr = masScheduleMapping.values().stream().distinct().collect(Collectors.joining(",")).concat(",").concat(masScheduleDIMMapping.values().stream().distinct().collect(Collectors.joining(","))).concat(",adjust,datasort,entrysource");
                details = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)selectFieldStr, (QFilter[])qf.toArray(), (String)"showseq,groupnum,dseq,currency.number asc").stream().collect(Collectors.groupingBy(p -> p.getLong("adjust")));
            }
            for (Object adjusttemp : adjusts) {
                List<DynamicObject> detail;
                JSONObject adjust = AbjustExportUtil.getJSONObject(adjusttemp);
                if (adjust == null) continue;
                JSONObject modelJsom = new JSONObject();
                modelJsom.put("name", (Object)adjust.getString("model.name"));
                modelJsom.put("number", (Object)adjust.getString("model.number"));
                modelJsom.put("id", (Object)adjust.getLong("model.id"));
                modelJsom.put("shownumber", (Object)adjust.getString("model.shownumber"));
                adjust.put("model", (Object)modelJsom);
                adjust.put("scenario", (Object)AbjustExportUtil.createJSONObject(adjust.getLong("model.id"), "bcm_scenemembertree", adjust.getLong("scenario.id")));
                adjust.put("year", (Object)AbjustExportUtil.createJSONObject(adjust.getLong("model.id"), "bcm_fymembertree", adjust.getLong("year.id")));
                adjust.put("period", (Object)AbjustExportUtil.createJSONObject(adjust.getLong("model.id"), "bcm_periodmembertree", adjust.getLong("period.id")));
                adjust.put("entity", (Object)AbjustExportUtil.createJSONObject(adjust.getLong("model.id"), "bcm_entitymembertree", adjust.getLong("entity.id")));
                adjust.put("cvtbeforecurrency", (Object)AbjustExportUtil.createJSONObject(adjust.getLong("model.id"), "bcm_currencymembertree", adjust.getLong("cvtbeforecurrency.id")));
                if (LongUtil.toLong((Object)adjust.get((Object)"templatecatalog.id")) != 0L) {
                    JSONObject tmplCataJson = new JSONObject();
                    tmplCataJson.put("name", (Object)adjust.getString("templatecatalog.name"));
                    tmplCataJson.put("number", (Object)adjust.getString("templatecatalog.number"));
                    tmplCataJson.put("id", (Object)adjust.getLong("templatecatalog.id"));
                    adjust.put("templatecatalog", (Object)tmplCataJson);
                }
                if (nameMap.containsKey(adjust.getLong("id"))) {
                    adjust.put("name", JSON.toJSON((Object)nameMap.get(adjust.getLong("id")).get("name")));
                }
                adjust.put("process_imp", (Object)AbjustExportUtil.createJSONObject((Long)modelId, adjust.getString("process"), "Process"));
                boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"));
                adjust.put("permission", (Object)adjId2permClassDysMap.get(adjust.getLong("id")));
                if (details == null || !CollectionUtils.isNotEmpty(detail = details.get(adjust.getLong("id")))) continue;
                boolean hasPerm2Head = true;
                if (!modelManage) {
                    if (hasMerge) {
                        boolean bl = hasPerm2Head = !AbjustExportUtil.validateNoPerm(modelId, adjust.getLong("entity.id"), "entity", (Long)spreadDim.get("entity"));
                    }
                    if (hasPerm2Head) {
                        hasPerm2Head = fixDim.keySet().stream().noneMatch(dimNum -> AbjustExportUtil.validateNoPerm(modelId, adjust.getLong(dimNum + ".id"), dimNum, (Long)fixDim.get(dimNum)));
                    }
                }
                if (((List)rptLayOutMap.getOrDefault(adjust.getLong("id"), new ArrayList())).stream().anyMatch(p -> "DataSort".equals(p.getString("commembentry.comdimension.number")))) {
                    adjust.put("datasort_imp", (Object)AbjustExportUtil.createJSONObject((Long)modelId, detail.get(0).getLong("datasort"), "datasort"));
                }
                JSONArray entryentity = new JSONArray(detail.size());
                adjust.put("entryentity", (Object)entryentity);
                Iterator<DynamicObject> iterator = detail.iterator();
                while (iterator.hasNext()) {
                    DynamicObject det = iterator.next();
                    if (!"1".equals(adjust.getString("multiplecurrency")) && LongUtil.toLong((Object)adjust.get((Object)"cvtbeforecurrency.id")) == 0L) {
                        det.set("cvtbeforesummoney", (Object)BigDecimal.ZERO);
                        det.set("cvtbeforedebit", (Object)BigDecimal.ZERO);
                        det.set("cvtbeforecredit", (Object)BigDecimal.ZERO);
                        det.set("rate", (Object)BigDecimal.ZERO);
                    }
                    det.set("cvtbeforesummoney", (Object)det.getBigDecimal("cvtbeforedebit").add(det.getBigDecimal("cvtbeforecredit").negate()));
                    det.set("summoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)det.getBigDecimal("debit"), (BigDecimal)det.getBigDecimal("credit")));
                    JSONObject dy = new JSONObject();
                    entryentity.add((Object)dy);
                    boolean noPerm = !modelManage && hasPerm2Head && spreadDim.keySet().stream().filter(e -> !e.equals("entity") || !hasMerge).anyMatch(dimNum -> AbjustExportUtil.validateNoPerm(modelId, det.getLong(dimNum), dimNum, (Long)spreadDim.get(dimNum)));
                    dy.put("islink", (Object)EntrySourceEnum.getLinkList().contains(det.getInt("entrysource")));
                    masScheduleMapping.forEach((master, schedule) -> {
                        if (noPerm && AdjustmentServiceHelper.isBigicmalCol((String)schedule)) {
                            dy.put(master, null);
                        } else if ("olaporg".equals(schedule) && StringUtils.isEmpty((CharSequence)det.getString(schedule))) {
                            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)det.getLong("entity"));
                            String olaporg = orgNode.getNumber();
                            if (hasMerge) {
                                olaporg = AdjustCheckServiceHelper.getParentDirectChild((String)adjust.getString("entity.number"), (String)orgNode.getLongNumber());
                            }
                            dy.put(master, (Object)olaporg);
                        } else if ("description".equals(schedule)) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put(Lang.get().toString(), det.get(schedule));
                            dy.put(master, (Object)jsonObject);
                        } else {
                            dy.put(master, det.get(schedule));
                        }
                    });
                    masScheduleDIMMapping.forEach((fieldKey, dimNum) -> dy.put(fieldKey, (Object)AbjustExportUtil.createJSONObject((Long)modelId, det.getLong(dimNum), dimNum)));
                    iterator.remove();
                }
            }
            return adjusts;
        }
        return null;
    }

    private static JSONArray serializeAndParseJson(Supplier supplier) {
        String json = SerializationUtils.toJsonString(supplier.get());
        return JSON.parseArray((String)json);
    }

    private static JSONObject createJSONObject(Long modelId, String memeberNumber, String dimNum) {
        if (StringUtils.isEmpty((CharSequence)memeberNumber)) {
            return null;
        }
        return (JSONObject)ThreadCache.get((Object)(dimNum + memeberNumber), () -> {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)memeberNumber);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)node.getName());
            obj.put("number", (Object)node.getNumber());
            obj.put("id", (Object)node.getId());
            return obj;
        });
    }

    private static JSONObject createJSONObject(Long modelId, String entity, Long menId) {
        if (LongUtil.toLong((Object)menId) == 0L) {
            return null;
        }
        return (JSONObject)ThreadCache.get((Object)(menId + entity), () -> {
            IDNumberTreeNode node = MemberReader.findMemberById((String)MemberReader.findModelNumberById((Object)modelId), (String)entity, (Long)menId);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)node.getName());
            obj.put("number", (Object)node.getNumber());
            obj.put("id", (Object)node.getId());
            return obj;
        });
    }

    private static JSONObject createJSONObject(Long modelId, Long memberId, String dimNum) {
        if (memberId == 0L) {
            return null;
        }
        return (JSONObject)ThreadCache.get((Object)(dimNum + memberId), () -> {
            String entityNumber = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNum);
            IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)memberId);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)node.getName());
            obj.put("number", (Object)node.getNumber());
            obj.put("id", (Object)node.getId());
            return obj;
        });
    }

    private static boolean validateNoPerm(Long modelId, Long memberId, String dimNum, Long dimId) {
        return ((Set)ThreadCache.get((Object)("export-" + dimId), () -> MemberPermHelper.getNoPermissionIds((String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNum), (long)dimId, (Object)modelId))).contains(memberId);
    }

    public static String exportAnnualAccSetting(String routeAppId, long modelId, int[] dseq) throws IOException {
        QFBuilder filterParam = new QFBuilder();
        filterParam.add("model", "=", (Object)modelId);
        if (dseq != null && dseq.length > 0) {
            filterParam.add("dseq", "in", (Object)dseq);
        }
        String strName = ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u635f\u76ca\u7ed3\u8f6c\u8bbe\u7f6e", (String)"AbjustExportUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String filterName = strName + ".xlsx";
        String formId = "bcm_annualaccount";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"bcm_annaccount_import_IMPT_S"), new QFilter("bizobject.number", "=", (Object)"bcm_annaccount_import")};
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"AbjustExportUtil.export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)1);
        if (pkIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbjustExportUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filterParam.toArray()).values().toArray(new DynamicObject[0]);
        DynamicObject[] arrDimMappingImport = new DynamicObject[arrDimMapping.length];
        int i = 0;
        for (DynamicObject srcDy : arrDimMapping) {
            DynamicObject descDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_annaccount_import");
            descDy.set("model", srcDy.get("model"));
            descDy.set("dseq", srcDy.get("dseq"));
            descDy.set("isopen", srcDy.get("isopen"));
            DynamicObject afterDimension = descDy.getDynamicObjectCollection("annualaccountafter").addNew();
            LossCarryScheme.getDimensions((Long)modelId).forEach(dim -> afterDimension.set(dim.getFieldmapped(), srcDy.get(dim.getFieldmapped())));
            DynamicObjectCollection before = descDy.getDynamicObjectCollection("annualaccountbefore");
            DynamicObjectCollection srcbefore = srcDy.getDynamicObjectCollection("annualaccountbefore");
            DynamicObjectCollection applyEntityEntry = descDy.getDynamicObjectCollection("applyentityentry");
            DynamicObjectCollection applySceneEntry = descDy.getDynamicObjectCollection("applysceneentry");
            Map<String, List<DynamicObject>> dimNumber2Dys = srcbefore.stream().filter(src -> {
                String dimNumber = src.getString("dimension.number");
                return Objects.nonNull(dimNumber) && !"Entity".equals(dimNumber) && !"Scenario".equals(dimNumber);
            }).collect(Collectors.groupingBy(src -> rowName2FieldMapped.getOrDefault(src.getString("dimension.fieldmapped"), src.getString("dimension.number"))));
            Arrays.stream(SRC_DIM_ORDER).map(dimNumber2Dys::get).filter(Objects::nonNull).forEach(dys -> dys.forEach(src -> {
                DynamicObject beforeDimension = before.addNew();
                beforeDimension.set("dimension", src.get("dimension"));
                beforeDimension.set("dimmembernum", src.get("dimmembernum"));
                beforeDimension.set("scope", src.get("scope"));
            }));
            srcbefore.stream().filter(d -> "Entity".equals(d.getString("dimension.number"))).collect(Collectors.toSet()).forEach(applyEntity -> {
                DynamicObject dynamicObject = applyEntityEntry.addNew();
                dynamicObject.set("entitynumber", applyEntity.get("dimmembernum"));
                dynamicObject.set("entityscope", applyEntity.get("scope"));
                dynamicObject.set("entityapplytype", applyEntity.get("applytype"));
            });
            srcbefore.stream().filter(d -> "Scenario".equals(d.getString("dimension.number"))).collect(Collectors.toSet()).forEach(applyScene -> {
                DynamicObject dynamicObject = applySceneEntry.addNew();
                dynamicObject.set("scenenumber", applyScene.get("dimmembernum"));
                dynamicObject.set("scenescope", applyScene.get("scope"));
                dynamicObject.set("sceneapplytype", applyScene.get("applytype"));
            });
            arrDimMappingImport[i] = descDy;
            ++i;
        }
        return ExportUtil.export((DynamicObject[])arrDimMappingImport, pkIds.get(0), (String)routeAppId, (String)"bcm_annaccount_import", (String)filterName);
    }

    static {
        masScheduleMapping.put("groupnum", "groupnum");
        masScheduleMapping.put("olaporg", "olaporg");
        masScheduleMapping.put("dseq_imp", "dseq");
        masScheduleMapping.put("sumary_imp", "description");
        masScheduleMapping.put("isdefaultcurrency", "isdefaultcurrency");
        masScheduleMapping.put("cvtbeforedebit", "cvtbeforedebit");
        masScheduleMapping.put("cvtbeforecredit", "cvtbeforecredit");
        masScheduleMapping.put("rate_imp", "rate");
        masScheduleMapping.put("debit_imp", "debit");
        masScheduleMapping.put("credit_imp", "credit");
        masScheduleMapping.put("summoney", "summoney");
        masScheduleMapping.put("cvtbeforesummoney", "cvtbeforesummoney");
        masScheduleDIMMapping.put("org_imp", "entity");
        masScheduleDIMMapping.put("account_imp", "account");
        masScheduleDIMMapping.put("changetype_imp", "changetype");
        masScheduleDIMMapping.put("mycompany_imp", "mycompany");
        masScheduleDIMMapping.put("icorg_imp", "internalcompany");
        masScheduleDIMMapping.put("process_imp1", "process");
        masScheduleDIMMapping.put("audittrail_imp1", "audittrail");
        masScheduleDIMMapping.put("audittrail_imp", "audittrail");
        masScheduleDIMMapping.put("dim1_imp", DIM_1);
        masScheduleDIMMapping.put("dim2_imp", DIM_2);
        masScheduleDIMMapping.put("dim3_imp", DIM_3);
        masScheduleDIMMapping.put("dim4_imp", DIM_4);
        masScheduleDIMMapping.put("dim5_imp", DIM_5);
        masScheduleDIMMapping.put("dim6_imp", DIM_6);
        masScheduleDIMMapping.put("multigaap_imp", "multigaap");
        masScheduleDIMMapping.put("currency_imp", "currency");
        rowName2FieldMapped.put(DIM_1, "C1");
        rowName2FieldMapped.put(DIM_2, "C2");
        rowName2FieldMapped.put(DIM_3, "C3");
        rowName2FieldMapped.put(DIM_4, "C4");
        rowName2FieldMapped.put(DIM_5, "C5");
        rowName2FieldMapped.put(DIM_6, "C6");
    }
}

