/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractAdjustBaseListPlugin
extends AbstractBaseListPlugin {
    private static final String OPEN_TYPE = "opentype";
    private static final String ADJUST = "adjust";
    private static final String NUMBER = "number";

    protected AdjustModel getAdjustModel(Object pkId) {
        AdjustModel am = new AdjustModel();
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        am.loadDynaObj2Model(dy);
        return am;
    }

    protected void openRptAdjustEntry(OperationStatus opera, AdjustModel am) {
        FormShowParameter param = new FormShowParameter();
        String opentype = (String)this.getFormCustomParam(OPEN_TYPE);
        AdjustTypeEnum type = AdjustTypeEnum.getAdjustTypeByVal((String)opentype);
        param.setFormId(type.getFormId());
        param.setStatus(opera);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam(OPEN_TYPE, (Object)opentype);
        AdjustModel adjust = null;
        if (am == null) {
            adjust = this.buildDefaultAdjustModel();
        } else {
            if (am.getCheckrecordId() != 0L) {
                this.setCheckrecordInfo(am);
            }
            adjust = am;
        }
        int maxgroup = AdjustModelUtil.getMaxGroupIndex(adjust.getId());
        adjust.setId(GlobalIdUtil.genGlobalLongId());
        param.setPageId(this.getView().getPageId() + this.getBizAppId() + this.getUserId() + "-" + adjust.getId() + "source");
        param.setCustomParam("maxgroup", (Object)maxgroup);
        param.setCustomParam("adjust_model", (Object)ObjectSerialUtil.toByteSerialized((Object)adjust));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_rptadjustdraft_entry"));
        this.getView().showForm(param);
    }

    protected void openAdjustOffsetEntry(OperationStatus opera, AdjustModel am, Map<String, Object> returnData, Long template) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_adjustoffset_entry");
        param.setStatus(opera);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        AdjustModel adjust = new AdjustModel();
        if (returnData.get("bussnesstype") != null) {
            String[] processAndOpenType = this.getOpenType(returnData.get("bussnesstype").toString());
            String process = AdjustTypeEnum.ELIM.getNumbers().contains(processAndOpenType[0]) && DimensionServiceHelper.isCM02Model((long)this.getModelId()) ? "EJE" : processAndOpenType[0];
            returnData.put(OPEN_TYPE, processAndOpenType[1]);
            returnData.put("process", process);
            adjust.setProcess(process);
        }
        adjust.setPermClass(returnData.get("permclass"));
        if (am == null) {
            if (template != null && template != 0L) {
                DynamicObject tmp = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bcm_adjusttemplate");
                if (!returnData.containsKey("process")) {
                    String[] processAndOpenType = this.getOpenType(tmp.getString("bussnesstype"));
                    String process = AdjustTypeEnum.ELIM.getNumbers().contains(processAndOpenType[0]) && DimensionServiceHelper.isCM02Model((long)this.getModelId()) ? "EJE" : processAndOpenType[0];
                    returnData.put(OPEN_TYPE, processAndOpenType[1]);
                    returnData.put("process", process);
                    adjust.setProcess(process);
                }
                adjust = this.buildDefaultAdjustModel(tmp.getString("spreadjson"), adjust);
                adjust.setTemplateId(template.longValue());
                adjust.setData(tmp.getString("data"));
                AdjustModel data = (AdjustModel)this.deSerializedBytes(tmp.getString("spreadjson"));
                adjust.setLinkCreateType(data.getLinkCreateType());
                returnData.put("linkcreatetype", data.getLinkCreateType());
                if (returnData.get(NUMBER) == null) {
                    returnData.put(NUMBER, AdjustOperationHelper.batchGetNumbers((String)"bcm_rptadjust", Collections.singletonList(adjust.genDynamicObject())).get(0));
                    returnData.put("name", tmp.getString("name"));
                    returnData.put("journaltype", tmp.getString("journaltype"));
                    returnData.put("updatecycle", "REQUIRED");
                    returnData.put("balancetype", tmp.getString("balancetype"));
                    returnData.put("bussnesstype", tmp.getString("bussnesstype"));
                }
                returnData.put("loadType", "addByTemplate");
            } else {
                adjust = this.buildDefaultAdjustModel(null, adjust);
                returnData.put("loadType", "addNew");
            }
            if (StringUtils.isNotEmpty((String)returnData.get("balancetype").toString())) {
                adjust.setBalancetype(Integer.parseInt(returnData.get("balancetype").toString()));
            } else {
                adjust.setBalancetype(BalanceTypeEnum.BALANCE.index);
            }
            adjust.setJournaltype(Integer.parseInt(returnData.get("journaltype").toString()));
            adjust.setMultiplecurrency(null == returnData.get("multiplecurrency") ? "0" : returnData.get("multiplecurrency").toString());
            adjust.setCvtBeforeCurrencyId(((Long)(null == returnData.get("foreigncurrency") ? Long.valueOf(0L) : returnData.get("foreigncurrency"))).longValue());
            param.setPageId(this.getView().getPageId() + this.getBizAppId() + this.getUserId() + "-" + adjust.getId() + "source");
        } else {
            if (am.getCheckrecordId() != 0L) {
                this.setCheckrecordInfo(am);
            }
            adjust = am;
        }
        this.dealAdjustModelBuilder(adjust, returnData);
        param.setCustomParams(returnData);
        param.setCustomParam("isLinkPage", (Object)false);
        param.setCustomParam("cslscheme", this.getValue("cslscheme_id"));
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("mergeid", returnData.get("merge"));
        param.setCustomParam("maxgroup", (Object)AdjustModelUtil.getMaxGroupIndex(adjust.getId()));
        param.setCustomParam("adjust_model", (Object)ObjectSerialUtil.toByteSerialized((Object)adjust));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPage"));
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showForm(param);
        } else {
            parentView.showForm(param);
            this.getView().sendFormAction(parentView);
        }
    }

    public void dealAdjustModelBuilder(AdjustModel adjust, Map<String, Object> returnData) {
    }

    private String[] getOpenType(String businessType) {
        String openType = "";
        String process = "";
        if (BusinessTypeEnum.ADJUSTSELFLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "DADJ";
            openType = "rpt";
        } else if (BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "IRpt";
            openType = "rpt";
        } else if (BusinessTypeEnum.ADJUSTCROSSLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "CS";
            openType = "rpt";
        } else if (BusinessTypeEnum.OFFSETSELFLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "DEJE";
            openType = "rpt";
        } else if (BusinessTypeEnum.ADJUSTSUBLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "ADJ";
            openType = ADJUST;
        } else if (BusinessTypeEnum.OFFSETEICA.getName().equalsIgnoreCase(businessType)) {
            process = "EICA";
            openType = "elim";
        } else if (BusinessTypeEnum.OFFSETEIT.getName().equalsIgnoreCase(businessType)) {
            process = "EIT";
            openType = "elim";
        } else if (BusinessTypeEnum.OFFSETECF.getName().equalsIgnoreCase(businessType)) {
            process = "ECF";
            openType = "elim";
        } else if (BusinessTypeEnum.OFFSETEOE.getName().equalsIgnoreCase(businessType)) {
            process = "EOE";
            openType = "elim";
        } else if (BusinessTypeEnum.OFFSETEOther.getName().equalsIgnoreCase(businessType)) {
            process = "EOther";
            openType = "elim";
        } else if (BusinessTypeEnum.ADJUSTCONTRIBUTIONLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "CCADJ";
            openType = ADJUST;
        } else if (BusinessTypeEnum.ADJUSTLAYERLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "CADJ";
            openType = ADJUST;
        } else if (BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName().equalsIgnoreCase(businessType)) {
            process = "EJE";
            openType = ADJUST;
        } else if (BusinessTypeEnum.RADJ.getName().equalsIgnoreCase(businessType)) {
            process = "RAdj";
            openType = "rpt";
        } else if (BusinessTypeEnum.EADJ.getName().equalsIgnoreCase(businessType)) {
            process = BusinessTypeEnum.EADJ.getName();
            openType = "erpt";
        } else if (BusinessTypeEnum.PADJ.getName().equalsIgnoreCase(businessType)) {
            process = "PADJ";
            openType = ADJUST;
        }
        String[] result = new String[]{process, openType};
        return result;
    }

    public void setCheckrecordInfo(AdjustModel am) {
        if (CollectionUtils.isEmpty((Collection)am.getSpreadDimensionEntries()) || CollectionUtils.isEmpty((Collection)am.getCommDimensionEntries())) {
            AdjustModelUtil.fillBack2AdjustModel((AbstractFormPlugin)this, am);
        }
        List commDimensionEntries = am.getCommDimensionEntries();
        for (CommDimensionEntry entry : commDimensionEntries) {
            if ("Process".equals(entry.getDimension().getNumber())) {
                DynamicObject memberDy = QueryDimensionServiceHelper.getMemberMsgByNumber((long)am.getModelId(), (String)am.getProcess(), (String)"bcm_processmembertree");
                Member member = new Member();
                member.setId(memberDy.getLong("id"));
                member.setName(memberDy.getString("name"));
                member.setNumber(memberDy.getString(NUMBER));
                entry.setMember(member);
                continue;
            }
            if (!"Currency".equals(entry.getDimension().getNumber()) || entry.getMember() != null) continue;
            DynamicObject currency = OrgCurrencyServiceHelper.getOrgModelAndCurrency((Long)am.getMergeId(), (Long)am.getYearId(), (Long)am.getPeriodId());
            DynamicObject currencyDim = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,name,number", (QFilter[])new QFilter(NUMBER, "=", (Object)currency.getString("currency.number")).and("model", "=", (Object)am.getModelId()).toArray());
            Member member = new Member();
            member.setId(currencyDim.getLong("id"));
            member.setName(currencyDim.getString("name"));
            member.setNumber(currencyDim.getString(NUMBER));
            entry.setMember(member);
        }
        am.put("isAdjustOnlyView", (Object)"true");
        am.put("isIncludeLinkage", (Object)"false");
        am.put("idsMap", (Object)this.getPageCache().get("idsMap"));
    }

    private DynamicObject getAuditTrialMemberByNumber(String number) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter1 = new QFilter(NUMBER, "=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_audittrialmembertree", (String)"id,numebr,name", (QFilter[])new QFilter[]{filter, filter1});
    }

    public AdjustModel buildDefaultAdjustModel(String defautSpread, AdjustModel adjust) {
        adjust.setModelId(this.getModelId());
        Predicate<Object> p = Objects::isNull;
        adjust.setScenarioId(this.defaultIfNull(p, this.getModel().getValue("scenario"), 0L, v -> ((DynamicObject)v).getLong("id")).longValue());
        adjust.setYearId(this.defaultIfNull(p, this.getModel().getValue("year"), 0L, v -> ((DynamicObject)v).getLong("id")).longValue());
        adjust.setPeriodId(this.defaultIfNull(p, this.getModel().getValue("period"), 0L, v -> ((DynamicObject)v).getLong("id")).longValue());
        if (this.isExistAuditTrailDimension()) {
            adjust.setAudittrail(this.defaultIfNull(p, this.getAuditTrialMemberByNumber("ManualJournal"), 0L, v -> ((DynamicObject)v).getLong("id")).longValue());
        }
        AdjustModelUtil.fillBack2AdjustModel((AbstractFormPlugin)this, adjust, defautSpread);
        adjust.setCreateTime(TimeServiceHelper.now());
        adjust.setCreatorId(this.getUserId());
        adjust.setStatus("0");
        adjust.setJournaltype(1);
        return adjust;
    }

    public AdjustModel buildDefaultAdjustModel() {
        return this.buildDefaultAdjustModel(null, new AdjustModel());
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object v, R defaultValue, Function<Object, R> f) {
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    protected String getOpenTypeByProcess(String sProcess) {
        String opentype = "";
        opentype = "IRpt".equalsIgnoreCase(sProcess) || "CS".equalsIgnoreCase(sProcess) || "DADJ".equalsIgnoreCase(sProcess) || "DEJE".equalsIgnoreCase(sProcess) ? "rpt" : ("ADJ".equalsIgnoreCase(sProcess) || "CCADJ".equalsIgnoreCase(sProcess) || "CADJ".equalsIgnoreCase(sProcess) || "EJE".equalsIgnoreCase(sProcess) ? ADJUST : "elim");
        return opentype;
    }

    protected boolean isCM017() {
        return ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM017");
    }
}

