/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.inputReader.AdjustInputMemberReader;
import kd.fi.bcm.business.adjust.model.AdjustErrorCatcher;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerPluginProxy;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.model.AreaPositionManger;
import kd.fi.bcm.formplugin.adjust.model.AreaPositionPluginManger;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AdjustAfterSpreadValidator;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AdjustSpreadValidatorExecute;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AdjustSpreadValidatorPluginExecute;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.websocket.IAdjustSpiltScrean;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractAdjustBasePlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier,
MainPage,
IAdjustSpiltScrean {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String ENTITY_SIGN = "entitysign";
    private static final String OPEN_TYPE = "opentype";
    protected static final String LONG_NUMBER = "longnumber";
    protected static final String key_effectRow = "effectRow";
    protected String KEY_ADJUST_MODEL = "adjust_model";
    protected String KEY_SPREAD_MODEL = "KEY_SPREAD_MODEL";
    protected boolean isInitPage = false;
    private AdjustOperationContext ctx;
    protected AdjustModel adjust;
    protected SpreadManager spread;
    private AdjustErrorCatcher errorCatcher;
    private AreaPositionManger areaPositionManger;
    private AdjustSpreadActionHandlerProxy adjustSpreadActionHandlerProxy;
    private AdjustSpreadValidatorExecute spreadValidatorExecute;
    private AdjustInputMemberReader inputMemberReader;
    protected Map<String, Integer> indexMap;

    protected void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            this.handleCellSelectEvent(e);
            this.doAfterSpreadEventHandle();
        });
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_COL, this::handleDealCol2RowBeforeEvent);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, this::handleDealCol2RowBeforeEvent);
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, this::handleDealCol2RowBeforeEvent);
        this.registerBeforeEvent(EventConstant.ActionName.ADD_COL, this::handleDealCol2RowBeforeEvent);
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            this.handleDealCol2RowAfterEvent(e);
            this.doAfterSpreadEventHandle();
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            this.handleDealCol2RowAfterEvent(e);
            this.doAfterSpreadEventHandle();
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            this.handleDealCol2RowAfterEvent(e);
            this.doAfterSpreadEventHandle();
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> {
            this.handleDealCol2RowAfterEvent(e);
            this.doAfterSpreadEventHandle();
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> {
            SpreadPostDataInfo postDataInfos = (SpreadPostDataInfo)e.getParam();
            this.handleUpdateMulvalueBeforeEvent(postDataInfos.getValues());
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, this::handleUpdateValueEvent);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> {
            SpreadPostDataInfo postDataInfos = (SpreadPostDataInfo)e.getSource();
            this.handleUpdateMulvalueAfterEvent(postDataInfos.getValues());
            this.doAfterSpreadEventHandle();
            this.setModifyStatus(true);
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_FORMULA, this::handleUpdateFormulaBeforeEvent);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_FORMULA, this::handleUpdateFormulaAfterEvent);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_MULFORMULA, e -> {
            this.doAfterSpreadEventHandle();
            this.setModifyStatus(true);
        });
    }

    protected Set<String> getNoNeedManualChangedColNumSet() {
        return Collections.emptySet();
    }

    protected void doAfterSpreadEventHandle() {
        this.afterCollectError();
        this.getAdjustSheetHandler().invokeCommands();
    }

    protected void handleUpdateFormulaBeforeEvent(NotifyEvent e) {
    }

    private void handleUpdateFormulaAfterEvent(NotifyEvent notifyEvent) {
    }

    protected void handleUpdateMulvalueBeforeEvent(List<LinkedHashMap<String, Object>> values) {
        Set noNeedManualChangedColSet = this.getNoNeedManualChangedColNumSet().stream().map(p -> this.createOrGetIndexMap().get(p)).collect(Collectors.toSet());
        values.removeIf(cellData -> {
            int row = Integer.parseInt(cellData.get("r").toString());
            int col = Integer.parseInt(cellData.get("c").toString());
            if (row < 1) {
                this.getAdjustSheetHandler().setCellValue(row, col, this.getEffectiveSheet().getCell(row, col).getValue(), true);
                return true;
            }
            if (noNeedManualChangedColSet.contains(col)) {
                this.getAdjustSheetHandler().setCellValue(row, col, null, true);
                return true;
            }
            return false;
        });
    }

    protected void handleCellSelectEvent(NotifyEvent e) {
        SpreadPostDataInfo data = (SpreadPostDataInfo)e.getSource();
        this.getPageCache().put("spread_selectrows", ObjectSerialUtil.toByteSerialized((Object)data.getSelRows()));
    }

    protected void handleUpdateValueEvent(NotifyEvent e) {
    }

    protected void handleUpdateCellvalue(int row, int col, Object input) {
        this.handleUpdateMulvalueAfterEvent(Collections.singletonList(MapInitHelper.ofCvMap((int)row, (int)col, (Object)input)));
    }

    protected void handleUpdateMulvalueAfterEvent(List<LinkedHashMap<String, Object>> values) {
    }

    protected void handleDealCol2RowBeforeEvent(NotifyEvent e) {
        AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
        if (excuteinfo.getOperationdata().contains(0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u65f6\u4e0d\u80fd\u5305\u542b\u5206\u5f55\u5934\u3002", (String)"AbstractAdjustBasePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.RemoveOrAddRowCol(e);
    }

    protected void handleDealCol2RowAfterEvent(NotifyEvent e) {
        if (e.isCancel()) {
            return;
        }
        this.setModifyStatus(true);
        this.updateRowAndCol((AskExcuteInfo)e.getSource());
    }

    public void afterItemClick(ItemClickEvent evt) {
        this.doAfterSpreadEventHandle();
    }

    @Override
    public void destory() {
        this.doAfterSpreadEventHandle();
        super.destory();
    }

    @Override
    public void afterDealMsg(CommandParam com) {
        this.doAfterSpreadEventHandle();
    }

    @Override
    public void doAfterNotify(NotifyEvent event) {
        super.doAfterNotify(event);
    }

    protected void setModifyStatus(boolean isModifyStatus) {
        if (isModifyStatus) {
            this.getPageCache().put("modifyStatus", "1");
        } else {
            this.getPageCache().remove("modifyStatus");
        }
    }

    protected boolean isModifyStatus() {
        return "1".equals(this.getPageCache().get("modifyStatus"));
    }

    @Override
    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        super.afterSpreadEventHandle(actionName);
        this.doAfterSpreadEventHandle();
    }

    public AdjustOperationContext getCtx() {
        if (this.ctx == null) {
            long sceneId = this.getFormCustomParam("op_scene", this.getAdjustModel().getScenarioId());
            long yearId = this.getFormCustomParam("op_year", this.getAdjustModel().getYearId());
            long periodId = this.getFormCustomParam("op_period", this.getAdjustModel().getPeriodId());
            this.ctx = new AdjustOperationContext(this.getAdjustModel().getModelId(), sceneId, yearId, periodId);
            this.ctx.setCslId((Long)this.getView().getFormShowParameter().getCustomParam("cslscheme"));
            this.ctx.addUserObject("bcm_mergenode", (Object)this.getAdjustModel().getMergeId());
            this.ctx.addUserObject("src_page", (Object)"bcm_rptadjustdraft_adjust");
            this.ctx.addUserObject("process", (Object)this.getAdjustModel().getProcess());
        }
        return this.ctx;
    }

    public AreaPositionManger getAreaPositionManger() {
        if (this.areaPositionManger == null) {
            this.areaPositionManger = new AreaPositionPluginManger(this);
        }
        return this.areaPositionManger;
    }

    public AdjustInputMemberReader getInputMemberReader() {
        if (this.inputMemberReader == null) {
            this.inputMemberReader = new AdjustInputMemberReader(this.getCtx());
        }
        return this.inputMemberReader;
    }

    public void clearSpreadModel() {
        this.spread = null;
        this.indexMap = null;
        this.getAreaPositionManger().clear();
        this.adjustSpreadActionHandlerProxy = null;
        this.getPageCache().remove(this.KEY_SPREAD_MODEL);
    }

    public AdjustSpreadActionHandlerProxy getAdjustSheetHandler() {
        if (this.adjustSpreadActionHandlerProxy == null) {
            this.adjustSpreadActionHandlerProxy = new AdjustSpreadActionHandlerPluginProxy(this);
        }
        return this.adjustSpreadActionHandlerProxy;
    }

    public AdjustErrorCatcher getErrorCatcher() {
        if (this.errorCatcher == null) {
            this.errorCatcher = new AdjustErrorCatcher(this.getView());
        }
        return this.errorCatcher;
    }

    public AdjustSpreadValidatorExecute getSpreadValidatorExecute() {
        if (this.spreadValidatorExecute == null) {
            this.spreadValidatorExecute = new AdjustSpreadValidatorPluginExecute(this);
            this.getView().getFormShowParameter().getCustomParams().forEach((k, v) -> this.spreadValidatorExecute.getCtx().addUserObject(k, v));
        }
        return this.spreadValidatorExecute;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.spreadValidate(evt.getItemKey());
    }

    protected void spreadValidate(String itemKey) {
        this.getSpreadValidatorExecute().setOperationKey(itemKey);
        this.initSpreadValidators(this.getSpreadValidatorExecute());
        this.getSpreadValidatorExecute().excute();
        this.afterCollectError();
        List<Integer> effectRowList = this.getSpreadValidatorExecute().getEffectRows();
        if (effectRowList != null) {
            this.getPageCache().put(key_effectRow, this.toByteSerialized(effectRowList));
        }
    }

    protected List<Integer> getRealEffectRows() {
        AdjustSpreadValidatorExecute spreadValidatorExecute = new AdjustSpreadValidatorExecute(this.getErrorCatcher(), this.getCtx(), this.getAdjustModel(), this.getEffectiveSheet());
        spreadValidatorExecute.addValidator(new AdjustAfterSpreadValidator());
        spreadValidatorExecute.excute();
        return spreadValidatorExecute.getEffectRows();
    }

    protected void initSpreadValidators(AdjustSpreadValidatorExecute e) {
    }

    protected void afterCollectError() {
        this.getErrorCatcher().throwError();
    }

    @Override
    public void checkPerm(String opkey) {
        if ("btn_cancel_submit".equals(opkey)) {
            opkey = "btn_submit";
        } else if ("btn_cancel_ratify".equals(opkey)) {
            opkey = "btn_ratify";
        }
        super.checkPerm(opkey, this.getView().getEntityId());
    }

    protected void addChangeDataSign(Integer ... rows) {
        Map<String, Integer> indexmap = this.createOrGetIndexMap();
        Integer[] integerArray = rows;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int row = integerArray[i];
            this.getEffectiveSheet().getCell(row, indexmap.get("ischanged").intValue()).setValue((Object)"1");
        }
        this.cacheSpreadModel();
    }

    @Override
    protected void mergeInvokeUpdateValueCommands(Map<String, Object> e) {
        this.getAdjustSheetHandler().setCellValue((Integer)e.get(SpreadProperties.UpdataValueMethod.R.k()), (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k()), e.get(SpreadProperties.UpdataValueMethod.V.k()));
    }

    @Override
    protected void mergeInvokeUpdateValueCommands(List<Map<String, Object>> item) {
        item.forEach(e -> this.getAdjustSheetHandler().setCellValue((Integer)e.get(SpreadProperties.UpdataValueMethod.R.k()), (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k()), e.get(SpreadProperties.UpdataValueMethod.V.k())));
    }

    protected void RemoveOrAddRowCol(NotifyEvent e) {
        if (this.getAdjustModel() != null) {
            String status = this.getAdjustModel().getStatus();
            if (RptAdjustStatusEnum.AUDIT.status().equals(status)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u9879\u64cd\u4f5c\u3002", (String)"AbstractAdjustBasePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (RptAdjustStatusEnum.COMMIT.status().equals(status)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u9879\u64cd\u4f5c\u3002", (String)"AbstractAdjustBasePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
        List<Integer> nums = excuteinfo.getOperationdata();
        EventConstant.ActionName actionname = excuteinfo.getActionname();
        if (CollectionUtils.isNotEmpty(nums) && nums.get(0) == 0 && (EventConstant.ActionName.ADD_ROW == actionname || EventConstant.ActionName.REMOVE_ROW == actionname)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u8868\u5934\u6216\u8005\u5728\u8868\u5934\u4e0a\u65b9\u63d2\u5165\u884c\u3002", (String)"AbstractAdjustBasePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Sheet sheet = this.getEffectiveSheet();
        if (EventConstant.ActionName.REMOVE_COL == actionname) {
            int MaxRows = sheet.getMaxRowCount();
            for (Integer col : nums) {
                for (int i = 0; i < MaxRows; ++i) {
                    Cell cell = sheet.getCell(i, col.intValue());
                    if (cell == null || cell.getUserObject(ENTITY_SIGN) == null) continue;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5217\u4e0d\u53ef\u5220\u9664\u3002", (String)"AbstractAdjustBasePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    protected void dealUpdateValue(Cell selectCell) {
    }

    protected void dealSpecialCellValue(Cell selectCell) {
    }

    protected void handleUpdateValueEvent(Cell cell) {
    }

    protected void clearData(Cell cell) {
        ArrayList<String> clears = new ArrayList<String>(10);
        clears.add("debit");
        clears.add("credit");
        clears.add("groupnum");
        clears.add("dseq");
        Sheet effectiveSheet = this.getEffectiveSheet();
        for (String sign : clears) {
            Cell de = this.getHeaderBySign(sign);
            if (de == null) continue;
            effectiveSheet.getCell(cell.getRow(), de.getCol()).setValue(null);
            this.mergeInvokeUpdateValueCommands(Lists.newArrayList((Object[])new Map[]{AdjustModelUtil.packedUpdateCellMap(cell.getRow(), de.getCol(), null)}));
        }
    }

    protected Cell getHeaderBySign(String sign) {
        Sheet sheet = this.getEffectiveSheet();
        int maxRow = sheet.getMaxRowCount();
        int maxCol = sheet.getMaxColumnCount();
        for (int row = 0; row < maxRow; ++row) {
            for (int col = 0; col < maxCol; ++col) {
                Cell cell = sheet.getCell(row, col);
                if (!sign.equals(cell.getUserObject(ENTITY_SIGN))) continue;
                return cell;
            }
        }
        return null;
    }

    protected void setF7Cell(List<Integer> nums) {
        int maxCol = this.getEffectiveSheet().getMaxColumnCount();
        for (Integer integer : nums) {
            for (int j = 0; j < maxCol; ++j) {
                Cell cell = this.getHeader(j);
                if (cell == null || !((String)cell.getUserObject(ENTITY_SIGN)).startsWith("bcm_")) continue;
                this.getAdjustSheetHandler().setCellF7Style(integer, j, 1, 1, 0, 0);
            }
        }
    }

    public AdjustModel getAdjustModel() {
        if (this.adjust != null) {
            return this.adjust;
        }
        Predicate<String> p = StringUtils::isEmpty;
        String serial = this.getPageCache().get(this.KEY_ADJUST_MODEL);
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam(this.KEY_ADJUST_MODEL);
        }
        this.adjust = !p.test(serial) ? this.getAdjustModelFromSerial(serial) : new AdjustModel();
        this.getPageCache().put(this.KEY_ADJUST_MODEL, this.toSerialAdjustModel(this.adjust));
        return this.adjust;
    }

    protected AdjustModel getAdjustModelFromSerial(String serial) {
        return (AdjustModel)this.deSerializedBytes(serial);
    }

    protected String toSerialAdjustModel(AdjustModel model) {
        return this.toByteSerialized(model);
    }

    protected void cacheAdjustModel(AdjustModel model) {
        this.getPageCache().put(this.KEY_ADJUST_MODEL, this.toSerialAdjustModel(model));
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spread != null) {
            return this.spread;
        }
        String schema = this.getPageCache().get(this.KEY_SPREAD_MODEL);
        Predicate<String> p = StringUtils::isEmpty;
        boolean hasCache = true;
        if (p.test(schema)) {
            schema = this.getAdjustModel().getData();
            hasCache = false;
        }
        this.spread = !p.test(schema) ? (SpreadManager)ObjectSerialUtil.deSerializedBytesAdjust((String)schema) : this.buildSpread(false);
        if (!hasCache) {
            SpreadUtils.updateCellOnUnchangeState(this.spread.getBook(), false);
            this.cacheSpreadModel();
        }
        return this.spread;
    }

    protected SpreadManager buildSpread(boolean hasSpread) {
        SpreadManager spread;
        if (hasSpread) {
            spread = this.getSpreadModel();
            spread.setFilter(this.builderFiltView());
        } else {
            String name = this.getAdjustModel().getName();
            if (StringUtils.isEmpty((String)name)) {
                name = ResManager.loadKDString((String)"\u5e95\u7a3f\u5f0f\u5206\u5f55", (String)"AbstractAdjustBasePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            spread = new SpreadManager(name, this.builderFiltView());
        }
        this.spread = spread;
        this.getPageCache().put(this.KEY_SPREAD_MODEL, this.toSerialSpreadModel(spread));
        return spread;
    }

    protected FilterView builderFiltView() {
        return null;
    }

    public String toSerialSpreadModel(SpreadManager spread) {
        return this.toByteSerialized(spread);
    }

    protected String getSpreadModelSerial() {
        return this.toSerialSpreadModel(this.getSpreadModel());
    }

    public void cacheSpreadModel() {
        this.getAdjustSheetHandler().setNeedInvoke(true);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        this.spread = sm;
        this.getAdjustSheetHandler().setSpreadManager(sm);
        this.getAdjustSheetHandler().setNeedInvoke(true);
    }

    protected int parseOrgScope() {
        switch (this.getAdjustModel().getProcess()) {
            case "CCADJ": 
            case "EJE": 
            case "ADJ": 
            case "CADJ": {
                return 2;
            }
            case "DADJ": 
            case "DEJE": {
                return 1;
            }
        }
        return 0;
    }

    protected void setOrgFilter(BasedataEdit ed, int row, String entitysign) {
        ed.setQFilters(this.getOrgFilterList(this.parseOrgScope(), row, entitysign));
    }

    protected List<QFilter> getOrgFilterList(int orgScopeType, int row, String entitysign) {
        String value = (String)this.getFormCustomParam(OPEN_TYPE);
        QFBuilder orgQFb = new QFBuilder("model", "=", (Object)this.getAdjustModel().getModelId());
        if (value != null) {
            orgQFb.add("isexchangerate", "=", (Object)"0");
        }
        String plongnumber = ((DynamicObject)this.getModel().getValue("entity")).getString(LONG_NUMBER);
        if (row == -1 || entitysign.equals("bcm_mergenode")) {
            orgScopeType = 1;
        } else {
            this.indexMap = this.createOrGetIndexMap();
            Integer mergeIndex = this.indexMap.get("bcm_mergenode");
            if (mergeIndex != null) {
                plongnumber = this.getEffectiveSheet().getCell(row, mergeIndex.intValue()).getUserObject(LONG_NUMBER) != null ? (String)this.getEffectiveSheet().getCell(row, mergeIndex.intValue()).getUserObject(LONG_NUMBER) : null;
            }
        }
        if (plongnumber == null) {
            DynamicObject org = this.getDefaultCslOrg();
            plongnumber = org.getString(LONG_NUMBER);
            orgQFb.and(LONG_NUMBER, "like", (Object)(plongnumber + "!%"));
        } else if (orgScopeType == 2) {
            orgQFb.and(LONG_NUMBER, "!=", (Object)plongnumber);
            if (this.getAdjustModel().isMergeinspread()) {
                orgQFb.and("parent.longnumber", "=", (Object)plongnumber);
            } else {
                orgQFb.and(new QFilter(LONG_NUMBER, "like", (Object)(plongnumber + "!%")));
            }
        } else {
            orgQFb.and(new QFilter(LONG_NUMBER, "like", (Object)(plongnumber + "!%")).or(LONG_NUMBER, "=", (Object)plongnumber));
        }
        if (orgScopeType == 1) {
            orgQFb.add("isleaf", "=", (Object)"0");
        }
        orgQFb.and("cslscheme", "=", this.getModel().getValue("cslscheme_id"));
        orgQFb.and("storagetype", "!=", (Object)"1");
        QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), "bcm_entitymembertree", "id");
        orgQFb.add(readOrWritePermFilter);
        return orgQFb.toList();
    }

    protected DynamicObject getDefaultCslOrg() {
        Object cslid = this.getView().getFormShowParameter().getCustomParam("cslscheme");
        if (cslid == null) {
            cslid = ((DynamicObject)this.getValue("entity")).getLong("cslscheme.id");
        }
        Object finalCslid = cslid;
        return (DynamicObject)ThreadCache.get((Object)(finalCslid.toString() + this.getAdjustModel().getModelId()), () -> QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,longnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getAdjustModel().getModelId()), new QFilter("cslscheme", "=", (Object)LongUtil.toLong((Object)finalCslid)), new QFilter("parent.number", "=", (Object)"Entity")}));
    }

    protected boolean ifComCanChange() {
        Sheet sheet = this.getEffectiveSheet();
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            for (int j = 0; j < sheet.getMaxRowCount(); ++j) {
                Cell cell = sheet.getCell(j, i);
                if (!CollectionUtils.isNotEmpty((Collection)cell.getMemberFromUserObject())) continue;
                return false;
            }
        }
        return true;
    }

    protected Cell getHeader(int col) {
        int maxRow = this.getEffectiveSheet().getMaxRowCount();
        for (int i = 0; i < maxRow; ++i) {
            Cell cell = this.getEffectiveSheet().getCell(i, col);
            if (cell.getUserObject(ENTITY_SIGN) == null) continue;
            return cell;
        }
        return null;
    }

    protected Map<String, Integer> createOrGetIndexMap() {
        if (this.indexMap != null && !this.indexMap.isEmpty()) {
            return this.indexMap;
        }
        this.indexMap = AdjustModelUtil.createOrGetIndexMap(this.getEffectiveSheet());
        return this.indexMap;
    }

    protected List<Integer> getDimensionCol(Map<String, Integer> indexmap) {
        ArrayList<Integer> hasEntityCol = new ArrayList<Integer>(10);
        for (Map.Entry<String, Integer> entry : indexmap.entrySet()) {
            String key = entry.getKey();
            if ("groupnum".equals(key) || "dseq".equals(key) || "description".equals(key) || key.startsWith("debit") || key.startsWith("credit") || key.startsWith("summoney") || key.startsWith("rate") || "cvtbeforedebit".equals(key) || "cvtbeforecredit".equals(key) || "cvtbeforesummoney".equals(key) || "entryrowtype".equals(key) || "entrysource".equals(key) || "ischanged".equals(key) || "linksource".equals(key) || "calculatecontent".equals(key)) continue;
            hasEntityCol.add(entry.getValue());
        }
        return hasEntityCol;
    }

    protected void hideEntryRowTypeColumn(Map<String, Integer> indexmap) {
        int[] colArray = new int[]{indexmap.get("entryrowtype")};
        SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), this.getSpreadKey(), colArray, false);
    }

    @Override
    public long getModelId() {
        Long modelId = super.getModelId();
        if ((modelId == null || modelId == 0L) && (modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model")) != null && modelId != 0L) {
            if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model")) {
                this.getModel().setValue("model", (Object)modelId);
            }
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        }
        if (modelId == null) {
            return 0L;
        }
        return modelId;
    }

    @Override
    public boolean isSpiltScreanModel() {
        return false;
    }
}

