/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.query.AdjustQueryService;
import kd.fi.bcm.business.adjust.task.platDisPatchJobTask.AdjustBelongOrgUpTask;
import kd.fi.bcm.business.adjust.task.platDisPatchJobTask.AdjustOlapOrgUpGradleTask;
import kd.fi.bcm.business.adjust.task.platDisPatchJobTask.AdjustSummoryUpGradleTask;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.model.AbstractDimensionMember;
import kd.fi.bcm.business.scheme.model.PrefPropertyDimensionMember;
import kd.fi.bcm.business.scheme.model.SysPropertyDimensionMember;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.report.AbstractAdjustBaseListPlugin;
import kd.fi.bcm.formplugin.adjust.report.ListDataProviderExt4AdjustDate;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class AbstractRptAdjustQueryPlugin
extends AbstractAdjustBaseListPlugin
implements MainPage {
    protected static final String f7MapCACHEKEY = "f7MapCacheKey";
    protected static final String comDImEntry = "commembentry";
    private static final String action_save = "action_save";
    private static final String action_base = "action_base";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(AbstractRptAdjustQueryPlugin.class);
    private Map<String, DimensionScope> f7DimModels;
    private AdjustQueryService adjustQueryService;
    List<QFilter> qfList = new ArrayList<QFilter>();

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addPackageDataListener(this::packData);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
    }

    private Map<String, Pair<String, Boolean>> controlForCreateListColumns() {
        HashedMap columnShowMap = new HashedMap(16);
        boolean isOne = false;
        for (String key : Lists.newArrayList((Object[])new String[]{"status", "journaltype"})) {
            String status = (String)this.getModel().getValue(key);
            if (!kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)status) && !kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)status.trim()) && Arrays.stream(status.split(",")).filter(e -> !kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)e.trim())).count() == 1L) {
                isOne = Boolean.TRUE;
            }
            columnShowMap.put("adjust." + key, Pair.onePair(null, (Object)isOne));
            isOne = false;
        }
        for (DimensionScope dimScope : this.getF7ModelCache().values()) {
            String colkey = "bcm_userdefinedmembertree".equals(dimScope.getDimension().getMembermodel()) ? dimScope.getDimension().getFieldmapped().toLowerCase(Locale.ENGLISH) + ".number" : dimScope.getDimension().getNumber().toLowerCase(Locale.ENGLISH) + ".number";
            columnShowMap.put(colkey, Pair.onePair((Object)dimScope.getDimension().getName(), (Object)(dimScope.getResolveScopeIds().size() == 1 ? 1 : 0)));
        }
        return columnShowMap;
    }

    protected Map<String, DimensionScope> getF7ModelCache() {
        if (this.f7DimModels == null) {
            this.f7DimModels = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(f7MapCACHEKEY));
        }
        return this.f7DimModels;
    }

    protected void setF7DimModels(Map<String, DimensionScope> f7DimModels) {
        this.f7DimModels = f7DimModels;
    }

    private QFBuilder queryRptAdjustDataFilterCache() {
        return (QFBuilder)ThreadCache.get((Object)"queryRptAdjustDataFilterCache", () -> this.queryRptAdjustDataFilter());
    }

    private void getCommonFilter(QFBuilder qf) {
        String status = (String)this.getModel().getValue("status");
        if (!(kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)status) || kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)status.trim()) || ",,".equals(status.trim()))) {
            qf.and(new QFilter("adjust.status", "in", (Object)status.split(",")));
        }
        Lists.newArrayList((Object[])new String[]{"journaltype"}).forEach(k -> {
            String value = (String)this.getModel().getValue(k);
            if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)value)) {
                qf.and(new QFilter("adjust." + k, "=", (Object)value));
            }
        });
        String journalnumber = (String)this.getModel().getValue("journalnumber");
        if (!kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)journalnumber) && kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)journalnumber.trim())) {
            qf.and(new QFilter("adjust.number", "like", (Object)("%" + journalnumber.trim() + "%")));
        }
        this.addNameAndTimeFilter("creator", "createtime", qf);
        this.addNameAndTimeFilter("modifier", "modifytime", qf);
        this.addNameAndTimeFilter("reviewer", "reviewtime", qf);
    }

    private boolean dealAdjustQuerySpecialFilter(QFBuilder qfBuilder) {
        DimensionScope processScope = this.getF7ModelCache().get(this.getF7Key("bcm_processmembertree", DimTypesEnum.PROCESS.getNumber()));
        Set processScopeNumbers = processScope.getResolveScopes();
        this.dealProcessMember(processScopeNumbers);
        String bussnesstype = (String)this.getModel().getValue("bussnesstype");
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)bussnesstype)) {
            String processNumber = BusinessTypeEnum.searchByName((String)bussnesstype).getProcessNumber();
            if (!processScopeNumbers.isEmpty() && !processScopeNumbers.contains(processNumber)) {
                return false;
            }
            processScopeNumbers.clear();
            processScopeNumbers.add(processNumber);
        }
        HashMap<Boolean, Set<String>> process = new HashMap<Boolean, Set<String>>();
        DynamicObject mergeOrg = (DynamicObject)this.getModel().getValue("entity");
        if (mergeOrg != null) {
            Long dimId = this.getAdjustQueryService().getCxt().getDimensionByNumber("Entity").getId();
            if (PermissionServiceImpl.getInstance((Long)this.getModelId()).hasNoPerm(dimId, Long.valueOf(mergeOrg.getLong("id")))) {
                return false;
            }
            if (!processScopeNumbers.isEmpty()) {
                processScopeNumbers.removeIf(e -> !OrgRelaProcessMembPool.isRelaProcess((String)e));
                if (processScopeNumbers.isEmpty()) {
                    return false;
                }
            } else {
                processScopeNumbers = OrgRelaProcessMembPool.getRelaProcessMembPool();
            }
            process.put(true, processScopeNumbers);
        }
        if (process.isEmpty()) {
            processScopeNumbers = processScopeNumbers.isEmpty() ? Arrays.stream(BusinessTypeEnum.values()).map(BusinessTypeEnum::getProcessNumber).collect(Collectors.toSet()) : processScopeNumbers;
            processScopeNumbers.forEach(e -> process.computeIfAbsent(OrgRelaProcessMembPool.isRelaProcess((String)e), k -> new HashSet()).add(e));
        }
        DimensionScope entityScope = this.getF7ModelCache().get(this.getF7Key("bcm_entitymembertree", DimTypesEnum.ENTITY.getNumber()));
        Set olapOrgIds = entityScope.getResolveScopeIds();
        boolean isSelectOrg = true;
        if (!CollectionUtils.isEmpty((Collection)olapOrgIds)) {
            int type = process.size() == 2 ? 2 : (process.containsKey(Boolean.TRUE) ? 1 : 3);
            Collection<String> olapOrgs = this.getOlapOrgs(olapOrgIds, mergeOrg != null ? mergeOrg.getLong("id") : 0L, type);
            if (olapOrgs.isEmpty()) {
                return false;
            }
            qfBuilder.and("olaporg", "in", olapOrgs);
        } else {
            if (!CollectionUtils.isEmpty((Collection)entityScope.getDimensionMembers())) {
                return false;
            }
            if (mergeOrg != null) {
                qfBuilder.and("adjust.entity.number", "=", (Object)mergeOrg.getString("number"));
            } else {
                isSelectOrg = false;
            }
        }
        Map<Boolean, List<Long>> processIdsMap = this.getProcessIds(process, processScope.getDimension());
        if (processIdsMap.isEmpty()) {
            return false;
        }
        if (isSelectOrg) {
            ArrayList prs = new ArrayList(processIdsMap.size());
            processIdsMap.forEach((isMerge, processIds) -> prs.addAll(processIds));
            qfBuilder.and("process", "in", prs);
        } else {
            ArrayList list = new ArrayList(2);
            processIdsMap.forEach((isMerge, processIds) -> {
                QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getHasPermFilterIncludeIds(entityScope.getDimension().getId(), isMerge != false ? "adjust.entity" : "entity", Collections.singleton(0L));
                list.add(new QFilter("process", "in", processIds).and(readOrWritePermFilter));
            });
            QFilter qf = list.size() == 2 ? ((QFilter)list.get(1)).or((QFilter)list.get(0)) : (QFilter)list.get(0);
            qfBuilder.add(qf);
        }
        return true;
    }

    private Map<Boolean, List<Long>> getProcessIds(Map<Boolean, Set<String>> proMap, Dimension dimension) {
        HashMap<Boolean, List<Long>> p = new HashMap<Boolean, List<Long>>(16);
        HashSet sets = new HashSet(16);
        proMap.forEach((k, v) -> {
            List processIds = AdjustCheckServiceHelper.transfNum2Ids((String)this.getAdjustQueryService().getCxt().getModelNumber(), (String)"Process", (Set)v);
            p.put((Boolean)k, processIds);
            sets.addAll(processIds);
        });
        Set noPerms = PermissionServiceImpl.getInstance((Long)this.getModelId()).matchNoPermMembers(dimension.getId(), dimension.getMembermodel(), sets);
        if (!noPerms.isEmpty()) {
            Iterator iterator = p.keySet().iterator();
            while (iterator.hasNext()) {
                ((List)p.get(iterator.next())).removeAll(noPerms);
            }
        }
        return p;
    }

    public QFBuilder queryRptAdjustDataFilter() {
        Map permissionMap;
        Collection noPermList;
        Long modelId = this.getModelId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        this.getCommonFilter(qfBuilder);
        if (!this.dealAdjustQuerySpecialFilter(qfBuilder)) {
            return qfBuilder.add("1", "=", (Object)0);
        }
        for (DimensionScope dimScope : this.getF7ModelCache().values()) {
            String colkey;
            Dimension dim = dimScope.getDimension();
            String dimNumber = dim.getNumber();
            String entitySign = dim.getMembermodel();
            String string = colkey = dim.isIssys() ? dim.getNumber().toLowerCase(Locale.ENGLISH) : dim.getFieldmapped().toLowerCase(Locale.ENGLISH);
            if (DimTypesEnum.PROCESS.getNumber().equals(dimNumber) || DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) continue;
            if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimNumber)) {
                qfBuilder.add(colkey + ".datasource", "=", (Object)DataSourceEnum.ENTRYADJUSTMENT.getOIndex());
            }
            Set memberIds = dimScope.getResolveScopeIds();
            this.dealAllShareMemberId(modelId, entitySign, memberIds);
            if (CollectionUtils.isEmpty((Collection)memberIds)) {
                if (DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber) || DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) || !CollectionUtils.isEmpty((Collection)dimScope.getDimensionMembers())) {
                    return qfBuilder.add("1", "=", (Object)0);
                }
                QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getHasPermFilterIncludeIds(dim.getId(), colkey, Collections.singleton(0L));
                qfBuilder.add(readOrWritePermFilter);
                continue;
            }
            Set needrms = PermissionServiceImpl.getInstance((Long)this.getModelId()).matchNoPermMembers(dim.getId(), dim.getMembermodel(), (Collection)memberIds);
            memberIds.removeAll(needrms);
            if (CollectionUtils.isEmpty((Collection)memberIds)) {
                return qfBuilder.add("1", "=", (Object)0);
            }
            qfBuilder.add(new QFilter(colkey, "in", (Object)memberIds));
        }
        if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin() && !CollectionUtil.isEmpty((Collection)(noPermList = (Collection)(permissionMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_rptadjust", (String)(this.getModelId() + ""), (String)RequestContext.getOrCreate().getUserId()).asMap()).get(PermClassEntityHelper.PermClassEnum.NOPERM.getValue())))) {
            qfBuilder.add("adjust", "not in", (Object)noPermList);
        }
        qfBuilder.add("adjust.number", "is not null", null);
        qfBuilder.add("currency.number", "is not null", null);
        return qfBuilder;
    }

    private void addNameAndTimeFilter(String operatorSign, String timeSign, QFBuilder filter) {
        Date endTime;
        Date startTime;
        String oper = (String)this.getModel().getValue(operatorSign + "name");
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)oper) && kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)oper.trim())) {
            filter.add("adjust." + operatorSign + ".name", "like", (Object)("%" + oper.trim() + "%"));
        }
        if ((startTime = (Date)this.getModel().getValue(timeSign + "start")) != null) {
            filter.add("adjust." + timeSign, ">=", (Object)startTime);
        }
        if ((endTime = (Date)this.getModel().getValue(timeSign + "end")) != null) {
            filter.add("adjust." + timeSign, "<=", (Object)endTime);
        }
    }

    private void dealProcessMember(Set<String> memberNumbers) {
        if (!CollectionUtils.isEmpty(memberNumbers)) {
            Set pNumbers = memberNumbers.stream().filter(e -> "EJET".equals(e) || "SEJE".equals(e) || "RAdj".equals(e) || "ERAdj".equals(e)).collect(Collectors.toSet()).stream().map(e -> {
                if ("EJET".equals(e)) {
                    return Arrays.asList("DEJE", "EICA", "EIT", "EOE", "ECF", "EOther", "EJE");
                }
                if ("SEJE".equals(e)) {
                    return Arrays.asList("EICA", "EIT", "EOE", "ECF", "EOther", "EJE");
                }
                return Arrays.asList("RAdj", "ERAdj");
            }).flatMap(e -> e.stream()).collect(Collectors.toSet());
            memberNumbers.addAll(pNumbers);
        }
    }

    public Collection<String> getOlapOrgs(Set<Long> memberIds, Long mergeOrg, int type) {
        if (memberIds == null || memberIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<Long, Set> olapMaps = new HashMap<Long, Set>(16);
        for (Long memberId : memberIds) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((String)this.getAdjustQueryService().getCxt().getModelNumber(), (Long)memberId);
            if (node == IDNumberTreeNode.NotFoundTreeNode || node.getParent() == null || node.getParent() == IDNumberTreeNode.NotFoundTreeNode) continue;
            if (node.getParent().getLongNumber().equals(node.getParent().getNumber())) {
                if (mergeOrg != 0L && !mergeOrg.equals(node.getId())) continue;
                olapMaps.computeIfAbsent(node.getId(), k -> new HashSet(16)).add(node.getNumber());
                continue;
            }
            if (mergeOrg != 0L && !mergeOrg.equals(node.getParent().getId())) continue;
            if (type <= 2) {
                olapMaps.computeIfAbsent(node.getParent().getId(), k -> new HashSet(16)).add(node.getParent_SonNumber());
            }
            if (type < 2) continue;
            olapMaps.computeIfAbsent(node.getId(), k -> new HashSet(16)).add(node.getNumber());
        }
        Set noPermIds = PermissionServiceImpl.getInstance((Long)this.getModelId()).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), "bcm_entitymembertree", olapMaps.keySet());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)noPermIds)) {
            noPermIds.forEach(e -> {
                Set cfr_ignored_0 = (Set)olapMaps.remove(e);
            });
        }
        return olapMaps.values().stream().flatMap(e -> e.stream()).collect(Collectors.toSet());
    }

    private void dealAllShareMemberId(Long modelId, String entity, Set<Long> memberIds) {
        if (!CollectionUtils.isEmpty(memberIds)) {
            for (Long memberId : new HashSet<Long>(memberIds)) {
                IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entity, (Long)memberId);
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                memberIds.add(node.getBaseTreeNode().getId());
                node.getBaseTreeNode().getShareNodes().forEach(e -> memberIds.add(e.getId()));
            }
        }
    }

    protected AdjustQueryService getAdjustQueryService() {
        if (this.adjustQueryService == null) {
            this.adjustQueryService = new AdjustQueryService(this.getModelId());
        }
        return this.adjustQueryService;
    }

    private void packData(PackageDataEvent e) {
        this.getAdjustQueryService().packData(e);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.qfList == e.getQFilters()) {
            return;
        }
        this.qfList.clear();
        e.getQFilters().forEach(qFilter -> Arrays.stream(qFilter.recombine()).forEach(qf -> {
            if (qf.getProperty().equals("merge") && "not exists".equalsIgnoreCase(qf.getCP())) {
                this.qfList.add(new QFilter("process.number", "not in", (Object)OrgRelaProcessMembPool.getRelaProcessMembPool()));
            } else if (qf.getProperty().contains(".number")) {
                if (qf.getProperty().equals("merge.number")) {
                    Set mergeProcess = OrgRelaProcessMembPool.getRelaProcessMembPool();
                    if ("is not null".equalsIgnoreCase((qf = new QFilter("adjust.entity.number", qf.getCP(), qf.getValue())).getCP())) {
                        this.qfList.add(new QFilter("process.number", "in", (Object)mergeProcess));
                    } else if ("is null".equalsIgnoreCase(qf.getCP()) || "=".equals(qf.getCP()) && qf.getValue() == QEmptyValue.value) {
                        this.qfList.add(new QFilter("process.number", "not in", (Object)mergeProcess));
                    } else if ("not like".equalsIgnoreCase(qf.getCP()) || "!=".equalsIgnoreCase(qf.getCP()) || "<>".equalsIgnoreCase(qf.getCP())) {
                        this.qfList.add(new QFilter("process.number", "not in", (Object)mergeProcess).or(new QFilter("process.number", "in", (Object)mergeProcess).and(qf.and(qf.copy().getProperty().replace(".number", ".name"), qf.getCP(), qf.getValue()))));
                    } else {
                        this.qfList.add(new QFilter("process.number", "in", (Object)mergeProcess).and(qf.or(qf.copy().getProperty().replace(".number", ".name"), qf.getCP(), qf.getValue())));
                    }
                } else if ("not like".equalsIgnoreCase(qf.getCP()) || "!=".equalsIgnoreCase(qf.getCP()) || "<>".equalsIgnoreCase(qf.getCP())) {
                    this.qfList.add(qf.and(qf.copy().getProperty().replace(".number", ".name"), qf.getCP(), qf.getValue()));
                } else {
                    this.qfList.add(qf.or(qf.copy().getProperty().replace(".number", ".name"), qf.getCP(), qf.getValue()));
                }
            } else {
                this.qfList.add((QFilter)qf);
            }
        }));
        this.qfList.addAll(this.queryRptAdjustDataFilterCache().toList());
        e.setQFilters(this.qfList);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_query": {
                if (!this.beforeRefreshCheck()) break;
                this.actionRefresh();
                break;
            }
            case "btn_save": {
                this.showBasePage(action_save);
                break;
            }
            case "btn_base": {
                this.showBasePage(action_base);
                break;
            }
            case "btn_baselist": {
                ListShowParameter formShowParameter = new ListShowParameter();
                formShowParameter.setFormId("bcm_rptadjustquery_list");
                formShowParameter.setBillFormId("bcm_rptadjustqueryplan");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("model", (Object)this.getModelId());
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "btn_upgradle_olaporg": {
                this.upgradleOlapOrgForAdjust();
                break;
            }
            case "btn_upgradle_summory": {
                this.upgradleSummoryForAdjust();
                break;
            }
            case "btn_upgradle_belongorg": {
                this.upgradleBelongorgForAdjust();
                break;
            }
        }
    }

    private void upgradleBelongorgForAdjust() {
        if (this.beforeRefreshCheck()) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (DimensionScope dimScope : this.getF7ModelCache().values()) {
                if (dimScope.getDimension().getMembermodel().equals("bcm_fymembertree")) {
                    params.put("yearIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (dimScope.getDimension().getMembermodel().equals("bcm_periodmembertree")) {
                    params.put("periodIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (!dimScope.getDimension().getMembermodel().equals("bcm_scenemembertree")) continue;
                params.put("scenarioIds", dimScope.getResolveScopeIds());
            }
            params.put("modelId", this.getModelId());
            this.createTask(ResManager.loadKDString((String)"\u5347\u7ea7\u6240\u5c5e\u7ec4\u7ec7", (String)"AbstractRptAdjustQueryPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AdjustBelongOrgUpTask.class.getName(), params);
        }
    }

    private void upgradleSummoryForAdjust() {
        if (this.beforeRefreshCheck()) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (DimensionScope dimScope : this.getF7ModelCache().values()) {
                if (dimScope.getDimension().getMembermodel().equals("bcm_fymembertree")) {
                    params.put("yearIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (dimScope.getDimension().getMembermodel().equals("bcm_periodmembertree")) {
                    params.put("periodIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (!dimScope.getDimension().getMembermodel().equals("bcm_scenemembertree")) continue;
                params.put("scenarioIds", dimScope.getResolveScopeIds());
            }
            params.put("modelId", this.getModelId());
            this.createTask(ResManager.loadKDString((String)"\u5347\u7ea7\u91d1\u989d\u5f0f", (String)"AbstractRptAdjustQueryPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AdjustSummoryUpGradleTask.class.getName(), params);
        }
    }

    private void upgradleOlapOrgForAdjust() {
        if (this.beforeRefreshCheck()) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (DimensionScope dimScope : this.getF7ModelCache().values()) {
                if (dimScope.getDimension().getMembermodel().equals("bcm_fymembertree")) {
                    params.put("yearIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (dimScope.getDimension().getMembermodel().equals("bcm_periodmembertree")) {
                    params.put("periodIds", dimScope.getResolveScopeIds());
                    continue;
                }
                if (!dimScope.getDimension().getMembermodel().equals("bcm_scenemembertree")) continue;
                params.put("scenarioIds", dimScope.getResolveScopeIds());
            }
            params.put("modelId", this.getModelId());
            this.createTask(ResManager.loadKDString((String)"\u5347\u7ea7\u5165\u5e93\u7ec4\u7ec7", (String)"AbstractRptAdjustQueryPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AdjustOlapOrgUpGradleTask.class.getName(), params);
        }
    }

    private void createTask(String taskName, String taskPath, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskPath);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        this.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    private void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    private void checkControlPermFromOtherBar() {
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map entityMap = (Map)permitem.get("bcm_rptadjustquery_list");
        if (entityMap != null && entityMap.containsKey("btn_addnew")) {
            String[] perm = ((String)entityMap.get("btn_addnew")).split("@");
            if (perm.length < 2) {
                return;
            }
            this.doCheckPermission(perm[0], perm[1]);
        }
    }

    protected boolean beforeRefreshCheck() {
        boolean flag = this.getF7ModelCache().values().stream().allMatch(e -> !DimTypesEnum.YEAR.getNumber().equals(e.getDimension().getNumber()) && !DimTypesEnum.SCENARIO.getNumber().equals(e.getDimension().getNumber()) && !DimTypesEnum.PERIOD.getNumber().equals(e.getDimension().getNumber()) || !CollectionUtils.isEmpty((Collection)e.getResolveScopeIds()));
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\uff1a\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AbstractRptAdjustQueryPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (String e2 : Arrays.asList("createtime", "modifytime", "reviewtime")) {
            Date start = (Date)this.getModel().getValue(e2 + "start");
            Date end = (Date)this.getModel().getValue(e2 + "end");
            if (start == null || end == null || start.compareTo(end) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5927\u4e8e%2$s", (String)"AbstractRptAdjustQueryPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getModel().getProperty(e2 + "start").getDisplayName().getLocaleValue(), this.getModel().getProperty(e2 + "end").getDisplayName().getLocaleValue()));
            return false;
        }
        return true;
    }

    private void showBasePage(String action) {
        this.checkControlPermFromOtherBar();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_adjustquerybase");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u57fa\u672c\u4fe1\u606f", (String)"AbstractRptAdjustQueryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        IDataModel model = this.getModel();
        if (action_base.equals(action)) {
            formShowParameter.setCustomParam("number", model.getValue("number"));
            formShowParameter.setCustomParam("name", model.getValue("name"));
            formShowParameter.setCustomParam("description", model.getValue("description"));
            formShowParameter.setCustomParam("id", (Object)this.getPageCache().get("pkId"));
        }
        formShowParameter.setCustomParam("applyscope", model.getValue("applyscope"));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (action_save.equals(actionId)) {
            this.handelBaseBack(closedCallBackEvent, false);
        } else if (action_base.equals(actionId)) {
            this.handelBaseBack(closedCallBackEvent, true);
        } else if ("taskcloseback".equals(actionId) && (result = (Map)closedCallBackEvent.getReturnData()) != null && result.containsKey("taskinfo") && kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotBlank((CharSequence)(data = taskInfo.getData()))) {
            JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
            if (dataObj.getBoolean("success").booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"AbstractRptAdjustQueryPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(dataObj.getString("message"));
            }
        }
    }

    private void handelBaseBack(ClosedCallBackEvent closedCallBackEvent, boolean isSave) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            this.actionSave(returnData, isSave);
        }
    }

    private void actionSave(Map<String, Object> returnData, boolean isSave) {
        if (isSave || !isSave && this.getPageCache().get("pkId") == null) {
            returnData.forEach((k, v) -> this.getModel().setValue(k, v));
        }
        if (this.validate()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"bcm_actionSave");){
            try {
                DynamicObject newPlan = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustqueryplan");
                DynamicObject dyob = this.getModel().getDataEntity();
                if (isSave && (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus() || this.getPageCache().get("pkId") != null)) {
                    QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get("pkId")));
                    DeleteServiceHelper.delete((String)"bcm_rptadjustqueryplan", (QFilter[])new QFilter[]{filter});
                }
                if (isSave) {
                    newPlan.set("name", (Object)dyob.getLocaleString("name"));
                    newPlan.set("number", (Object)dyob.getString("number"));
                    newPlan.set("applyscope", (Object)dyob.getString("applyscope"));
                    newPlan.set("description", (Object)dyob.getLocaleString("description"));
                    newPlan.set("creator", dyob.get("creator"));
                    newPlan.set("createtime", dyob.get("createtime"));
                } else {
                    newPlan.set("name", returnData.get("name"));
                    newPlan.set("number", returnData.get("number"));
                    newPlan.set("applyscope", returnData.get("applyscope"));
                    newPlan.set("description", returnData.get("description"));
                    newPlan.set("creator", (Object)RequestContext.get().getUserId());
                    newPlan.set("createtime", (Object)TimeServiceHelper.now());
                }
                newPlan.set("model", (Object)dyob.getDynamicObject("model"));
                newPlan.set("status", (Object)dyob.getString("status"));
                newPlan.set("journaltype", dyob.get("journaltype"));
                newPlan.set("modifier", (Object)RequestContext.get().getUserId());
                newPlan.set("modifytime", (Object)TimeServiceHelper.now());
                newPlan.set("entity", dyob.get("entity"));
                newPlan.set("bussnesstype", dyob.get("bussnesstype"));
                DynamicObjectCollection coll = newPlan.getDynamicObjectCollection(comDImEntry);
                Map<String, DimensionScope> f7keys = this.getF7ModelCache();
                int dseq = 1;
                for (DimensionScope dimScope : f7keys.values()) {
                    StringJoiner sjcommonfield = new StringJoiner(";");
                    for (AbstractDimensionMember dimMember : dimScope.getDimensionMembers()) {
                        if (dimMember instanceof PrefPropertyDimensionMember) {
                            sjcommonfield.add(((PrefPropertyDimensionMember)dimMember).getCommonField());
                            continue;
                        }
                        DynamicObject entry = new DynamicObject(coll.getDynamicObjectType());
                        entry.set("comdimension", (Object)dimScope.getDimension().getId());
                        entry.set("seq", (Object)dseq++);
                        entry.set("range", (Object)dimMember.getScope());
                        if (dimMember instanceof SysPropertyDimensionMember) {
                            entry.set("commembid", (Object)0L);
                            entry.set("pid", (Object)dimMember.getId());
                        } else {
                            entry.set("commembid", (Object)dimMember.getId());
                            entry.set("pid", (Object)0L);
                        }
                        coll.add((Object)entry);
                    }
                    if (sjcommonfield.length() <= 0) continue;
                    DynamicObject entry = new DynamicObject(coll.getDynamicObjectType());
                    entry.set("comdimension", (Object)dimScope.getDimension().getId());
                    entry.set("seq", (Object)dseq++);
                    entry.set("range", (Object)RangeEnum.VALUE_10.getValue());
                    entry.set("commembid", (Object)0L);
                    entry.set("pid", (Object)0L);
                    entry.set("commonfield", (Object)sjcommonfield.toString());
                    coll.add((Object)entry);
                }
                Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPlan});
                if (isSave || !isSave && this.getPageCache().get("pkId") == null) {
                    this.getPageCache().put("pkId", ((DynamicObject)result[0]).getString("id"));
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                }
                String opName = isSave ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractRptAdjustQueryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a\u6210\u529f\u3002", (String)"AbstractRptAdjustQueryPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(opName);
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "AbstractRptAdjustQueryPlugin_4", "fi-bcm-formplugin", "Add and new"), new OPDescMultiLangEnumBridge("%1$s\u64cd\u4f5c\u6210\u529f", "AbstractRptAdjustQueryPlugin_5", "fi-bcm-formplugin", new String[]{(String)returnData.get("number")}));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private boolean validate() {
        boolean isEdit;
        String cachePkId = this.getPageCache().get("pkId");
        if (cachePkId != null) {
            this.getView().getFormShowParameter().setCustomParam("pkId", (Object)Long.valueOf(cachePkId));
        }
        DynamicObject dyObj = this.getModel().getDataEntity();
        String number = dyObj.getString("number");
        String name = dyObj.getString("name");
        DynamicObject model = dyObj.getDynamicObject("model");
        StringBuilder msg = new StringBuilder();
        if (kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)number) || kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)number.trim())) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"AbstractRptAdjustQueryPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)name) || kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)name.trim())) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"AbstractRptAdjustQueryPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        if (!this.beforeRefreshCheck()) {
            return true;
        }
        QFilter filter1 = new QFilter("number", "=", (Object)number.trim());
        QFilter filter2 = new QFilter("name", "=", (Object)name.trim());
        QFilter filter3 = new QFilter("model", "=", (Object)model.getLong("id"));
        long id = this.getFormCustomParam("pkId") == null ? 0L : (Long)this.getFormCustomParam("pkId");
        boolean bl = isEdit = id != 0L;
        if (isEdit) {
            QFilter filter4 = new QFilter("id", "!=", (Object)id);
            if (QueryServiceHelper.exists((String)"bcm_rptadjustqueryplan", (QFilter[])new QFilter[]{filter2, filter3, filter4})) {
                msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\u3002", (String)"AbstractRptAdjustQueryPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (QueryServiceHelper.exists((String)"bcm_rptadjustqueryplan", (QFilter[])new QFilter[]{filter1, filter3})) {
                msg.append(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"AbstractRptAdjustQueryPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (QueryServiceHelper.exists((String)"bcm_rptadjustqueryplan", (QFilter[])new QFilter[]{filter2, filter3})) {
                msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\u3002", (String)"AbstractRptAdjustQueryPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        return false;
    }

    public void actionRefresh() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        CommandParam com = new CommandParam(this.getView().getEntityId(), "bcm_adjustdatadiff", "query", this.queryRptAdjustDataFilterCache());
        this.sendMsg(this.getView(), com);
    }

    @Override
    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packData);
    }

    protected void showDiffView(QFBuilder qfBuilder) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("bcm_adjustdatadiff");
        lsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        lsp.setPageId(this.getPageIdAndCache(this.getPageCache(), "bcm_adjustdatadiff", true));
        lsp.getOpenStyle().setTargetKey("tabpageap1");
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setParentFormId(this.getView().getPageId());
        this.getView().showForm(lsp);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        ArrayList showList = Lists.newArrayList((Object[])new String[]{"merge.number", "groupnum", "adjust.number", "adjust.name", "description", "adjust.entity.name", "olaporg", "entity.number", "account.number", "debit", "credit", "differ", "adjust.modifier.name", "adjust.modifytime", "adjust.submitter.name", "adjust.description", "adjust.submittime", "adjust.cancelsubmitter.name", "adjust.cancelsubmittime", "adjust.ratifier.name", "adjust.ratifytime", "adjust.reviewer.name", "adjust.reviewtime", "adjust.callbacker.name", "adjust.callbacktime", "adjust.creator.name", "adjust.createtime", "adjust.templatecatalog.name", "adjust.bussnesstype", "adjust.status", "adjust.journaltype", "adjust.balancetype", "listaccount", "listchangetype", "listinternalcompany", "adjust.multiplecurrency", "adjust.sourcetype", "adjust.entrysource", "adjust.extendfrom"});
        Map<String, Pair<String, Boolean>> nameShowMap = this.controlForCreateListColumns();
        for (IListColumn column : columns) {
            String colname = column.getListFieldKey();
            if (showList.contains(colname)) {
                column.setVisible(11);
                continue;
            }
            Pair<String, Boolean> nameIsShow = nameShowMap.get(colname);
            if (nameIsShow != null) {
                if (nameIsShow.p1 != null) {
                    column.setCaption(new LocaleString((String)nameIsShow.p1));
                }
                column.setVisible((Boolean)nameIsShow.p2 != false ? 0 : 11);
                continue;
            }
            column.setVisible(0);
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ListDataProviderExt4AdjustDate listDataProviderExt4AdjustDate = new ListDataProviderExt4AdjustDate();
        args.setListDataProvider((IListDataProvider)listDataProviderExt4AdjustDate);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        DynamicObject[] rptAdjustDatas = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)"entity.cslscheme.id,id,adjust.id,adjust.multiplecurrency,process.number,adjust.process,entity.id,entrysource", (QFilter[])new QFilter[]{new QFilter("id", "=", list.getFocusRowPkId())});
        AdjustModel am = null;
        if (rptAdjustDatas.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u884c\u4e0d\u652f\u6301\u8d85\u94fe\u63a5\u5c55\u793a\u3002", (String)"AbstractRptAdjustQueryPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isLinkagePage = rptAdjustDatas[0].getInt("entrysource") == ElimRptAdjSourceTypeEnum.LINK.getValue();
        String sProcess = rptAdjustDatas[0].getString("process.number");
        String opentype = this.getOpenTypeByProcess(sProcess);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_adjustoffset_entry");
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam("opentype", (Object)opentype);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("selectedNodeId", (Object)rptAdjustDatas[0].getString("entity.id"));
        param.setCustomParam("cslscheme", (Object)rptAdjustDatas[0].getString("entity.cslscheme.id"));
        param.setCustomParam("process", (Object)sProcess);
        param.setCustomParam("multiplecurrency", (Object)rptAdjustDatas[0].getLong("adjust.multiplecurrency"));
        param.setCustomParam("adjustdata.id", (Object)rptAdjustDatas[0].getLong("id"));
        am = this.getAdjustModel(rptAdjustDatas[0].getLong("adjust.id"));
        if (am == null) {
            am = this.buildDefaultAdjustModel();
        } else if (am.getCheckrecordId() != 0L) {
            this.setCheckrecordInfo(am);
        }
        am.put("isIncludeLinkage", (Object)isLinkagePage);
        if (isLinkagePage) {
            param.setCustomParam("yearNum", (Object)MemberReader.findFyMemberById((Long)this.getModelId(), (Long)am.getYearId()).getNumber());
            param.setCustomParam("periodId", (Object)am.getPeriodId());
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        CharSequence[] selectEntryIds = (String[])billList.getSelectedRows().getBillListSelectedRowCollection().stream().map(p -> p.getPrimaryKeyValue().toString()).distinct().toArray(String[]::new);
        ArrayList selectPkIdList = Lists.newArrayList();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)BCMConstant.DBROUTE, (String)String.format("select distinct fadjustid from T_BCM_rptadjustdata where fid in (%s)", String.join((CharSequence)",", selectEntryIds)));){
            ds.forEachRemaining(row -> selectPkIdList.add(row.getLong("fadjustid")));
        }
        if (selectPkIdList.size() > 1) {
            param.setCustomParam("showAdjustList", (Object)ObjectSerialUtil.toByteSerialized((Object)selectPkIdList));
        }
        int maxgroup = AdjustModelUtil.getMaxGroupIndex(am.getId());
        param.setCustomParam("maxgroup", (Object)maxgroup);
        param.setCustomParam("isLinkPage", (Object)isLinkagePage);
        param.setCustomParam("adjust_model", (Object)ObjectSerialUtil.toByteSerialized((Object)am));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPage"));
        this.getView().showForm(param);
        args.setCancel(true);
        try {
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "AbstractRptAdjustQueryPlugin_11", "fi-bcm-formplugin", "view"), new OPDescMultiLangEnumBridge("%1$s %2$s \u67e5\u770b\u6210\u529f", "AbstractRptAdjustQueryPlugin_12", "fi-bcm-formplugin", new String[]{am.getNumber(), am.getName()}));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    protected AdjustModel getAdjustModel(Object pkId) {
        try {
            return super.getAdjustModel(pkId);
        }
        catch (Throwable t) {
            throw new KDBizException(t.getMessage());
        }
    }

    protected String getF7Key(String entityNumber, String dimNum) {
        return entityNumber + '_' + dimNum.toLowerCase(Locale.ENGLISH);
    }
}

