/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class AdjustOffsetHelper {
    public static final String SHOW_NUMBER = "showNumber";
    public static final Integer MONEY_PRECISION = 38;
    public static final Integer MONEY_SCALE = 20;
    private static final List<String> processList = Lists.newArrayList((Object[])new String[]{"ERAdj", "ADJ", "CADJ", "CCADJ", "EJE", "EICA", "EIT", "EOE", "ECF", "EOther", "DADJ", "DEJE"});

    public static List<Map<String, Object>> dealCellUpdateValue(AdjustModel adjustmodel, Cell selectCell, Map<String, Integer> indexmap, Sheet sheet, String spreadKey, IClientViewProxy view, Map<Integer, Map<String, BigDecimal>> changeDataMap) {
        int row = selectCell.getRow();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        if (selectCell.getValue() == null) {
            cellValues.addAll(AdjustOffsetHelper.clearMoney(indexmap, sheet, spreadKey, view, row, changeDataMap));
            return cellValues;
        }
        int col = selectCell.getCol();
        Cell cell = sheet.getCell(0, col);
        String entitySign = cell.getUserObject("entitysign").toString();
        Cell accountCell = sheet.getCell(row, indexmap.get("Account").intValue());
        List memList = (List)accountCell.getUserObject("KEY_DIM_FLAG");
        Long memid = (Long)accountCell.getUserObject("membid");
        if (memList != null && memList.size() > 0 && memid != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)memid);
            if (changeDataMap != null) {
                changeDataMap.putIfAbsent(row, new HashMap(16));
            }
            DynamicObject mem = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)"id,number,name,isleaf,drcrdirect,accounttype", (QFilter[])new QFilter[]{qFilter});
            BigDecimal money = (BigDecimal)selectCell.getValue();
            if (entitySign.startsWith("cvtbeforecredit") || entitySign.startsWith("cvtbeforedebit") || entitySign.startsWith("credit") || entitySign.startsWith("debit")) {
                AdjustOffsetHelper.updateSummoneyByDebit(adjustmodel, selectCell, indexmap, sheet, changeDataMap, entitySign, mem, cellValues);
            } else if (entitySign.startsWith("cvtbeforesummoney") || entitySign.startsWith("summoney")) {
                AdjustOffsetHelper.updateDebitBySummoney(adjustmodel, selectCell, indexmap, sheet, changeDataMap, entitySign, mem, cellValues);
            } else {
                String[] split = entitySign.split("_");
                String curNumber = null;
                if (split.length > 1) {
                    curNumber = split[1];
                }
                AdjustOffsetHelper.updateByRate(adjustmodel, indexmap, sheet, selectCell.getRow(), cellValues, money, curNumber);
            }
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, col, money));
        } else {
            selectCell.setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, selectCell.getCol(), null));
        }
        return cellValues;
    }

    private static List<Map<String, Object>> clearMoney(Map<String, Integer> indexmap, Sheet sheet, String spreadKey, IClientViewProxy view, int row, Map<Integer, Map<String, BigDecimal>> changeDataMap) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<String, Integer> entry : indexmap.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith("debit") && !key.startsWith("credit") && !key.startsWith("summoney") && !key.startsWith("rate")) continue;
            sheet.getCell(row, entry.getValue().intValue()).setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, entry.getValue(), null));
        }
        SpreadClientInvoker.invokeUpdataValueMethod(view, spreadKey, cellValues);
        if (changeDataMap != null) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            fieldMap.put("summoney", null);
            fieldMap.put("debit", null);
            fieldMap.put("credit", null);
            changeDataMap.putIfAbsent(row, fieldMap);
        }
        return cellValues;
    }

    private static void updateDebitBySummoney(AdjustModel adjustmodel, Cell selectCell, Map<String, Integer> indexmap, Sheet sheet, Map<Integer, Map<String, BigDecimal>> changeDataMap, String entitySign, DynamicObject mem, List<Map<String, Object>> cellValues) {
        String rightCol = null;
        String clearCol = null;
        boolean isBefore = entitySign.startsWith("cvtbefore");
        int row = selectCell.getRow();
        if (isBefore) {
            String cvtBeforeDebit = "cvtbeforedebit";
            String cvtBeforeCredit = "cvtbeforecredit";
            if ("1".equals(mem.getString("drcrdirect"))) {
                rightCol = cvtBeforeDebit;
                clearCol = cvtBeforeCredit;
            } else if ("2".equals(mem.getString("drcrdirect"))) {
                rightCol = cvtBeforeCredit;
                clearCol = cvtBeforeDebit;
            } else {
                return;
            }
            Cell resultCell = sheet.getCell(row, indexmap.get(rightCol).intValue());
            BigDecimal money = (BigDecimal)selectCell.getValue();
            Cell delCell = sheet.getCell(row, indexmap.get(clearCol).intValue());
            if (delCell.getValue() != null) {
                delCell.setValue((Object)money.negate());
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), money.negate()));
                resultCell.setValue(null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), null));
            } else {
                resultCell.setValue((Object)money);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), money));
                delCell.setValue(null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), null));
            }
            for (Map.Entry<String, Integer> entry : indexmap.entrySet()) {
                Cell rateCell;
                String colSign = entry.getKey();
                if (colSign == null || !colSign.startsWith("rate")) continue;
                if ("1".equals(mem.getString("drcrdirect"))) {
                    rightCol = cvtBeforeDebit;
                    clearCol = cvtBeforeCredit;
                } else if ("2".equals(mem.getString("drcrdirect"))) {
                    rightCol = cvtBeforeCredit;
                    clearCol = cvtBeforeDebit;
                } else {
                    return;
                }
                String[] numberSplit = colSign.split("_");
                String multiCurNumber = null;
                if (numberSplit != null && numberSplit.length > 1) {
                    multiCurNumber = numberSplit[1];
                }
                if ((rateCell = sheet.getCell(row, indexmap.get(StringUtils.isEmpty(multiCurNumber) ? "rate" : "rate_" + multiCurNumber).intValue())).getValue() == null) continue;
                Integer scale = AdjustOffsetHelper.getNewCurrencyScale(adjustmodel, indexmap, sheet, row, multiCurNumber);
                rightCol = rightCol.substring("cvtbefore".length());
                rightCol = StringUtils.isEmpty((CharSequence)multiCurNumber) ? rightCol : rightCol + "_" + multiCurNumber;
                Cell linkageCell = sheet.getCell(row, indexmap.get(rightCol).intValue());
                clearCol = clearCol.substring("cvtbefore".length());
                clearCol = StringUtils.isEmpty((CharSequence)multiCurNumber) ? clearCol : clearCol + "_" + multiCurNumber;
                delCell = sheet.getCell(row, indexmap.get(clearCol).intValue());
                BigDecimal value = money.multiply((BigDecimal)rateCell.getValue()).setScale((int)scale, RoundingMode.HALF_UP);
                if (delCell.getValue() != null) {
                    delCell.setValue((Object)value.negate());
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), money.negate()));
                    resultCell.setValue(null);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), null));
                } else {
                    resultCell.setValue((Object)value);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), money));
                    delCell.setValue(null);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), null));
                }
                String summoneyKey = "summoney";
                summoneyKey = StringUtils.isEmpty((CharSequence)multiCurNumber) ? summoneyKey : summoneyKey + "_" + multiCurNumber;
                Cell linkageSummoneyCell = sheet.getCell(row, indexmap.get(summoneyKey).intValue());
                BigDecimal linkageSummoneyValue = money.multiply((BigDecimal)rateCell.getValue()).setScale((int)scale, RoundingMode.HALF_UP);
                linkageSummoneyCell.setValue((Object)linkageSummoneyValue);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(summoneyKey), linkageSummoneyValue));
            }
        } else {
            String credit;
            String[] numberSplit = entitySign.split("_");
            String multiCurNumber = null;
            if (numberSplit != null && numberSplit.length > 1) {
                multiCurNumber = numberSplit[1];
            }
            String debit = StringUtils.isEmpty(multiCurNumber) ? "debit" : "debit_" + multiCurNumber;
            String string = credit = StringUtils.isEmpty((CharSequence)multiCurNumber) ? "credit" : "credit_" + multiCurNumber;
            if ("1".equals(mem.getString("drcrdirect"))) {
                rightCol = debit;
                clearCol = credit;
            } else if ("2".equals(mem.getString("drcrdirect"))) {
                rightCol = credit;
                clearCol = debit;
            } else {
                return;
            }
            Cell delCell = sheet.getCell(row, indexmap.get(clearCol).intValue());
            Cell resultCell = sheet.getCell(row, indexmap.get(rightCol).intValue());
            BigDecimal money = (BigDecimal)selectCell.getValue();
            if (delCell.getValue() != null) {
                delCell.setValue((Object)money.negate());
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), money.negate()));
                resultCell.setValue(null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), null));
            } else {
                resultCell.setValue((Object)money);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), money));
                delCell.setValue(null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), null));
            }
            Cell rateCell = sheet.getCell(row, indexmap.get(StringUtils.isEmpty((CharSequence)multiCurNumber) ? "rate" : "rate_" + multiCurNumber).intValue());
            if (rateCell.getValue() != null) {
                Integer scale = AdjustOffsetHelper.getNewCurrencyScale(adjustmodel, indexmap, sheet, row, multiCurNumber);
                rightCol = "cvtbefore" + rightCol;
                if (rightCol.contains("_")) {
                    rightCol = rightCol.substring(0, rightCol.indexOf("_"));
                }
                Cell linkageCell = sheet.getCell(row, indexmap.get(rightCol).intValue());
                BigDecimal value = money.divide((BigDecimal)rateCell.getValue(), (int)scale, RoundingMode.HALF_UP);
                clearCol = "cvtbefore" + clearCol;
                if (clearCol.contains("_")) {
                    clearCol = clearCol.substring(0, clearCol.indexOf("_"));
                }
                if ((delCell = sheet.getCell(row, indexmap.get(clearCol).intValue())).getValue() != null) {
                    delCell.setValue((Object)value.negate());
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), money.negate()));
                    linkageCell.setValue(null);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), null));
                } else {
                    linkageCell.setValue((Object)value);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(rightCol), money));
                    delCell.setValue(null);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearCol), null));
                }
                String summoneyKey = "cvtbeforesummoney";
                Cell linkageSummoneyCell = sheet.getCell(row, indexmap.get(summoneyKey).intValue());
                BigDecimal linkageSummoneyValue = money.divide((BigDecimal)rateCell.getValue(), (int)scale, RoundingMode.HALF_UP);
                linkageSummoneyCell.setValue((Object)linkageSummoneyValue);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(summoneyKey), linkageSummoneyValue));
                selectCell = sheet.getCell(row, indexmap.get(summoneyKey).intValue());
                AdjustOffsetHelper.updateDebitBySummoney(adjustmodel, selectCell, indexmap, sheet, changeDataMap, summoneyKey, mem, cellValues);
            }
        }
        if (changeDataMap != null) {
            Map<String, BigDecimal> fieldMap = changeDataMap.get(row);
            String otherSign = "debit";
            if ("debit".equalsIgnoreCase(entitySign)) {
                otherSign = "credit";
            }
            if (selectCell.getValue() == null) {
                fieldMap.put("summoney", null);
                fieldMap.put(entitySign, null);
            } else {
                fieldMap.put("summoney", (BigDecimal)selectCell.getValue());
                fieldMap.put(entitySign, (BigDecimal)selectCell.getValue());
            }
            fieldMap.put(otherSign, null);
        }
    }

    private static void updateSummoneyByDebit(AdjustModel adjustmodel, Cell selectCell, Map<String, Integer> indexmap, Sheet sheet, Map<Integer, Map<String, BigDecimal>> changeDataMap, String entitySign, DynamicObject mem, List<Map<String, Object>> cellValues) {
        int row;
        BigDecimal money;
        block15: {
            block14: {
                block16: {
                    money = (BigDecimal)selectCell.getValue();
                    if (money == null) {
                        return;
                    }
                    if ("1".equals(mem.getString("drcrdirect"))) {
                        if (entitySign.startsWith("credit") || entitySign.startsWith("cvtbeforecredit")) {
                            money = BigDecimal.ZERO.subtract(money);
                        }
                    } else if ("2".equals(mem.getString("drcrdirect")) && (entitySign.startsWith("debit") || entitySign.startsWith("cvtbeforedebit"))) {
                        money = BigDecimal.ZERO.subtract(money);
                    }
                    row = selectCell.getRow();
                    boolean isBefore = entitySign.startsWith("cvtbefore");
                    if (isBefore) break block14;
                    String[] numberSplit = entitySign.split("_");
                    String multiCurNumber = null;
                    if (numberSplit != null && numberSplit.length > 1) {
                        multiCurNumber = numberSplit[1];
                    }
                    String cvtBeforeSummoney = "cvtbeforesummoney";
                    String summoney = StringUtils.isEmpty(multiCurNumber) ? "summoney" : "summoney_" + multiCurNumber;
                    Cell summoneyCell = sheet.getCell(row, indexmap.get(summoney).intValue());
                    summoneyCell.setValue((Object)money);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(summoney), money));
                    Cell rateCell = sheet.getCell(row, indexmap.get(StringUtils.isEmpty((CharSequence)multiCurNumber) ? "rate" : "rate_" + multiCurNumber).intValue());
                    if (rateCell.getValue() == null) break block15;
                    Integer scale = AdjustOffsetHelper.getNewCurrencyScale(adjustmodel, indexmap, sheet, row, multiCurNumber);
                    if (entitySign.contains("_")) {
                        entitySign = entitySign.substring(0, entitySign.indexOf("_"));
                    }
                    String key = "cvtbefore" + entitySign;
                    Cell linkageCell = sheet.getCell(row, indexmap.get(key).intValue());
                    BigDecimal value = ((BigDecimal)selectCell.getValue()).divide((BigDecimal)rateCell.getValue(), (int)scale, RoundingMode.HALF_UP);
                    linkageCell.setValue((Object)value);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(key), value));
                    String summoneyKey = cvtBeforeSummoney;
                    Cell linkageSummoneyCell = sheet.getCell(row, indexmap.get(summoneyKey).intValue());
                    BigDecimal linkageSummoneyValue = money.divide((BigDecimal)rateCell.getValue(), (int)scale, RoundingMode.HALF_UP);
                    linkageSummoneyCell.setValue((Object)linkageSummoneyValue);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(summoneyKey), linkageSummoneyValue));
                    if (!entitySign.contains("credit")) break block16;
                    entitySign = "cvtbeforecredit";
                    selectCell = sheet.getCell(row, indexmap.get(entitySign).intValue());
                    AdjustOffsetHelper.updateSummoneyByDebit(adjustmodel, selectCell, indexmap, sheet, changeDataMap, entitySign, mem, cellValues);
                    AdjustModelUtil.setBigDecimalValue(sheet.getCell(row, indexmap.get("cvtbeforedebit").intValue()), null);
                    cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get("cvtbeforedebit"), null));
                    break block15;
                }
                if (!entitySign.contains("debit")) break block15;
                entitySign = "cvtbeforedebit";
                selectCell = sheet.getCell(row, indexmap.get(entitySign).intValue());
                AdjustOffsetHelper.updateSummoneyByDebit(adjustmodel, selectCell, indexmap, sheet, changeDataMap, entitySign, mem, cellValues);
                AdjustModelUtil.setBigDecimalValue(sheet.getCell(row, indexmap.get("cvtbeforecredit").intValue()), null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get("cvtbeforecredit"), null));
                break block15;
            }
            String cvtBeforeSummoney = "cvtbeforesummoney";
            Cell summoneyCell = sheet.getCell(row, indexmap.get(cvtBeforeSummoney).intValue());
            summoneyCell.setValue((Object)money);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(cvtBeforeSummoney), money));
            String key = entitySign.substring("cvtbefore".length());
            String clearKey = "credit".equals(key) ? "debit" : "credit";
            Cell clearCell = sheet.getCell(row, indexmap.get("cvtbefore" + clearKey).intValue());
            clearCell.setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get("cvtbefore" + clearKey), null));
            for (Map.Entry<String, Integer> entry : indexmap.entrySet()) {
                Cell rateCell;
                String colSign = entry.getKey();
                if (colSign == null || !colSign.startsWith("rate")) continue;
                String[] numberSplit = colSign.split("_");
                String multiCurNumber = null;
                if (numberSplit != null && numberSplit.length > 1) {
                    multiCurNumber = numberSplit[1];
                }
                if ((rateCell = sheet.getCell(row, indexmap.get(StringUtils.isEmpty(multiCurNumber) ? "rate" : "rate_" + multiCurNumber).intValue())).getValue() == null) continue;
                Integer scale = AdjustOffsetHelper.getNewCurrencyScale(adjustmodel, indexmap, sheet, row, multiCurNumber);
                key = entitySign.substring("cvtbefore".length());
                clearKey = "credit".equals(key) ? "debit" : "credit";
                key = StringUtils.isEmpty((CharSequence)multiCurNumber) ? key : key + "_" + multiCurNumber;
                String string = clearKey = StringUtils.isEmpty((CharSequence)multiCurNumber) ? clearKey : clearKey + "_" + multiCurNumber;
                if (key.startsWith("cvtbefore") && key.contains("_")) {
                    key = key.substring(0, key.indexOf("_"));
                }
                if (clearKey.startsWith("cvtbefore") && clearKey.contains("_")) {
                    clearKey = clearKey.substring(0, clearKey.indexOf("_"));
                }
                Cell linkageCell = sheet.getCell(row, indexmap.get(key).intValue());
                BigDecimal value = ((BigDecimal)selectCell.getValue()).multiply((BigDecimal)rateCell.getValue()).setScale((int)scale, RoundingMode.HALF_UP);
                linkageCell.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(key), value));
                clearCell = sheet.getCell(row, indexmap.get(clearKey).intValue());
                clearCell.setValue(null);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(clearKey), null));
                String summoneyKey = "summoney";
                summoneyKey = StringUtils.isEmpty((CharSequence)multiCurNumber) ? summoneyKey : summoneyKey + "_" + multiCurNumber;
                Cell linkageSummoneyCell = sheet.getCell(row, indexmap.get(summoneyKey).intValue());
                BigDecimal linkageSummoneyValue = money.multiply((BigDecimal)rateCell.getValue()).setScale((int)scale, RoundingMode.HALF_UP);
                linkageSummoneyCell.setValue((Object)linkageSummoneyValue);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(row, indexmap.get(summoneyKey), linkageSummoneyValue));
            }
        }
        if (changeDataMap != null) {
            Map<String, BigDecimal> fieldMap = changeDataMap.get(row);
            if (selectCell.getValue() == null) {
                fieldMap.put(entitySign, null);
            } else {
                fieldMap.put(entitySign, (BigDecimal)selectCell.getValue());
            }
            fieldMap.put("summoney", money);
        }
    }

    private static int getNewCurrencyScale(AdjustModel adjustmodel, Map<String, Integer> indexmap, Sheet effectiveSheet, int rowIndex, String cvtCurrencyNumber) {
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)MemberReader.findModelNumberById((Object)adjustmodel.getModelId()), (Long)adjustmodel.getScenarioId());
        String accNum = (String)effectiveSheet.getCell(rowIndex, indexmap.get("Account").intValue()).getUserObject("membnumber");
        if (cvtCurrencyNumber == null) {
            IDNumberTreeNode orgNode;
            if (OrgRelaProcessMembPool.isRelaProcess((String)adjustmodel.getProcess())) {
                orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)adjustmodel.getModelId()), (Long)adjustmodel.getBelongOrg());
            } else {
                String orgNum = (String)effectiveSheet.getCell(rowIndex, indexmap.get("Entity").intValue()).getUserObject("membnumber");
                orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)adjustmodel.getModelId()), (String)orgNum);
            }
            cvtCurrencyNumber = orgNode.getCurrency();
        }
        return CurrencyScaleHandler.getNewCurrencyScale((long)adjustmodel.getModelId(), (String)sceneNode.getNumber(), (String)cvtCurrencyNumber, (String)accNum);
    }

    public static void updateByRate(AdjustModel adjustmodel, Map<String, Integer> indexmap, Sheet effectiveSheet, int rowIndex, List<Map<String, Object>> cellValues, BigDecimal rate, String cvtCurrencyNumber) {
        Cell beforeDebitCol = effectiveSheet.getCell(rowIndex, indexmap.get("cvtbeforedebit").intValue());
        Cell beforeCreditCol = effectiveSheet.getCell(rowIndex, indexmap.get("cvtbeforecredit").intValue());
        Cell beforeSummoneyCol = effectiveSheet.getCell(rowIndex, indexmap.get("cvtbeforesummoney").intValue());
        Cell debitCol = effectiveSheet.getCell(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "debit" : AdjustOffsetHelper.getColumnKey("debit", cvtCurrencyNumber)).intValue());
        Cell creditCol = effectiveSheet.getCell(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "credit" : AdjustOffsetHelper.getColumnKey("credit", cvtCurrencyNumber)).intValue());
        Cell summoneyCol = effectiveSheet.getCell(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "summoney" : AdjustOffsetHelper.getColumnKey("summoney", cvtCurrencyNumber)).intValue());
        if (rate == null) {
            debitCol.setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "debit" : AdjustOffsetHelper.getColumnKey("debit", cvtCurrencyNumber)), null));
            creditCol.setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "credit" : AdjustOffsetHelper.getColumnKey("credit", cvtCurrencyNumber)), null));
            summoneyCol.setValue(null);
            cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "summoney" : AdjustOffsetHelper.getColumnKey("summoney", cvtCurrencyNumber)), null));
        } else {
            BigDecimal value;
            Integer scale = AdjustOffsetHelper.getNewCurrencyScale(adjustmodel, indexmap, effectiveSheet, rowIndex, cvtCurrencyNumber);
            if (beforeDebitCol.getValue() != null) {
                value = ((BigDecimal)beforeDebitCol.getValue()).multiply(rate).setScale((int)scale, RoundingMode.HALF_UP);
                debitCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "debit" : AdjustOffsetHelper.getColumnKey("debit", cvtCurrencyNumber)), value));
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "credit" : AdjustOffsetHelper.getColumnKey("credit", cvtCurrencyNumber)), null));
            } else if (debitCol.getValue() != null) {
                value = ((BigDecimal)debitCol.getValue()).divide(rate, (int)scale, RoundingMode.HALF_UP);
                beforeDebitCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get("cvtbeforedebit"), value));
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get("cvtbeforecredit"), null));
            }
            if (beforeCreditCol.getValue() != null) {
                value = ((BigDecimal)beforeCreditCol.getValue()).multiply(rate).setScale((int)scale, RoundingMode.HALF_UP);
                creditCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "credit" : AdjustOffsetHelper.getColumnKey("credit", cvtCurrencyNumber)), value));
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "debit" : AdjustOffsetHelper.getColumnKey("debit", cvtCurrencyNumber)), null));
            } else if (creditCol.getValue() != null) {
                value = ((BigDecimal)creditCol.getValue()).divide(rate, (int)scale, RoundingMode.HALF_UP);
                beforeCreditCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get("cvtbeforecredit"), value));
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get("cvtbeforedebit"), null));
            }
            if (beforeSummoneyCol.getValue() != null) {
                value = ((BigDecimal)beforeSummoneyCol.getValue()).multiply(rate).setScale((int)scale, RoundingMode.HALF_UP);
                summoneyCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get(cvtCurrencyNumber == null ? "summoney" : AdjustOffsetHelper.getColumnKey("summoney", cvtCurrencyNumber)), value));
            } else if (summoneyCol.getValue() != null) {
                value = ((BigDecimal)summoneyCol.getValue()).divide(rate, (int)scale, RoundingMode.HALF_UP);
                beforeSummoneyCol.setValue((Object)value);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(rowIndex, indexmap.get("cvtbeforesummoney"), value));
            }
        }
    }

    public static String getColumnKey(String columnName, String cvtCurrencyNumber) {
        return columnName + "_" + cvtCurrencyNumber;
    }

    public static boolean isMultiCurrencyCol(String entitySign) {
        if (StringUtils.isEmpty((CharSequence)entitySign)) {
            return false;
        }
        return entitySign.startsWith("debit") || entitySign.startsWith("credit") || entitySign.startsWith("rate") || entitySign.startsWith("summoney");
    }

    public static void getRateNumberByEnumValue(int rowIndex, String rate, Map<Integer, String> row2Rate) {
        switch (rate) {
            case "1": {
                row2Rate.put(rowIndex, "ClosingRate");
                break;
            }
            case "2": {
                row2Rate.put(rowIndex, "AverageRate");
                break;
            }
            case "3": {
                row2Rate.put(rowIndex, "UserdefinedRate");
                break;
            }
            default: {
                row2Rate.put(rowIndex, "1");
            }
        }
    }

    public static List<String> getLockedF7(String process) {
        boolean isLockCurrency = processList.contains(process);
        if (isLockCurrency) {
            return Arrays.asList("scenario", "year", "period", "process", "currency");
        }
        return Arrays.asList("scenario", "year", "period", "process");
    }
}

