/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustErrorCatcher;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.report.AdjustOffsetHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class AdjustPaperTemplateHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkInputValueValid(Cell selectCell, Map<String, Integer> indexmap, Sheet sheet, String spreadKey, AdjustSpreadActionHandlerProxy handler, AdjustErrorCatcher errorCacher) {
        String credit;
        String[] split;
        int row = selectCell.getRow();
        int col = selectCell.getCol();
        Cell colCell = sheet.getCell(0, col);
        if (colCell.getUserObject("entitysign") == null) {
            return false;
        }
        if (selectCell.getValue() == null) {
            return true;
        }
        String entitySign = colCell.getUserObject("entitysign").toString();
        String curNumber = null;
        if (!StringUtils.isEmpty((CharSequence)entitySign) && AdjustOffsetHelper.isMultiCurrencyCol(entitySign) && (split = entitySign.split("_")) != null && split.length > 1) {
            curNumber = split[1];
        }
        String debit = StringUtils.isEmpty(curNumber) ? "debit" : "debit_" + curNumber;
        String string = credit = StringUtils.isEmpty(curNumber) ? "credit" : "credit_" + curNumber;
        if (!entitySign.startsWith(debit) && !entitySign.startsWith(credit)) {
            return false;
        }
        Cell cell0 = sheet.getCell(0, col);
        if (cell0.getUserObject("entitysign") == null) return false;
        if (AdjustPaperTemplateHelper.vildValueAndFormula(sheet.getCell(row, indexmap.get(debit).intValue())) && AdjustPaperTemplateHelper.vildValueAndFormula(sheet.getCell(row, indexmap.get(credit).intValue())) && (col == indexmap.get(debit) || col == indexmap.get(credit))) {
            int tempCol = col == indexmap.get(debit) ? indexmap.get(credit).intValue() : indexmap.get(debit).intValue();
            handler.setCellValue(row, tempCol, null);
            handler.setFormula(row, tempCol, null);
        }
        try {
            BigDecimal money = InvestUtils.convertToBigDecimal((Object)selectCell.getValue());
            if (money == null || money.precision() <= AdjustOffsetHelper.MONEY_PRECISION && money.scale() <= AdjustOffsetHelper.MONEY_SCALE) return true;
            errorCacher.collectMsg(cell0.getRow(), String.format(ResManager.loadKDString((String)"\u6570\u503c\u4e0d\u7b26\u5408\u683c\u5f0f\uff0c\u6b63\u786e\u4f4d\u6570\u9650\u5236\u4e3a\uff08%1$s,%2$s\uff09\u3002", (String)"AdjustOffsetHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), AdjustOffsetHelper.MONEY_PRECISION, AdjustOffsetHelper.MONEY_SCALE));
            handler.setCellValue(row, col, null);
            return true;
        }
        catch (Exception ext) {
            errorCacher.collectMsg(cell0.getRow(), ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u5408\u6cd5\u7684\u6570\u503c\u3002", (String)"AdjustOffsetHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            handler.setCellValue(row, col, null);
            return false;
        }
    }

    public static boolean vildValueAndFormula(Cell cell) {
        return cell.hasFormula() || cell.getValue() != null;
    }
}

