/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustEntryConfig;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.RateCvtSetScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;

public class EntryCvtCurrencySettingPlugin
extends AbstractBaseListPlugin {
    private static final String CACHE_DIM = "cache_dim";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String DELETE_IDS_CACHE = "deleteIdsCache";
    private static final BiMap<String, String> multiF7Keys = HashBiMap.create();
    private static final int RATESET = 0;
    private static final int RATEDIFF = 1;
    public static final List<String> EICA_LIST = Arrays.asList(BusinessTypeEnum.OFFSETEICA.getName(), BusinessTypeEnum.OFFSETEIT.getName(), BusinessTypeEnum.OFFSETECF.getName(), BusinessTypeEnum.OFFSETEOE.getName(), BusinessTypeEnum.OFFSETEOther.getName());
    private static final String ENTITY_TXT = "entitytxt";
    private static final String CURRENCY_TXT = "currencytxt";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_ENTITY_1 = "entryentity1";
    private static final String BCM_ENTRYEXCHANGE = "bcm_entryexchange";
    private static final String SELECT_STR = "model, account, changetype, mycompany, internalcompany, multigaap, dim1, dim2, dim3, dim4, dim5, dim6";
    private static final String ACCOUNT = "account";
    private static final String CHANGE_TYPE = "changetype";
    private static final String MY_COMPANY = "mycompany";
    private static final String INTERNAL_COMPANY = "internalcompany";
    private static final String MULTIGAAP = "multigaap";
    private static final String AUDITTRAIL = "audittrail";
    private static final String DIM_1 = "dim1";
    private static final String DIM_2 = "dim2";
    private static final String DIM_3 = "dim3";
    private static final String DIM_4 = "dim4";
    private static final String DIM_5 = "dim5";
    private static final String DIM_6 = "dim6";
    private static final String NUMBER = "number";
    private static final String CTL_ACCOUNT = "cl_account";
    private static final String CL_MY_COMPANY = "cl_mycompany";
    private static final String CL_MULTIGAAP = "cl_multigaap";
    private static final String CL_INTERNAL_COMPANY = "cl_internalcompany";
    private static final String CL_AUDITTRAIL = "cl_audittrail";
    private static final String SCHEME = "scheme";
    private static final String RATE_SCHEME = "rate_scheme";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String MODEL = "model";
    private static final String TYPE = "type";
    private static final String SCOPE = "scope";
    private static final String OP_TYPE = "optype";
    private static final String IS_CHANGE = "ischange";
    private static final String _HIDDEN = "_hidden";
    private static final String DIMENSION = "dimension";
    private static final String HAS_MODIFY = "hasModify";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MEMBER_ID = "memberid";
    private static final String DIMENSION_NUM = "dimensionnum";
    private static final String MEMBER_NUM = "membernum";
    private static Set<String> cvtFiledsSet = Sets.newHashSet();
    private static Set<String> currencyCvtFiledsSet = Sets.newHashSet();
    private static final String RATE_CVT_DIFF_ENTITY = "ratecvtdiffentity";
    private static final String RATE_CVT_DIFF_ID = "ratecvtdiffid";
    public static final List<String> MULTILPLEMEMBERLIST = Collections.unmodifiableList(Arrays.asList("cl_account", "cl_mycompany", "cl_internalcompany", "cl_multigaap", "listcolumnap1", "listcolumnap2", "listcolumnap3", "listcolumnap4", "listcolumnap5", "listcolumnap6"));
    public static final List<String> RATESETMEMBERLIST = Collections.unmodifiableList(Arrays.asList("sd_account", "sd_changetype", "sd_mycompany", "sd_internalcompany", "sd_multigaap", "sd_dim1", "sd_dim2", "sd_dim3", "sd_dim4", "sd_dim5", "sd_dim6"));
    public static final List<String> RATEDIFFMEMBERLIST = Collections.unmodifiableList(Arrays.asList("rate_account", "rate_changetype", "rate_mycompany", "rate_internalcompany", "rate_multigaap", "rate_dim1", "rate_dim2", "rate_dim3", "rate_dim4", "rate_dim5", "rate_dim6"));
    private static HashMap<String, String> MULTIPLE_MEMBER_NUMBER_MAP = new HashMap(4);
    private static final String modelCol = "modelCol";
    private Map<String, String> dimKeys = Maps.newHashMap();
    private List<String> dim_hideList = Lists.newArrayList();
    private HashSet<String> dim_HidePreSet = Sets.newHashSet();
    private List<String> dim_showlist = Lists.newArrayList();
    private static final String RATESETTINGENTRY = "ratesettingentry";
    private static final String RATEDIFFENTRY = "ratediffentry";

    public EntryCvtCurrencySettingPlugin() {
        this.dimKeys.put(ACCOUNT, DimTypesEnum.ACCOUNT.getNumber());
        this.dimKeys.put(CHANGE_TYPE, DimTypesEnum.CHANGETYPE.getNumber());
        this.dimKeys.put(MY_COMPANY, DimTypesEnum.MYCOMPANY.getNumber());
        this.dimKeys.put(INTERNAL_COMPANY, DimTypesEnum.INTERCOMPANY.getNumber());
        this.dimKeys.put(MULTIGAAP, DimTypesEnum.MULTIGAAP.getNumber());
        this.dim_hideList.add(DIM_1);
        this.dim_hideList.add(DIM_2);
        this.dim_hideList.add(DIM_3);
        this.dim_hideList.add(DIM_4);
        this.dim_hideList.add(DIM_5);
        this.dim_hideList.add(DIM_6);
        this.dim_HidePreSet.add(DimTypesEnum.MYCOMPANY.getNumber());
        this.dim_HidePreSet.add(DimTypesEnum.INTERCOMPANY.getNumber());
        this.dim_HidePreSet.add(DimTypesEnum.MULTIGAAP.getNumber());
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(multiF7Keys.keySet().toArray(new String[0]));
        this.addClickListeners(RATESETMEMBERLIST.toArray(new String[10]));
        this.addClickListeners(RATEDIFFMEMBERLIST.toArray(new String[10]));
        this.addItemClickListeners("toolbarap", "advcontoolbarap3");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModelId() != 0L && !MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId()))) {
            this.dim_showlist.remove(CHANGE_TYPE);
        }
        this.refreshBillByUserSelect(Lists.newArrayList(), Boolean.FALSE);
        this.modelChange();
        this.setDimColView();
        this.refreshRateSetDimCol(1);
        this.loadRateSetData(1);
        this.refreshRateSetDimCol(0);
        this.loadRateSetData(0);
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CHANGE_TYPE, "ratecvtdiff_changetype", "sd_changetype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHANGE_TYPE, "ratecvtdiff_changetype", "sd_changetype"});
        }
        this.getModel().setDataChanged(false);
    }

    private void refreshRateSetDimCol(int type) {
        ArrayList<String> memberList = new ArrayList<String>();
        String temp = null;
        if (1 == type) {
            memberList.addAll(RATEDIFFMEMBERLIST);
            temp = "rate_";
        } else if (0 == type) {
            memberList.addAll(RATESETMEMBERLIST);
            temp = "sd_";
        }
        String preString = temp;
        memberList.stream().forEach(p -> this.getView().setVisible(Boolean.FALSE, new String[]{p}));
        this.getSchemeContext().getDimensions().stream().forEach(dim -> {
            String key = preString + dim.getFieldmapped();
            this.getView().setVisible(Boolean.TRUE, new String[]{key});
            if (!dim.isIssys()) {
                TextEdit edit = (TextEdit)this.getView().getControl(key);
                edit.setCaption(new LocaleString(dim.getName()));
            }
        });
    }

    private RateCvtSetScheme getRateCvtSetScheme(int index, int type) {
        String entryName = RATESETTINGENTRY;
        String schemeName = SCHEME;
        if (1 == type) {
            entryName = RATEDIFFENTRY;
            schemeName = RATE_SCHEME;
        }
        String schemeStr = this.getModel().getEntryRowEntity(entryName, index).getString(schemeName);
        RateCvtSetScheme rateCvtSetScheme = null;
        rateCvtSetScheme = StringUtils.isNotEmpty((String)schemeStr) ? (RateCvtSetScheme)this.deSerializedBytes(schemeStr) : new RateCvtSetScheme(this.getModelId(), type);
        return rateCvtSetScheme;
    }

    public void setValueIntoRCS(Dimension dim, DimensionScope ds, int index, boolean refreshScheme, int type) {
        String preString = "sd_";
        String schemeName = SCHEME;
        if (1 == type) {
            preString = "rate_";
            schemeName = RATE_SCHEME;
        }
        this.getModel().setValue(preString + dim.getFieldmapped(), (Object)(ds != null ? ds.toString() : null), index);
        if (refreshScheme) {
            RateCvtSetScheme rateCvtSetScheme = this.getRateCvtSetScheme(index, type);
            rateCvtSetScheme.getSchemeDetails().put(dim, ds);
            this.getModel().setValue(schemeName, (Object)this.toByteSerialized(rateCvtSetScheme), index);
        }
    }

    private void saveRateSetDimCol(int type) {
        String entryName = RATESETTINGENTRY;
        String temp = SCHEME;
        if (1 == type) {
            entryName = RATEDIFFENTRY;
            temp = RATE_SCHEME;
        }
        String schemeName = temp;
        ArrayList toSaveData = new ArrayList();
        DynamicObjectCollection dys = this.getModel().getEntryEntity(entryName);
        dys.stream().forEach(dy -> {
            String schemeStr = dy.getString(schemeName);
            if (StringUtils.isNotEmpty((String)schemeStr)) {
                RateCvtSetScheme rateCvtSetScheme = (RateCvtSetScheme)this.deSerializedBytes(schemeStr);
                toSaveData.add(rateCvtSetScheme.toDy());
            }
        });
        DeleteServiceHelper.delete((String)"bcm_ratecvtset", (QFilter[])new QFilter(MODEL, "=", (Object)this.getModelId()).and(TYPE, "=", (Object)Integer.toString(type)).toArray());
        SaveServiceHelper.save((DynamicObject[])toSaveData.toArray(new DynamicObject[0]));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (multiF7Keys.containsKey((Object)actionId)) {
            HashMap dataMap;
            this.getPageCache().remove("openViewPlugin");
            Object returnData = evt.getReturnData();
            if (returnData instanceof HashMap && "true".equals((dataMap = (HashMap)returnData).get("okbtn"))) {
                DynamicObjectCollection doc = (DynamicObjectCollection)dataMap.get("doc");
                IDataModel model = this.getModel();
                if (doc.isEmpty()) {
                    int rowIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
                    model.setValue(actionId, (Object)"", rowIndex);
                    model.setValue((String)multiF7Keys.get((Object)actionId), null, rowIndex);
                    return;
                }
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                for (int i = 0; i < doc.size(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", ((DynamicObject)doc.get(i)).get(4).toString());
                    map.put(SCOPE, ((DynamicObject)doc.get(i)).get(5).toString());
                    map.put(NUMBER, ((DynamicObject)doc.get(i)).get(2).toString());
                    map.put("name", ((DynamicObject)doc.get(i)).get(3).toString());
                    CslSchemeUtils.buildPageViewShowName(sb, ((DynamicObject)doc.get(i)).get(3).toString(), ((DynamicObject)doc.get(i)).getInt(5));
                    list.add(map);
                }
                String showName = sb.substring(0, sb.length() - 1);
                int rowIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
                model.setValue(actionId, (Object)showName, rowIndex);
                model.setValue((String)multiF7Keys.get((Object)actionId), (Object)JSONArray.toJSONString(list), rowIndex);
            }
        } else if (evt.getReturnData() instanceof DynamicObjectCollection) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)evt.getReturnData();
            int index = 0;
            if (actionId.startsWith("sd_") || actionId.startsWith("rate_")) {
                String preString = "sd_";
                String entryName = RATESETTINGENTRY;
                int type = 0;
                if (actionId.startsWith("rate_")) {
                    entryName = RATEDIFFENTRY;
                    type = 1;
                    preString = "rate_";
                }
                index = this.getModel().getEntryCurrentRowIndex(entryName);
                if (returnData != null) {
                    Dimension dimension = this.getSchemeContext().getDimensionByNumber(actionId.replaceFirst(preString, ""));
                    DimensionScope ds = new DimensionScope(Long.toString(this.getModelId()), dimension, returnData);
                    this.setValueIntoRCS(dimension, ds, index, true, type);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                index = this.getModel().getEntryCurrentRowIndex(RATE_CVT_DIFF_ENTITY);
                if (returnData != null && !returnData.isEmpty()) {
                    ArrayList list = new ArrayList(returnData.size());
                    for (int i = 0; i < returnData.size(); ++i) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", ((DynamicObject)returnData.get(i)).get(4).toString());
                        map.put(SCOPE, ((DynamicObject)returnData.get(i)).get(5).toString());
                        map.put(NUMBER, ((DynamicObject)returnData.get(i)).get(2).toString());
                        map.put("name", ((DynamicObject)returnData.get(i)).get(3).toString());
                        CslSchemeUtils.buildPageViewShowName(sb, ((DynamicObject)returnData.get(i)).get(3).toString(), ((DynamicObject)returnData.get(i)).getInt(5));
                        list.add(map);
                    }
                    this.getModel().setValue(actionId, (Object)sb.substring(0, sb.length() - 1), index);
                    this.getModel().setValue(actionId + _HIDDEN, (Object)JSONArray.toJSONString(list), index);
                } else {
                    this.getModel().setValue(actionId, (Object)"", index);
                    this.getModel().setValue(actionId + _HIDDEN, (Object)"", index);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("close_save_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.getView().close();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_SAVE.equals(itemKey)) {
            if (this.validateMustIput(ENTRY_ENTITY) && this.validateMustIput(ENTRY_ENTITY_1) && this.validateMustIput(RATEDIFFENTRY) && this.validateMustIput(RATESETTINGENTRY)) {
                this.saveData();
                this.buildEntryData();
                this.saveRateSetDimCol(1);
                this.saveRateSetDimCol(0);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckUpChkDisplayPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.modelChange();
                this.setDimColView();
                this.refreshRateSetDimCol(1);
                this.loadRateSetData(1);
                this.refreshRateSetDimCol(0);
                this.loadRateSetData(0);
                this.getModel().setDataChanged(false);
                this.writeMultiLangLog(OpItemEnum.SAVE.getOpMultiLangEnumBridge(), ResultStatusEnum.SUCCESS.getOpDescBridge());
            }
        } else if (BTN_CANCEL.equals(itemKey)) {
            if (this.getModel().getDataChanged()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u6539\u53d8\uff0c\u672a\u4fdd\u5b58\u7684\u6570\u636e\u5c06\u4f1a\u4e22\u5931\uff0c\u786e\u5b9a\u9000\u51fa\u4e48\uff1f", (String)"EntryCvtCurrencySettingPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_save_confirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (multiF7Keys.containsKey((Object)key)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            String f7Value = (String)this.getModel().getEntryRowEntity(ENTRY_ENTITY, entryCurrentRowIndex).get((String)multiF7Keys.get((Object)key));
            if (StringUtils.isNotEmpty((String)f7Value)) {
                this.getPageCache().put(key, f7Value);
            } else {
                this.getPageCache().put(key, null);
            }
            String cacheDimStr = this.getPageCache().get(CACHE_DIM);
            Map dimIdMap = (Map)SerializationUtils.fromJsonString((String)cacheDimStr, Map.class);
            Integer dimension = (Integer)dimIdMap.get(multiF7Keys.get((Object)key));
            if (dimension != null) {
                String name;
                this.getPageCache().put("yearNum", "");
                this.getPageCache().put("periodId", "0");
                this.getPageCache().put("openViewPlugin", "EntryCvtCurrencySettingPlugin");
                FormShowParameter multiF7FormShowParameter = CslSchemeUtils.genDimMultiF7FormShowParameter(this.getModelId(), dimension, key, new CloseCallBack((IFormPlugin)this, key));
                multiF7FormShowParameter.setCustomParam("cvtCurrencySet", (Object)"true");
                String string = name = dimension == 1 ? ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"EntryCvtCurrencySettingPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e01\u79cd", (String)"EntryCvtCurrencySettingPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                if (dimension != 1) {
                    multiF7FormShowParameter.setCustomParam("customFilter", (Object)new QFilter(NUMBER, "not in", Arrays.asList("EC", "DC")).toSerializedString());
                }
                multiF7FormShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"EntryCvtCurrencySettingPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), name));
                this.getView().showForm(multiF7FormShowParameter);
            }
        } else if (key.startsWith("listcolumnap")) {
            this.openMultipleF7(key, "userdefind");
        } else if (key.startsWith("cl_")) {
            this.openMultipleF7(key, "sys");
        } else if (key.startsWith("sd_")) {
            this.openMultipleF7(key, null);
        } else if (key.startsWith("rate_")) {
            this.openMultipleF7(key, null);
        }
    }

    private void openMultipleF7(String key, String type) {
        int paramvalue = 0;
        boolean isRateSet = key.startsWith("sd_");
        boolean isRateDiff = key.startsWith("rate_");
        int index = 0;
        if (isRateSet || isRateDiff) {
            String temp = "sd_";
            String entryName = RATESETTINGENTRY;
            int rateType = 0;
            if (isRateDiff) {
                temp = "rate_";
                entryName = RATEDIFFENTRY;
                rateType = 1;
            }
            String preString = temp;
            Dimension dimension = this.getSchemeContext().getDimensions().stream().filter(p -> (preString + p.getFieldmapped()).equalsIgnoreCase(key)).findFirst().get();
            String number = dimension.getNumber();
            FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)this.getModelId(), (String)number, null);
            index = this.getModel().getEntryCurrentRowIndex(entryName);
            DimensionScope dimensionScope = (DimensionScope)this.getRateCvtSetScheme(index, rateType).getSchemeDetails().get(dimension);
            if (dimensionScope != null) {
                this.getPageCache().put(number, SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()));
            }
            if (para != null) {
                para.setCustomParam("sign", (Object)number);
                para.setCustomParam(number, (Object)(dimensionScope != null ? SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()) : "[]"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, preString + dimension.getNumber().toLowerCase(Locale.ENGLISH));
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
            }
        } else {
            boolean isSys = "sys".equals(type);
            String ctrlKey = key;
            if (isSys) {
                Map dimName_DseqMap = (Map)this.deSerializedBytes(this.getPageCache().get("dimName_DseqMap"));
                if (dimName_DseqMap == null) {
                    return;
                }
                paramvalue = (Integer)dimName_DseqMap.get(key);
            } else {
                ctrlKey = this.getPageCache().get(key);
                paramvalue = Integer.parseInt(ctrlKey.substring(ctrlKey.lastIndexOf(95) + 1));
            }
            long modelIdl = this.getModelId();
            if (0L == modelIdl) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"EntryCvtCurrencySettingPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String modelId = String.valueOf(this.getModelId());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sign", ctrlKey);
            params.put("KEY_MODEL_ID", modelId);
            params.put(DIMENSION, paramvalue + "");
            if (isRateSet || isRateDiff) {
                String temp = "sd_";
                String entryName = RATESETTINGENTRY;
                int rateType = 0;
                if (isRateDiff) {
                    temp = "rate_";
                    entryName = RATEDIFFENTRY;
                    rateType = 1;
                }
                String preString = temp;
                Dimension dim = this.getSchemeContext().getDimensions().stream().filter(p -> (preString + p.getFieldmapped()).equalsIgnoreCase(key)).findFirst().get();
                index = this.getModel().getEntryCurrentRowIndex(entryName);
                DimensionScope dimensionScope = (DimensionScope)this.getRateCvtSetScheme(index, rateType).getSchemeDetails().get(dim);
                if (dimensionScope != null) {
                    this.getPageCache().put(ctrlKey, kd.bos.login.actions.SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()));
                }
            } else {
                index = this.getModel().getEntryCurrentRowIndex(RATE_CVT_DIFF_ENTITY);
                Object data = this.getModel().getValue(key + _HIDDEN, index);
                if (null != data && !"".equals(data)) {
                    params.put(ctrlKey, data);
                }
            }
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("yearNum", "");
            pageCache.put("periodId", "0");
            pageCache.put("KEY_MODEL_ID", modelId);
            pageCache.remove(ctrlKey);
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bcm_mulmemberf7_tem_ic");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCustomParams(params);
            para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"EntryCvtCurrencySettingPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), QueryDimensionServiceHelper.getDimByDseq((int)paramvalue, (String)modelId).getString("name")));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DimensionScope ds;
        Dimension dimension;
        DynamicObjectCollection entryEntityDC;
        IDataModel model;
        int rowIndex;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (cvtFiledsSet.contains(name)) {
            rowIndex = changeSet[0].getRowIndex();
            model = this.getModel();
            entryEntityDC = model.getEntryEntity(ENTRY_ENTITY);
            if (rowIndex != -1 && CollectionUtils.isNotEmpty((Collection)entryEntityDC) && !((DynamicObject)entryEntityDC.get(rowIndex)).getBoolean(OP_TYPE)) {
                model.setValue(OP_TYPE, (Object)true, rowIndex);
            }
            if (null == changeSet[0].getNewValue() || "".equals(changeSet[0].getNewValue())) {
                model.setValue((String)multiF7Keys.get((Object)name), null, rowIndex);
            }
        } else if (name.startsWith("sd_")) {
            rowIndex = changeSet[0].getRowIndex();
            if (null == changeSet[0].getNewValue() || "".equals(changeSet[0].getNewValue())) {
                dimension = this.getSchemeContext().getDimensions().stream().filter(p -> ("sd_" + p.getFieldmapped()).equalsIgnoreCase(name)).findFirst().get();
                ds = new DimensionScope(Long.toString(this.getModelId()), dimension, new DynamicObjectCollection());
                this.setValueIntoRCS(dimension, ds, rowIndex, true, 0);
            }
        } else if (name.startsWith("rate_")) {
            rowIndex = changeSet[0].getRowIndex();
            if (null == changeSet[0].getNewValue() || "".equals(changeSet[0].getNewValue())) {
                dimension = this.getSchemeContext().getDimensions().stream().filter(p -> ("rate_" + p.getFieldmapped()).equalsIgnoreCase(name)).findFirst().get();
                ds = new DimensionScope(Long.toString(this.getModelId()), dimension, new DynamicObjectCollection());
                this.setValueIntoRCS(dimension, ds, rowIndex, true, 1);
            }
        }
        if (MODEL.equals(name)) {
            this.beforeModelChange(changeSet);
            this.modelChange();
            this.setDimColView();
            this.refreshRateSetDimCol(1);
            this.loadRateSetData(1);
            this.refreshRateSetDimCol(0);
            this.loadRateSetData(0);
            this.getModel().setDataChanged(false);
        } else if (currencyCvtFiledsSet.contains(name)) {
            this.getPageCache().put(HAS_MODIFY, "true");
        } else if (MULTILPLEMEMBERLIST.contains(name) || "ratecvtdiff_changetype".equals(name)) {
            rowIndex = changeSet[0].getRowIndex();
            model = this.getModel();
            entryEntityDC = model.getEntryEntity(RATE_CVT_DIFF_ENTITY);
            if (rowIndex != -1 && CollectionUtils.isNotEmpty((Collection)entryEntityDC) && !((DynamicObject)entryEntityDC.get(rowIndex)).getBoolean(IS_CHANGE)) {
                model.setValue(IS_CHANGE, (Object)true, rowIndex);
            }
            if (null == changeSet[0].getNewValue() || "".equals(changeSet[0].getNewValue())) {
                model.setValue(name + _HIDDEN, null, rowIndex);
            }
        }
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CHANGE_TYPE, "ratecvtdiff_changetype", "sd_changetype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHANGE_TYPE, "ratecvtdiff_changetype", "sd_changetype"});
        }
    }

    private void loadRateSetData(int type) {
        String entity = RATESETTINGENTRY;
        String schemeValue = SCHEME;
        if (1 == type) {
            entity = RATEDIFFENTRY;
            schemeValue = RATE_SCHEME;
        }
        this.getModel().deleteEntryData(entity);
        List rateCvtSetSchemes = AdjustConvertUtil.queryRateCvtSetSchemes((long)this.getModelId(), (int)type);
        if (rateCvtSetSchemes != null && !rateCvtSetSchemes.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(entity, rateCvtSetSchemes.size());
            for (int i = 0; i < rateCvtSetSchemes.size(); ++i) {
                RateCvtSetScheme rateCvtSetScheme = (RateCvtSetScheme)rateCvtSetSchemes.get(i);
                int finalI = i;
                rateCvtSetScheme.getSchemeDetails().forEach((dim, dimscope) -> this.setValueIntoRCS((Dimension)dim, (DimensionScope)dimscope, finalI, false, type));
                this.getModel().setValue(schemeValue, (Object)this.toByteSerialized(rateCvtSetScheme), i);
            }
        }
    }

    private DynamicObject getDimMemberFromCacheMap(Map<Object, DynamicObject> members, String dimNumer) {
        for (Map.Entry<Object, DynamicObject> entry : members.entrySet()) {
            if (!dimNumer.equals(entry.getValue().getString(NUMBER))) continue;
            return entry.getValue();
        }
        return null;
    }

    private String groupByDimnum(DynamicObject entity) {
        return entity.getString(DIMENSION_NUM);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (ENTRY_ENTITY_1.equals(name)) {
            this.getPageCache().put(HAS_MODIFY, "true");
        } else if (ENTRY_ENTITY.equals(name)) {
            Set<Long> deleteIds = this.getDeleteIdsCache();
            DynamicObjectCollection entryEntityDC = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject obj : entryEntityDC) {
                deleteIds.add(obj.getLong("mid"));
                obj.set(OP_TYPE, (Object)true);
            }
            this.saveDeleteCache(deleteIds);
        } else if (RATE_CVT_DIFF_ENTITY.equals(name)) {
            int[] rowIndexs;
            for (int rowIndex : rowIndexs = e.getRowIndexs()) {
                DynamicObject obj = (DynamicObject)this.getModel().getEntryEntity(RATE_CVT_DIFF_ENTITY).get(rowIndex);
                if (obj.getLong(RATE_CVT_DIFF_ID) == 0L) continue;
                this.getPageCache().put("ratecvtdiffModify", "true");
                return;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        if (ENTRY_ENTITY.equals(name)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity entity : rowDataEntities = e.getRowDataEntities()) {
                entity.getDataEntity().set(OP_TYPE, (Object)true);
            }
        }
    }

    private void setDimColView() {
        String[] str_arry;
        String modelid = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        DynamicObjectCollection dims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)modelid);
        this.dim_showlist.clear();
        ArrayList list = Lists.newArrayList();
        HashMap dimName_Map = Maps.newHashMap();
        HashSet dim_ShowPreSet = Sets.newHashSet();
        for (DynamicObject dim : dims) {
            String number = dim.getString(NUMBER);
            if (!dim.getBoolean("issysdimension")) {
                String fieldmapped = dim.getString("fieldmapped");
                String name = dim.getString("name");
                switch (fieldmapped) {
                    case "dim1": {
                        this.setCollection(list, dimName_Map, DIM_1, name, number);
                        break;
                    }
                    case "dim2": {
                        this.setCollection(list, dimName_Map, DIM_2, name, number);
                        break;
                    }
                    case "dim3": {
                        this.setCollection(list, dimName_Map, DIM_3, name, number);
                        break;
                    }
                    case "dim4": {
                        this.setCollection(list, dimName_Map, DIM_4, name, number);
                        break;
                    }
                    case "dim5": {
                        this.setCollection(list, dimName_Map, DIM_5, name, number);
                        break;
                    }
                    case "dim6": {
                        this.setCollection(list, dimName_Map, DIM_6, name, number);
                        break;
                    }
                }
                continue;
            }
            if (!this.dim_HidePreSet.contains(number)) continue;
            dim_ShowPreSet.add(number);
        }
        this.dim_showlist.addAll(this.dimKeys.keySet());
        this.getPageCache().put("dim_showlist", this.toByteSerialized(this.dim_showlist));
        this.getPageCache().put("dimKeys", this.toByteSerialized(this.dimKeys));
        this.dim_hideList.removeAll(list);
        if (CollectionUtils.isNotEmpty(this.dim_hideList)) {
            str_arry = this.dim_hideList.toArray(new String[this.dim_hideList.size()]);
            this.getView().setVisible(Boolean.FALSE, str_arry);
        }
        this.dim_HidePreSet.removeAll(dim_ShowPreSet);
        this.setPreDimColVisible(false, this.dim_HidePreSet);
        this.setPreDimColVisible(true, dim_ShowPreSet);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            str_arry = list.toArray(new String[list.size()]);
            this.getView().setVisible(Boolean.TRUE, str_arry);
            for (String dimColName : list) {
                String dimName = (String)dimName_Map.get(dimColName);
                BasedataEdit control = (BasedataEdit)this.getView().getControl(dimColName);
                if (control == null) continue;
                control.setCaption(new LocaleString(dimName));
            }
        }
    }

    private void setCollection(List<String> list, Map<String, String> dimName_Map, String dim, String name, String number) {
        list.add(dim);
        dimName_Map.put(dim, name);
        this.dimKeys.put(dim, number);
    }

    private void setPreDimColVisible(boolean show, HashSet<String> set) {
        if (set.isEmpty()) {
            return;
        }
        String[] strArray = new String[set.size()];
        int i = 0;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String number;
            strArray[i] = number = iterator.next();
            ++i;
        }
        this.getView().setVisible(Boolean.valueOf(show), strArray);
    }

    private void saveRateCvtDiff() {
        DynamicObjectCollection rateCvtDiffCol = this.getModel().getEntryEntity(RATE_CVT_DIFF_ENTITY);
        if (CollectionUtils.isEmpty((Collection)rateCvtDiffCol)) {
            DeleteServiceHelper.delete((String)"bcm_ratecvtdiff", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).toArray());
            this.getPageCache().remove("ratecvtdiffModify");
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(rateCvtDiffCol.size());
        for (DynamicObject rateCvtObj : rateCvtDiffCol) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ratecvtdiff");
            object.set(MODEL, (Object)this.getModelId());
            object.set(CHANGE_TYPE, rateCvtObj.get("ratecvtdiff_changetype"));
            DynamicObjectCollection dimCollection = object.getDynamicObjectCollection(ENTRY_ENTITY);
            this.collectRateCvtDiffDimData(dimCollection, rateCvtObj);
            list.add(object);
        }
        if (!list.isEmpty()) {
            PlatUtil.executeWithTXNew(txhandle -> {
                DeleteServiceHelper.delete((String)"bcm_ratecvtdiff", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).toArray());
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                this.getPageCache().remove("ratecvtdiffModify");
            });
        }
    }

    private void collectRateCvtDiffDimData(DynamicObjectCollection dimCollection, DynamicObject rateCvtObj) {
        DynamicObjectType type = dimCollection.getDynamicObjectType();
        for (String colName : MULTILPLEMEMBERLIST) {
            String colValue;
            if (StringUtils.isEmpty((String)rateCvtObj.getString(colName)) || StringUtils.isEmpty((String)(colValue = rateCvtObj.getString(colName + _HIDDEN)))) continue;
            List membColl = (List)SerializationUtils.fromJsonString((String)colValue, List.class);
            for (Map map : membColl) {
                DynamicObject dimObject = new DynamicObject(type);
                dimObject.set(MEMBER_ID, map.get("id"));
                dimObject.set(MEMBER_NUM, map.get(NUMBER));
                dimObject.set(SCOPE, map.get(SCOPE));
                dimObject.set(DIMENSION_NUM, (Object)Optional.ofNullable(MULTIPLE_MEMBER_NUMBER_MAP.get(colName)).orElseGet(() -> {
                    String ctrlKey = this.getPageCache().get(colName);
                    if (!StringUtils.isEmpty((String)ctrlKey)) {
                        String[] c = ctrlKey.split("_");
                        return c[c.length - 2];
                    }
                    return "";
                }));
                dimCollection.add((Object)dimObject);
            }
        }
    }

    private void saveData() {
        DynamicObjectCollection entryEntityDC = this.getModel().getEntryEntity(ENTRY_ENTITY);
        LinkedList waitSave = Lists.newLinkedList();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_entrycvtcurrency");
        for (int i = 0; i < entryEntityDC.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntityDC.get(i);
            DynamicObject add = this.createSettingDyn(entry, dataEntityType, true, i);
            if (add == null) continue;
            waitSave.add(add);
        }
        PlatUtil.executeWithTXNew(txhandle -> {
            DeleteServiceHelper.delete((String)"bcm_entrycvtcurrency", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).toArray());
            if (CollectionUtils.isNotEmpty((Collection)waitSave)) {
                SaveServiceHelper.save((DynamicObject[])waitSave.toArray(new DynamicObject[waitSave.size()]));
            }
            AdjustEntryConfig.get().clearAdjustCvtCurrencySchemeCache(Long.valueOf(this.getModelId()));
        });
    }

    private boolean check(DynamicObject entry) {
        return StringUtils.isNotEmpty((String)entry.getString("entity")) && StringUtils.isNotEmpty((String)entry.getString("currency"));
    }

    private DynamicObject createSettingDyn(DynamicObject entry, MainEntityType dataEntityType, boolean isNew, int row) {
        DynamicObject createInstance = (DynamicObject)dataEntityType.createInstance();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty pro : properties) {
            String name;
            switch (name = pro.getName()) {
                case "id": {
                    if (isNew) break;
                    createInstance.set(name, entry.get("mid"));
                    break;
                }
                case "model": {
                    createInstance.set(name, (Object)this.getModelId());
                    break;
                }
                case "businesstype": {
                    createInstance.set(name, entry.get(name));
                    break;
                }
                case "entryentity": {
                    DynamicObjectCollection dimCollection = createInstance.getDynamicObjectCollection(ENTRY_ENTITY);
                    this.collectDimData(dimCollection, entry);
                    break;
                }
            }
        }
        return createInstance;
    }

    private void collectDimData(DynamicObjectCollection collection, DynamicObject entry) {
        DynamicObjectType type = collection.getDynamicObjectType();
        this.collectDimDataSave(collection, type, "Entity", entry.getString("entity"));
        this.collectDimDataSave(collection, type, "Currency", entry.getString("currency"));
    }

    private void collectDimDataSave(DynamicObjectCollection collection, DynamicObjectType type, String dimNumber, String dimValue) {
        if (StringUtils.isEmpty((String)dimValue)) {
            return;
        }
        List membList = (List)SerializationUtils.fromJsonString((String)dimValue, List.class);
        DynamicObject dim = null;
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
            dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, number", (QFilter[])new QFBuilder().add(MODEL, "=", (Object)this.getModelId()).add("issysdimension", "=", (Object)"1").add(NUMBER, "=", (Object)DimTypesEnum.ENTITY.getNumber()).toArray());
        } else if (DimTypesEnum.CURRENCY.getNumber().equals(dimNumber)) {
            dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, number", (QFilter[])new QFBuilder().add(MODEL, "=", (Object)this.getModelId()).add("issysdimension", "=", (Object)"1").add(NUMBER, "=", (Object)DimTypesEnum.CURRENCY.getNumber()).toArray());
        }
        if (dim == null) {
            return;
        }
        for (Map map : membList) {
            DynamicObject dimObject = new DynamicObject(type);
            dimObject.set(MEMBER_ID, map.get("id"));
            dimObject.set(SCOPE, map.get(SCOPE));
            dimObject.set(DIMENSION, dim.get("id"));
            dimObject.set(DIMENSION_NUM, dim.get(NUMBER));
            collection.add((Object)dimObject);
        }
    }

    private boolean isNew(DynamicObject entry) {
        return entry.getLong("mid") == 0L;
    }

    private void saveDeleteCache(Set<Long> deleteIds) {
        this.getPageCache().put(DELETE_IDS_CACHE, SerializationUtils.toJsonString(deleteIds));
    }

    private Set<Long> getDeleteIdsCache() {
        Set deleteIds = null;
        String deleteIdsStr = this.getPageCache().get(DELETE_IDS_CACHE);
        if (StringUtils.isNotEmpty((String)deleteIdsStr)) {
            deleteIds = (Set)SerializationUtils.fromJsonString((String)deleteIdsStr, Set.class);
        }
        if (deleteIds == null) {
            deleteIds = Sets.newHashSet();
        }
        return deleteIds;
    }

    private void beforeModelChange(ChangeData[] changeSet) {
        ChangeData changeData = changeSet[0];
        DynamicObject modelDyn = (DynamicObject)changeData.getNewValue();
        if (modelDyn != null) {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelDyn.getString("id"));
        } else if (changeData.getOldValue() != null) {
            this.getModel().setValue(MODEL, changeData.getOldValue());
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", "" + this.getModelId());
    }

    private void modelChange() {
        this.initMultiComb();
        this.initCache();
        this.buildEntryData();
        this.buildRateDimension();
    }

    private void buildRateDimension() {
        SchemeContext schemeContext = new SchemeContext(this.getModelId());
        List<String> dims = Arrays.asList(DimTypesEnum.MULTIGAAP.getNumber(), DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber(), DimTypesEnum.MYCOMPANY.getNumber());
        schemeContext.removeIf(p -> p.isIssys() && !dims.contains(p.getNumber()));
        this.getPageCache().put("dimensionScheme", this.toByteSerialized(schemeContext));
    }

    private SchemeContext getSchemeContext() {
        String dimensionSchemeCache = this.getPageCache().get("dimensionScheme");
        if (StringUtils.isEmpty((String)dimensionSchemeCache)) {
            return new SchemeContext(this.getModelId());
        }
        return (SchemeContext)this.deSerializedBytes(dimensionSchemeCache);
    }

    private void buildEntryData() {
        int size;
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        this.getPageCache().remove(DELETE_IDS_CACHE);
        DynamicObject[] data = this.getAllSettingData();
        int n = size = data == null ? 0 : data.length;
        if (size < 1) {
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
        int index = 0;
        for (DynamicObject entry : data) {
            model.setValue("mid", entry.get("id"), index);
            model.setValue(BUSINESS_TYPE, "".equals(entry.get(BUSINESS_TYPE)) ? null : entry.get(BUSINESS_TYPE), index);
            DynamicObjectCollection entryCol = entry.getDynamicObjectCollection(ENTRY_ENTITY);
            if (!entryCol.isEmpty()) {
                HashMap entity_idScopeMap = Maps.newHashMap();
                HashMap currency_idScopeMap = Maps.newHashMap();
                String dimNumber = null;
                for (DynamicObject membObj : entryCol) {
                    dimNumber = membObj.getString(DIMENSION_NUM);
                    if (DimEntityNumEnum.ENTITY.getNumber().equals(dimNumber)) {
                        entity_idScopeMap.put(membObj.getLong(MEMBER_ID), membObj.getString(SCOPE));
                        continue;
                    }
                    if (!DimEntityNumEnum.CURRENCY.getNumber().equals(dimNumber)) continue;
                    currency_idScopeMap.put(membObj.getLong(MEMBER_ID), membObj.getString(SCOPE));
                }
                Map members_Entity = null;
                Map members_Currency = null;
                if (!entity_idScopeMap.keySet().isEmpty()) {
                    members_Entity = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.ENTITY.getEntityNum(), (String)"name, number", (QFilter[])new QFBuilder("id", "in", entity_idScopeMap.keySet()).toArray());
                }
                if (!currency_idScopeMap.keySet().isEmpty()) {
                    members_Currency = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.CURRENCY.getEntityNum(), (String)"name, number", (QFilter[])new QFBuilder("id", "in", currency_idScopeMap.keySet()).toArray());
                }
                this.loadMemb(entity_idScopeMap, members_Entity, model, index, ENTITY_TXT);
                this.loadMemb(currency_idScopeMap, members_Currency, model, index, CURRENCY_TXT);
            }
            model.setValue(OP_TYPE, (Object)false, index);
            ++index;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void loadMemb(Map<Long, String> idScopeMap, Map<Object, DynamicObject> members, IDataModel model, int index, String dimTextName) {
        if (idScopeMap.isEmpty() || members == null || members.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList list = new ArrayList(members.size());
        Iterator<Map.Entry<Long, String>> iterator = idScopeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            Map.Entry<Long, String> next = iterator.next();
            long memberId = next.getKey();
            DynamicObject dy = members.get(memberId);
            if (dy == null) continue;
            String scope = next.getValue();
            map.put("id", String.valueOf(memberId));
            map.put(SCOPE, scope);
            map.put(NUMBER, dy.getString(NUMBER));
            map.put("name", dy.getString("name"));
            CslSchemeUtils.buildPageViewShowName(sb, dy.getString("name"), Integer.parseInt(scope));
            list.add(map);
        }
        if (sb.length() > 0) {
            String showName = sb.substring(0, sb.length() - 1);
            model.setValue(dimTextName, (Object)showName, index);
            model.setValue((String)multiF7Keys.get((Object)dimTextName), (Object)JSONArray.toJSONString(list), index);
        }
    }

    private DynamicObject[] getAllSettingData() {
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entrycvtcurrency", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).toArray(), null, (int)-1);
        return BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_entrycvtcurrency"));
    }

    private void initCache() {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, dseq", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).and(new QFilter(NUMBER, "in", (Object)Lists.newArrayList((Object[])new String[]{"Currency", "Entity"}))).toArray());
        HashMap dimensionIdMapping = Maps.newHashMap();
        for (DynamicObject obj : collection) {
            dimensionIdMapping.put(obj.getString(NUMBER).toLowerCase(Locale.ENGLISH), obj.getInt("dseq"));
        }
        this.getPageCache().put(CACHE_DIM, SerializationUtils.toJsonString((Object)dimensionIdMapping));
    }

    private void initMultiComb() {
        boolean noEICA;
        MulComboEdit mulCombo = (MulComboEdit)this.getControl(BUSINESS_TYPE);
        ArrayList items = Lists.newArrayList();
        JSONArray bizTypeConfig = ConfigServiceHelper.getConfigCM005((long)this.getModelId());
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter.and(NUMBER, "=", (Object)"EICA");
        DynamicObject obj = QueryServiceHelper.queryOne((String)DimEntityNumEnum.PROCESS.getEntityNum(), (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        boolean bl = noEICA = null == obj;
        if (bizTypeConfig != null) {
            Recorder hasADJUSTCROSSLEVEL = new Recorder((Object)false);
            bizTypeConfig.forEach(e -> {
                JSONObject entry = (JSONObject)e;
                if (noEICA ? EICA_LIST.contains(entry.getString("businesstypevalue")) : "ADJUSTOFFSETLEVEL".equals(entry.getString("businesstypevalue"))) {
                    return;
                }
                BusinessTypeEnum busstypew = BusinessTypeEnum.searchByName((String)entry.getString("businesstypevalue"));
                if (OrgRelaProcessMembPool.isRelaProcess((String)busstypew.getProcessNumber())) {
                    items.add(new ComboItem(LocaleString.fromMap((Map)((Map)entry.get((Object)"showname"))), busstypew.getIndex()));
                    mulCombo.setComboItems(items);
                    if (BusinessTypeEnum.ADJUSTCROSSLEVEL.getName().equals(entry.getString("businesstypevalue"))) {
                        hasADJUSTCROSSLEVEL.setRecord((Object)true);
                    }
                }
            });
        } else {
            BusinessTypeEnum[] values = BusinessTypeEnum.values();
            for (int i = 1; i < values.length; ++i) {
                if ((!noEICA ? "ADJUSTOFFSETLEVEL".equals(values[i].getName()) : EICA_LIST.contains(values[i].getName())) || !OrgRelaProcessMembPool.isRelaProcess((String)values[i].getProcessNumber())) continue;
                items.add(new ComboItem(new LocaleString(values[i].getText()), values[i].getIndex()));
                mulCombo.setComboItems((List)items);
            }
        }
    }

    private boolean RateCvtDiffDataModify() {
        if ("true".equals(this.getPageCache().get("ratecvtdiffModify"))) {
            return true;
        }
        DynamicObjectCollection entryEntityDC = this.getModel().getEntryEntity(RATE_CVT_DIFF_ENTITY);
        for (DynamicObject temp : entryEntityDC) {
            if (!temp.getBoolean(IS_CHANGE)) continue;
            return true;
        }
        return false;
    }

    private boolean hasModify() {
        DynamicObjectCollection entryEntityDC = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entryEntityDC.isEmpty()) {
            return true;
        }
        for (DynamicObject temp : entryEntityDC) {
            if (!temp.getBoolean(OP_TYPE)) continue;
            return true;
        }
        return false;
    }

    private boolean hasModify(DynamicObject entry) {
        return entry.getBoolean(OP_TYPE);
    }

    private boolean validateMustIput(String type) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(type);
        if (entryEntity.isEmpty()) {
            return true;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)entryEntity.get(0)).getDynamicObjectType().getProperties();
        int rowIndex = 0;
        for (DynamicObject dyn : entryEntity) {
            ++rowIndex;
            for (IDataEntityProperty p : properties) {
                try {
                    boolean isnull;
                    Method mustInputMethod = ClassUtils.getPublicMethod(p.getClass(), (String)"isMustInput", (Class[])new Class[0]);
                    boolean mustInput = (Boolean)mustInputMethod.invoke((Object)p, new Object[0]);
                    Object value = p.getValue((Object)dyn);
                    boolean bl = isnull = value == null || value instanceof String && StringUtils.isEmpty((String)((String)value));
                    if (!mustInput || !isnull) continue;
                    if (RATE_CVT_DIFF_ENTITY.equals(type) || RATEDIFFENTRY.equals(type)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u6c47\u7387\u6298\u7b97\u5dee\u5904\u7406\u3011\u7b2c%1$d\u884c\uff0c\u8bf7\u8f93\u5165\u5fc5\u5f55\u5b57\u6bb5\uff1a%2$s\u3002", (String)"EntryCvtCurrencySettingPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), rowIndex, p.getDisplayName().toString()));
                    } else if (ENTRY_ENTITY_1.equals(type)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u5206\u5f55\u5916\u5e01\u62a5\u8868\u6298\u7b97\u5dee\u3011\u7b2c%1$d\u884c\uff0c\u8bf7\u8f93\u5165\u5fc5\u5f55\u5b57\u6bb5\uff1a%2$s\u3002", (String)"EntryCvtCurrencySettingPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), rowIndex, p.getDisplayName().toString()));
                    } else if (RATESETTINGENTRY.equals(type)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u6c47\u7387\u914d\u7f6e\u8868\u3011\u7b2c%1$d\u884c\uff0c\u8bf7\u8f93\u5165\u5fc5\u5f55\u5b57\u6bb5\uff1a%2$s\u3002", (String)"EntryCvtCurrencySettingPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), rowIndex, p.getDisplayName().toString()));
                    } else if (ENTRY_ENTITY.equals(type)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u591a\u5e01\u79cd\u8bbe\u7f6e\u3011\u7b2c%1$d\u884c\uff0c\u8bf7\u8f93\u5165\u5fc5\u5f55\u5b57\u6bb5\uff1a%2$s\u3002", (String)"EntryCvtCurrencySettingPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), rowIndex, p.getDisplayName().toString()));
                    }
                    return false;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                }
            }
        }
        return true;
    }

    private void actionSave() {
        DynamicObject step;
        DynamicObjectCollection stepColls = this.getModel().getEntryEntity(ENTRY_ENTITY_1);
        if (CollectionUtils.isEmpty((Collection)stepColls)) {
            DeleteServiceHelper.delete((String)BCM_ENTRYEXCHANGE, (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).toArray());
            return;
        }
        DynamicObject stepColl = (DynamicObject)stepColls.get(0);
        Long modelCol_id = stepColl.getLong(modelCol);
        String modelid = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
        if (modelCol_id != null && modelCol_id != 0L) {
            if (!this.getEntryEntityDataChange()) {
                return;
            }
            QFilter fmodelid = new QFilter(MODEL, "=", (Object)modelid);
            QFilter[] filters = new QFilter[]{fmodelid};
            step = BusinessDataServiceHelper.loadSingle((String)BCM_ENTRYEXCHANGE, (String)SELECT_STR, (QFilter[])filters);
        } else {
            step = BusinessDataServiceHelper.newDynamicObject((String)BCM_ENTRYEXCHANGE);
            step.set(MODEL, (Object)modelid);
        }
        step.set(ACCOUNT, stepColl.get(ACCOUNT));
        step.set(CHANGE_TYPE, stepColl.get(CHANGE_TYPE));
        step.set(MY_COMPANY, stepColl.get(MY_COMPANY));
        step.set(INTERNAL_COMPANY, stepColl.get(INTERNAL_COMPANY));
        step.set(MULTIGAAP, stepColl.get(MULTIGAAP));
        step.set(DIM_1, stepColl.get(DIM_1));
        step.set(DIM_2, stepColl.get(DIM_2));
        step.set(DIM_3, stepColl.get(DIM_3));
        step.set(DIM_4, stepColl.get(DIM_4));
        step.set(DIM_5, stepColl.get(DIM_5));
        step.set(DIM_6, stepColl.get(DIM_6));
        DynamicObject[] dyObject = new DynamicObject[]{step};
        if (modelCol_id != null && modelCol_id != 0L) {
            SaveServiceHelper.update((DynamicObject[])dyObject);
        } else {
            SaveServiceHelper.save((DynamicObject[])dyObject);
        }
    }

    private boolean getEntryEntityDataChange() {
        String hasModify = this.getPageCache().get(HAS_MODIFY);
        return "true".equals(hasModify);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        Map map = (Map)this.deSerializedBytes(this.getPageCache().get("dimKeys"));
        if (map != null && map.size() > 0) {
            this.dimKeys.clear();
            this.dimKeys.putAll(map);
        }
        this.dimKeys.put("ratecvtdiff_changetype", DimTypesEnum.CHANGETYPE.getNumber());
        String f7Key = e.getKey();
        String pagekey = this.dimKeys.get(f7Key);
        if (this.getDimKeysFromCache().containsKey(f7Key)) {
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
            Control ctrl = (Control)this.cacheControls.get(f7Key);
            if (ctrl != null) {
                e.setControl(ctrl);
            } else {
                BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), pagekey, f7Key, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                f7.setDisplayProp("name");
                Map<String, Object> customData = f7.getCustomData();
                if (customData == null) {
                    customData = new HashMap<String, Object>();
                    f7.setCustomData(customData);
                }
                customData.put("isContainShare", Boolean.TRUE);
                if (DimTypesEnum.ACCOUNT.getNumber().equals(pagekey) || DimTypesEnum.CHANGETYPE.getNumber().equals(pagekey)) {
                    customData.put("isShowCslScheme", "false");
                }
                e.setControl((Control)f7);
                this.cacheControls.put(pagekey, f7);
            }
        }
    }

    static {
        multiF7Keys.put((Object)ENTITY_TXT, (Object)"entity");
        multiF7Keys.put((Object)CURRENCY_TXT, (Object)"currency");
        multiF7Keys.put((Object)BUSINESS_TYPE, (Object)BUSINESS_TYPE);
        cvtFiledsSet.add(ENTITY_TXT);
        cvtFiledsSet.add(CURRENCY_TXT);
        cvtFiledsSet.add(BUSINESS_TYPE);
        currencyCvtFiledsSet.add(ACCOUNT);
        currencyCvtFiledsSet.add(CHANGE_TYPE);
        currencyCvtFiledsSet.add(MY_COMPANY);
        currencyCvtFiledsSet.add(INTERNAL_COMPANY);
        currencyCvtFiledsSet.add(MULTIGAAP);
        currencyCvtFiledsSet.add(DIM_1);
        currencyCvtFiledsSet.add(DIM_2);
        currencyCvtFiledsSet.add(DIM_3);
        currencyCvtFiledsSet.add(DIM_4);
        currencyCvtFiledsSet.add(DIM_5);
        currencyCvtFiledsSet.add(DIM_6);
        MULTIPLE_MEMBER_NUMBER_MAP.put(CTL_ACCOUNT, DimEntityNumEnum.ACCOUNT.getNumber());
        MULTIPLE_MEMBER_NUMBER_MAP.put(CL_MY_COMPANY, DimEntityNumEnum.MYCOMPANY.getNumber());
        MULTIPLE_MEMBER_NUMBER_MAP.put(CL_INTERNAL_COMPANY, DimTypesEnum.INTERCOMPANY.getNumber());
        MULTIPLE_MEMBER_NUMBER_MAP.put(CL_MULTIGAAP, DimTypesEnum.MULTIGAAP.getNumber());
    }
}

