/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class InvElimSelectPagePlugin
extends AbstractBaseFormPlugin {
    @Override
    public void initialize() {
        HashMap map = new HashMap(16);
        this.asMapF7toType(Collections.singletonList("currency"), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        QFilter filter;
        DynamicObjectCollection query;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("model");
        this.getPageCache().put("KEY_MODEL_ID", "" + modelId);
        Long scenarioId = (Long)formShowParameter.getCustomParam("scenario");
        Long orgId = (Long)formShowParameter.getCustomParam("orgId");
        Long yearId = (Long)formShowParameter.getCustomParam("yearId");
        Long periodId = (Long)formShowParameter.getCustomParam("periodId");
        DynamicObject cur = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId);
        IDataModel model = this.getModel();
        if (cur != null) {
            model.setValue("currency", (Object)cur.getLong("id"));
        }
        List templateIds = (List)formShowParameter.getCustomParam("templateIds");
        if (modelId != null && scenarioId != null && templateIds != null && (query = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"id, name, billno, invrelatype", (QFilter[])(filter = QFilter.of((String)"model = ? and scenario = ? and billstatus = ?", (Object[])new Object[]{modelId, scenarioId, "C"})).toArray())).size() > 0) {
            model.batchCreateNewEntryRow("entryentity", query.size());
            for (int i = 0; i < query.size(); ++i) {
                DynamicObject rowData = (DynamicObject)query.get(i);
                model.setValue("id", (Object)rowData.getLong("id"), i);
                model.setValue("name", (Object)rowData.getString("name"), i);
                model.setValue("billno", (Object)rowData.getString("billno"), i);
                model.setValue("invrelatype", (Object)rowData.getString("invrelatype"), i);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List templateIds = (List)formShowParameter.getCustomParam("templateIds");
        if (templateIds != null && !templateIds.isEmpty()) {
            IDataModel model = this.getModel();
            int rowCount = model.getEntryRowCount("entryentity");
            EntryGrid entity = (EntryGrid)this.getControl("entryentity");
            int[] indexs = new int[templateIds.size()];
            int index = 0;
            for (int i = 0; i < rowCount; ++i) {
                if (!templateIds.contains(model.getValue("id", i))) continue;
                indexs[index++] = i;
            }
            if (indexs.length > 0) {
                entity.selectRows(indexs, indexs[0]);
            }
        } else {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            EntryGrid entity = (EntryGrid)this.getControl("entryentity");
            int[] indexs = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                indexs[i] = i;
            }
            if (rowCount > 0) {
                entity.selectRows(indexs, indexs[0]);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_ok".equals(itemKey)) {
            EntryGrid entity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entity.getSelectRows();
            int rowCount = selectRows.length;
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"InvElimSelectPagePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            Object currency = model.getValue("currency");
            if (currency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd", (String)"InvElimSelectPagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> tempIds = new ArrayList<Long>(selectRows.length);
            for (int rowIndex : selectRows) {
                tempIds.add((Long)model.getValue("id", rowIndex));
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("tempIds", tempIds);
            returnData.put("currency", ((DynamicObject)currency).getLong("id"));
            returnData.put("currencyNumb", ((DynamicObject)currency).getString("number"));
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }
}

