/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.template.MultipleMemberF7TemPlugin;

public class MultipleMemberF74AdjustPlugin
extends MultipleMemberF7TemPlugin {
    private static final List<String> processSelect = Arrays.asList("Process", "IRpt", "CS", "DADJ", "DEJE", "ADJ", "CADJ", "CCADJ", "EJE", "EICA", "EIT", "EOE", "ECF", "EOther");
    private static final Set<String> noChooseCurrency = Sets.newHashSet((Object[])new String[]{"EC", "PC", "DC", "Currency", "OC"});
    private static final List<String> noChooseProcess = Arrays.asList("Process", "EJE");

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sign = "" + this.getView().getFormShowParameter().getCustomParam("sign");
        boolean isNeedCommonField = sign.startsWith("bcm_accountmembertree") || sign.startsWith("bcm_entitymembertree");
        this.getView().setVisible(Boolean.valueOf(isNeedCommonField), new String[]{"commonfieldradio"});
    }

    @Override
    protected DynamicObjectCollection queryMember(String dimensionid) {
        String dimNumber = QueryDimensionServiceHelper.getDimNumberById((String)dimensionid);
        if ("Process".equals(dimNumber)) {
            return this.getPresetMemberDoc4Process(dimensionid);
        }
        DynamicObjectCollection doc = super.queryMember(dimensionid);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        boolean isEntryCvt = "EntryCvtCurrencySettingPlugin".equals(pageCache.get("openViewPlugin"));
        if ("Currency".equals(dimNumber) && isEntryCvt) {
            ArrayList list = Lists.newArrayList();
            for (DynamicObject obj : doc) {
                if (!noChooseCurrency.contains(obj.getString("number")) && !"CNone".equals(obj.getString("number")) && obj.getLong("parent") != 0L) continue;
                list.add(obj);
            }
            doc.removeAll((Collection)list);
        }
        if ("Entity".equals(dimNumber)) {
            if (isEntryCvt) {
                ArrayList leafList = Lists.newArrayList();
                for (DynamicObject obj : doc) {
                    if (!obj.getBoolean("isleaf") && obj.getLong("parent") != 0L) continue;
                    leafList.add(obj);
                }
                doc.removeAll((Collection)leafList);
            }
            String yearNum = pageCache.get("yearNum");
            String periodId = pageCache.get("periodId");
            String[] splitYear = yearNum.split(",");
            String[] splitPeriod = periodId.split(",");
            ArrayList<DynamicObjectCollection> toFilterList = new ArrayList<DynamicObjectCollection>(10);
            long sceneId = this.getScenarioId();
            for (int i = 0; i < splitYear.length; ++i) {
                for (int j = 0; j < splitPeriod.length; ++j) {
                    DynamicObjectCollection clone = (DynamicObjectCollection)doc.clone();
                    FilterOrgStructParam param = new FilterOrgStructParam(this.getModelId(), sceneId, splitYear[i], LongUtil.toLong((Object)splitPeriod[j]).longValue());
                    EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, (List)clone);
                    toFilterList.add(clone);
                }
            }
            DynamicObjectCollection result = new DynamicObjectCollection();
            ArrayList tmpIds = new ArrayList(10);
            for (int i = toFilterList.size() - 1; i >= 0; --i) {
                DynamicObjectCollection tmp = (DynamicObjectCollection)toFilterList.get(i);
                tmp.forEach(d -> {
                    if (!tmpIds.contains(d.getString("id"))) {
                        result.add(d);
                        tmpIds.add(d.getString("id"));
                    }
                });
            }
            result.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    if (o1.getInt("level") < o2.getInt("level")) {
                        return -1;
                    }
                    if (o1.getInt("level") == o2.getInt("level")) {
                        if (o1.getInt("dseq") < o2.getInt("dseq")) {
                            return -1;
                        }
                        if (o1.getInt("dseq") == o2.getInt("dseq")) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
            });
            doc = result;
        }
        return doc;
    }

    @Override
    protected void setDefaultState() {
        super.setDefaultState();
        if ("Process".equals(this.getPageCache().get("mnumber"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"memrangdecombo", "entryentity1"});
        }
    }

    @Override
    protected void afterBuildDataList(List<Map<String, String>> newmemberlist) {
        switch (this.getPageCache().get("mnumber")) {
            case "Process": {
                this.removeCanNotChooseMember(newmemberlist, noChooseProcess);
                break;
            }
            case "Currency": {
                this.removeCanNotChooseMember(newmemberlist, new ArrayList<String>(noChooseCurrency));
                break;
            }
        }
    }

    @Override
    protected void filterFyAndPeriod(QFilter filter, String membermodel) {
        super.filterFyAndPeriod(filter, membermodel);
        if ("bcm_currencymembertree".equals(membermodel)) {
            filter.and(new QFilter("number", "not in", noChooseCurrency));
        }
    }

    private void removeCanNotChooseMember(List<Map<String, String>> newmemberlist, List<String> list) {
        Iterator<Map<String, String>> iter = newmemberlist.iterator();
        while (iter.hasNext()) {
            Map<String, String> map = iter.next();
            if (!list.contains(map.get("number"))) continue;
            iter.remove();
        }
    }

    private DynamicObjectCollection getPresetMemberDoc4Process(String dimensionid) {
        QFilter filter2;
        String entityName = this.getPageCache().get("membermodel");
        String selectFields = "id,name,number,parent,storagetype";
        QFilter filter1 = new QFilter("dimension", "=", (Object)dimensionid);
        Object openType = this.getView().getFormShowParameter().getCustomParam("opentype");
        if (openType == null) {
            filter2 = new QFilter("number", "in", (Object)processSelect.toArray());
        } else {
            String[] openTypes = openType.toString().split(",");
            ArrayList<String> numbers1 = new ArrayList<String>(10);
            for (String openTypeTemp : openTypes) {
                AdjustTypeEnum type = AdjustTypeEnum.getAdjustTypeByVal((String)openTypeTemp);
                List numbers = type.getNumbers();
                numbers1.addAll(numbers);
                numbers1.add("Process");
                if (type != AdjustTypeEnum.ELIM) continue;
                numbers1.add("EJE");
            }
            filter2 = new QFilter("number", "in", (Object)numbers1.toArray());
        }
        QFilter[] filters = new QFilter[]{filter1, filter2};
        String orderBys = "level,dseq";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        long rootId = 0L;
        for (DynamicObject one : doc) {
            if (one.getLong("parent") != 0L) continue;
            rootId = one.getLong("id");
            break;
        }
        int temp = 0;
        block2: for (DynamicObject one : doc) {
            long parentId = one.getLong("parent");
            if (parentId == 0L) continue;
            temp = 0;
            for (DynamicObject two : doc) {
                ++temp;
                if (two.getLong("id") == parentId) continue block2;
                if (temp != doc.size()) continue;
                one.set("parent", (Object)rootId);
            }
        }
        return this.orderByTheDataList(doc);
    }

    private DynamicObjectCollection orderByTheDataList(DynamicObjectCollection doc) {
        DynamicObjectCollection newdoc = new DynamicObjectCollection(doc.getDynamicObjectType(), null);
        block0: for (String number : processSelect) {
            for (DynamicObject dd : doc) {
                if (!number.equals(dd.getString("number"))) continue;
                newdoc.add((Object)dd);
                continue block0;
            }
        }
        return newdoc;
    }

    @Override
    protected void memberNodeClick(TreeNodeEvent ev) {
        String number;
        super.memberNodeClick(ev);
        switch (number = this.getPageCache().get("mnumber")) {
            case "Process": {
                if (!"0".equals(ev.getParentNodeId()) && !"EJE".equals(this.getNodeNumber(ev.getNodeId()))) break;
                this.resetTipMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8282\u70b9\u3002", (String)"MultipleMemberF74AdjustPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ev.getNodeId());
                break;
            }
            case "Currency": {
                Object id;
                String val = (String)this.getModel().getValue("radio");
                if (!"10".equals(val) || !noChooseCurrency.contains(this.queryCurrencyMember(id = ev.getNodeId()).getString("number"))) break;
                this.resetTipMessage(ResManager.loadKDString((String)"\u4e0d\u53ef\u9009\u62e9\u975e\u5b9e\u9645\u5e01\u79cd\u6210\u5458\u3002", (String)"MultipleMemberF74AdjustPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), id);
                break;
            }
        }
    }

    private void resetTipMessage(String msg, Object id) {
        TreeView memberTree = (TreeView)this.getControl("membertreeap");
        memberTree.unCheckNodeWithoutChild(String.valueOf(id));
        this.getView().showTipNotification(msg);
    }

    private DynamicObject queryCurrencyMember(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_currencymembertree", (String)"number");
    }

    private String getNodeNumber(Object id) {
        QFilter filter = new QFilter("id", "=", id);
        DynamicObject member = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"number", (QFilter[])new QFilter[]{filter});
        return member.getString("number");
    }

    @Override
    protected boolean checkHasMembers(Set<Long> orgIds) {
        return true;
    }
}

