/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.cslscheme.RptAdjustEntryCopyHelper;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class RptAdjustBasicInfoPlugin
extends AbstractBaseFormPlugin {
    private static final String PERMISSION_CLASS = "permclass";
    private static final String IS_USE_CODE_RULE = "isUseCodeRule";
    private static final String IS_ADD_VIEW = "isAddView";
    private static final String IS_MODIFIABLE = "isModifiable";
    private static final String SHOW_NUMBER = "showNumber";
    private static final String IS_RECYCLE_RULE_NUMBER = "is_recycle_rule_number";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Collections.singletonList("entity"), SingleF7TypeEnum.NOLEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        super.setSingleF7Filter(bdEdit);
        String entity = bdEdit.getDimNumber();
        if ("entity".equals(entity)) {
            QFilter qf = new QFilter("cslscheme", "=", this.getView().getFormShowParameter().getCustomParam("cslscheme"));
            qf.and("isleaf", "=", (Object)"0");
            qf.and("isexchangerate", "=", (Object)"0");
            List filterList = QueryServiceHelper.queryPrimaryKeys((String)bdEdit.getEntity(), (QFilter[])qf.toArray(), null, (int)-1).stream().map(p -> (Long)p).collect(Collectors.toList());
            if (bdEdit.getCustomData() == null) {
                bdEdit.setCustomData(new HashMap<String, Object>(16));
            }
            bdEdit.getCustomData().put("cslschemeisselect", true);
            bdEdit.getCustomData().put("cslscheme", this.getView().getFormShowParameter().getCustomParam("cslscheme"));
            if (!filterList.isEmpty()) {
                bdEdit.getCustomData().put("filter", filterList);
            }
        }
    }

    private boolean isOrgTreeType() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("isOrgTreeType");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCodeRuleData();
        this.getModel().setValue("model", this.getFormCustomParam("model"));
        this.getModel().setValue("cslscheme", this.getFormCustomParam("cslscheme"));
        this.getModel().setValue("journaltype", (Object)this.getFormCustomParam("journaltype", "1"));
        this.getModel().setValue("templatecatalog", (Object)this.getFormCustomParam("caltlogId", 0L));
        List<ComboItem> bussnesstypeComboItemList = AdjustModelUtil.setBusinessType(this.getModel(), (ComboEdit)this.getControl("bussnesstype"), this.getModelId(), (Boolean)this.getFormCustomParam("selectedNodeIsLeaf"), true, null, false);
        this.setAdjustTemplateComboEdit(AdjustModelUtil.getBussnesstypesFromCombo(bussnesstypeComboItemList));
        this.refresh();
    }

    private void refresh() {
        this.refreshMergeStatus();
        this.refreshMultipleCurrency();
        if (BlackListUtils.hasFeatureInCm((String)"CMLink")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"linkcreatetype"});
        }
    }

    private void initCodeRuleData() {
        CodeRuleInfo codeRuleInfo = CodeRuleUtil.getCodeRuleInfo("bcm_rptadjust");
        if (null == codeRuleInfo) {
            this.getPageCache().put(IS_USE_CODE_RULE, String.valueOf(false));
            return;
        }
        Boolean isAddView = codeRuleInfo.getIsAddView();
        Boolean isModifiable = codeRuleInfo.getIsModifiable();
        if (!isAddView.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"number"});
        } else if (!isModifiable.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        DynamicObject adjustDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        adjustDy.set("scenario", this.getFormCustomParam("scenario"));
        adjustDy.set("year", this.getFormCustomParam("year"));
        adjustDy.set("period", this.getFormCustomParam("period"));
        adjustDy.set("belongorg", this.getFormCustomParam("selectedNodeId"));
        adjustDy.set("entity", this.getFormCustomParam("selectedNodeId"));
        adjustDy.set("createtime", (Object)TimeServiceHelper.now());
        String showNumber = (String)AdjustOperationHelper.batchGetNumbers((String)"bcm_rptadjust", Collections.singletonList(adjustDy)).get(0);
        this.getModel().setValue("number", (Object)showNumber);
        this.getPageCache().put(IS_USE_CODE_RULE, String.valueOf(true));
        this.getPageCache().put(SHOW_NUMBER, showNumber);
        this.getPageCache().put(IS_ADD_VIEW, String.valueOf(isAddView));
        this.getPageCache().put(IS_MODIFIABLE, String.valueOf(isModifiable));
    }

    private void refreshMultipleCurrency() {
        String bussnesstype = (String)this.getModel().getValue("bussnesstype");
        boolean isShowMultipleCurrency = true;
        Long mergeid = (Long)this.getModel().getValue("entity_id");
        if (!OrgRelaProcessMembPool.isRelaProcess((String)BusinessTypeEnum.searchByName((String)bussnesstype).getProcessNumber()) || mergeid == null || mergeid == 0L) {
            isShowMultipleCurrency = false;
        } else {
            boolean bl = isShowMultipleCurrency = RptAdjustEntryCopyHelper.getMultipleCurrency(this.getModelId(), mergeid, bussnesstype).size() > 0;
        }
        if (!ConfigServiceHelper.isHwApp() && isShowMultipleCurrency) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"multiplecurrency", "foreigncurrency"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"multiplecurrency", "foreigncurrency"});
            ((BasedataEdit)this.getControl("foreigncurrency")).setMustInput(true);
            this.getModel().setValue("multiplecurrency", (Object)"1");
            Long yearId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("year").toString());
            Long periodId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("period").toString());
            DynamicObject defaultCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)mergeid, (Long)yearId, (Long)periodId);
            this.getModel().setValue("foreigncurrency", (Object)defaultCurrency);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"multiplecurrency", "foreigncurrency"});
            this.getModel().setValue("multiplecurrency", (Object)"0");
            this.getModel().setValue("foreigncurrency", null);
        }
    }

    private void refreshMergeStatus() {
        BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.searchByName((String)((String)this.getModel().getValue("bussnesstype")));
        boolean needMerge = !this.isOrgTreeType() && OrgRelaProcessMembPool.isRelaProcess((String)businessTypeEnum.getProcessNumber());
        this.getView().setVisible(Boolean.valueOf(needMerge), new String[]{"entity"});
        if (OrgRelaProcessMembPool.isRelaProcess((String)businessTypeEnum.getProcessNumber()) && this.getView().getFormShowParameter().getCustomParams().containsKey("selectedNodeId")) {
            this.getModel().setValue("entity", this.getView().getFormShowParameter().getCustomParam("selectedNodeId"));
        }
    }

    private void setAdjustTemplateComboEdit(Set<String> bussnesstypes) {
        QFilter listFilterParameter = new QFilter("model", "=", (Object)this.getModelId());
        listFilterParameter.and("bussnesstype", "in", bussnesstypes);
        if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
            listFilterParameter.and("id", "not in", (Object)PermClassEntityHelper.getPermissionMapBatch((String)"bcm_adjusttemplate", (String)(this.getModelId() + ""), (String)(this.getUserId() + "")).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        }
        DynamicObjectCollection templateArray = QueryServiceHelper.query((String)"bcm_adjusttemplate", (String)"id, name, number", (QFilter[])new QFilter[]{listFilterParameter});
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"RptAdjustBasicInfoPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "0"));
        if (templateArray != null && !templateArray.isEmpty()) {
            for (DynamicObject template : templateArray) {
                items.add(new ComboItem(new LocaleString(template.getString("name")), template.getString("id")));
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("template");
        comboEdit.setComboItems(items);
        this.getModel().setValue("template", (Object)0);
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit permissionClass;
        BasedataEdit fcurrency;
        super.registerListener(e);
        this.addClickListeners("btn_ok");
        BasedataEdit templatecatalog = (BasedataEdit)this.getControl("templatecatalog");
        if (templatecatalog != null) {
            templatecatalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((fcurrency = (BasedataEdit)this.getControl("foreigncurrency")) != null) {
            fcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((permissionClass = (BasedataEdit)this.getControl(PERMISSION_CLASS)) != null) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)permissionClass, (Object)this.getModelId());
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String chooseBaseDataEditName = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("templatecatalog".equalsIgnoreCase(chooseBaseDataEditName)) {
            PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"bcm_templatecatalog", (String)String.valueOf(this.getModelId()));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter model = new QFilter("model", "in", this.getView().getFormShowParameter().getCustomParam("model"));
            QFilter catalogtype = new QFilter("catalogtype", "=", (Object)(TemplateCatalogTypeEnum.ADJCATALOG.getType() + "")).or("parent.id", "=", (Object)0L);
            QFilter finalFilters = model.and(catalogtype);
            boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
            if (!isAdmin) {
                Map maps = BusinessDataServiceHelper.loadFromCache((String)"bcm_templatecatalog", (String)"id, parent.id", (QFilter[])finalFilters.toArray(), (String)"level");
                Set ids = PermClassCache.getPermissionIds((IPageCache)this.getPageCache(), maps.values());
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    finalFilters.and("1", "=", (Object)0);
                } else {
                    finalFilters.and("id", "in", (Object)ids);
                }
            }
            showParameter.getListFilterParameter().getQFilters().add(finalFilters);
        } else if ("foreigncurrency".equalsIgnoreCase(chooseBaseDataEditName)) {
            QFilter filter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
            filter.and("isleaf", "=", (Object)true);
            filter.and("number", "<>", (Object)"EC");
            filter.and("number", "<>", (Object)"DC");
            filter.and("number", "<>", (Object)"PC");
            filter.and("number", "<>", (Object)"OC");
            filter.and("number", "<>", (Object)"CNone");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), "dseq"));
        }
    }

    @Override
    public void click(EventObject evt) {
        IDataModel model = this.getModel();
        String number = (String)model.getValue("number");
        String name = (String)model.getValue("name");
        String journaltype = (String)model.getValue("journaltype");
        String updatecycle = (String)model.getValue("updatecycle");
        String bussnesstype = (String)model.getValue("bussnesstype");
        String balancetype = (String)model.getValue("balancetype");
        String multiplecurrency = (String)model.getValue("multiplecurrency");
        Long foreigncurrency = (Long)model.getValue("foreigncurrency_id");
        Long tmplog = (Long)model.getValue("templatecatalog_id");
        Long mergid = (Long)model.getValue("entity_id");
        String templateId = (String)model.getValue("template");
        String description = (String)model.getValue("description");
        DynamicObject permissionClass = (DynamicObject)model.getValue(PERMISSION_CLASS);
        String foreigncurrencyName = "";
        if (model.getValue("foreigncurrency") != null) {
            foreigncurrencyName = ((DynamicObject)model.getValue("foreigncurrency")).getString("name");
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modeId = (Long)formShowParameter.getCustomParam("model");
        if (this.isAllInput(number, name, journaltype, updatecycle, bussnesstype, tmplog, foreigncurrency, mergid)) {
            boolean isRAdj;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("number", number);
            map.put("name", name);
            map.put("journaltype", journaltype);
            map.put("updatecycle", updatecycle);
            map.put("bussnesstype", bussnesstype);
            map.put("model", modeId);
            BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.searchByName((String)bussnesstype);
            boolean bl = isRAdj = businessTypeEnum != null && !OrgRelaProcessMembPool.isRelaProcess((String)businessTypeEnum.getProcessNumber());
            if (!this.isOrgTreeType() || mergid == null || mergid == 0L || isRAdj) {
                List pkids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modeId), new QFilter("cslscheme", "=", this.getView().getFormShowParameter().getCustomParam("cslscheme")), new QFilter("parent.number", "=", (Object)"Entity")}, null, (int)1);
                if (pkids == null || pkids.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u4e0d\u5b58\u5728\u4efb\u4f55\u53ef\u7528\u7ec4\u7ec7\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"RptAdjustBasicInfoPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                mergid = (Long)pkids.get(0);
            }
            if (isRAdj) {
                mergid = LongUtil.toLong((Object)formShowParameter.getCustomParam("selectedNodeId"));
            }
            map.put("merge", mergid);
            map.put("templatecatalog", tmplog);
            map.put("multiplecurrency", multiplecurrency);
            map.put("foreigncurrency", foreigncurrency);
            map.put("linkcreatetype", this.getValue("linkcreatetype"));
            map.put("foreigncurrencyName", foreigncurrencyName);
            map.put("template", templateId == null ? 0L : Long.parseLong(templateId));
            map.put("balancetype", balancetype);
            map.put("description", description);
            if (this.isUseCodeRule()) {
                map.put(IS_USE_CODE_RULE, true);
                map.put(IS_ADD_VIEW, Boolean.valueOf(this.getPageCache().get(IS_ADD_VIEW)));
                map.put(IS_MODIFIABLE, Boolean.valueOf(this.getPageCache().get(IS_MODIFIABLE)));
                map.put(SHOW_NUMBER, this.getPageCache().get(SHOW_NUMBER));
                this.getPageCache().put(IS_RECYCLE_RULE_NUMBER, "0");
            } else {
                map.put(IS_USE_CODE_RULE, false);
            }
            if (permissionClass != null) {
                map.put(PERMISSION_CLASS, permissionClass.getPkValue());
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private boolean isUseCodeRule() {
        return null != this.getPageCache().get(IS_USE_CODE_RULE) && Boolean.parseBoolean(this.getPageCache().get(IS_USE_CODE_RULE));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (name = e.getProperty().getName()) {
            case "bussnesstype": {
                this.refresh();
                break;
            }
            case "multiplecurrency": {
                BasedataEdit foreigncurrency = (BasedataEdit)this.getControl("foreigncurrency");
                if ("1".equals(model.getValue("multiplecurrency"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"foreigncurrency"});
                    foreigncurrency.setMustInput(true);
                    Object yearObj = this.getView().getFormShowParameter().getCustomParam("year");
                    Object periodObj = this.getView().getFormShowParameter().getCustomParam("period");
                    String selectedOrgId = this.getView().getParentView().getPageCache().get("selectedNodeId");
                    if (yearObj == null || periodObj == null || selectedOrgId == null) break;
                    DynamicObject defaultCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)Long.parseLong(selectedOrgId), (Long)Long.parseLong(yearObj.toString()), (Long)Long.parseLong(periodObj.toString()));
                    model.setValue("foreigncurrency", (Object)defaultCurrency);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"foreigncurrency"});
                foreigncurrency.setMustInput(false);
                model.setValue("foreigncurrency", null);
                break;
            }
            case "entity": {
                this.refresh();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "loadInfoByTemplate": {
                if (evt.getReturnData() == null) break;
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
                Object templateId = selectedRows.get(0).getPrimaryKeyValue();
                this.getModel().setValue("template", templateId);
                break;
            }
        }
    }

    private void setDefaultValueByTemplateId(long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_adjusttemplate", (String)"id,bussnesstype,number,name,journaltype,spreaddim", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        String journalType = template.getString("journaltype");
        String bussnessType = template.getString("bussnesstype");
        this.getModel().setValue("journaltype", (Object)journalType);
        this.getModel().setValue("bussnesstype", (Object)bussnessType);
    }

    private boolean isAllInput(String number, String name, String journaltype, String updatecycle, String bussnesstype, Long tmplog, Long foreigncurrency, Long mergid) {
        Object periodId;
        Object scenarioId;
        Object yearId;
        Object modelId;
        if (number == null || number.length() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RptAdjustBasicInfoPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (name == null || name.length() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (journaltype == null || journaltype.length() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (updatecycle == null || updatecycle.length() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (bussnesstype == null || bussnesstype.length() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(this.getModel().getValue("multiplecurrency")) && (foreigncurrency == null || foreigncurrency == 0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.searchByName((String)bussnesstype);
        if (this.isOrgTreeType() && OrgRelaProcessMembPool.isRelaProcess((String)businessTypeEnum.getProcessNumber()) && (mergid == null || mergid == 0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String showNumber = this.getPageCache().get(SHOW_NUMBER);
        if (null != showNumber && !StringUtil.equals((String)showNumber, (String)number) && AdjustmentServiceHelper.newAdjustNumberIsExist((Object)(modelId = this.getView().getFormShowParameter().getCustomParam("model")), (Object)(yearId = this.getView().getFormShowParameter().getCustomParam("year")), (Object)(scenarioId = this.getView().getFormShowParameter().getCustomParam("scenario")), (Object)(periodId = this.getView().getFormShowParameter().getCustomParam("period")), (String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"RptAdjustBasicInfoPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        String showNumber;
        super.beforeClosed(e);
        if (this.isUseCodeRule() && !"0".equals(this.getPageCache().get(IS_RECYCLE_RULE_NUMBER)) && !StringUtils.isEmpty((CharSequence)(showNumber = this.getPageCache().get(SHOW_NUMBER)))) {
            CodeRuleUtil.recycleCodeRuleNumber("bcm_rptadjust", showNumber);
        }
    }
}

